/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.EventRefSet;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class CifEventUtils {
    private CifEventUtils() {
    }

    public static List<Alphabets> getAllAlphabets(Specification spec) {
        return (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, Lists.list()).stream().map(aut -> CifEventUtils.getAllAlphabets(aut, null)).collect(Lists.toList());
    }

    public static List<Alphabets> getAllAlphabets(List<Automaton> automata, List<Set<Event>> syncAlphabets) {
        List alphabets = Lists.listc((int)automata.size());
        int i = 0;
        while (i < automata.size()) {
            Automaton aut = automata.get(i);
            Set<Event> syncAlphabet = syncAlphabets == null ? null : syncAlphabets.get(i);
            alphabets.add(CifEventUtils.getAllAlphabets(aut, syncAlphabet));
            ++i;
        }
        return alphabets;
    }

    public static Alphabets getAllAlphabets(Automaton automaton, Set<Event> syncAlphabet) {
        Alphabets alphabets = new Alphabets();
        if (syncAlphabet == null) {
            syncAlphabet = CifEventUtils.getAlphabet(automaton);
        }
        alphabets.syncAlphabet = syncAlphabet;
        alphabets.sendAlphabet = CifEventUtils.getSendAlphabet(automaton);
        alphabets.recvAlphabet = CifEventUtils.getReceiveAlphabet(automaton);
        alphabets.moniAlphabet = CifEventUtils.getMonitors(automaton, syncAlphabet);
        return alphabets;
    }

    public static EventRefSet getAlphabetRefSet(Automaton automaton) {
        EventRefSet alphabet = new EventRefSet();
        if (automaton.getAlphabet() != null) {
            for (Expression eventRef : automaton.getAlphabet().getEvents()) {
                alphabet.add(eventRef);
            }
        } else {
            for (Location loc : automaton.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Expression eventRef;
                        if (edgeEvent.getClass() != EdgeEventImpl.class || (eventRef = edgeEvent.getEvent()) instanceof TauExpression) continue;
                        alphabet.add(eventRef);
                    }
                }
            }
        }
        return alphabet;
    }

    public static List<Set<Event>> getAlphabets(List<Automaton> automata) {
        List alphabets = Lists.listc((int)automata.size());
        for (Automaton aut : automata) {
            alphabets.add(CifEventUtils.getAlphabet(aut));
        }
        return alphabets;
    }

    public static Set<Event> getAlphabet(Specification spec) {
        List automata = CifCollectUtils.collectAutomata((ComplexComponent)spec, Lists.list());
        List<Set<Event>> alphabets = CifEventUtils.getAlphabets(automata);
        Set alphabet = alphabets.stream().reduce(Sets::union).orElseGet(() -> Sets.setc((int)0));
        return alphabet;
    }

    public static Set<Event> getAlphabet(Automaton automaton) {
        Set alphabet;
        if (automaton.getAlphabet() != null) {
            EList eventRefs = automaton.getAlphabet().getEvents();
            alphabet = Sets.setc((int)eventRefs.size());
            for (Expression eventRef : eventRefs) {
                Event event = ((EventExpression)eventRef).getEvent();
                alphabet.add(event);
            }
        } else {
            alphabet = Sets.set();
            for (Location loc : automaton.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Expression eventRef;
                        if (edgeEvent.getClass() != EdgeEventImpl.class || (eventRef = edgeEvent.getEvent()) instanceof TauExpression) continue;
                        Event event = ((EventExpression)eventRef).getEvent();
                        alphabet.add(event);
                    }
                }
            }
        }
        return alphabet;
    }

    public static List<Set<Event>> getSendAlphabets(List<Automaton> automata) {
        List alphabets = Lists.listc((int)automata.size());
        for (Automaton aut : automata) {
            alphabets.add(CifEventUtils.getSendAlphabet(aut));
        }
        return alphabets;
    }

    public static Set<Event> getSendAlphabet(Automaton automaton) {
        Set alphabet = Sets.set();
        for (Location loc : automaton.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    if (!(edgeEvent instanceof EdgeSend)) continue;
                    Expression eventRef = edgeEvent.getEvent();
                    Event event = ((EventExpression)eventRef).getEvent();
                    alphabet.add(event);
                }
            }
        }
        return alphabet;
    }

    public static List<Set<Event>> getReceiveAlphabets(List<Automaton> automata) {
        List alphabets = Lists.listc((int)automata.size());
        for (Automaton aut : automata) {
            alphabets.add(CifEventUtils.getReceiveAlphabet(aut));
        }
        return alphabets;
    }

    public static Set<Event> getReceiveAlphabet(Automaton automaton) {
        Set alphabet = Sets.set();
        for (Location loc : automaton.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    if (!(edgeEvent instanceof EdgeReceive)) continue;
                    Expression eventRef = edgeEvent.getEvent();
                    Event event = ((EventExpression)eventRef).getEvent();
                    alphabet.add(event);
                }
            }
        }
        return alphabet;
    }

    public static EventRefSet getMonitorsRefSet(Automaton automaton, EventRefSet alphabet) {
        Monitors monitors = automaton.getMonitors();
        if (monitors == null) {
            return new EventRefSet();
        }
        EList eventRefs = monitors.getEvents();
        if (eventRefs.isEmpty()) {
            return alphabet != null ? alphabet : CifEventUtils.getAlphabetRefSet(automaton);
        }
        EventRefSet rslt = new EventRefSet();
        for (Expression eventRef : eventRefs) {
            rslt.add(eventRef);
        }
        return rslt;
    }

    public static List<Set<Event>> getMonitors(List<Automaton> automata, List<Set<Event>> alphabets) {
        if (alphabets == null) {
            alphabets = CifEventUtils.getAlphabets(automata);
        }
        List monitorAlphabets = Lists.listc((int)automata.size());
        int i = 0;
        while (i < automata.size()) {
            Automaton aut = automata.get(i);
            Set<Event> alphabet = alphabets.get(i);
            monitorAlphabets.add(CifEventUtils.getMonitors(aut, alphabet));
            ++i;
        }
        return monitorAlphabets;
    }

    public static Set<Event> getMonitors(Automaton automaton, Set<Event> alphabet) {
        Monitors monitors = automaton.getMonitors();
        if (monitors == null) {
            return Sets.set();
        }
        EList eventRefs = monitors.getEvents();
        if (eventRefs.isEmpty()) {
            return alphabet != null ? Sets.copy(alphabet) : CifEventUtils.getAlphabet(automaton);
        }
        Set rslt = Sets.setc((int)eventRefs.size());
        for (Expression eventRef : eventRefs) {
            rslt.add(((EventExpression)eventRef).getEvent());
        }
        return rslt;
    }

    public static List<List<Automaton>> filterAutomata(List<Automaton> automata, List<Set<Event>> alphabets, List<Event> events) {
        List rslt = Lists.listc((int)events.size());
        for (Event event : events) {
            rslt.add(CifEventUtils.filterAutomata(automata, alphabets, event));
        }
        return rslt;
    }

    public static List<Automaton> filterAutomata(List<Automaton> automata, List<Set<Event>> alphabets, Event event) {
        List rslt = Lists.list();
        int i = 0;
        while (i < automata.size()) {
            Automaton aut = automata.get(i);
            Set<Event> alphabet = alphabets.get(i);
            if (alphabet.contains(event)) {
                rslt.add(aut);
            }
            ++i;
        }
        return rslt;
    }

    public static List<Set<Automaton>> filterMonitorAuts(List<Automaton> automata, List<Set<Event>> alphabets, List<Event> events) {
        List rslt = Lists.listc((int)events.size());
        for (Event event : events) {
            rslt.add(CifEventUtils.filterMonitorAuts(automata, alphabets, event));
        }
        return rslt;
    }

    public static Set<Automaton> filterMonitorAuts(List<Automaton> automata, List<Set<Event>> alphabets, Event event) {
        Set rslt = Sets.set();
        int i = 0;
        while (i < automata.size()) {
            Automaton aut = automata.get(i);
            Set<Event> alphabet = alphabets.get(i);
            if (alphabet.contains(event)) {
                rslt.add(aut);
            }
            ++i;
        }
        return rslt;
    }

    public static EventRefSet getEventsRefSet(Edge edge) {
        EventRefSet events = new EventRefSet();
        for (EdgeEvent edgeEvent : edge.getEvents()) {
            events.add(edgeEvent.getEvent());
        }
        if (edge.getEvents().isEmpty()) {
            TauExpression tauRef = CifConstructors.newTauExpression();
            tauRef.setType((CifType)CifConstructors.newBoolType());
            events.add((Expression)tauRef);
        }
        return events;
    }

    public static Set<Event> getEvents(Edge edge) {
        Set events = Sets.setc((int)edge.getEvents().size());
        for (EdgeEvent edgeEvent : edge.getEvents()) {
            Expression eventRef = edgeEvent.getEvent();
            Event event = ((EventExpression)eventRef).getEvent();
            events.add(event);
        }
        return events;
    }

    public static Event getEventFromEdgeEvent(EdgeEvent edgeEvent) {
        Expression eventRef = edgeEvent.getEvent();
        if (eventRef instanceof TauExpression) {
            return null;
        }
        return ((EventExpression)eventRef).getEvent();
    }

    public static List<Event> sortEvents(Set<Event> events) {
        Comparator<Event> cmp = new Comparator<Event>(){

            @Override
            public int compare(Event e1, Event e2) {
                return Strings.SORTER.compare(e1.getName(), e2.getName());
            }
        };
        return Sets.sortedgeneric(events, (Comparator)cmp);
    }

    public static boolean areSameEventRefs(Expression ref1, Expression ref2) {
        if (CifScopeUtils.isParamRefExpr(ref1) || CifScopeUtils.isParamRefExpr(ref2)) {
            throw new RuntimeException("Unexpected parameter reference.");
        }
        if (ref1 instanceof CompInstWrapExpression || ref2 instanceof CompInstWrapExpression) {
            throw new RuntimeException("Unexpected via component instantiation reference.");
        }
        if (ref1 instanceof TauExpression && ref2 instanceof TauExpression) {
            return true;
        }
        if (ref1 instanceof EventExpression && ref2 instanceof EventExpression) {
            Event event2;
            Event event1 = ((EventExpression)ref1).getEvent();
            return event1 == (event2 = ((EventExpression)ref2).getEvent());
        }
        return false;
    }

    public static boolean eventParamSupportsSend(EventParameter param) {
        if (param.getEvent().getType() == null) {
            return false;
        }
        if (!(param.isSendFlag() || param.isRecvFlag() || param.isSyncFlag())) {
            return true;
        }
        return param.isSendFlag();
    }

    public static boolean eventParamSupportsRecv(EventParameter param) {
        if (param.getEvent().getType() == null) {
            return false;
        }
        if (!(param.isSendFlag() || param.isRecvFlag() || param.isSyncFlag())) {
            return true;
        }
        return param.isRecvFlag();
    }

    public static boolean eventParamSupportsSync(EventParameter param) {
        if (param.getEvent().getType() == null) {
            return true;
        }
        if (!(param.isSendFlag() || param.isRecvFlag() || param.isSyncFlag())) {
            return true;
        }
        return param.isSyncFlag();
    }

    public static class Alphabets {
        public Set<Event> syncAlphabet;
        public Set<Event> sendAlphabet;
        public Set<Event> recvAlphabet;
        public Set<Event> moniAlphabet;
    }
}

