/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CifAnnotationUtils {
    private CifAnnotationUtils() {
    }

    public static boolean hasAnnotation(AnnotatedObject annotatedObject, String annoName) {
        return CifAnnotationUtils.getAnnotations(annotatedObject, annoName).findAny().isPresent();
    }

    public static Annotation tryGetSingleAnnotation(AnnotatedObject annotatedObject, String annoName) {
        List<Annotation> annos = CifAnnotationUtils.getAnnotations(annotatedObject, annoName).toList();
        if (annos.size() > 1) {
            throw new IllegalArgumentException(Strings.fmt((String)"%d annotations named \"%s\" on \"%s\".", (Object[])new Object[]{annos.size(), annoName, annotatedObject}));
        }
        return annos.isEmpty() ? null : (Annotation)Lists.first(annos);
    }

    public static Annotation getSingleAnnotation(AnnotatedObject annotatedObject, String annoName) {
        List<Annotation> annos = CifAnnotationUtils.getAnnotations(annotatedObject, annoName).toList();
        if (annos.size() != 1) {
            throw new IllegalArgumentException(Strings.fmt((String)"%d annotations named \"%s\" on \"%s\".", (Object[])new Object[]{annos.size(), annoName, annotatedObject}));
        }
        return (Annotation)Lists.first(annos);
    }

    public static Annotation getOrCreateSingleAnnotation(AnnotatedObject annotatedObject, String annoName) {
        Annotation anno = CifAnnotationUtils.tryGetSingleAnnotation(annotatedObject, annoName);
        if (anno == null) {
            anno = CifConstructors.newAnnotation();
            anno.setName(annoName);
            annotatedObject.getAnnotations().add((Object)anno);
        }
        return anno;
    }

    public static Stream<Annotation> getAnnotations(AnnotatedObject annotatedObject, String annoName) {
        return annotatedObject.getAnnotations().stream().filter(anno -> anno.getName().equals(annoName));
    }

    public static AnnotationArgument tryGetArgument(Annotation anno, String argName) {
        Assert.notNull((Object)argName);
        return anno.getArguments().stream().filter(arg -> argName.equals(arg.getName())).findFirst().orElse(null);
    }

    public static AnnotationArgument getArgument(Annotation anno, String argName) {
        AnnotationArgument arg = CifAnnotationUtils.tryGetArgument(anno, argName);
        if (arg == null) {
            throw new IllegalArgumentException(Strings.fmt((String)"Annotation argument \"%s\" not present on annotation named \"%s\".", (Object[])new Object[]{argName, anno.getName()}));
        }
        return arg;
    }

    public static AnnotationArgument setArgument(Annotation anno, String argName, Expression value) {
        Assert.notNull((Object)argName);
        AnnotationArgument arg = CifAnnotationUtils.tryGetArgument(anno, argName);
        if (arg == null) {
            arg = CifConstructors.newAnnotationArgument((String)argName, null, (Expression)value);
            anno.getArguments().add((Object)arg);
        } else {
            arg.setValue(value);
        }
        return arg;
    }

    public static AnnotationArgument tryRemoveArgument(Annotation anno, String argName) {
        Assert.notNull((Object)argName);
        AnnotationArgument arg = CifAnnotationUtils.tryGetArgument(anno, argName);
        if (arg != null) {
            EMFHelper.removeFromParentContainment((EObject)arg);
        }
        return arg;
    }

    public static AnnotationArgument removeArgument(Annotation anno, String argName) {
        Assert.notNull((Object)argName);
        AnnotationArgument arg = CifAnnotationUtils.getArgument(anno, argName);
        EMFHelper.removeFromParentContainment((EObject)arg);
        return arg;
    }

    public static boolean isObjInAnnotation(EObject obj) {
        EObject ancestor = obj.eContainer();
        while (ancestor != null) {
            if (ancestor instanceof Annotation) {
                return true;
            }
            ancestor = ancestor.eContainer();
        }
        return false;
    }
}

