/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class ElimIfUpdates
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        this.walkSpecification(spec);
    }

    protected void preprocessEdge(Edge edge) {
        if (edge.getUpdates().isEmpty()) {
            return;
        }
        List<Assignment> assignments = this.updatesToAssignmentsPerVar((List<Update>)edge.getUpdates());
        edge.getUpdates().clear();
        edge.getUpdates().addAll(assignments);
    }

    protected void preprocessSvgIn(SvgIn svgIn) {
        if (svgIn.getUpdates().isEmpty()) {
            return;
        }
        List<Assignment> assignments = this.updatesToAssignmentsPerVar((List<Update>)svgIn.getUpdates());
        svgIn.getUpdates().clear();
        svgIn.getUpdates().addAll(assignments);
    }

    private List<Assignment> updatesToAssignmentsPerVar(List<Update> updates) {
        Set vars = Sets.set();
        for (Update update : updates) {
            vars.addAll(this.getVariables(update));
        }
        List assignments = Lists.listc((int)vars.size());
        for (Declaration var : vars) {
            Assignment assignment = CifConstructors.newAssignment();
            assignments.add(assignment);
            assignment.setAddressable(this.varToAddr(var));
            Expression value = this.updatesToValue(updates, var);
            assignment.setValue(value);
        }
        return assignments;
    }

    private Set<Declaration> getVariables(Update update) {
        if (update instanceof IfUpdate) {
            IfUpdate iupdate = (IfUpdate)update;
            Set rslt = Sets.set();
            for (Update upd : iupdate.getThens()) {
                rslt.addAll(this.getVariables(upd));
            }
            for (ElifUpdate elif : iupdate.getElifs()) {
                for (Update upd : elif.getThens()) {
                    rslt.addAll(this.getVariables(upd));
                }
            }
            for (Update upd : iupdate.getElses()) {
                rslt.addAll(this.getVariables(upd));
            }
            return rslt;
        }
        Expression addr = ((Assignment)update).getAddressable();
        this.checkAddressable(addr);
        try {
            return CifAddressableUtils.getRefs((Expression)addr);
        }
        catch (CifAddressableUtils.DuplVarAsgnException e) {
            throw new RuntimeException("Precondition violated.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Expression varToAddr(Declaration var) {
        Declaration declaration = var;
        if (declaration instanceof DiscVariable) {
            void dvar;
            DiscVariable discVariable = (DiscVariable)declaration;
            DiscVariable cfr_ignored_0 = (DiscVariable)declaration;
            DiscVariableExpression daddr = CifConstructors.newDiscVariableExpression();
            daddr.setVariable((DiscVariable)dvar);
            daddr.setType((CifType)EMFHelper.deepclone((EObject)dvar.getType()));
            return daddr;
        }
        Declaration declaration2 = var;
        if (declaration2 instanceof ContVariable) {
            void cvar;
            ContVariable daddr = (ContVariable)declaration2;
            ContVariable cfr_ignored_1 = (ContVariable)declaration2;
            ContVariableExpression caddr = CifConstructors.newContVariableExpression();
            caddr.setVariable((ContVariable)cvar);
            caddr.setType((CifType)CifConstructors.newRealType());
            return caddr;
        }
        Declaration declaration3 = var;
        if (declaration3 instanceof InputVariable) {
            void ivar;
            InputVariable caddr = (InputVariable)declaration3;
            InputVariable cfr_ignored_2 = (InputVariable)declaration3;
            InputVariableExpression iaddr = CifConstructors.newInputVariableExpression();
            iaddr.setVariable((InputVariable)ivar);
            iaddr.setType((CifType)EMFHelper.deepclone((EObject)ivar.getType()));
            return iaddr;
        }
        throw new RuntimeException("Unknown variable: " + String.valueOf(var));
    }

    private Expression updatesToValue(List<Update> updates, Declaration var) {
        for (Update update : updates) {
            if (!this.getVariables(update).contains(var)) continue;
            return this.updateToValue(update, var);
        }
        return this.varToAddr(var);
    }

    private Expression updateToValue(Update update, Declaration var) {
        if (update instanceof Assignment) {
            Set addrVars;
            Assignment asgn = (Assignment)update;
            Expression addr = asgn.getAddressable();
            try {
                addrVars = CifAddressableUtils.getRefs((Expression)addr);
            }
            catch (CifAddressableUtils.DuplVarAsgnException e) {
                throw new RuntimeException("Precondition violated.");
            }
            Assert.check((addrVars.size() == 1 ? 1 : 0) != 0);
            Declaration addrVar = (Declaration)addrVars.iterator().next();
            if (addrVar == var) {
                return asgn.getValue();
            }
            return this.varToAddr(var);
        }
        IfUpdate iupdate = (IfUpdate)update;
        IfExpression ifExpr = CifConstructors.newIfExpression();
        ifExpr.setType(this.varToAddr(var).getType());
        ifExpr.getGuards().addAll((Collection)EMFHelper.deepclone((List)iupdate.getGuards()));
        ifExpr.setThen(this.updatesToValue((List<Update>)iupdate.getThens(), var));
        for (ElifUpdate elif : iupdate.getElifs()) {
            ElifExpression elifExpr = CifConstructors.newElifExpression();
            elifExpr.getGuards().addAll((Collection)EMFHelper.deepclone((List)elif.getGuards()));
            elifExpr.setThen(this.updatesToValue((List<Update>)elif.getThens(), var));
            ifExpr.getElifs().add((Object)elifExpr);
        }
        ifExpr.setElse(this.updatesToValue((List<Update>)iupdate.getElses(), var));
        return ifExpr;
    }

    private void checkAddressable(Expression addr) {
        if (addr instanceof TupleExpression || addr instanceof ProjectionExpression) {
            String msg = "Eliminating 'if' updates, from a CIF specification with multi-assignments and/or partial variable assignments (projected addressables), is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
    }
}

