/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDeclaredType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouInstance;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTask;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcFuncBlockType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public abstract class Writer {
    public static final int INDENT = 4;
    protected final PlcTarget target;

    protected Writer(PlcTarget target) {
        this.target = target;
    }

    public abstract void write(PlcProject var1, String var2);

    protected void ensureDirectory(String outPath) {
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)outPath);
        Path nioAbsPath = Paths.get(absPath, new String[0]);
        if (!Files.isDirectory(nioAbsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(nioAbsPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create output directory \"%s\" for the generated PLC code.", (Object[])new Object[]{outPath});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
    }

    protected Box toBox(PlcProject project) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("PROJECT %s", new Object[]{project.name});
        c.indent();
        for (PlcDeclaredType declaredType : project.declaredTypes) {
            c.add(this.toTypeDeclBox(declaredType));
        }
        for (PlcPou pou : project.pous) {
            c.add(this.toBox(pou));
        }
        for (PlcConfiguration configuration : project.configurations) {
            c.add(this.toBox(configuration));
        }
        c.dedent();
        c.add("END_PROJECT");
        return c;
    }

    protected Box toBox(PlcConfiguration configuration) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("CONFIGURATION %s", new Object[]{configuration.name});
        c.indent();
        for (PlcGlobalVarList globalVarList : configuration.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(this.toVarDeclBox(globalVarList));
        }
        Assert.check((configuration.resources.size() <= 1 ? 1 : 0) != 0);
        for (PlcResource resource : configuration.resources) {
            c.add(this.toBox(resource));
        }
        c.dedent();
        c.add("END_CONFIGURATION");
        return c;
    }

    protected Box toBox(PlcTask task) {
        return new TextBox("TASK %s(INTERVAL := t#%dms, PRIORITY := %d);", new Object[]{task.name, task.cycleTime, task.priority});
    }

    protected Box toBox(PlcResource resource) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        for (PlcGlobalVarList globalVarList : resource.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(this.toVarDeclBox(globalVarList));
        }
        for (PlcTask task : resource.tasks) {
            c.add(this.toBox(task));
        }
        for (PlcPouInstance pouInstance : resource.pouInstances) {
            c.add(this.toBox(pouInstance, null));
        }
        for (PlcTask task : resource.tasks) {
            for (PlcPouInstance pouInstance : task.pouInstances) {
                c.add(this.toBox(pouInstance, task.name));
            }
        }
        return c;
    }

    protected Box toVarDeclBox(PlcGlobalVarList globVarList) {
        Assert.check((!globVarList.variables.isEmpty() ? 1 : 0) != 0);
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("VAR_GLOBAL%s // %s", new Object[]{globVarList.listKind == PlcGlobalVarList.PlcVarListKind.CONSTANTS ? " CONSTANT" : "", globVarList.name});
        c.indent();
        for (PlcDataVariable variable : globVarList.variables) {
            c.add(this.toVarDeclBox(variable));
        }
        c.dedent();
        c.add("END_VAR");
        return c;
    }

    protected Box toVarDeclBox(PlcDataVariable dataVar) {
        String addrTxt = dataVar.address == null ? "" : Strings.fmt((String)" AT %s", (Object[])new Object[]{dataVar.address});
        String valueTxt = dataVar.value == null ? "" : " := " + this.target.getModelTextGenerator().literalToString(dataVar.value);
        String txt = Strings.fmt((String)"%s%s: %s%s;", (Object[])new Object[]{dataVar.varName, addrTxt, this.toTypeRefBox(dataVar.type), valueTxt});
        return new TextBox(txt);
    }

    protected Box toBox(PlcPouInstance pouInstance) {
        return this.toBox(pouInstance, null);
    }

    protected Box toBox(PlcPouInstance pouInstance, String taskName) {
        String taskTxt = taskName == null ? "" : Strings.fmt((String)" WITH %s", (Object[])new Object[]{taskName});
        return new TextBox("PROGRAM %s%s: %s;", new Object[]{pouInstance.name, taskTxt, pouInstance.pou.name});
    }

    protected Box toBox(PlcPou pou) {
        CodeBox c = this.headerToBox(pou);
        c.add();
        c.add((Box)pou.body);
        c.add("END_%s", new Object[]{pou.pouType});
        return c;
    }

    protected CodeBox headerToBox(PlcPou pou) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        String retTypeTxt = pou.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.toTypeRefBox(pou.retType)});
        c.add("%s %s%s", new Object[]{pou.pouType, pou.name, retTypeTxt});
        if (!pou.inputVars.isEmpty()) {
            c.add("VAR_INPUT");
            c.indent();
            for (PlcDataVariable var : pou.inputVars) {
                c.add(this.toVarDeclBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!pou.outputVars.isEmpty()) {
            c.add("VAR_OUTPUT");
            c.indent();
            for (PlcDataVariable var : pou.outputVars) {
                c.add(this.toVarDeclBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!pou.localVars.isEmpty()) {
            c.add("VAR");
            c.indent();
            for (PlcDataVariable var : pou.localVars) {
                c.add(this.toVarDeclBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!pou.tempVars.isEmpty()) {
            c.add("VAR_TEMP");
            c.indent();
            for (PlcDataVariable var : pou.tempVars) {
                c.add(this.toVarDeclBox(var));
            }
            c.dedent();
            c.add("END_VAR");
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    protected Box toTypeRefBox(PlcType type) {
        PlcType plcType = type;
        if (plcType instanceof PlcArrayType) {
            void arrayType;
            PlcArrayType plcArrayType = (PlcArrayType)plcType;
            PlcArrayType cfr_ignored_0 = (PlcArrayType)plcType;
            return this.toTypeRefBox((PlcArrayType)arrayType);
        }
        PlcType plcType2 = type;
        if (plcType2 instanceof PlcDerivedType) {
            void derType;
            PlcDerivedType plcDerivedType = (PlcDerivedType)plcType2;
            PlcDerivedType cfr_ignored_1 = (PlcDerivedType)plcType2;
            return this.toTypeRefBox((PlcDerivedType)derType);
        }
        PlcType plcType3 = type;
        if (plcType3 instanceof PlcElementaryType) {
            void elemType;
            PlcElementaryType plcElementaryType = (PlcElementaryType)plcType3;
            PlcElementaryType cfr_ignored_2 = (PlcElementaryType)plcType3;
            return this.toTypeRefBox((PlcElementaryType)elemType);
        }
        PlcType plcType4 = type;
        if (plcType4 instanceof PlcEnumType) {
            void enumType;
            PlcEnumType plcEnumType = (PlcEnumType)plcType4;
            PlcEnumType cfr_ignored_3 = (PlcEnumType)plcType4;
            return this.toTypeRefBox((PlcEnumType)enumType);
        }
        PlcType plcType5 = type;
        if (plcType5 instanceof PlcStructType) {
            void structType;
            PlcStructType plcStructType = (PlcStructType)plcType5;
            PlcStructType cfr_ignored_4 = (PlcStructType)plcType5;
            return this.toTypeRefBox((PlcStructType)structType);
        }
        PlcType plcType6 = type;
        if (plcType6 instanceof PlcFuncBlockType) {
            void blockType;
            PlcFuncBlockType plcFuncBlockType = (PlcFuncBlockType)plcType6;
            PlcFuncBlockType cfr_ignored_5 = (PlcFuncBlockType)plcType6;
            return this.toTypeRefBox((PlcFuncBlockType)blockType);
        }
        String typeText = type == null ? "null" : type.getClass().toString();
        throw new AssertionError((Object)("Unexpected PlcType, found: " + typeText + "."));
    }

    /*
     * WARNING - void declaration
     */
    protected Box toTypeDeclBox(PlcDeclaredType declaredType) {
        PlcDeclaredType plcDeclaredType = declaredType;
        if (plcDeclaredType instanceof PlcStructType) {
            void structType;
            PlcStructType plcStructType = (PlcStructType)plcDeclaredType;
            PlcStructType cfr_ignored_0 = (PlcStructType)plcDeclaredType;
            return this.toTypeDeclBox((PlcStructType)structType);
        }
        PlcDeclaredType plcDeclaredType2 = declaredType;
        if (plcDeclaredType2 instanceof PlcEnumType) {
            void enumType;
            PlcEnumType plcEnumType = (PlcEnumType)plcDeclaredType2;
            PlcEnumType cfr_ignored_1 = (PlcEnumType)plcDeclaredType2;
            return this.toTypeDeclBox((PlcEnumType)enumType);
        }
        throw new AssertionError((Object)("Unexpected declared type found: \"" + String.valueOf(declaredType) + "\"."));
    }

    protected Box toTypeDeclBox(PlcStructType structType) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("TYPE %s:", new Object[]{structType.typeName});
        c.indent();
        c.add("STRUCT");
        c.indent();
        for (PlcStructField field : structType.fields) {
            c.add(this.toTypeDeclBox(field));
        }
        c.dedent();
        c.add("END_STRUCT;");
        c.dedent();
        c.add("END_TYPE");
        return c;
    }

    protected Box toTypeDeclBox(PlcStructField field) {
        String txt = Strings.fmt((String)"%s: %s;", (Object[])new Object[]{field.fieldName, this.toTypeRefBox(field.type)});
        return new TextBox(txt);
    }

    protected Box toTypeDeclBox(PlcEnumType enumType) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("TYPE %s:", new Object[]{enumType.typeName});
        c.indent();
        c.add("(%s);", new Object[]{enumType.literals.stream().map(elit -> elit.value).collect(Collectors.joining(", "))});
        c.dedent();
        c.add("END_TYPE");
        return c;
    }

    protected Box toTypeRefBox(PlcElementaryType elementaryType) {
        return new TextBox(elementaryType.name);
    }

    protected Box toTypeRefBox(PlcDerivedType derivedType) {
        return new TextBox(derivedType.name);
    }

    protected Box toTypeRefBox(PlcArrayType arrayType) {
        HBox b = new HBox();
        b.add(Strings.fmt((String)"ARRAY[%d..%d] of ", (Object[])new Object[]{arrayType.lower, arrayType.upper}));
        b.add(this.toTypeRefBox(arrayType.elemType));
        return b;
    }

    protected Box toTypeRefBox(PlcStructType structType) {
        return new TextBox(structType.typeName);
    }

    protected Box toTypeRefBox(PlcEnumType enumType) {
        return new TextBox(enumType.typeName);
    }

    protected Box toTypeRefBox(PlcFuncBlockType blockType) {
        return new TextBox(blockType.typeName);
    }
}

