/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDeclaredType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouInstance;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTask;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcEnumLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcFuncBlockType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PlcOpenXmlWriter
extends Writer {
    private static final String PLCOPEN_NS = "http://www.plcopen.org/xml/tc6_0201";
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    public PlcOpenXmlWriter(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, String filePath) {
        filePath = Paths.resolve((String)filePath);
        Document doc = this.transProject(project);
        this.writeDocument(doc, filePath);
        this.validateDocument(filePath);
    }

    private Document transProject(PlcProject project) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document doc = domImpl.createDocument(PLCOPEN_NS, "project", null);
        doc.setXmlStandalone(true);
        Element root = doc.getDocumentElement();
        Element fileHeader = this.makeChild(root, "fileHeader");
        fileHeader.setAttribute("companyName", "Eclipse Foundation");
        fileHeader.setAttribute("productName", "CIF to Structured Text");
        fileHeader.setAttribute("productVersion", "0.0");
        Instant instant = Instant.ofEpochMilli(0L);
        String formattedDateTime = DateTimeFormatter.ISO_INSTANT.format(instant);
        fileHeader.setAttribute("creationDateTime", formattedDateTime);
        Element contentHeader = this.makeChild(root, "contentHeader");
        contentHeader.setAttribute("name", project.name);
        Element coordInfo = this.makeChild(contentHeader, "coordinateInfo");
        Element fbd = this.makeChild(coordInfo, "fbd");
        Element fbdScaling = this.makeChild(fbd, "scaling");
        fbdScaling.setAttribute("x", "1");
        fbdScaling.setAttribute("y", "1");
        Element ld = this.makeChild(coordInfo, "ld");
        Element ldScaling = this.makeChild(ld, "scaling");
        ldScaling.setAttribute("x", "1");
        ldScaling.setAttribute("y", "1");
        Element sfc = this.makeChild(coordInfo, "sfc");
        Element sfcScaling = this.makeChild(sfc, "scaling");
        sfcScaling.setAttribute("x", "1");
        sfcScaling.setAttribute("y", "1");
        Element types = this.makeChild(root, "types");
        Element dataTypes = this.makeChild(types, "dataTypes");
        Element pous = this.makeChild(types, "pous");
        Element instances = this.makeChild(root, "instances");
        Element configurations = this.makeChild(instances, "configurations");
        for (PlcDeclaredType declaredType : project.declaredTypes) {
            this.transDeclaredType(declaredType, dataTypes);
        }
        for (PlcPou pou : project.pous) {
            this.transPou(pou, pous);
        }
        for (PlcConfiguration config : project.configurations) {
            this.transConfig(config, configurations);
        }
        return doc;
    }

    /*
     * WARNING - void declaration
     */
    private void transDeclaredType(PlcDeclaredType declaredType, Element parent) {
        PlcDeclaredType plcDeclaredType = declaredType;
        if (plcDeclaredType instanceof PlcStructType) {
            void structType;
            PlcStructType plcStructType = (PlcStructType)plcDeclaredType;
            PlcStructType cfr_ignored_0 = (PlcStructType)plcDeclaredType;
            this.transDeclaredType((PlcStructType)structType, parent);
        } else {
            PlcDeclaredType plcDeclaredType2 = declaredType;
            if (plcDeclaredType2 instanceof PlcEnumType) {
                void enumType;
                PlcEnumType plcEnumType = (PlcEnumType)plcDeclaredType2;
                PlcEnumType cfr_ignored_1 = (PlcEnumType)plcDeclaredType2;
                this.transDeclaredType((PlcEnumType)enumType, parent);
            } else {
                throw new AssertionError((Object)("Unexpected declared type found: \"" + String.valueOf(declaredType) + "\"."));
            }
        }
    }

    private void transDeclaredType(PlcStructType structType, Element parent) {
        Element dataType = this.makeChild(parent, "dataType");
        dataType.setAttribute("name", structType.typeName);
        Element baseType = this.makeChild(dataType, "baseType");
        Element struct = this.makeChild(baseType, "struct");
        for (PlcStructField field : structType.fields) {
            this.transStructField(field, struct);
        }
    }

    private void transDeclaredType(PlcEnumType enumType, Element parent) {
        Element dataType = this.makeChild(parent, "dataType");
        dataType.setAttribute("name", enumType.typeName);
        Element baseType = this.makeChild(dataType, "baseType");
        Element enumElem = this.makeChild(baseType, "enum");
        Element values = this.makeChild(enumElem, "values");
        for (PlcEnumLiteral enumLit : enumType.literals) {
            Element value = this.makeChild(values, "value");
            value.setAttribute("name", enumLit.value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void transType(PlcType type, Element parent) {
        PlcType plcType = type;
        if (plcType instanceof PlcElementaryType) {
            void eType;
            PlcElementaryType plcElementaryType = (PlcElementaryType)plcType;
            PlcElementaryType cfr_ignored_0 = (PlcElementaryType)plcType;
            this.makeChild(parent, eType.name);
        } else {
            PlcType plcType2 = type;
            if (plcType2 instanceof PlcDerivedType) {
                void dType;
                PlcDerivedType plcDerivedType = (PlcDerivedType)plcType2;
                PlcDerivedType cfr_ignored_1 = (PlcDerivedType)plcType2;
                Element derived = this.makeChild(parent, "derived");
                derived.setAttribute("name", dType.name);
            } else {
                PlcType plcType3 = type;
                if (plcType3 instanceof PlcStructType) {
                    void structType;
                    PlcStructType derived = (PlcStructType)plcType3;
                    PlcStructType cfr_ignored_2 = (PlcStructType)plcType3;
                    Element derived2 = this.makeChild(parent, "derived");
                    derived2.setAttribute("name", structType.typeName);
                } else {
                    PlcType plcType4 = type;
                    if (plcType4 instanceof PlcEnumType) {
                        void enumType;
                        PlcEnumType derived2 = (PlcEnumType)plcType4;
                        PlcEnumType cfr_ignored_3 = (PlcEnumType)plcType4;
                        Element derived = this.makeChild(parent, "derived");
                        derived.setAttribute("name", enumType.typeName);
                    } else {
                        PlcType plcType5 = type;
                        if (plcType5 instanceof PlcArrayType) {
                            void aType;
                            PlcArrayType derived = (PlcArrayType)plcType5;
                            PlcArrayType cfr_ignored_4 = (PlcArrayType)plcType5;
                            Element array = this.makeChild(parent, "array");
                            Element dim = this.makeChild(array, "dimension");
                            dim.setAttribute("lower", Strings.str((Object)aType.lower));
                            dim.setAttribute("upper", Strings.str((Object)aType.upper));
                            Element bt = this.makeChild(array, "baseType");
                            this.transType(aType.elemType, bt);
                        } else {
                            PlcType plcType6 = type;
                            if (plcType6 instanceof PlcFuncBlockType) {
                                void blockType;
                                PlcFuncBlockType array = (PlcFuncBlockType)plcType6;
                                PlcFuncBlockType cfr_ignored_5 = (PlcFuncBlockType)plcType6;
                                Element derived = this.makeChild(parent, "derived");
                                derived.setAttribute("name", blockType.typeName);
                            } else {
                                throw new RuntimeException("Unknown plc type: " + String.valueOf(type));
                            }
                        }
                    }
                }
            }
        }
    }

    private void transVariable(PlcDataVariable var, Element parent) {
        Element varElem = this.makeChild(parent, "variable");
        varElem.setAttribute("name", var.varName);
        if (var.address != null) {
            varElem.setAttribute("address", var.address);
        }
        Element type = this.makeChild(varElem, "type");
        this.transType(var.type, type);
        if (var.value != null) {
            Element value = this.makeChild(varElem, "initialValue");
            this.transValue(var.value, value);
        }
    }

    private void transStructField(PlcStructField field, Element parent) {
        Element varElem = this.makeChild(parent, "variable");
        varElem.setAttribute("name", field.fieldName);
        Element type = this.makeChild(varElem, "type");
        this.transType(field.type, type);
    }

    private void transValue(PlcExpression value, Element parent) {
        Element vElem = this.makeChild(parent, "simpleValue");
        vElem.setAttribute("value", this.target.getModelTextGenerator().literalToString(value));
    }

    private void transPou(PlcPou pou, Element parent) {
        Element e;
        Element pouElem = this.makeChild(parent, "pou");
        pouElem.setAttribute("name", pou.name);
        String pouTypeText = null;
        switch (pou.pouType) {
            case FUNCTION: {
                pouTypeText = "function";
                break;
            }
            case PROGRAM: {
                pouTypeText = "program";
            }
        }
        pouElem.setAttribute("pouType", pouTypeText);
        Element iface = this.makeChild(pouElem, "interface");
        if (pou.retType != null) {
            Element rtElem = this.makeChild(iface, "returnType");
            this.transType(pou.retType, rtElem);
        }
        if (!pou.inputVars.isEmpty()) {
            e = this.makeChild(iface, "inputVars");
            for (PlcDataVariable var : pou.inputVars) {
                this.transVariable(var, e);
            }
        }
        if (!pou.outputVars.isEmpty()) {
            e = this.makeChild(iface, "outputVars");
            for (PlcDataVariable var : pou.outputVars) {
                this.transVariable(var, e);
            }
        }
        if (!pou.localVars.isEmpty()) {
            e = this.makeChild(iface, "localVars");
            for (PlcDataVariable var : pou.localVars) {
                this.transVariable(var, e);
            }
        }
        if (!pou.tempVars.isEmpty()) {
            e = this.makeChild(iface, "tempVars");
            for (PlcDataVariable var : pou.tempVars) {
                this.transVariable(var, e);
            }
        }
        this.transBody(pou.body, pouElem);
    }

    private void transBody(CodeBox body, Element parent) {
        Element bodyElem = this.makeChild(parent, "body");
        Element st = this.makeChild(bodyElem, "ST");
        Element xhtml = st.getOwnerDocument().createElementNS(XHTML_NS, "xhtml");
        st.appendChild(xhtml);
        xhtml.setTextContent(body.toString());
    }

    private void transConfig(PlcConfiguration config, Element parent) {
        Element configElem = this.makeChild(parent, "configuration");
        configElem.setAttribute("name", config.name);
        for (PlcResource resource : config.resources) {
            this.transResource(resource, configElem);
        }
        for (PlcGlobalVarList varList : config.globalVarLists) {
            this.transGlobalVarList(varList, configElem);
        }
    }

    private void transGlobalVarList(PlcGlobalVarList varList, Element parent) {
        if (varList.variables.isEmpty()) {
            return;
        }
        Element gv = this.makeChild(parent, "globalVars");
        gv.setAttribute("name", varList.name);
        gv.setAttribute("constant", varList.listKind == PlcGlobalVarList.PlcVarListKind.CONSTANTS ? "true" : "false");
        for (PlcDataVariable var : varList.variables) {
            this.transVariable(var, gv);
        }
    }

    private void transResource(PlcResource resource, Element parent) {
        Element resElem = this.makeChild(parent, "resource");
        resElem.setAttribute("name", resource.name);
        for (PlcTask task : resource.tasks) {
            this.transTask(task, resElem);
        }
        for (PlcGlobalVarList varList : resource.globalVarLists) {
            this.transGlobalVarList(varList, resElem);
        }
        for (PlcPouInstance inst : resource.pouInstances) {
            this.transPouInstance(inst, resElem);
        }
    }

    private Element transPouInstance(PlcPouInstance inst, Element parent) {
        Element instElem = this.makeChild(parent, "pouInstance");
        instElem.setAttribute("name", inst.name);
        instElem.setAttribute("typeName", inst.pou.name);
        return instElem;
    }

    private void transPouInstanceWithDoc(PlcPouInstance inst, Element parent) {
        Element instElem = this.transPouInstance(inst, parent);
        Element docElem = this.makeChild(instElem, "documentation");
        Element xhtml = docElem.getOwnerDocument().createElementNS(XHTML_NS, "xhtml");
        docElem.appendChild(xhtml);
    }

    private void transTask(PlcTask task, Element parent) {
        Element taskElem = this.makeChild(parent, "task");
        taskElem.setAttribute("name", task.name);
        taskElem.setAttribute("interval", Strings.fmt((String)"PT%.3fS", (Object[])new Object[]{Float.valueOf((float)task.cycleTime / 1000.0f)}));
        taskElem.setAttribute("priority", Strings.str((Object)task.priority));
        for (PlcPouInstance inst : task.pouInstances) {
            this.transPouInstanceWithDoc(inst, taskElem);
        }
    }

    private Element makeChild(Element parent, String childName) {
        Element child = parent.getOwnerDocument().createElement(childName);
        parent.appendChild(child);
        return child;
    }

    private void validateDocument(String filePath) {
        InputStream schemaStream = null;
        InputStream xmlStream = null;
        try {
            try {
                Schema schema;
                Object schemaName = PlcOpenXmlWriter.class.getPackage().getName();
                schemaName = ((String)schemaName).replace('.', '/') + "/tc6_xml_v201.xsd";
                ClassLoader classLoader = PlcOpenXmlWriter.class.getClassLoader();
                schemaStream = classLoader.getResourceAsStream((String)schemaName);
                StreamSource schemaSrc = new StreamSource(schemaStream);
                xmlStream = new FileInputStream(filePath);
                xmlStream = new BufferedInputStream(xmlStream);
                StreamSource xmlSrc = new StreamSource(xmlStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                try {
                    schema = schemaFactory.newSchema(schemaSrc);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
                Validator validator = schema.newValidator();
                try {
                    validator.validate(xmlSrc);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to validate \"%s\" due to an I/O error.", (Object[])new Object[]{filePath});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException iOException) {}
            }
            if (xmlStream != null) {
                try {
                    xmlStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeDocument(Document doc, String filePath) {
        FileOutputStream xmlStream;
        Transformer xmlTrans;
        TransformerFactory xmlTransFactory = TransformerFactory.newInstance();
        try {
            xmlTrans = xmlTransFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        xmlTrans.setOutputProperty("indent", "yes");
        xmlTrans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        try {
            xmlStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException ex) {
            String msg = Strings.fmt((String)"Failed to write PLCopen XML file to \"%s\".", (Object[])new Object[]{filePath});
            throw new InputOutputException(msg, (Throwable)ex);
        }
        StreamResult result = new StreamResult(xmlStream);
        try {
            xmlTrans.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        try {
            xmlStream.close();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{filePath});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }
}

