/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDeclaredType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.Box;

public class Iec611313Writer
extends Writer {
    public Iec611313Writer(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, String outPath) {
        this.ensureDirectory(outPath);
        for (PlcConfiguration config : project.configurations) {
            this.write(config, outPath);
        }
        for (PlcPou pou : project.pous) {
            this.write(pou, outPath);
        }
        for (PlcDeclaredType declaredType : project.declaredTypes) {
            this.writeDeclaredType(declaredType, outPath);
        }
    }

    private void write(PlcConfiguration config, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, config.name + ".plccfg"});
        Box code = this.toBox(config);
        code.writeToFile(path);
    }

    private void write(PlcPou pou, String outPath) {
        String ext = pou.retType == null ? ".plcprog" : ".plcfunc";
        String path = Paths.join((String[])new String[]{outPath, pou.name + ext});
        Box code = this.toBox(pou);
        code.writeToFile(path);
    }

    /*
     * WARNING - void declaration
     */
    private void writeDeclaredType(PlcDeclaredType declaredType, String outPath) {
        String typeName;
        PlcDeclaredType plcDeclaredType = declaredType;
        if (plcDeclaredType instanceof PlcStructType) {
            void structType;
            PlcStructType plcStructType = (PlcStructType)plcDeclaredType;
            PlcStructType cfr_ignored_0 = (PlcStructType)plcDeclaredType;
            typeName = structType.typeName;
        } else {
            PlcDeclaredType plcDeclaredType2 = declaredType;
            if (plcDeclaredType2 instanceof PlcEnumType) {
                void enumType;
                PlcEnumType plcEnumType = (PlcEnumType)plcDeclaredType2;
                PlcEnumType cfr_ignored_1 = (PlcEnumType)plcDeclaredType2;
                typeName = enumType.typeName;
            } else {
                throw new AssertionError((Object)("Unexpected declared type found: \"" + String.valueOf(declaredType) + "\"."));
            }
        }
        String path = Paths.join((String[])new String[]{outPath, typeName + ".plctype"});
        Box code = this.toTypeDeclBox(declaredType);
        code.writeToFile(path);
    }
}

