/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDeclaredType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.Box;

public class AbbWriter
extends Writer {
    public AbbWriter(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, String outputPath) {
        this.ensureDirectory(outputPath);
        for (PlcConfiguration config : project.configurations) {
            this.write(config, outputPath);
        }
        for (PlcPou pou : project.pous) {
            this.write(pou, outputPath);
        }
        for (PlcDeclaredType declaredType : project.declaredTypes) {
            this.writeDeclaredType(declaredType, outputPath);
        }
    }

    private void write(PlcConfiguration config, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, config.name + ".plccfg"});
        Box code = this.toBox(config);
        code.writeToFile(path);
    }

    private void write(PlcPou pou, String outPath) {
        String ext = pou.retType == null ? ".plcprog" : ".plcfunc";
        String path = Paths.join((String[])new String[]{outPath, pou.name + ext});
        Box code = this.toBox(pou);
        code.writeToFile(path);
    }

    /*
     * WARNING - void declaration
     */
    private void writeDeclaredType(PlcDeclaredType declaredType, String outPath) {
        String typeName;
        PlcDeclaredType plcDeclaredType = declaredType;
        if (plcDeclaredType instanceof PlcStructType) {
            void structType;
            PlcStructType plcStructType = (PlcStructType)plcDeclaredType;
            PlcStructType cfr_ignored_0 = (PlcStructType)plcDeclaredType;
            typeName = structType.typeName;
        } else {
            PlcDeclaredType plcDeclaredType2 = declaredType;
            if (plcDeclaredType2 instanceof PlcStructType) {
                void enumType;
                PlcStructType plcStructType = (PlcStructType)plcDeclaredType2;
                PlcStructType cfr_ignored_1 = (PlcStructType)plcDeclaredType2;
                typeName = enumType.typeName;
            } else {
                throw new AssertionError((Object)("Unexpected declared type found: \"" + String.valueOf(declaredType) + "\"."));
            }
        }
        String path = Paths.join((String[])new String[]{outPath, typeName + ".plctype"});
        Box code = this.toTypeDeclBox(declaredType);
        code.writeToFile(path);
    }
}

