/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.options;

import java.util.Locale;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class PlcMaxIterOption
extends StringOption {
    private static final String DEFAULT_VALUE = "inf,inf";
    private static final String VALUE_DESCRIPTION_TEXT = "The maximum number of iterations to try each uncontrollable event once and the maximum number of\niterations to try each controllable event once, for a single execution of the main program body.\nA maximum number of iterations is either a positive integer number or \"inf\" to state\nthere is no upper bound on the maximum number of iterations.\nThis option takes two maximum numbers, one for uncontrollable events and one for controllable\nevents.\nFor example \"20,inf\" means that in a single execution of the main program body at most 20 times\nevery uncontrollable event is tried, and at most an unrestricted number of times every\ncontrollable event is tried. Note that an iteration loop is always considered finished as soon\nas none of the tried events in one iteration was possible.\nIf only one value is given to this option, it is used as maximum iteration count for both\nuncontrollable and controllable events.";

    public PlcMaxIterOption() {
        super("PLC maximum iterations", "The maximum number of iterations to try each uncontrollable event once and the maximum number of\niterations to try each controllable event once, for a single execution of the main program body.\nA maximum number of iterations is either a positive integer number or \"inf\" to state\nthere is no upper bound on the maximum number of iterations.\nThis option takes two maximum numbers, one for uncontrollable events and one for controllable\nevents.\nFor example \"20,inf\" means that in a single execution of the main program body at most 20 times\nevery uncontrollable event is tried, and at most an unrestricted number of times every\ncontrollable event is tried. Note that an iteration loop is always considered finished as soon\nas none of the tried events in one iteration was possible.\nIf only one value is given to this option, it is used as maximum iteration count for both\nuncontrollable and controllable events. [DEFAULT=\"inf,inf\"]".replace("\n", " "), Character.valueOf('x'), "max-iter", "ITERS", DEFAULT_VALUE, false, true, VALUE_DESCRIPTION_TEXT.replace("\n", " "), "Maximum iterations:");
    }

    public static MaxIterLimits getMaxIterLimits() {
        String conText;
        String unconText;
        String value = (String)Options.get(PlcMaxIterOption.class);
        int sepIndex = value.indexOf(44);
        if (sepIndex < 0) {
            unconText = value.strip();
            conText = value.strip();
        } else {
            unconText = value.substring(0, sepIndex).strip();
            conText = value.substring(sepIndex + 1).strip();
        }
        return new MaxIterLimits(PlcMaxIterOption.convertLimit("uncontrollable", unconText), PlcMaxIterOption.convertLimit("controllable", conText));
    }

    private static Integer convertLimit(String eventKind, String numberText) {
        int value;
        if (numberText.toLowerCase(Locale.US).equals("inf")) {
            return null;
        }
        try {
            value = Integer.parseInt(numberText);
        }
        catch (NumberFormatException ex) {
            throw new InvalidOptionException(Strings.fmt((String)"PLC maximum iterations option value \"%s\" for %s events is neither recognized as infinite (\"inf\" without quotes) nor as positive integer number.", (Object[])new Object[]{numberText, eventKind}), (Throwable)ex);
        }
        if (value <= 0) {
            throw new InvalidOptionException(Strings.fmt((String)"PLC maximum iterations option value \"%d\" for %s events is not a positive number.", (Object[])new Object[]{value, eventKind}));
        }
        return value;
    }

    public record MaxIterLimits(Integer uncontrollableLimit, Integer controllableLimit) {
    }
}

