/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.types;

import org.eclipse.escet.cif.plcgen.model.types.PlcType;

public class PlcElementaryType
extends PlcType {
    public static final PlcElementaryType BOOL_TYPE = new PlcElementaryType("BOOL");
    public static final PlcElementaryType INT_TYPE = new PlcElementaryType("INT");
    public static final PlcElementaryType DINT_TYPE = new PlcElementaryType("DINT");
    public static final PlcElementaryType LINT_TYPE = new PlcElementaryType("LINT");
    public static final PlcElementaryType REAL_TYPE = new PlcElementaryType("REAL");
    public static final PlcElementaryType LREAL_TYPE = new PlcElementaryType("LREAL");
    public static final PlcElementaryType TIME_TYPE = new PlcElementaryType("TIME");
    public final String name;

    private PlcElementaryType(String name) {
        this.name = name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void elementaryType;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!(object instanceof PlcElementaryType)) {
            return false;
        }
        PlcElementaryType plcElementaryType = (PlcElementaryType)object;
        PlcElementaryType cfr_ignored_0 = (PlcElementaryType)object;
        return this.name.equals(elementaryType.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        return "PlcElementaryType(\"" + this.name + "\")";
    }

    public static PlcElementaryType getIntTypeBySize(int numBits) {
        return switch (numBits) {
            case 16 -> INT_TYPE;
            case 32 -> DINT_TYPE;
            case 64 -> LINT_TYPE;
            default -> throw new AssertionError((Object)("Unexpected integer size " + String.valueOf(numBits) + " found."));
        };
    }

    public static int getSizeOfIntType(PlcElementaryType intType) {
        if (intType.equals(LINT_TYPE)) {
            return 64;
        }
        if (intType.equals(DINT_TYPE)) {
            return 32;
        }
        if (intType.equals(INT_TYPE)) {
            return 16;
        }
        if (intType.equals(BOOL_TYPE)) {
            return 1;
        }
        throw new AssertionError((Object)("Unexpected elementary type " + String.valueOf(intType) + " found."));
    }

    public static PlcElementaryType getRealTypeBySize(int numBits) {
        return switch (numBits) {
            case 32 -> REAL_TYPE;
            case 64 -> LREAL_TYPE;
            default -> throw new AssertionError((Object)("Unexpected real size " + String.valueOf(numBits) + " found."));
        };
    }

    public static boolean isIntType(PlcType type) {
        return type.equals(INT_TYPE) || type.equals(DINT_TYPE) || type.equals(LINT_TYPE);
    }

    public static boolean isRealType(PlcType type) {
        return type.equals(REAL_TYPE) || type.equals(LREAL_TYPE);
    }
}

