/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.functions;

import java.util.EnumSet;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.types.PlcAbstractType;
import org.eclipse.escet.common.java.Assert;

public class PlcPlainFuncDescription
extends PlcBasicFuncDescription {
    public final String infixFuncName;
    public final PlcBasicFuncDescription.ExprBinding infixBinding;

    public PlcPlainFuncDescription(String prefixFuncName, PlcBasicFuncDescription.PlcParameterDescription[] parameters, String infixFuncName, PlcBasicFuncDescription.ExprBinding infixBinding, EnumSet<PlcBasicFuncDescription.PlcFuncNotation> notations, PlcAbstractType resultType) {
        super(prefixFuncName, parameters, PlcPlainFuncDescription.computeFuncApplNotations(prefixFuncName, infixFuncName, notations), resultType);
        Assert.implies((infixFuncName == null ? 1 : 0) != 0, (infixBinding == PlcBasicFuncDescription.ExprBinding.NO_PRIORITY ? 1 : 0) != 0);
        this.infixFuncName = infixFuncName;
        this.infixBinding = infixBinding;
    }

    public PlcPlainFuncDescription(String prefixFuncName, PlcBasicFuncDescription.PlcParameterDescription[] parameters, String infixFuncName, PlcBasicFuncDescription.ExprBinding infixBinding, EnumSet<PlcBasicFuncDescription.PlcFuncNotation> notations, PlcAbstractType resultType, PlcBasicFuncDescription.PlcFuncTypeExtension typeExtension) {
        super(prefixFuncName, parameters, PlcPlainFuncDescription.computeFuncApplNotations(prefixFuncName, infixFuncName, notations), resultType, typeExtension);
        Assert.implies((infixFuncName == null ? 1 : 0) != 0, (infixBinding == PlcBasicFuncDescription.ExprBinding.NO_PRIORITY ? 1 : 0) != 0);
        this.infixFuncName = infixFuncName;
        this.infixBinding = infixBinding;
    }

    private static EnumSet<PlcBasicFuncDescription.PlcFuncNotation> computeFuncApplNotations(String prefixFuncName, String infixFuncName, EnumSet<PlcBasicFuncDescription.PlcFuncNotation> notations) {
        notations = EnumSet.copyOf(notations);
        if (infixFuncName == null) {
            notations.retainAll(PlcBasicFuncDescription.PlcFuncNotation.NOT_INFIX);
        }
        if (prefixFuncName == null) {
            notations.retainAll(PlcBasicFuncDescription.PlcFuncNotation.INFIX_ONLY);
        }
        return notations;
    }

    @Override
    public String getFuncName() {
        if (this.prefixFuncName != null && !this.prefixFuncName.isEmpty()) {
            return super.getFuncName();
        }
        if (this.infixFuncName != null) {
            return "infix-\"" + this.infixFuncName + "\"";
        }
        return super.getFuncName();
    }
}

