/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEnumUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultTypeGenerator
implements TypeGenerator {
    private final PlcTarget target;
    private final PlcElementaryType standardIntType;
    private final PlcElementaryType standardRealType;
    private final Map<TypeEqHashWrap, PlcStructType> structTypes = Maps.map();
    private final Map<CifEnumUtils.EnumDeclEqHashWrap, PlcEnumType> enumTypes = Maps.map();

    public DefaultTypeGenerator(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.standardIntType = target.getIntegerType();
        this.standardRealType = target.getRealType();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PlcType convertType(CifType type) {
        if (type instanceof BoolType) {
            return PlcElementaryType.BOOL_TYPE;
        }
        if (type instanceof IntType) {
            return this.standardIntType;
        }
        if (type instanceof RealType) {
            return this.standardRealType;
        }
        CifType cifType = type;
        if (cifType instanceof TypeRef) {
            void typeRef;
            TypeRef typeRef2 = (TypeRef)cifType;
            TypeRef cfr_ignored_0 = (TypeRef)cifType;
            return this.convertType(typeRef.getType().getType());
        }
        CifType cifType2 = type;
        if (cifType2 instanceof TupleType) {
            void tupleType;
            TupleType tupleType2 = (TupleType)cifType2;
            TupleType cfr_ignored_1 = (TupleType)cifType2;
            return this.convertTupleType((TupleType)tupleType);
        }
        CifType cifType3 = type;
        if (cifType3 instanceof EnumType) {
            void enumType;
            EnumType enumType2 = (EnumType)cifType3;
            EnumType cfr_ignored_2 = (EnumType)cifType3;
            return this.convertEnumDecl(enumType.getEnum());
        }
        CifType cifType4 = type;
        if (cifType4 instanceof ListType) {
            void arrayType;
            ListType listType = (ListType)cifType4;
            ListType cfr_ignored_3 = (ListType)cifType4;
            int size = arrayType.getLower();
            Assert.check((boolean)CifTypeUtils.isArrayType((ListType)arrayType));
            Assert.check((!(arrayType.getElementType() instanceof ListType) ? 1 : 0) != 0);
            PlcType elemType = this.convertType(arrayType.getElementType());
            return new PlcArrayType(0, size == 0 ? 0 : size - 1, elemType);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    @Override
    public PlcStructType convertTupleType(TupleType tupleType) {
        TypeEqHashWrap typeWrap = new TypeEqHashWrap((CifType)tupleType, true, false);
        PlcStructType structType = this.structTypes.get(typeWrap);
        if (structType == null) {
            structType = this.makePlcStructType(tupleType);
            this.structTypes.put(typeWrap, structType);
        }
        return structType;
    }

    private PlcStructType makePlcStructType(TupleType tupleType) {
        EList tupleFields = tupleType.getFields();
        List structFields = Lists.listc((int)tupleFields.size());
        int fieldNumber = 1;
        for (Field field : tupleFields) {
            String fieldName = "field" + String.valueOf(fieldNumber);
            PlcType ftype = this.convertType(field.getType());
            structFields.add(new PlcStructField(fieldName, ftype));
            ++fieldNumber;
        }
        String typeName = this.target.getNameGenerator().generateGlobalName("TupleStruct", false);
        PlcStructType structType = new PlcStructType(typeName, structFields);
        this.target.getCodeStorage().addDeclaredType(structType);
        return structType;
    }

    @Override
    public PlcEnumType convertEnumDecl(EnumDecl enumDecl) {
        CifEnumUtils.EnumDeclEqHashWrap wrappedEnumDecl = new CifEnumUtils.EnumDeclEqHashWrap(enumDecl);
        return this.enumTypes.computeIfAbsent(wrappedEnumDecl, key -> this.makePlcEnumType(enumDecl));
    }

    public PlcEnumType makePlcEnumType(EnumDecl enumDecl) {
        Assert.areEqual((Object)((Object)this.target.getActualEnumerationsConversion()), (Object)((Object)ConvertEnums.KEEP));
        NameGenerator nameGenerator = this.target.getNameGenerator();
        List litNames = (List)enumDecl.getLiterals().stream().map(lit -> nameGenerator.generateGlobalName(CifTextUtils.getAbsName((PositionObject)lit, (boolean)false), true)).collect(Lists.toList());
        String typeName = nameGenerator.generateGlobalName(CifTextUtils.getAbsName((PositionObject)enumDecl, (boolean)false), true);
        PlcEnumType plcEnumType = new PlcEnumType(typeName, litNames);
        this.target.getCodeStorage().addDeclaredType(plcEnumType);
        return plcEnumType;
    }
}

