/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprAddressableResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.generators.CifEventTransition;
import org.eclipse.escet.cif.plcgen.generators.DocumentingSupport;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.TransitionGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentBlock;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcSelectionStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultTransitionGenerator
implements TransitionGenerator {
    private static final int EVENT_COMMENT_STARCOUNT = 60;
    private static final int AUTOMATA_COMMENT_STARCOUNT = 30;
    private final PlcTarget target;
    private List<CifEventTransition> eventTransitions = null;
    private final Map<Automaton, PlcBasicVariable> edgeSelectionVariables = Maps.map();
    private NameGenerator nameGen;
    private ExprGenerator mainExprGen;
    private PlcFunctionAppls funcAppls;

    public DefaultTransitionGenerator(PlcTarget target) {
        this.target = target;
    }

    @Override
    public void setTransitions(List<CifEventTransition> eventTransitions) {
        this.eventTransitions = eventTransitions;
    }

    @Override
    public void generate() {
        List uncontrollableTransitions = Lists.list();
        List controllableTransitions = Lists.list();
        for (CifEventTransition eventTrans : this.eventTransitions) {
            if (eventTrans.event.getControllable() == null) {
                throw new AssertionError((Object)("Unexpected lack of controllability for event \"" + String.valueOf(eventTrans.event) + "\" found."));
            }
            if (eventTrans.event.getControllable().booleanValue()) {
                controllableTransitions.add(eventTrans);
                continue;
            }
            uncontrollableTransitions.add(eventTrans);
        }
        PlcBasicVariable isProgressVar = this.target.getCodeStorage().getIsProgressVariable();
        List<PlcStatement> uncontrollableStatements = this.generateCode(isProgressVar, uncontrollableTransitions);
        List<PlcStatement> controllableStatements = this.generateCode(isProgressVar, controllableTransitions);
        this.target.getCodeStorage().addEventTransitions(uncontrollableStatements, controllableStatements);
    }

    List<PlcStatement> generateCode(PlcBasicVariable isProgressVar, List<CifEventTransition> eventTransitions) {
        this.nameGen = this.target.getNameGenerator();
        this.mainExprGen = this.target.getCodeStorage().getExprGenerator();
        this.funcAppls = new PlcFunctionAppls(this.target);
        this.edgeSelectionVariables.clear();
        for (CifEventTransition evtTrans : eventTransitions) {
            for (CifEventTransition.TransitionAutomaton transAut : evtTrans.senders) {
                this.ensureEdgeVariable(transAut.aut);
            }
            for (CifEventTransition.TransitionAutomaton transAut : evtTrans.receivers) {
                this.ensureEdgeVariable(transAut.aut);
            }
            for (CifEventTransition.TransitionAutomaton transAut : evtTrans.syncers) {
                this.ensureEdgeVariable(transAut.aut);
            }
        }
        boolean addEmptyLineBefore = false;
        List statements = Lists.list();
        for (CifEventTransition eventTransition : eventTransitions) {
            statements.addAll(this.generateEventTransitionCode(eventTransition, addEmptyLineBefore, isProgressVar));
            addEmptyLineBefore = true;
        }
        this.mainExprGen.releaseTempVariables(this.edgeSelectionVariables.values());
        this.edgeSelectionVariables.clear();
        return statements;
    }

    private void ensureEdgeVariable(Automaton aut) {
        if (this.edgeSelectionVariables.containsKey(aut)) {
            return;
        }
        String edgeVariableName = this.nameGen.generateGlobalName("edge_" + aut.getName(), false);
        this.target.getCodeStorage().setAutomatonEdgeVariableName(aut, edgeVariableName);
        PlcBasicVariable autVar = this.mainExprGen.getTempVariable(edgeVariableName, PlcElementaryType.DINT_TYPE);
        this.edgeSelectionVariables.put(aut, autVar);
    }

    private List<PlcStatement> generateEventTransitionCode(CifEventTransition eventTransition, boolean prependEmptyLine, PlcBasicVariable isProgressVar) {
        List testCode = Lists.list();
        List performCode = Lists.list();
        List createdTempVariables = Lists.list();
        PlcBasicVariable eventEnabledVar = this.mainExprGen.getTempVariable("eventEnabled", PlcElementaryType.BOOL_TYPE);
        createdTempVariables.add(eventEnabledVar);
        boolean eventEnabledAlwaysHolds = true;
        if (prependEmptyLine) {
            testCode.add(new PlcCommentLine(null));
        }
        testCode.add(this.genAnnounceEventBeingTried(eventTransition));
        testCode.add(new PlcAssignmentStatement(eventEnabledVar, (PlcExpression)new PlcBoolLiteral(true)));
        performCode.add(new PlcAssignmentStatement(isProgressVar, (PlcExpression)new PlcBoolLiteral(true)));
        CifDataProvider performProvider = this.generateCopiedState(eventTransition.collectAssignedVariables(), performCode, createdTempVariables);
        CifType channelType = eventTransition.event.getType();
        if (channelType != null) {
            String performAcceptText;
            String performProvideText;
            PlcBasicVariable channelValueVar;
            if ((channelType = CifTypeUtils.normalizeType((CifType)channelType)) instanceof VoidType) {
                channelValueVar = null;
                performProvideText = "Perform assignments of the selected providing automaton.";
                performAcceptText = "Perform assignments of the selected accepting automaton.";
            } else {
                channelValueVar = this.mainExprGen.getTempVariable("channelValue", channelType);
                createdTempVariables.add(channelValueVar);
                performProvideText = "Store the provided value and perform assignments of the selected providing automaton.";
                performAcceptText = "Deliver the provided value and perform assignments of the selected accepting automaton.";
            }
            testCode.add(new PlcCommentBlock(30, List.of("Try to find a sender automaton that provides a value.")));
            performCode.add(new PlcCommentBlock(30, List.of(performProvideText)));
            this.generateSendReceiveCode(eventTransition.event, eventTransition.senders, testCode, performProvider, performCode, CifEventTransition.TransAutPurpose.SENDER, createdTempVariables, eventEnabledVar, channelValueVar, eventEnabledAlwaysHolds);
            eventEnabledAlwaysHolds = false;
            testCode.add(new PlcCommentBlock(30, List.of("Try to find a receiver automaton that accepts a value.")));
            performCode.add(new PlcCommentBlock(30, List.of(performAcceptText)));
            this.mainExprGen.setChannelValueVariable(channelValueVar);
            this.generateSendReceiveCode(eventTransition.event, eventTransition.receivers, testCode, performProvider, performCode, CifEventTransition.TransAutPurpose.RECEIVER, createdTempVariables, eventEnabledVar, null, eventEnabledAlwaysHolds);
            this.mainExprGen.setChannelValueVariable(null);
        }
        if (!eventTransition.syncers.isEmpty()) {
            testCode.add(new PlcCommentBlock(30, List.of("Check each synchronizing automaton for having an edge with a true guard.")));
            performCode.add(new PlcCommentBlock(30, List.of("Perform the assignments of each synchronizing automaton.")));
            this.generateSyncCode(eventTransition.event, eventTransition.syncers, testCode, performProvider, performCode, createdTempVariables, eventEnabledVar, eventEnabledAlwaysHolds);
        }
        if (!eventTransition.monitors.isEmpty()) {
            performCode.add(new PlcCommentBlock(30, List.of("Perform the assignments of each optionally synchronizing automaton.")));
            this.generateMonitorCode(eventTransition.monitors, performProvider, performCode, createdTempVariables);
        }
        List resultCode = testCode;
        PlcVarExpression guard = new PlcVarExpression(eventEnabledVar, new PlcVarExpression.PlcProjection[0]);
        resultCode.add(new PlcCommentLine(Strings.fmt((String)"All checks have been done. If variable \"%s\" still holds, event \"%s\" can occur.", (Object[])new Object[]{eventEnabledVar.varName, CifTextUtils.getAbsName((PositionObject)eventTransition.event, (boolean)false)})));
        resultCode.add(this.generateIfGuardThenCode(guard, performCode));
        this.mainExprGen.releaseTempVariables(createdTempVariables);
        return resultCode;
    }

    private PlcCommentBlock genAnnounceEventBeingTried(CifEventTransition eventTrans) {
        MemoryCodeBox box = new MemoryCodeBox();
        box.add("Try to perform %s.", new Object[]{DocumentingSupport.getDescription((PositionObject)eventTrans.event)});
        CifType eventType = eventTrans.event.getType();
        if (eventType != null) {
            boolean transferValue = !(eventType instanceof VoidType);
            box.add();
            if (eventTrans.senders.isEmpty()) {
                box.add("- An automaton that must send a value is missing, so the event cannot occur.");
            } else {
                if (transferValue) {
                    box.add("- One automaton must send a value.");
                } else {
                    box.add("- One automaton must send a value (although no data is actually transferred).");
                }
                for (CifEventTransition.TransitionAutomaton transAut : eventTrans.senders) {
                    box.add("   - Automaton \"%s\" may send a value.", new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)});
                }
            }
            box.add();
            if (eventTrans.receivers.isEmpty()) {
                box.add("- An automaton that must receive a value is missing, so the event cannot occur.");
            } else {
                if (transferValue) {
                    box.add("- One automaton must receive a value.");
                } else {
                    box.add("- One automaton must receive a value (although no data is actually transferred).");
                }
                for (CifEventTransition.TransitionAutomaton transAut : eventTrans.receivers) {
                    box.add("   - Automaton \"%s\" may receive a value.", new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)});
                }
            }
        }
        if (!eventTrans.syncers.isEmpty()) {
            box.add();
            for (CifEventTransition.TransitionAutomaton transAut : eventTrans.syncers) {
                box.add("- Automaton \"%s\" must always synchronize.", new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)});
            }
        }
        if (!eventTrans.monitors.isEmpty()) {
            box.add();
            for (CifEventTransition.TransitionAutomaton transAut : eventTrans.monitors) {
                box.add("- Automaton \"%s\" may synchronize.", new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)});
            }
        }
        return new PlcCommentBlock(60, box.getLines());
    }

    /*
     * WARNING - void declaration
     */
    private CifDataProvider generateCopiedState(Set<Declaration> assignedVariables, List<PlcStatement> codeStorage, List<PlcBasicVariable> createdTempVariables) {
        if (assignedVariables.isEmpty()) {
            return null;
        }
        List assignedVarList = Lists.set2list(assignedVariables);
        Collections.sort(assignedVarList, Comparator.comparing(v -> CifTextUtils.getAbsName((PositionObject)v, (boolean)false)));
        if (!assignedVariables.isEmpty()) {
            codeStorage.add(new PlcCommentLine("Make temporary copies of assigned variables to preserve the old values while assigning new values."));
        }
        CifDataProvider cifDataProvider = this.mainExprGen.getScopeCifDataProvider();
        Map redirectedDecls = Maps.map();
        for (Declaration assignedVar : assignedVarList) {
            Declaration declaration = assignedVar;
            if (declaration instanceof DiscVariable) {
                void dv;
                DiscVariable cfr_ignored_0 = (DiscVariable)declaration;
                DiscVariable cfr_ignored_1 = (DiscVariable)declaration;
                Object currentVar = this.mainExprGen.getTempVariable("current_" + CifTextUtils.getAbsName((PositionObject)dv, (boolean)false), dv.getType());
                createdTempVariables.add((PlcBasicVariable)currentVar);
                redirectedDecls.put(dv, new PlcVarExpression((PlcBasicVariable)currentVar, new PlcVarExpression.PlcProjection[0]));
                codeStorage.add(new PlcAssignmentStatement(new PlcVarExpression((PlcBasicVariable)currentVar, new PlcVarExpression.PlcProjection[0]), cifDataProvider.getValueForDiscVar((DiscVariable)dv)));
                continue;
            }
            Declaration declaration2 = assignedVar;
            if (declaration2 instanceof ContVariable) {
                void cv;
                ContVariable cfr_ignored_2 = (ContVariable)declaration2;
                ContVariable cfr_ignored_3 = (ContVariable)declaration2;
                PlcBasicVariable currentVar = this.mainExprGen.getTempVariable("current_" + CifTextUtils.getAbsName((PositionObject)cv, (boolean)false), this.target.getRealType());
                createdTempVariables.add(currentVar);
                redirectedDecls.put(cv, new PlcVarExpression(currentVar, new PlcVarExpression.PlcProjection[0]));
                codeStorage.add(new PlcAssignmentStatement(new PlcVarExpression(currentVar, new PlcVarExpression.PlcProjection[0]), cifDataProvider.getValueForContvar((ContVariable)cv, false)));
                continue;
            }
            throw new AssertionError((Object)("Unexpected kind of assigned variable \"" + String.valueOf(assignedVar) + "\"."));
        }
        return new TransitionDataProvider(redirectedDecls, cifDataProvider);
    }

    private void generateSendReceiveCode(Event event, List<CifEventTransition.TransitionAutomaton> autTransitions, List<PlcStatement> testCode, CifDataProvider performProvider, List<PlcStatement> performCode, CifEventTransition.TransAutPurpose purpose, List<PlcBasicVariable> createdTempVariables, PlcBasicVariable eventEnabledVar, PlcBasicVariable channelValueVar, boolean eventEnabledAlwaysHolds) {
        String failResultText;
        String varPrefix;
        if (purpose == CifEventTransition.TransAutPurpose.SENDER) {
            varPrefix = "sender";
            failResultText = "Failed to find an automaton that provides a value. Skip to the next event.";
        } else {
            varPrefix = "receiver";
            failResultText = "Failed to find an automaton that accepts a value. Skip to the next event.";
        }
        List autTestCode = Lists.list();
        PlcBasicVariable autVar = this.mainExprGen.getTempVariable(varPrefix + "Aut", PlcElementaryType.DINT_TYPE);
        createdTempVariables.add(autVar);
        autTestCode.add(this.generatePlcIntAssignment(autVar, 0));
        PlcSelectionStatement performSelectStat = new PlcSelectionStatement();
        List collectedNoUpdates = Lists.list();
        int autIndex = 1;
        for (CifEventTransition.TransitionAutomaton transAut : autTransitions) {
            PlcBasicVariable edgeVar = this.getAutomatonEdgeVariable(transAut.aut);
            autTestCode.addAll(this.generateEdgesTestCode(event, transAut, autIndex, autVar, edgeVar, eventEnabledVar));
            this.mainExprGen.setCurrentCifDataProvider(performProvider);
            String autCommentUpdateText = Strings.fmt((String)"Automaton \"%s\" was selected.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)});
            List<PlcStatement> updateCode = this.generateSelectedEdgePerformCode(transAut, edgeVar, channelValueVar, autCommentUpdateText, collectedNoUpdates);
            if (!updateCode.isEmpty()) {
                performSelectStat.condChoices.add(new PlcSelectionStatement.PlcSelectChoice(this.generateCompareVarWithVal(autVar, autIndex), updateCode));
            }
            this.mainExprGen.setCurrentCifDataProvider(null);
            ++autIndex;
        }
        if (!performSelectStat.condChoices.isEmpty()) {
            performCode.add(performSelectStat);
        }
        PlcExpression guard = this.generateCompareVarWithVal(autVar, 0);
        PlcCommentLine explanation = new PlcCommentLine(failResultText);
        PlcAssignmentStatement assignment = this.generatePlcBoolAssignment(eventEnabledVar, false);
        autTestCode.add(this.generateIfGuardThenCode(guard, Lists.list((Object[])new PlcStatement[]{explanation, assignment})));
        if (eventEnabledAlwaysHolds) {
            testCode.addAll(autTestCode);
        } else {
            guard = new PlcVarExpression(eventEnabledVar, new PlcVarExpression.PlcProjection[0]);
            testCode.add(this.generateIfGuardThenCode(guard, autTestCode));
        }
    }

    private void generateSyncCode(Event event, List<CifEventTransition.TransitionAutomaton> autTransitions, List<PlcStatement> testCode, CifDataProvider performProvider, List<PlcStatement> performCode, List<PlcBasicVariable> createdTempVariables, PlcBasicVariable eventEnabledVar, boolean eventEnabledAlwaysHolds) {
        List collectedNoUpdates = Lists.list();
        List collectedUpdates = Lists.list();
        for (CifEventTransition.TransitionAutomaton transAut : autTransitions) {
            PlcBasicVariable autEdgeVar = this.getAutomatonEdgeVariable(transAut.aut);
            List autTestCode = Lists.list();
            autTestCode.addAll(this.generateEdgesTestCode(event, transAut, -1, null, autEdgeVar, eventEnabledVar));
            this.mainExprGen.setCurrentCifDataProvider(performProvider);
            String autCommentUpdateText = Strings.fmt((String)"Perform assignments of automaton \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)});
            collectedUpdates.addAll(this.generateSelectedEdgePerformCode(transAut, autEdgeVar, null, autCommentUpdateText, collectedNoUpdates));
            this.mainExprGen.setCurrentCifDataProvider(null);
            if (eventEnabledAlwaysHolds) {
                testCode.addAll(autTestCode);
            } else {
                PlcVarExpression guard = new PlcVarExpression(eventEnabledVar, new PlcVarExpression.PlcProjection[0]);
                testCode.add(this.generateIfGuardThenCode(guard, autTestCode));
            }
            eventEnabledAlwaysHolds = false;
        }
        if (collectedUpdates.isEmpty()) {
            performCode.add(new PlcCommentLine("There are no assignments to perform for automata that must always synchronize."));
        }
        performCode.addAll(collectedUpdates);
        performCode.addAll(collectedNoUpdates);
    }

    private void generateMonitorCode(List<CifEventTransition.TransitionAutomaton> autTransitions, CifDataProvider performProvider, List<PlcStatement> testAndPerformCode, List<PlcBasicVariable> createdTempVariables) {
        List collectedNoUpdates = Lists.list();
        List collectedUpdates = Lists.list();
        this.mainExprGen.setCurrentCifDataProvider(performProvider);
        for (CifEventTransition.TransitionAutomaton transAut : autTransitions) {
            List updates = Lists.list();
            PlcSelectionStatement selStat = null;
            boolean addedAutomatonHeaderText = false;
            for (CifEventTransition.TransitionEdge edge : transAut.transitionEdges) {
                if (edge.updates.isEmpty()) continue;
                if (!addedAutomatonHeaderText) {
                    updates.add(new PlcCommentLine(Strings.fmt((String)"Perform assignments of automaton \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)})));
                    addedAutomatonHeaderText = true;
                }
                Supplier<List<PlcStatement>> thenStats = () -> this.generateEdgeUpdates(transitionAutomaton.aut, edge);
                selStat = this.mainExprGen.addBranch(edge.guards, thenStats, selStat, updates);
            }
            collectedUpdates.addAll(updates);
            if (!updates.isEmpty()) continue;
            collectedNoUpdates.add(new PlcCommentLine(Strings.fmt((String)"Automaton \"%s\" has no assignments to perform.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)})));
        }
        this.mainExprGen.setCurrentCifDataProvider(null);
        if (collectedUpdates.isEmpty()) {
            testAndPerformCode.add(new PlcCommentLine("There are no assignments to perform for automata that may synchronize."));
        }
        testAndPerformCode.addAll(collectedUpdates);
        testAndPerformCode.addAll(collectedNoUpdates);
    }

    private List<PlcStatement> generateEdgesTestCode(Event event, CifEventTransition.TransitionAutomaton transAut, int autIndex, PlcBasicVariable autVar, PlcBasicVariable edgeVar, PlcBasicVariable eventEnabledVar) {
        List testCode = Lists.list();
        PlcSelectionStatement selStat = null;
        testCode.add(this.genEdgeTestsDocumentation(event, transAut));
        int edgeIndex = 1;
        for (CifEventTransition.TransitionEdge edge : transAut.transitionEdges) {
            int finalEdgeIndex = edgeIndex++;
            Supplier<List<PlcStatement>> thenStats = () -> {
                if (autVar != null) {
                    return List.of(this.generatePlcIntAssignment(autVar, autIndex), this.generatePlcIntAssignment(edgeVar, finalEdgeIndex));
                }
                return List.of(this.generatePlcIntAssignment(edgeVar, finalEdgeIndex));
            };
            selStat = this.mainExprGen.addBranch(edge.guards, thenStats, selStat, testCode);
        }
        if (autVar != null) {
            PlcExpression guard = this.generateCompareVarWithVal(autVar, 0);
            return List.of(this.generateIfGuardThenCode(guard, testCode));
        }
        PlcCommentLine explainFail = new PlcCommentLine("The automaton has no edge with a true guard. Skip to the next event.");
        if (selStat == null) {
            testCode.add(explainFail);
            testCode.add(this.generatePlcBoolAssignment(eventEnabledVar, false));
        } else {
            selStat.elseStats.add(explainFail);
            selStat.elseStats.add(this.generatePlcBoolAssignment(eventEnabledVar, false));
        }
        return testCode;
    }

    private PlcBasicVariable getAutomatonEdgeVariable(Automaton aut) {
        PlcBasicVariable edgeVariable = this.edgeSelectionVariables.get(aut);
        Assert.notNull((Object)edgeVariable);
        return edgeVariable;
    }

    private PlcCommentBlock genEdgeTestsDocumentation(Event event, CifEventTransition.TransitionAutomaton transAut) {
        MemoryCodeBox box = new MemoryCodeBox();
        String edgePluralText = transAut.transitionEdges.size() != 1 ? "s" : "";
        box.add("Test edge%s of automaton \"%s\" to %s for event \"%s\".", new Object[]{edgePluralText, CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false), transAut.purpose.purposeText, CifTextUtils.getAbsName((PositionObject)event, (boolean)false)});
        switch (transAut.purpose) {
            case MONITOR: {
                throw new AssertionError((Object)"Unexpected test-doc request from a monitor.");
            }
            case SENDER: 
            case RECEIVER: {
                String kindText = transAut.purpose == CifEventTransition.TransAutPurpose.SENDER ? "sending" : "receiving";
                box.add("At least one %s automaton must have an edge with a true guard to allow the event.", new Object[]{kindText});
                break;
            }
            case SYNCER: {
                box.add("This automaton must have an edge with a true guard to allow the event.");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown purpose \"" + String.valueOf((Object)transAut.purpose) + "\" encountered."));
            }
        }
        box.add();
        box.add("Edge%s being tested:", new Object[]{edgePluralText});
        Location lastLoc = null;
        for (CifEventTransition.TransitionEdge transEdge : transAut.transitionEdges) {
            if (transEdge.sourceLoc != lastLoc) {
                lastLoc = transEdge.sourceLoc;
                if (lastLoc.getName() == null) {
                    box.add("- Location:");
                } else {
                    box.add("- Location \"%s\":", new Object[]{lastLoc.getName()});
                }
            }
            box.add("  - %s edge in the location", new Object[]{Numbers.toOrdinal((int)transEdge.edgeNumber)});
        }
        if (lastLoc == null) {
            switch (transAut.purpose) {
                case RECEIVER: {
                    box.add("  - No edges found. Value cannot be accepted by this automaton.");
                    break;
                }
                case SENDER: {
                    box.add("  - No edges found. Value cannot be provided by this automaton.");
                    break;
                }
                case SYNCER: {
                    box.add("  - No edges found. Event \"%s\" will never occur!", new Object[]{CifTextUtils.getAbsName((PositionObject)event, (boolean)false)});
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown purpose \"" + String.valueOf((Object)transAut.purpose) + "\" encountered."));
                }
            }
        }
        return new PlcCommentBlock(box.getLines());
    }

    private List<PlcStatement> generateSelectedEdgePerformCode(CifEventTransition.TransitionAutomaton transAut, PlcBasicVariable edgeVar, PlcBasicVariable channelValueVar, String autCommentUpdateText, List<PlcStatement> collectedNoUpdates) {
        List performCode = Lists.list();
        PlcSelectionStatement selStat = null;
        boolean mustCompute = false;
        int edgeIndex = 1;
        for (CifEventTransition.TransitionEdge edge : transAut.transitionEdges) {
            if (channelValueVar != null || !edge.updates.isEmpty()) {
                mustCompute = true;
                if (autCommentUpdateText != null) {
                    performCode.add(new PlcCommentLine(autCommentUpdateText));
                    autCommentUpdateText = null;
                }
                Supplier<List<PlcStatement>> thenStats = () -> {
                    List thenStatements = Lists.list();
                    if (channelValueVar != null) {
                        thenStatements.add(new PlcCommentLine("Compute sent channel value."));
                        this.genAssignExpr(new PlcVarExpression(channelValueVar, new PlcVarExpression.PlcProjection[0]), transitionEdge.sendValue, thenStatements);
                    }
                    if (!transitionEdge.updates.isEmpty()) {
                        thenStatements.addAll(this.generateEdgeUpdates(transitionAutomaton.aut, edge));
                    }
                    return thenStatements;
                };
                PlcExpression guard = this.generateCompareVarWithVal(edgeVar, edgeIndex);
                selStat = this.mainExprGen.addPlcBranch(List.of((ExprValueResult)new ExprValueResult(this.mainExprGen, new ExprGenResult[0]).setValue(guard)), thenStats, selStat, performCode);
            }
            ++edgeIndex;
        }
        if (!mustCompute) {
            collectedNoUpdates.add(new PlcCommentLine(Strings.fmt((String)"Automaton \"%s\" has no assignments to perform.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)transAut.aut, (boolean)false)})));
        }
        return performCode;
    }

    private List<PlcStatement> generateEdgeUpdates(Automaton aut, CifEventTransition.TransitionEdge transEdge) {
        Assert.check((!transEdge.updates.isEmpty() ? 1 : 0) != 0);
        String text = transEdge.sourceLoc.getName() == null ? Strings.fmt((String)"Perform assignments of the %s edge of automaton \"%s\".", (Object[])new Object[]{Numbers.toOrdinal((int)transEdge.edgeNumber), CifTextUtils.getAbsName((PositionObject)aut, (boolean)false)}) : Strings.fmt((String)"Perform assignments of the %s edge in location \"%s\".", (Object[])new Object[]{Numbers.toOrdinal((int)transEdge.edgeNumber), CifTextUtils.getAbsName((PositionObject)transEdge.sourceLoc, (boolean)false)});
        List stats = Lists.list();
        stats.add(new PlcCommentLine(text));
        stats.addAll(this.generateUpdates(transEdge.updates));
        return stats;
    }

    /*
     * WARNING - void declaration
     */
    private List<PlcStatement> generateUpdates(List<Update> updates) {
        List statements = Lists.list();
        for (Update upd : updates) {
            Update update = upd;
            if (update instanceof IfUpdate) {
                void ipUpd;
                IfUpdate cfr_ignored_0 = (IfUpdate)update;
                IfUpdate cfr_ignored_1 = (IfUpdate)update;
                this.genIfUpdate((IfUpdate)ipUpd, statements);
                continue;
            }
            Update update2 = upd;
            if (update2 instanceof Assignment) {
                void asg;
                Assignment cfr_ignored_2 = (Assignment)update2;
                Assignment cfr_ignored_3 = (Assignment)update2;
                this.genUpdateAssignment(asg.getAddressable(), asg.getValue(), statements);
                continue;
            }
            throw new AssertionError((Object)("Unexpected kind of update \"" + String.valueOf(upd) + "\" found."));
        }
        return statements;
    }

    private void genIfUpdate(IfUpdate ifUpd, List<PlcStatement> statements) {
        PlcSelectionStatement selStat = null;
        selStat = this.mainExprGen.addBranch((List<Expression>)ifUpd.getGuards(), () -> this.generateUpdates((List<Update>)ifUpd.getThens()), selStat, statements);
        for (ElifUpdate elifUpd : ifUpd.getElifs()) {
            selStat = this.mainExprGen.addBranch((List<Expression>)elifUpd.getGuards(), () -> this.generateUpdates((List<Update>)elifUpd.getThens()), selStat, statements);
        }
        this.mainExprGen.addBranch(null, () -> this.generateUpdates((List<Update>)ifUpd.getElses()), selStat, statements);
    }

    /*
     * WARNING - void declaration
     */
    private void genUpdateAssignment(Expression lhs, Expression rhs, List<PlcStatement> statements) {
        Expression expression = lhs;
        if (!(expression instanceof TupleExpression)) {
            ContVariable contvar;
            ExprAddressableResult lhsResult;
            Expression expression2 = lhs;
            if (expression2 instanceof ProjectionExpression) {
                void pe;
                ProjectionExpression projectionExpression = (ProjectionExpression)expression2;
                ProjectionExpression cfr_ignored_0 = (ProjectionExpression)expression2;
                lhsResult = this.mainExprGen.convertProjectedAddressable((Expression)pe);
                contvar = null;
            } else {
                Expression expression3 = lhs;
                if (expression3 instanceof ContVariableExpression) {
                    void ce;
                    ContVariableExpression contVariableExpression = (ContVariableExpression)expression3;
                    ContVariableExpression cfr_ignored_1 = (ContVariableExpression)expression3;
                    lhsResult = this.mainExprGen.convertVariableAddressable(lhs);
                    contvar = ce.getVariable();
                } else {
                    lhsResult = this.mainExprGen.convertVariableAddressable(lhs);
                    contvar = null;
                }
            }
            String varDesc = DocumentingSupport.getDescription((PositionObject)lhsResult.varDecl, lhsResult.isDerivativeAssigned());
            statements.add(new PlcCommentLine(Strings.fmt((String)"Perform update of %s.", (Object[])new Object[]{varDesc})));
            statements.addAll(lhsResult.code);
            lhsResult.releaseCodeVariables();
            this.genAssignExpr((PlcVarExpression)lhsResult.value, rhs, statements);
            lhsResult.releaseValueVariables();
            if (contvar != null) {
                statements.addAll(this.target.getContinuousVariablesGenerator().getPlcTimerCodeGen(contvar).generateAssignPreset());
            }
            return;
        }
        TupleExpression tupleExpression = (TupleExpression)expression;
        TupleExpression cfr_ignored_2 = (TupleExpression)expression;
        Expression expression4 = rhs;
        if (expression4 instanceof TupleExpression) {
            void rhsTuple;
            void lhsTuple;
            TupleExpression contvar = (TupleExpression)expression4;
            TupleExpression cfr_ignored_3 = (TupleExpression)expression4;
            Assert.check((lhsTuple.getFields().size() == rhsTuple.getFields().size() ? 1 : 0) != 0);
            int i = 0;
            while (i < lhsTuple.getFields().size()) {
                this.genUpdateAssignment((Expression)lhsTuple.getFields().get(i), (Expression)rhsTuple.getFields().get(i), statements);
                ++i;
            }
            return;
        }
        PlcBasicVariable rhsVariable = this.mainExprGen.getTempVariable("rightValue", rhs.getType());
        ExprValueResult rhsValueResult = this.mainExprGen.convertValue(rhs);
        statements.addAll(rhsValueResult.code);
        rhsValueResult.releaseCodeVariables();
        statements.add(new PlcAssignmentStatement(rhsVariable, rhsValueResult.value));
        rhsValueResult.releaseValueVariables();
        this.genUpdateAssignment(lhs, rhsVariable, List.of(), statements);
        this.mainExprGen.releaseTempVariable(rhsVariable);
    }

    /*
     * WARNING - void declaration
     */
    private void genUpdateAssignment(Expression lhs, PlcBasicVariable rhsVariable, List<PlcVarExpression.PlcStructProjection> rhsProjections, List<PlcStatement> statements) {
        Expression expression = lhs;
        if (!(expression instanceof TupleExpression)) {
            ExprAddressableResult lhsResult = this.mainExprGen.convertVariableAddressable(lhs);
            String varDesc = DocumentingSupport.getDescription((PositionObject)lhsResult.varDecl, lhsResult.isDerivativeAssigned());
            statements.add(new PlcCommentLine(Strings.fmt((String)"Perform update of %s.", (Object[])new Object[]{varDesc})));
            statements.addAll(lhsResult.code);
            lhsResult.releaseCodeVariables();
            PlcVarExpression rhsValue = new PlcVarExpression(rhsVariable, Lists.cast(rhsProjections));
            statements.add(new PlcAssignmentStatement((PlcVarExpression)lhsResult.value, (PlcExpression)rhsValue));
            lhsResult.releaseValueVariables();
            Expression expression2 = lhs;
            if (expression2 instanceof ContVariableExpression) {
                void cve;
                ContVariableExpression contVariableExpression = (ContVariableExpression)expression2;
                ContVariableExpression cfr_ignored_0 = (ContVariableExpression)expression2;
                statements.addAll(this.target.getContinuousVariablesGenerator().getPlcTimerCodeGen(cve.getVariable()).generateAssignPreset());
            }
            return;
        }
        TupleExpression tupleExpression = (TupleExpression)expression;
        TupleExpression cfr_ignored_1 = (TupleExpression)expression;
        TupleType tupleType = (TupleType)CifTypeUtils.normalizeType((CifType)lhs.getType());
        PlcStructType lhsStructType = this.target.getTypeGenerator().convertTupleType(tupleType);
        int idx = 0;
        while (idx < lhsStructType.fields.size()) {
            void lhsTuple;
            List projs = Lists.listc((int)(rhsProjections.size() + 1));
            projs.addAll(rhsProjections);
            projs.add(new PlcVarExpression.PlcStructProjection(lhsStructType.fields.get((int)idx).fieldName));
            this.genUpdateAssignment((Expression)lhsTuple.getFields().get(idx), rhsVariable, projs, statements);
            ++idx;
        }
    }

    private PlcSelectionStatement generateIfGuardThenCode(PlcExpression guard, List<PlcStatement> statements) {
        PlcSelectionStatement selStat = new PlcSelectionStatement();
        selStat.condChoices.add(new PlcSelectionStatement.PlcSelectChoice(guard, statements));
        return selStat;
    }

    private List<PlcStatement> genAssignExpr(PlcVarExpression lhsVarExpr, Expression value, List<PlcStatement> statements) {
        statements = statements == null ? Lists.list() : statements;
        ExprValueResult rhsResult = this.mainExprGen.convertValue(value);
        statements.addAll(rhsResult.code);
        rhsResult.releaseCodeVariables();
        statements.add(new PlcAssignmentStatement(lhsVarExpr, rhsResult.value));
        rhsResult.releaseValueVariables();
        return statements;
    }

    private PlcExpression generateCompareVarWithVal(PlcBasicVariable variable, int value) {
        PlcVarExpression varExpr = new PlcVarExpression(variable, new PlcVarExpression.PlcProjection[0]);
        PlcIntLiteral valExpr = this.target.makeStdInteger(value);
        return this.funcAppls.equalFuncAppl(varExpr, valExpr);
    }

    private PlcAssignmentStatement generatePlcIntAssignment(PlcBasicVariable variable, int value) {
        return new PlcAssignmentStatement(variable, (PlcExpression)this.target.makeStdInteger(value));
    }

    private PlcAssignmentStatement generatePlcBoolAssignment(PlcBasicVariable variable, boolean value) {
        return new PlcAssignmentStatement(variable, (PlcExpression)new PlcBoolLiteral(value));
    }

    private static class TransitionDataProvider
    extends CifDataProvider {
        private final Map<Declaration, PlcExpression> redirectedDecls;
        private final CifDataProvider cifDataProvider;

        public TransitionDataProvider(Map<Declaration, PlcExpression> redirectedDecls, CifDataProvider cifDataProvider) {
            this.redirectedDecls = redirectedDecls;
            this.cifDataProvider = cifDataProvider;
        }

        @Override
        public PlcExpression getValueForInputVar(InputVariable variable) {
            return this.cifDataProvider.getValueForInputVar(variable);
        }

        @Override
        public PlcExpression getValueForDiscVar(DiscVariable variable) {
            return this.redirectedDecls.getOrDefault(variable, this.cifDataProvider.getValueForDiscVar(variable));
        }

        @Override
        public PlcExpression getValueForContvar(ContVariable variable, boolean getDerivative) {
            if (getDerivative) {
                return this.cifDataProvider.getValueForContvar(variable, getDerivative);
            }
            return this.redirectedDecls.getOrDefault(variable, this.cifDataProvider.getValueForContvar(variable, getDerivative));
        }

        @Override
        public PlcExpression getValueForConstant(Constant constant) {
            return this.cifDataProvider.getValueForConstant(constant);
        }

        @Override
        public PlcVarExpression getAddressableForDiscVar(DiscVariable variable) {
            return this.cifDataProvider.getAddressableForDiscVar(variable);
        }

        @Override
        public PlcVarExpression getAddressableForContvar(ContVariable variable, boolean writeDerivative) {
            return this.cifDataProvider.getAddressableForContvar(variable, writeDerivative);
        }

        @Override
        public PlcVarExpression getAddressableForInputVar(InputVariable variable) {
            return this.cifDataProvider.getAddressableForInputVar(variable);
        }
    }
}

