/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultNameGenerator
implements NameGenerator {
    static final char DEFAULT_CHAR = 'x';
    private static final Set<String> PLC_RESERVED_WORDS;
    private final boolean warnOnRename;
    private final WarnOutput warnOutput;
    private Map<String, Integer> globalSuffixes;

    static {
        String[] languageKeywords = new String[]{"action", "array", "at", "by", "case", "configuration", "constant", "do", "else", "elsif", "end_action", "end_case", "end_configuration", "end_for", "end_function", "end_function_block", "end_if", "end_program", "end_repeat", "end_resource", "end_retain", "end_step", "end_struct", "end_transition", "end_type", "end_var", "end_while", "exit", "false", "f_edge", "for", "from", "function", "function_block", "if", "initial_step", "of", "on", "program", "read_only", "read_write", "r_edge", "repeat", "resource", "retain", "return", "step", "struct", "task", "then", "to", "transition", "true", "type", "until", "var", "var_access", "var_config", "var_external", "var_global", "var_in_out", "var_input", "var_output", "var_temp", "while", "with"};
        String[] functionNames = new String[]{"abs", "acos", "add", "and", "asin", "atan", "cos", "div", "eq", "exp", "expt", "ge", "gt", "le", "ln", "log", "lt", "max", "min", "mod", "mul", "ne", "not", "or", "sel", "sin", "sqrt", "sub", "tan", "xor"};
        String[] functionBlockNames = new String[]{"rs", "sr", "ton", "tof", "tp", "iec_timer", "timer", "f_trig", "r_trig", "ctu", "ctu_dint", "ctu_lint", "ctu_udint", "ctu_ulint", "ctd", "ctd_dint", "ctd_lint", "ctd_udint", "ctd_ulint", "ctud", "ctud_dint", "ctud_lint", "ctud_udint", "ctud_ulint"};
        String[] typeKeywords = new String[]{"bool", "sint", "int", "dint", "lint", "usint", "uint", "ulint", "udint", "real", "lreal", "time", "date", "time_of_day", "tod", "date_and_time", "dt", "string", "byte", "word", "dword", "lword", "wstring"};
        String[] genericTypeKeywords = new String[]{"any", "and_derived", "any_elementary", "any_magnitude", "any_num", "any_real", "any_int", "any_bit", "any_string", "any_date"};
        int numTypes = genericTypeKeywords.length;
        int reservedWordCount = languageKeywords.length + functionNames.length + functionBlockNames.length + typeKeywords.length + genericTypeKeywords.length + numTypes * (numTypes - 1);
        Set reservedWords = Sets.setc((int)reservedWordCount);
        reservedWords.addAll(Arrays.asList(languageKeywords));
        reservedWords.addAll(Arrays.asList(functionNames));
        reservedWords.addAll(Arrays.asList(functionBlockNames));
        reservedWords.addAll(Arrays.asList(typeKeywords));
        reservedWords.addAll(Arrays.asList(genericTypeKeywords));
        int i = 0;
        while (i < typeKeywords.length) {
            int j = 0;
            while (j < typeKeywords.length) {
                if (i != j) {
                    reservedWords.add(typeKeywords[i] + "_to_" + typeKeywords[j]);
                }
                ++j;
            }
            ++i;
        }
        PLC_RESERVED_WORDS = Collections.unmodifiableSet(reservedWords);
    }

    public DefaultNameGenerator(PlcGenSettings settings) {
        this.warnOnRename = settings.warnOnRename;
        this.warnOutput = settings.warnOutput;
        this.globalSuffixes = Maps.map();
        for (String name : PLC_RESERVED_WORDS) {
            this.globalSuffixes.put(name, 0);
        }
    }

    @Override
    public String generateGlobalName(PositionObject posObject) {
        Assert.check((boolean)CifTextUtils.hasName((PositionObject)posObject), (Object)("Missing name for \"" + String.valueOf(posObject) + "\"."));
        return this.generateName(CifTextUtils.getAbsName((PositionObject)posObject, (boolean)false), true, null);
    }

    @Override
    public String generateGlobalName(String initialName, boolean initialIsCifName) {
        return this.generateName(initialName, initialIsCifName, null);
    }

    @Override
    public String generateLocalName(String initialName, Map<String, Integer> localSuffixes) {
        return this.generateName(initialName, false, localSuffixes);
    }

    private String generateName(String initialName, boolean initialIsCifName, Map<String, Integer> localSuffixes) {
        StringBuilder cleanedName = this.cleanName(initialName);
        String lowerCleanedName = cleanedName.toString().toLowerCase(Locale.US);
        int maxUsedNumber = this.globalSuffixes.getOrDefault(lowerCleanedName, -1);
        if (localSuffixes != null) {
            maxUsedNumber = Math.max(maxUsedNumber, localSuffixes.getOrDefault(lowerCleanedName, -1));
        }
        if (maxUsedNumber < 0) {
            if (localSuffixes != null) {
                localSuffixes.put(lowerCleanedName, 0);
            } else {
                this.globalSuffixes.put(lowerCleanedName, 0);
            }
            return cleanedName.toString();
        }
        ++maxUsedNumber;
        if (localSuffixes != null) {
            localSuffixes.put(lowerCleanedName, maxUsedNumber);
        } else {
            this.globalSuffixes.put(lowerCleanedName, maxUsedNumber);
        }
        cleanedName.append("_");
        cleanedName.append(maxUsedNumber);
        String newName = cleanedName.toString();
        if (initialIsCifName && this.warnOnRename) {
            this.warnOutput.line("Renaming \"%s\" to \"%s\".", new Object[]{initialName, newName});
        }
        return newName;
    }

    private StringBuilder cleanName(String text) {
        StringBuilder sb = new StringBuilder(text.length() + 4 + 1 + 3);
        char[] data = text.toCharArray();
        int inputIndex = 0;
        while (inputIndex < data.length) {
            int length = this.matchGoodChars(data, inputIndex);
            if (length > 0 && Character.isDigit(data[inputIndex])) {
                sb.append('x');
            }
            sb.append(data, inputIndex, length);
            if ((inputIndex += length) == data.length) break;
            length = this.matchBadChars(data, inputIndex);
            if (sb.isEmpty() || (inputIndex += length) >= data.length) continue;
            sb.append('_');
        }
        if (sb.isEmpty()) {
            sb.append('x');
        }
        return sb;
    }

    private int matchGoodChars(char[] data, int index) {
        int endIndex = index;
        while (endIndex < data.length) {
            char c = data[endIndex];
            if (!Character.isLetter(c) && !Character.isDigit(c)) break;
            ++endIndex;
        }
        return endIndex - index;
    }

    private int matchBadChars(char[] data, int index) {
        int endIndex = index;
        while (endIndex < data.length) {
            char c = data[endIndex];
            if (Character.isLetter(c) || Character.isDigit(c)) break;
            ++endIndex;
        }
        return endIndex - index;
    }
}

