/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncBlockAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcCastFunctionDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFunctionBlockDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcSemanticFuncDescription;
import org.eclipse.escet.cif.plcgen.model.types.PlcAbstractType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcFuncBlockType;
import org.eclipse.escet.cif.plcgen.model.types.PlcGenericType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlcFunctionAppls {
    private final PlcTarget target;
    private PlcFuncBlockType tonBlockType = null;

    public PlcFunctionAppls(PlcTarget target) {
        this.target = target;
    }

    public PlcFuncAppl negateFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.NEGATE_OP, null, "-", PlcBasicFuncDescription.ExprBinding.UNARY_EXPR, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl multiplyFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.MULTIPLY_OP, "MUL", "*", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl divideFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.DIVIDE_OP, "DIV", "/", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl moduloFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.MODULO_OP, "MOD", "MOD", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl addFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.ADD_OP, "ADD", "+", PlcBasicFuncDescription.ExprBinding.ADD_EXPR, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl subtractFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.SUBTRACT_OP, "SUB", "-", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE);
    }

    public PlcFuncAppl lessThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.LESS_THAN_OP, "LT", "<", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl lessEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.LESS_EQUAL_OP, "LE", "<=", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl greaterThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.GREATER_THAN_OP, "GT", ">", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl greaterEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.GREATER_EQUAL_OP, "GE", ">=", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl equalFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.EQUAL_OP, "EQ", "=", PlcBasicFuncDescription.ExprBinding.EQUAL_EXPR, (PlcAbstractType)PlcGenericType.ANY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl unEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.UNEQUAL_OP, "NE", "<>", PlcBasicFuncDescription.ExprBinding.EQUAL_EXPR, (PlcAbstractType)PlcGenericType.ANY_TYPE, new PlcExpression[]{in1, in2}, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl complementFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.COMPLEMENT_OP, "NOT", "NOT ", PlcBasicFuncDescription.ExprBinding.UNARY_EXPR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, in, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl andFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.AND_OP, "AND", "AND", PlcBasicFuncDescription.ExprBinding.CONJUNCT_EXPR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl xorFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.XOR_OP, "XOR", "XOR", PlcBasicFuncDescription.ExprBinding.EXCL_DISJUNCT_EXPR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl orFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.OR_OP, "OR", "OR", PlcBasicFuncDescription.ExprBinding.DISJUNCT_EXPR, (PlcAbstractType)PlcElementaryType.BOOL_TYPE, inN, (PlcAbstractType)PlcElementaryType.BOOL_TYPE);
    }

    public PlcFuncAppl castFunctionAppl(PlcExpression in, PlcElementaryType outType) {
        PlcFuncOperation operation = PlcFuncOperation.CAST_OP;
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcCastFunctionDescription func = new PlcCastFunctionDescription((PlcElementaryType)in.type, outType);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl selFuncAppl(PlcExpression g, PlcExpression in0, PlcExpression in1) {
        PlcFuncOperation operation = PlcFuncOperation.SEL_OP;
        Assert.check((boolean)this.target.supportsOperation(operation, 3));
        PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("G", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcElementaryType.BOOL_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("IN0", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcGenericType.ANY_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("IN1", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcGenericType.ANY_TYPE)};
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, "SEL", params, this.target.getSupportedFuncNotations(operation, 3), PlcGenericType.ANY_TYPE, PlcBasicFuncDescription.PlcFuncTypeExtension.ELEMENTARY_NOT_BOOL);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("G", g), new PlcNamedValue("IN0", in0), new PlcNamedValue("IN1", in1)));
    }

    public PlcFuncAppl normalizeArrayIndex(PlcExpression indexExpr, int arraySize) {
        PlcFuncAppl g = this.greaterEqualFuncAppl(indexExpr, this.target.makeStdInteger(0));
        PlcFuncAppl in0 = this.addFuncAppl(indexExpr, this.target.makeStdInteger(arraySize));
        PlcExpression in1 = indexExpr;
        return this.selFuncAppl(g, in0, in1);
    }

    public PlcFuncAppl absFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ABS, "ABS", (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_NUM_TYPE);
    }

    public PlcFuncAppl expFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_EXP, "EXP", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl lnFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_LN, "LN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl logFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_LOG, "LOG", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl minFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.STDLIB_MIN, "MIN", (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE);
    }

    public PlcFuncAppl maxFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.STDLIB_MAX, "MAX", (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE, inN, (PlcAbstractType)PlcGenericType.ANY_ELEMENTARY_TYPE);
    }

    public PlcFuncAppl sqrtFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_SQRT, "SQRT", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl acosFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ACOS, "ACOS", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl asinFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ASIN, "ASIN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl atanFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ATAN, "ATAN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl cosFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_COS, "COS", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl sinFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_SIN, "SIN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncAppl tanFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_TAN, "TAN", (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE, in, (PlcAbstractType)PlcGenericType.ANY_REAL_TYPE);
    }

    public PlcFuncBlockType getTonFuncBlockType() {
        if (this.tonBlockType == null) {
            PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcElementaryType.BOOL_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("PT", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, PlcElementaryType.TIME_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("Q", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY, PlcElementaryType.BOOL_TYPE), new PlcBasicFuncDescription.PlcParameterDescription("ET", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY, PlcElementaryType.TIME_TYPE)};
            PlcFunctionBlockDescription tonBlockDescr = new PlcFunctionBlockDescription("TON", this.target.getTonFuncBlockCallName(), params, (PlcAbstractType)PlcElementaryType.TIME_TYPE);
            this.tonBlockType = new PlcFuncBlockType(tonBlockDescr);
        }
        return this.tonBlockType;
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, PlcAbstractType paramType, PlcExpression in, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcBasicFuncDescription.PlcParameterDescription[] parameterDesc = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, paramType)};
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, parameterDesc, this.target.getSupportedFuncNotations(operation, 1), resultType);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, String infixText, PlcBasicFuncDescription.ExprBinding exprBinding, PlcAbstractType paramType, PlcExpression in, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcBasicFuncDescription.PlcParameterDescription[] parameterDesc = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, paramType)};
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, parameterDesc, infixText, exprBinding, this.target.getSupportedFuncNotations(operation, 1), resultType);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, PlcAbstractType paramType, PlcExpression[] inN, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, inN.length));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, PlcFunctionAppls.makeParamList(inN.length, paramType), this.target.getSupportedFuncNotations(operation, inN.length), resultType);
        return new PlcFuncAppl(func, PlcFunctionAppls.makeArgumentList(inN));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, String infixText, PlcBasicFuncDescription.ExprBinding exprBinding, PlcAbstractType paramType, PlcExpression[] inN, PlcAbstractType resultType) {
        Assert.check((boolean)this.target.supportsOperation(operation, inN.length));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, PlcFunctionAppls.makeParamList(inN.length, paramType), infixText, exprBinding, this.target.getSupportedFuncNotations(operation, inN.length), resultType);
        return new PlcFuncAppl(func, PlcFunctionAppls.makeArgumentList(inN));
    }

    private static PlcBasicFuncDescription.PlcParameterDescription[] makeParamList(int length, PlcAbstractType paramType) {
        return (PlcBasicFuncDescription.PlcParameterDescription[])IntStream.range(0, length).mapToObj(i -> new PlcBasicFuncDescription.PlcParameterDescription("IN" + (i + 1), PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY, paramType)).toArray(PlcBasicFuncDescription.PlcParameterDescription[]::new);
    }

    private static List<PlcNamedValue> makeArgumentList(PlcExpression[] inN) {
        return (List)IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + (i + 1), inN[i])).collect(Lists.toList());
    }

    public PlcFuncBlockAppl funcBlockAppl(PlcBasicVariable variable, List<PlcNamedValue> arguments) {
        return new PlcFuncBlockAppl(variable, arguments);
    }
}

