/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcArrayLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcEnumLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncBlockAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcRealLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcStructLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.functions.PlcPlainFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcSemanticFuncDescription;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentBlock;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcFuncApplStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcReturnStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcSelectionStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class ModelTextGenerator {
    public String toString(PlcExpression expr) {
        return this.toString(expr, FuncApplPreference.PREFER_INFIX);
    }

    public String toString(PlcExpression expr, FuncApplPreference funcApplPreference) {
        StringBuilder textBuilder = new StringBuilder();
        this.toText(expr, textBuilder, funcApplPreference);
        return textBuilder.toString();
    }

    private void toText(PlcExpression expr, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        this.toText(expr, textBuilder, PlcBasicFuncDescription.ExprBinding.NO_PRIORITY, false, false, funcApplPreference);
    }

    /*
     * WARNING - void declaration
     */
    private void toText(PlcExpression expr, StringBuilder textBuilder, PlcBasicFuncDescription.ExprBinding parentBinding, boolean atParentLeft, boolean atParentRight, FuncApplPreference funcApplPreference) {
        PlcExpression plcExpression = expr;
        if (plcExpression instanceof PlcBoolLiteral) {
            void boolLit;
            PlcBoolLiteral plcBoolLiteral = (PlcBoolLiteral)plcExpression;
            PlcBoolLiteral cfr_ignored_0 = (PlcBoolLiteral)plcExpression;
            this.toText((PlcBoolLiteral)boolLit, textBuilder);
        } else {
            PlcExpression plcExpression2 = expr;
            if (plcExpression2 instanceof PlcIntLiteral) {
                void intLit;
                PlcIntLiteral plcIntLiteral = (PlcIntLiteral)plcExpression2;
                PlcIntLiteral cfr_ignored_1 = (PlcIntLiteral)plcExpression2;
                this.toText((PlcIntLiteral)intLit, textBuilder);
            } else {
                PlcExpression plcExpression3 = expr;
                if (plcExpression3 instanceof PlcRealLiteral) {
                    void realLit;
                    PlcRealLiteral plcRealLiteral = (PlcRealLiteral)plcExpression3;
                    PlcRealLiteral cfr_ignored_2 = (PlcRealLiteral)plcExpression3;
                    this.toText((PlcRealLiteral)realLit, textBuilder);
                } else {
                    PlcExpression plcExpression4 = expr;
                    if (plcExpression4 instanceof PlcEnumLiteral) {
                        void enumLit;
                        PlcEnumLiteral plcEnumLiteral = (PlcEnumLiteral)plcExpression4;
                        PlcEnumLiteral cfr_ignored_3 = (PlcEnumLiteral)plcExpression4;
                        this.toText((PlcEnumLiteral)enumLit, textBuilder);
                    } else {
                        PlcExpression plcExpression5 = expr;
                        if (plcExpression5 instanceof PlcArrayLiteral) {
                            void arrayLit;
                            PlcArrayLiteral plcArrayLiteral = (PlcArrayLiteral)plcExpression5;
                            PlcArrayLiteral cfr_ignored_4 = (PlcArrayLiteral)plcExpression5;
                            this.toText((PlcArrayLiteral)arrayLit, textBuilder, funcApplPreference);
                        } else {
                            PlcExpression plcExpression6 = expr;
                            if (plcExpression6 instanceof PlcStructLiteral) {
                                void structLit;
                                PlcStructLiteral plcStructLiteral = (PlcStructLiteral)plcExpression6;
                                PlcStructLiteral cfr_ignored_5 = (PlcStructLiteral)plcExpression6;
                                this.toText((PlcStructLiteral)structLit, textBuilder, funcApplPreference);
                            } else {
                                PlcExpression plcExpression7 = expr;
                                if (plcExpression7 instanceof PlcFuncAppl) {
                                    void funcAppl;
                                    PlcFuncAppl plcFuncAppl = (PlcFuncAppl)plcExpression7;
                                    PlcFuncAppl cfr_ignored_6 = (PlcFuncAppl)plcExpression7;
                                    this.toText((PlcFuncAppl)funcAppl, textBuilder, parentBinding, atParentLeft, atParentRight, funcApplPreference);
                                } else {
                                    PlcExpression plcExpression8 = expr;
                                    if (plcExpression8 instanceof PlcVarExpression) {
                                        void varExpr;
                                        PlcVarExpression plcVarExpression = (PlcVarExpression)plcExpression8;
                                        PlcVarExpression cfr_ignored_7 = (PlcVarExpression)plcExpression8;
                                        this.toText((PlcVarExpression)varExpr, textBuilder, funcApplPreference);
                                    } else {
                                        throw new AssertionError((Object)("Unexpected PLC expression \"" + String.valueOf(expr) + "\" found."));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public String literalToString(PlcExpression expr) {
        Integer value;
        if (PlcElementaryType.isIntType(expr.type) && (value = this.tryGetIntValue(expr)) != null) {
            return Integer.toString(value);
        }
        return this.toString(expr);
    }

    /*
     * WARNING - void declaration
     */
    private Integer tryGetIntValue(PlcExpression expr) {
        Assert.check((boolean)PlcElementaryType.isIntType(expr.type));
        PlcExpression plcExpression = expr;
        if (plcExpression instanceof PlcIntLiteral) {
            void intLit;
            PlcIntLiteral plcIntLiteral = (PlcIntLiteral)plcExpression;
            PlcIntLiteral cfr_ignored_0 = (PlcIntLiteral)plcExpression;
            return intLit.value;
        }
        PlcExpression plcExpression2 = expr;
        if (plcExpression2 instanceof PlcFuncAppl) {
            void fnAppl;
            PlcFuncAppl plcFuncAppl = (PlcFuncAppl)plcExpression2;
            PlcFuncAppl cfr_ignored_1 = (PlcFuncAppl)plcExpression2;
            PlcBasicFuncDescription plcBasicFuncDescription = fnAppl.function;
            if (plcBasicFuncDescription instanceof PlcSemanticFuncDescription) {
                void sfd;
                PlcSemanticFuncDescription plcSemanticFuncDescription = (PlcSemanticFuncDescription)plcBasicFuncDescription;
                PlcSemanticFuncDescription cfr_ignored_2 = (PlcSemanticFuncDescription)plcBasicFuncDescription;
                if (sfd.operation == PlcFuncOperation.NEGATE_OP) {
                    Integer v = this.tryGetIntValue(fnAppl.arguments.get((Object)fnAppl.function.parameters[0].name).value);
                    return v == null ? null : Integer.valueOf(-v.intValue());
                }
                if (sfd.operation == PlcFuncOperation.SUBTRACT_OP) {
                    Integer left = this.tryGetIntValue(fnAppl.arguments.get((Object)fnAppl.function.parameters[0].name).value);
                    Integer right = this.tryGetIntValue(fnAppl.arguments.get((Object)fnAppl.function.parameters[1].name).value);
                    if (left != null && right != null) {
                        return left - right;
                    }
                }
            }
        }
        return null;
    }

    private void toText(PlcBoolLiteral boolLit, StringBuilder textBuilder) {
        textBuilder.append(boolLit.value ? "TRUE" : "FALSE");
    }

    private void toText(PlcIntLiteral intLit, StringBuilder textBuilder) {
        textBuilder.append(String.valueOf(intLit.value));
    }

    private void toText(PlcRealLiteral realLit, StringBuilder textBuilder) {
        Object rslt = realLit.value;
        int idx = ((String)rslt).indexOf(46);
        if (idx == -1) {
            idx = ((String)rslt).indexOf(101);
            if (idx == -1 && (idx = ((String)rslt).indexOf(69)) == -1) {
                idx = ((String)rslt).length();
            }
            rslt = ((String)rslt).substring(0, idx) + ".0" + ((String)rslt).substring(idx);
        }
        textBuilder.append((String)rslt);
    }

    private void toText(PlcEnumLiteral enumLit, StringBuilder textBuilder) {
        textBuilder.append(enumLit.value);
    }

    private void toText(PlcArrayLiteral arrayLit, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append("[");
        boolean first = true;
        for (PlcExpression value : arrayLit.values) {
            if (!first) {
                textBuilder.append(", ");
            }
            first = false;
            this.toText(value, textBuilder, funcApplPreference);
        }
        textBuilder.append("]");
    }

    private void toText(PlcStructLiteral structLit, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append("(");
        boolean first = true;
        for (PlcNamedValue namedValue : structLit.values) {
            if (!first) {
                textBuilder.append(", ");
            }
            first = false;
            textBuilder.append(namedValue.name);
            textBuilder.append(" := ");
            this.toText(namedValue.value, textBuilder, funcApplPreference);
        }
        textBuilder.append(")");
    }

    /*
     * WARNING - void declaration
     */
    private void toText(PlcFuncAppl funcAppl, StringBuilder textBuilder, PlcBasicFuncDescription.ExprBinding parentBinding, boolean atParentLeft, boolean atParentRight, FuncApplPreference funcApplPreference) {
        PlcBasicFuncDescription basicDescr = funcAppl.function;
        Map<String, PlcNamedValue> arguments = funcAppl.arguments;
        boolean allArgumentsSupplied = basicDescr.parameters.length == arguments.size();
        boolean infixNotationAllowed = basicDescr.notations.contains((Object)PlcBasicFuncDescription.PlcFuncNotation.INFIX) && funcApplPreference != FuncApplPreference.OUTER_PREFIX && allArgumentsSupplied;
        boolean informalNotationAllowed = basicDescr.notations.contains((Object)PlcBasicFuncDescription.PlcFuncNotation.INFORMAL) && allArgumentsSupplied;
        boolean formalNotationAllowed = basicDescr.notations.contains((Object)PlcBasicFuncDescription.PlcFuncNotation.FORMAL);
        Assert.check((infixNotationAllowed || informalNotationAllowed || formalNotationAllowed ? 1 : 0) != 0);
        if (infixNotationAllowed) {
            void plainFunc;
            PlcBasicFuncDescription plcBasicFuncDescription = basicDescr;
            if (!(plcBasicFuncDescription instanceof PlcPlainFuncDescription)) {
                throw new AssertionError((Object)"Function allows infix notation but does not supply infix notation data.");
            }
            PlcPlainFuncDescription plcPlainFuncDescription = (PlcPlainFuncDescription)plcBasicFuncDescription;
            PlcPlainFuncDescription cfr_ignored_0 = (PlcPlainFuncDescription)plcBasicFuncDescription;
            PlcBasicFuncDescription.ExprBinding infixBinding = plainFunc.infixBinding;
            String infixFuncName = plainFunc.infixFuncName;
            Assert.notNull((Object)infixFuncName);
            int lastArgumentIndex = arguments.size() - 1;
            boolean isUnaryOperation = lastArgumentIndex == 0;
            boolean needsParentheses = infixBinding.needsParentheses(parentBinding, atParentLeft, atParentRight);
            textBuilder.append((needsParentheses |= isUnaryOperation) ? "(" : "");
            if (isUnaryOperation) {
                textBuilder.append(infixFuncName);
            }
            String infixString = " " + infixFuncName + " ";
            int argNumber = 0;
            PlcBasicFuncDescription.PlcParameterDescription[] plcParameterDescriptionArray = basicDescr.parameters;
            int n = basicDescr.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                PlcBasicFuncDescription.PlcParameterDescription param = plcParameterDescriptionArray[n2];
                PlcNamedValue argNamedValue = arguments.get(param.name);
                Assert.notNull((Object)argNamedValue);
                textBuilder.append((String)(argNumber > 0 ? infixString : ""));
                this.toText(argNamedValue.value, textBuilder, infixBinding, argNumber == 0, argNumber == lastArgumentIndex, FuncApplPreference.PREFER_INFIX);
                ++argNumber;
                ++n2;
            }
            textBuilder.append(needsParentheses ? ")" : "");
        } else if (informalNotationAllowed || formalNotationAllowed) {
            Object prefixFuncName;
            PlcFuncAppl plcFuncAppl;
            Object typeExtension = "";
            if (basicDescr.typeExtension.testFunction.test(funcAppl.type)) {
                typeExtension = "_" + this.getTypeName(funcAppl.type);
            }
            if ((plcFuncAppl = funcAppl) instanceof PlcFuncBlockAppl) {
                void blockAppl;
                PlcFuncBlockAppl infixBinding = (PlcFuncBlockAppl)plcFuncAppl;
                PlcFuncBlockAppl cfr_ignored_1 = (PlcFuncBlockAppl)plcFuncAppl;
                prefixFuncName = blockAppl.variable.varName;
                if (!basicDescr.prefixFuncName.isEmpty()) {
                    prefixFuncName = (String)prefixFuncName + "." + basicDescr.prefixFuncName;
                }
            } else {
                prefixFuncName = basicDescr.prefixFuncName + (String)typeExtension;
            }
            Assert.notNull((Object)prefixFuncName);
            textBuilder.append((String)prefixFuncName);
            textBuilder.append("(");
            int argNumber = 0;
            boolean useFormalSyntax = !informalNotationAllowed;
            PlcBasicFuncDescription.PlcParameterDescription[] plcParameterDescriptionArray = basicDescr.parameters;
            int n = basicDescr.parameters.length;
            int n3 = 0;
            while (n3 < n) {
                PlcBasicFuncDescription.PlcParameterDescription param = plcParameterDescriptionArray[n3];
                PlcNamedValue argNamedValue = arguments.get(param.name);
                if (argNamedValue != null) {
                    textBuilder.append(argNumber > 0 ? ", " : "");
                    if (useFormalSyntax) {
                        textBuilder.append(param.name);
                        textBuilder.append(param.direction == PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY ? " => " : " := ");
                    }
                    this.toText(argNamedValue.value, textBuilder, FuncApplPreference.PREFER_INFIX);
                    ++argNumber;
                }
                ++n3;
            }
            textBuilder.append(")");
        } else {
            throw new AssertionError((Object)"Failed to convert the function application to text.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getTypeName(PlcType type) {
        PlcType plcType = type;
        if (plcType instanceof PlcElementaryType) {
            void elemType;
            PlcElementaryType plcElementaryType = (PlcElementaryType)plcType;
            PlcElementaryType cfr_ignored_0 = (PlcElementaryType)plcType;
            return elemType.name;
        }
        PlcType plcType2 = type;
        if (plcType2 instanceof PlcEnumType) {
            void enumType;
            PlcEnumType plcEnumType = (PlcEnumType)plcType2;
            PlcEnumType cfr_ignored_1 = (PlcEnumType)plcType2;
            return enumType.typeName;
        }
        PlcType plcType3 = type;
        if (plcType3 instanceof PlcStructType) {
            void structType;
            PlcStructType plcStructType = (PlcStructType)plcType3;
            PlcStructType cfr_ignored_2 = (PlcStructType)plcType3;
            return structType.typeName;
        }
        throw new AssertionError((Object)("Cannot extract a type name from \"" + String.valueOf(type) + "\"."));
    }

    private void toText(PlcVarExpression varExpr, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        textBuilder.append(varExpr.variable.varRefText);
        for (PlcVarExpression.PlcProjection proj : varExpr.projections) {
            this.toText(proj, textBuilder, funcApplPreference);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void toText(PlcVarExpression.PlcProjection proj, StringBuilder textBuilder, FuncApplPreference funcApplPreference) {
        PlcVarExpression.PlcProjection plcProjection = proj;
        if (plcProjection instanceof PlcVarExpression.PlcStructProjection) {
            void structProj;
            PlcVarExpression.PlcStructProjection plcStructProjection = (PlcVarExpression.PlcStructProjection)plcProjection;
            PlcVarExpression.PlcStructProjection cfr_ignored_0 = (PlcVarExpression.PlcStructProjection)plcProjection;
            textBuilder.append(".");
            textBuilder.append(structProj.fieldName);
        } else {
            PlcVarExpression.PlcProjection plcProjection2 = proj;
            if (plcProjection2 instanceof PlcVarExpression.PlcArrayProjection) {
                void arrayProj;
                PlcVarExpression.PlcArrayProjection plcArrayProjection = (PlcVarExpression.PlcArrayProjection)plcProjection2;
                PlcVarExpression.PlcArrayProjection cfr_ignored_1 = (PlcVarExpression.PlcArrayProjection)plcProjection2;
                textBuilder.append('[');
                this.toText(arrayProj.indexExpression, textBuilder, funcApplPreference);
                textBuilder.append(']');
            } else {
                throw new AssertionError((Object)("Unexpected PLC projection \"" + String.valueOf(proj) + "\" found."));
            }
        }
    }

    public String toString(List<PlcStatement> plcStats, String pouName, boolean fixCodeBlcok) {
        MemoryCodeBox boxBuilder = new MemoryCodeBox();
        this.toText(plcStats, (CodeBox)boxBuilder, pouName, fixCodeBlcok);
        return boxBuilder.toString();
    }

    public void toText(List<PlcStatement> plcStats, CodeBox boxBuilder, String pouName, boolean fixCodeBlcok) {
        boolean foundStat = false;
        for (PlcStatement plcStat : plcStats) {
            this.toText(plcStat, boxBuilder, pouName);
            foundStat |= plcStat.isProperPlcStatement();
        }
        if (!foundStat) {
            if (fixCodeBlcok) {
                this.toText(new PlcCommentLine("Nothing to do.", true), boxBuilder, pouName);
            } else {
                throw new AssertionError((Object)"Code block does not have a proper PLC statement.");
            }
        }
    }

    public String toString(PlcStatement plcStat, String pouName) {
        MemoryCodeBox boxBuilder = new MemoryCodeBox();
        this.toText(plcStat, (CodeBox)boxBuilder, pouName);
        return boxBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void toText(PlcStatement plcStat, CodeBox boxBuilder, String pouName) {
        PlcStatement plcStatement = plcStat;
        if (plcStatement instanceof PlcAssignmentStatement) {
            void asgStat;
            PlcAssignmentStatement plcAssignmentStatement = (PlcAssignmentStatement)plcStatement;
            PlcAssignmentStatement cfr_ignored_0 = (PlcAssignmentStatement)plcStatement;
            this.toText((PlcAssignmentStatement)asgStat, boxBuilder, pouName);
        } else {
            PlcStatement plcStatement2 = plcStat;
            if (plcStatement2 instanceof PlcCommentLine) {
                void cmtLine;
                PlcCommentLine plcCommentLine = (PlcCommentLine)plcStatement2;
                PlcCommentLine cfr_ignored_1 = (PlcCommentLine)plcStatement2;
                this.toText((PlcCommentLine)cmtLine, boxBuilder, pouName);
            } else {
                PlcStatement plcStatement3 = plcStat;
                if (plcStatement3 instanceof PlcCommentBlock) {
                    void cmtBlock;
                    PlcCommentBlock plcCommentBlock = (PlcCommentBlock)plcStatement3;
                    PlcCommentBlock cfr_ignored_2 = (PlcCommentBlock)plcStatement3;
                    this.toText((PlcCommentBlock)cmtBlock, boxBuilder, pouName);
                } else {
                    PlcStatement plcStatement4 = plcStat;
                    if (plcStatement4 instanceof PlcReturnStatement) {
                        void retStat;
                        PlcReturnStatement plcReturnStatement = (PlcReturnStatement)plcStatement4;
                        PlcReturnStatement cfr_ignored_3 = (PlcReturnStatement)plcStatement4;
                        this.toText((PlcReturnStatement)retStat, boxBuilder, pouName);
                    } else {
                        PlcStatement plcStatement5 = plcStat;
                        if (plcStatement5 instanceof PlcSelectionStatement) {
                            void selStat;
                            PlcSelectionStatement plcSelectionStatement = (PlcSelectionStatement)plcStatement5;
                            PlcSelectionStatement cfr_ignored_4 = (PlcSelectionStatement)plcStatement5;
                            this.toText((PlcSelectionStatement)selStat, boxBuilder, pouName);
                        } else {
                            PlcStatement plcStatement6 = plcStat;
                            if (plcStatement6 instanceof PlcFuncApplStatement) {
                                void funcApplStat;
                                PlcFuncApplStatement plcFuncApplStatement = (PlcFuncApplStatement)plcStatement6;
                                PlcFuncApplStatement cfr_ignored_5 = (PlcFuncApplStatement)plcStatement6;
                                this.toText((PlcFuncApplStatement)funcApplStat, boxBuilder, pouName);
                            } else {
                                throw new AssertionError((Object)("Unexpected PLC statement \"" + String.valueOf(plcStat) + "\" found."));
                            }
                        }
                    }
                }
            }
        }
    }

    private void toText(PlcAssignmentStatement asgStat, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("%s := %s;", new Object[]{this.toString(asgStat.lhs), this.toString(asgStat.value)});
    }

    private void toText(PlcCommentLine cmtLine, CodeBox boxBuilder, String pouName) {
        if (cmtLine.commentText == null) {
            boxBuilder.add("%s", new Object[]{cmtLine.isEmptyStatement ? ";" : ""});
        } else {
            boxBuilder.add("(* %s *)%s", new Object[]{cmtLine.commentText, cmtLine.isEmptyStatement ? " ;" : ""});
        }
    }

    private void toText(PlcCommentBlock cmtBlock, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("(*" + Strings.duplicate((String)"*", (int)cmtBlock.starCount));
        for (String line : cmtBlock.lines) {
            boxBuilder.add(" * " + line);
        }
        boxBuilder.add(" " + Strings.duplicate((String)"*", (int)cmtBlock.starCount) + "*)");
    }

    private void toText(PlcFuncApplStatement funcApplStat, CodeBox boxBuilder, String pouName) {
        boxBuilder.add("%s;", new Object[]{this.toString(funcApplStat.funcApplExpr, FuncApplPreference.OUTER_PREFIX)});
    }

    private void toText(PlcReturnStatement retStat, CodeBox boxBuilder, String pouName) {
        if (retStat.returnValue != null) {
            boxBuilder.add("%s := %s;", new Object[]{pouName, this.toString(retStat.returnValue)});
        }
        boxBuilder.add("RETURN;");
    }

    private void toText(PlcSelectionStatement selStat, CodeBox boxBuilder, String pouName) {
        if (selStat.condChoices.isEmpty()) {
            this.toText(selStat.elseStats, boxBuilder, pouName, true);
            return;
        }
        String testText = "IF";
        for (PlcSelectionStatement.PlcSelectChoice condChoice : selStat.condChoices) {
            boxBuilder.add("%s %s THEN", new Object[]{testText, this.toString(condChoice.guard)});
            testText = "ELSIF";
            boxBuilder.indent();
            this.toText(condChoice.thenStats, boxBuilder, pouName, true);
            boxBuilder.dedent();
        }
        if (!selStat.elseStats.isEmpty()) {
            boxBuilder.add("ELSE");
            boxBuilder.indent();
            this.toText(selStat.elseStats, boxBuilder, pouName, true);
            boxBuilder.dedent();
        }
        boxBuilder.add("END_IF;");
    }

    public static enum FuncApplPreference {
        PREFER_INFIX,
        OUTER_PREFIX;

    }
}

