/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.options.ConvertEnumsOption;
import org.eclipse.escet.cif.plcgen.options.IoTablePathOption;
import org.eclipse.escet.cif.plcgen.options.PlcConfigurationNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcIntTypeSizeOption;
import org.eclipse.escet.cif.plcgen.options.PlcMaxIterOption;
import org.eclipse.escet.cif.plcgen.options.PlcNumberBits;
import org.eclipse.escet.cif.plcgen.options.PlcProjectNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcRealTypeSizeOption;
import org.eclipse.escet.cif.plcgen.options.PlcResourceNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcTargetTypeOption;
import org.eclipse.escet.cif.plcgen.options.PlcTaskCycleTimeOption;
import org.eclipse.escet.cif.plcgen.options.PlcTaskNameOption;
import org.eclipse.escet.cif.plcgen.options.PlcTaskPriorityOption;
import org.eclipse.escet.cif.plcgen.options.ProgramHeaderTextFilePathOption;
import org.eclipse.escet.cif.plcgen.options.RenameWarningsOption;
import org.eclipse.escet.cif.plcgen.options.SimplifyValuesOption;
import org.eclipse.escet.cif.plcgen.targets.AbbTarget;
import org.eclipse.escet.cif.plcgen.targets.Iec611313Target;
import org.eclipse.escet.cif.plcgen.targets.PlcBaseTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcOpenXmlTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.targets.SiemensS7Target;
import org.eclipse.escet.cif.plcgen.targets.TwinCatTarget;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.output.WarnOutput;

public class CifPlcGenApp
extends Application<IOutputComponent> {
    public static final String APP_NAME_PATTERN = "${app-name}";
    public static final String APP_VERSION_PATTERN = "${app-version}";
    public static final String TIME_STAMP_PATTERN = "${time-stamp}";
    public static final String BRIEF_EXPLANATION_PATTERN = "${brief-explanation}";

    public static void main(String[] args) {
        CifPlcGenApp app = new CifPlcGenApp();
        app.run(args, true);
    }

    public CifPlcGenApp() {
    }

    public CifPlcGenApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF PLC code generator";
    }

    public String getAppDescription() {
        return "Generates PLC code from a suitable CIF specification.";
    }

    protected int runInternal() {
        PlcTargetType targetType = PlcTargetTypeOption.getPlcTargetType();
        PlcBaseTarget target = switch (targetType) {
            case PlcTargetType.ABB -> new AbbTarget();
            case PlcTargetType.IEC_61131_3 -> new Iec611313Target();
            case PlcTargetType.PLC_OPEN_XML -> new PlcOpenXmlTarget();
            case PlcTargetType.S7_1500, PlcTargetType.S7_1200, PlcTargetType.S7_400, PlcTargetType.S7_300 -> new SiemensS7Target(targetType);
            case PlcTargetType.TWINCAT -> new TwinCatTarget();
            default -> throw new RuntimeException("Unknown target type: " + String.valueOf((Object)targetType));
        };
        PlcGenSettings settings = this.makePlcGenSettings(target);
        target.generate(settings);
        return 0;
    }

    private PlcGenSettings makePlcGenSettings(PlcTarget target) {
        String projectName = PlcProjectNameOption.getProjName();
        String configurationName = PlcConfigurationNameOption.getCfgName();
        String resourceName = PlcResourceNameOption.getResName();
        String plcTaskName = PlcTaskNameOption.getTaskName();
        int taskCyceTime = PlcTaskCycleTimeOption.getTaskCycleTime();
        int priority = PlcTaskPriorityOption.getTaskPrio();
        PlcMaxIterOption.MaxIterLimits iterLimits = PlcMaxIterOption.getMaxIterLimits();
        String inputPath = InputFileOption.getPath();
        String outputPath = OutputFileOption.getDerivedPath((String)".cif", (String)target.getPathSuffixReplacement());
        String ioTablePath = IoTablePathOption.getDerivedPath();
        List<String> programHeaderLines = this.expandAndCleanProgramHeaderLines(this.obtainProgramHeaderLines());
        PlcNumberBits intSize = PlcIntTypeSizeOption.getNumberBits();
        PlcNumberBits realSize = PlcRealTypeSizeOption.getNumberBits();
        boolean simplifyValues = SimplifyValuesOption.simplifyValues();
        ConvertEnums enumConversion = ConvertEnumsOption.getValue();
        BooleanSupplier shouldTerminate = () -> AppEnv.isTerminationRequested();
        boolean warnOnRename = RenameWarningsOption.isEnabled();
        WarnOutput warnOutput = OutputProvider.getWarningOutputStream();
        return new PlcGenSettings(projectName, configurationName, resourceName, plcTaskName, taskCyceTime, priority, iterLimits.uncontrollableLimit(), iterLimits.controllableLimit(), new PathPair(inputPath, Paths.resolve((String)inputPath)), new PathPair(outputPath, Paths.resolve((String)outputPath)), new PathPair(ioTablePath, Paths.resolve((String)ioTablePath)), programHeaderLines, intSize, realSize, simplifyValues, enumConversion, shouldTerminate, warnOnRename, warnOutput);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifPlcGenApp.getGeneralOptionCategory();
        List applicationOpts = Lists.list();
        applicationOpts.add(Options.getInstance(InputFileOption.class));
        applicationOpts.add(Options.getInstance(OutputFileOption.class));
        applicationOpts.add(Options.getInstance(IoTablePathOption.class));
        applicationOpts.add(Options.getInstance(ProgramHeaderTextFilePathOption.class));
        applicationOpts.add(Options.getInstance(PlcTargetTypeOption.class));
        applicationOpts.add(Options.getInstance(PlcConfigurationNameOption.class));
        applicationOpts.add(Options.getInstance(PlcProjectNameOption.class));
        applicationOpts.add(Options.getInstance(PlcResourceNameOption.class));
        applicationOpts.add(Options.getInstance(PlcTaskCycleTimeOption.class));
        applicationOpts.add(Options.getInstance(PlcTaskNameOption.class));
        applicationOpts.add(Options.getInstance(PlcTaskPriorityOption.class));
        applicationOpts.add(Options.getInstance(PlcIntTypeSizeOption.class));
        applicationOpts.add(Options.getInstance(PlcRealTypeSizeOption.class));
        applicationOpts.add(Options.getInstance(SimplifyValuesOption.class));
        applicationOpts.add(Options.getInstance(ConvertEnumsOption.class));
        applicationOpts.add(Options.getInstance(RenameWarningsOption.class));
        applicationOpts.add(Options.getInstance(PlcMaxIterOption.class));
        List generatorSubCats = Lists.list();
        OptionCategory generatorCat = new OptionCategory("Generator", "Generator options.", generatorSubCats, applicationOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, generatorCat});
        OptionCategory options = new OptionCategory("CIF PLC Code Generator Options", "All options for the CIF PLC code generator.", cats, Lists.list());
        return options;
    }

    private List<String> obtainProgramHeaderLines() {
        PathPair paths = ProgramHeaderTextFilePathOption.getProgramHeaderFilePaths();
        if (paths == null) {
            return List.of("This file is generated with CIF's PLC code generator from the Eclipse ESCET toolkit.", "", "Generator name:    ${app-name}", "Generator version: ${app-version}", "Generation time:   ${time-stamp}", "", BRIEF_EXPLANATION_PATTERN);
        }
        List lines = Lists.list();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader headerTextFile = new BufferedReader(new FileReader(paths.systemPath));){
                String line = headerTextFile.readLine();
                while (line != null) {
                    lines.add(line.stripTrailing());
                    line = headerTextFile.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            String msgText = Strings.fmt((String)"Program header text file \"%s\" does not exist, is a directory rather than a file, or could not be opened for reading.", (Object[])new Object[]{paths.userPath});
            throw new InputOutputException(msgText, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new InputOutputException("Failed to read or close program header text file \"" + paths.userPath + "\".", (Throwable)ex);
        }
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> expandAndCleanProgramHeaderLines(List<String> rawHeaderLines) {
        void var10_17;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
        String appName = this.getAppName().strip();
        String appVersion = this.getAppVersion().strip();
        String timeStamp = df.format(new Date()).strip();
        List briefExplanation = Lists.list();
        briefExplanation.add("- - - - - - - - - - - - -");
        this.formatText(briefExplanation, "This PLC program implements a controller that was designed in the CIF language.");
        briefExplanation.add("");
        this.formatText(briefExplanation, "For those that do not know the CIF language, this brief explanation relates", "concepts in the CIF language with known concepts in PLC programming. This makes it easier to", "understand what is being computed in this PLC program.");
        briefExplanation.add("");
        this.formatText(briefExplanation, "A CIF model has one or more automata (which work like state machines). All these", "automata work in parallel.");
        this.formatText(briefExplanation, "Each automaton has locations (equivalent to states). Like state machines, one of", "the locations is the \"current state\". Each location has edges to other locations of the same", "automaton, thus allowing to change the current state of the state machine by an edge. An edge also ", "has a guard condition that must be satisfied for the edge to be taken and updates to change the", "values of variables (like assignments).");
        briefExplanation.add("");
        this.formatText(briefExplanation, "In CIF, different state machines can be coupled by labeling their edges with the", "same \"event\". The most common form of coupling is \"synchronizing\", which means that all automata ", "that have the event must take an edge at the same time. Automata coupled with \"monitoring\" must", "also synchronize, but only if they have an edge for the event in their current state. In some cases a", "channel may be used. In such a case, one additional \"sender\" and one additional \"receiver\"", "automaton must be involved, and they may exchange a data value.");
        briefExplanation.add("");
        this.formatText(briefExplanation, "In CIF there are two kinds of events. Uncontrollable events are events that are", "caused by received changes from the environment (such as sensor signal changes). Controllable events", "are performed while computing a control response (such as enabling or disabling an actuator). In a", "single PLC cycle first the state is updated from the PLC inputs. Then the uncontrollable events are", "performed as much as possible, followed by performing as many as possible controllable events.", "Finally, the updated state is written to the PLC outputs.");
        briefExplanation.add("- - - - - - - - - - - - -");
        int lastExplainIndex = briefExplanation.size() - 1;
        int lengthLastExplainLine = ((String)Lists.last((List)briefExplanation)).length();
        List headerLines = Lists.list();
        for (String string : rawHeaderLines) {
            void var10_12;
            String string2 = string.replace(APP_NAME_PATTERN, appName).replace(APP_VERSION_PATTERN, appVersion).replace(TIME_STAMP_PATTERN, timeStamp);
            int patternIndex = string2.indexOf(BRIEF_EXPLANATION_PATTERN);
            while (patternIndex >= 0) {
                this.postProcessLine(headerLines, var10_12.substring(0, patternIndex) + (String)Lists.first((List)briefExplanation));
                int explainLineNum = 1;
                while (explainLineNum < lastExplainIndex) {
                    this.postProcessLine(headerLines, (String)briefExplanation.get(explainLineNum));
                    ++explainLineNum;
                }
                String string3 = (String)Lists.last((List)briefExplanation) + var10_12.substring(patternIndex + BRIEF_EXPLANATION_PATTERN.length());
                patternIndex = string3.indexOf(BRIEF_EXPLANATION_PATTERN, lengthLastExplainLine);
            }
            this.postProcessLine(headerLines, (String)var10_12);
        }
        boolean bl = false;
        while (var10_17 < headerLines.size() && ((String)headerLines.get((int)var10_17)).isEmpty()) {
            ++var10_17;
        }
        int lastNonEmpty = headerLines.size() - 1;
        while (lastNonEmpty >= var10_17 && ((String)headerLines.get(lastNonEmpty)).isEmpty()) {
            --lastNonEmpty;
        }
        return var10_17 > lastNonEmpty ? Collections.emptyList() : headerLines.subList((int)var10_17, lastNonEmpty + 1);
    }

    private void formatText(List<String> dest, String ... texts) {
        String[] stringArray = Strings.wrap((int)75, (String[])new String[]{String.join((CharSequence)" ", texts)});
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            dest.add(line);
            ++n2;
        }
    }

    private void postProcessLine(List<String> headerLines, String line) {
        line = this.restrictToPrintableAscii(line);
        headerLines.add(line.replace("(*", "(-*").replace("*)", "*-)").stripTrailing());
    }

    private String restrictToPrintableAscii(String textLine) {
        char[] newChars = null;
        int newLength = 0;
        int i = 0;
        while (i < textLine.length()) {
            char c = textLine.charAt(i);
            if (c < ' ' || c > '~') {
                if (newChars == null) {
                    newChars = new char[textLine.length()];
                    newLength = 0;
                    while (newLength < i) {
                        newChars[newLength] = textLine.charAt(newLength);
                        ++newLength;
                    }
                }
            } else if (newChars != null) {
                newChars[newLength] = c;
                ++newLength;
            }
            ++i;
        }
        return newChars == null ? textLine : new String(newChars, 0, newLength);
    }
}

