/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps.conversion;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.eventbased.apps.conversion.CifOrigin;
import org.eclipse.escet.cif.eventbased.automata.AutomatonComparator;
import org.eclipse.escet.cif.eventbased.automata.AutomatonKind;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ConvertToEventBased {
    public Map<org.eclipse.escet.cif.metamodel.cif.declarations.Event, Event> events;
    public List<org.eclipse.escet.cif.eventbased.automata.Automaton> automata;
    public boolean allowPlainEvents;
    public Map<String, Automaton> origAutoms = Maps.map();

    public void convertSpecification(Specification spec, boolean allowPlainEvents) {
        this.allowPlainEvents = allowPlainEvents;
        this.events = Maps.map();
        this.automata = Lists.list();
        new ElimComponentDefInst().transform(spec);
        this.convertComponent((ComplexComponent)spec);
    }

    public void sortAutomata() {
        Collections.sort(this.automata, AutomatonComparator.INSTANCE);
    }

    private static boolean getBooleanValue(List<Expression> preds, boolean defaultValue, Location loc, String kind) {
        if (preds.isEmpty()) {
            return defaultValue;
        }
        if (preds.size() > 1) {
            String msg = Strings.fmt((String)"Unsupported %s: multiple %s predicates are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), kind});
            throw new UnsupportedException(msg);
        }
        Expression pred = (Expression)Lists.first(preds);
        if (!(pred instanceof BoolExpression)) {
            String aPostfix = kind.startsWith("i") ? "n" : "";
            String msg = Strings.fmt((String)"Unsupported %s: a%s %s predicate is not trivially true or false.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), aPostfix, kind});
            throw new UnsupportedException(msg);
        }
        return ((BoolExpression)pred).isValue();
    }

    private Event convertEvent(Expression expr, Location loc) {
        Event.EventControllability eventContr;
        if (expr instanceof TauExpression) {
            String msg = Strings.fmt((String)"Unsupported %s: edges with event \"tau\" are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            throw new UnsupportedException(msg);
        }
        Assert.check((boolean)(expr instanceof EventExpression));
        org.eclipse.escet.cif.metamodel.cif.declarations.Event evt = ((EventExpression)expr).getEvent();
        Event autEvt = this.events.get(evt);
        if (autEvt != null) {
            return autEvt;
        }
        if (evt.getControllable() == null) {
            if (!this.allowPlainEvents) {
                String msg = Strings.fmt((String)"Unsupported event \"%s\": event is not controllable or uncontrollable.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)evt)});
                throw new UnsupportedException(msg);
            }
            eventContr = Event.EventControllability.PLAIN_EVENT;
        } else {
            eventContr = evt.getControllable() != false ? Event.EventControllability.CONTR_EVENT : Event.EventControllability.UNCONTR_EVENT;
        }
        autEvt = new Event(CifTextUtils.getAbsName((PositionObject)evt, (boolean)false), eventContr);
        if (evt.getType() != null) {
            String msg = Strings.fmt((String)"Unsupported event \"%s\": event has a data type.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)evt)});
            throw new UnsupportedException(msg);
        }
        this.events.put(evt, autEvt);
        return autEvt;
    }

    private void convertComponent(ComplexComponent comp) {
        if (!comp.getInvariants().isEmpty()) {
            String msg = Strings.fmt((String)"Unsupported %s: invariants in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            throw new UnsupportedException(msg);
        }
        if (!comp.getMarkeds().isEmpty()) {
            String msg = Strings.fmt((String)"Unsupported %s: marker predicates in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            throw new UnsupportedException(msg);
        }
        if (!comp.getInitials().isEmpty()) {
            String msg = Strings.fmt((String)"Unsupported %s: initialization predicates in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            throw new UnsupportedException(msg);
        }
        if (comp instanceof Automaton) {
            this.convertAutomaton((Automaton)comp);
            return;
        }
        if (comp instanceof Group) {
            Group group = (Group)comp;
            for (Component cmp : group.getComponents()) {
                this.convertComponent((ComplexComponent)cmp);
            }
            return;
        }
        throw new RuntimeException("Unexpected component: " + String.valueOf(comp));
    }

    private void convertAutomaton(Automaton aut) {
        Set alphabet = Sets.set();
        if (aut.getAlphabet() == null) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event event = this.convertEvent(edgeEvent.getEvent(), loc);
                        alphabet.add(event);
                    }
                }
            }
        } else {
            for (Expression evt : aut.getAlphabet().getEvents()) {
                Event event = this.convertEvent(evt, null);
                alphabet.add(event);
            }
        }
        Set monitors = null;
        if (aut.getMonitors() != null) {
            EList monEvents = aut.getMonitors().getEvents();
            if (monEvents.isEmpty()) {
                monitors = alphabet;
            } else {
                monitors = Sets.setc((int)monEvents.size());
                for (Expression exprevt : monEvents) {
                    Event event = this.convertEvent(exprevt, null);
                    monitors.add(event);
                }
            }
        }
        org.eclipse.escet.cif.eventbased.automata.Automaton resAut = new org.eclipse.escet.cif.eventbased.automata.Automaton(alphabet);
        switch (aut.getKind()) {
            case NONE: {
                resAut.kind = AutomatonKind.UNKNOWN;
                break;
            }
            case PLANT: {
                resAut.kind = AutomatonKind.PLANT;
                break;
            }
            case REQUIREMENT: {
                resAut.kind = AutomatonKind.REQUIREMENT;
                break;
            }
            case SUPERVISOR: {
                resAut.kind = AutomatonKind.SUPERVISOR;
            }
        }
        resAut.name = CifTextUtils.getAbsName((PositionObject)aut);
        this.origAutoms.put(resAut.name, aut);
        Set seen = Sets.set();
        Map locs = Maps.map();
        for (Location loc : aut.getLocations()) {
            org.eclipse.escet.cif.eventbased.automata.Location srcLoc = this.convertLocation(loc, aut, locs, resAut);
            if (monitors != null) {
                seen.clear();
            }
            for (Edge edge : loc.getEdges()) {
                org.eclipse.escet.cif.eventbased.automata.Location dstLoc = edge.getTarget() == null ? srcLoc : this.convertLocation(edge.getTarget(), aut, locs, resAut);
                if (edge.getEvents().isEmpty()) {
                    String msg = Strings.fmt((String)"Unsupported %s: edges with event \"tau\" are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                    throw new UnsupportedException(msg);
                }
                boolean guard = this.checkEdge(edge, loc);
                for (EdgeEvent ee : edge.getEvents()) {
                    Event evt = this.convertEvent(ee.getEvent(), loc);
                    if (!guard) continue;
                    org.eclipse.escet.cif.eventbased.automata.Edge.addEdge(evt, srcLoc, dstLoc);
                    if (monitors == null) continue;
                    seen.add(evt);
                }
            }
            if (monitors == null) continue;
            for (Event evt : monitors) {
                if (seen.contains(evt)) continue;
                org.eclipse.escet.cif.eventbased.automata.Edge.addEdge(evt, srcLoc, srcLoc);
            }
        }
        this.automata.add(resAut);
    }

    private org.eclipse.escet.cif.eventbased.automata.Location convertLocation(Location loc, Automaton aut, Map<Location, org.eclipse.escet.cif.eventbased.automata.Location> locations, org.eclipse.escet.cif.eventbased.automata.Automaton resAut) {
        org.eclipse.escet.cif.eventbased.automata.Location resLoc = locations.get(loc);
        if (resLoc != null) {
            return resLoc;
        }
        EList invs = loc.getInvariants();
        if (!invs.isEmpty()) {
            List preds = Lists.listc((int)invs.size());
            for (Invariant inv : loc.getInvariants()) {
                if (inv.getInvKind() != InvKind.STATE) {
                    String msg = Strings.fmt((String)"Unsupported %s: state/event exclusion invariants are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                    throw new UnsupportedException(msg);
                }
                preds.add(inv.getPredicate());
            }
            if (!ConvertToEventBased.getBooleanValue(preds, true, loc, "invariant")) {
                String msg = Strings.fmt((String)"Unsupported %s: the state invariants are not trivially true.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                throw new UnsupportedException(msg);
            }
        }
        if (loc.isUrgent()) {
            String msg = Strings.fmt((String)"Unsupported %s: urgent locations are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            throw new UnsupportedException(msg);
        }
        boolean marked = ConvertToEventBased.getBooleanValue((List<Expression>)loc.getMarkeds(), false, loc, "marker");
        CifOrigin org = new CifOrigin(loc);
        resLoc = new org.eclipse.escet.cif.eventbased.automata.Location(resAut, org);
        resLoc.marked = marked;
        locations.put(loc, resLoc);
        if (ConvertToEventBased.getBooleanValue((List<Expression>)loc.getInitials(), false, loc, "initialization")) {
            if (resAut.initial != null) {
                String msg = Strings.fmt((String)"Unsupported automaton \"%s\": the automaton has multiple initial locations.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
                throw new UnsupportedException(msg);
            }
            resAut.setInitial(resLoc);
        }
        return resLoc;
    }

    private boolean checkEdge(Edge edge, Location loc) {
        if (!edge.getUpdates().isEmpty()) {
            String msg = Strings.fmt((String)"Unsupported %s: edges with updates are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            throw new UnsupportedException(msg);
        }
        if (edge.isUrgent()) {
            String msg = Strings.fmt((String)"Unsupported %s: urgent edges are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            throw new UnsupportedException(msg);
        }
        return ConvertToEventBased.getBooleanValue((List<Expression>)edge.getGuards(), true, loc, "guard");
    }
}

