/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.options.ReportFileOption;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class TrimCheckApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        TrimCheckApplication app = new TrimCheckApplication();
        app.run(args, true);
    }

    public TrimCheckApplication() {
    }

    public TrimCheckApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(ReportFileOption.class));
        return new OptionCategory("Trim check", "CIF event-based trim check options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(TrimCheckApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based trim check tool.";
        return new OptionCategory("Event-based trim check options", optDesc, subPages, options);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    private void outputLocations(Automaton aut, Set<Location> locs, int locCount, String locType, AppStream stream) {
        if ((locCount -= locs.size()) == 0) {
            stream.printf("- All locations are %s.\n", new Object[]{locType});
            return;
        }
        if (locCount == 1) {
            stream.printf("- The following location is not %s:\n", new Object[]{locType});
        } else {
            stream.printf("- The following %d locations are not %s:\n", new Object[]{locCount, locType});
        }
        for (Location loc : aut) {
            if (locs.contains(loc)) continue;
            stream.printf("  %s.\n", new Object[]{loc.toString()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int runInternal() {
        String rsltMsg;
        boolean exitCode;
        try {
            String absOutPath;
            String outPath;
            OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
            Specification spec = (Specification)((CifReader)new CifReader().init()).read();
            if (this.isTerminationRequested()) {
                return 0;
            }
            OutputProvider.dbg((String)"Converting to internal representation...");
            ConvertToEventBased cte = new ConvertToEventBased();
            cte.convertSpecification(spec, true);
            if (this.isTerminationRequested()) {
                return 0;
            }
            OutputProvider.dbg((String)"Applying trim check...");
            List reachables = Lists.listc((int)cte.automata.size());
            List coreachables = Lists.listc((int)cte.automata.size());
            boolean ok = true;
            Iterator<Automaton> iterator = cte.automata.iterator();
            do {
                Set locs;
                if (!iterator.hasNext()) {
                    outPath = "_trimcheck.txt";
                    outPath = ReportFileOption.getDerivedPath(".cif", outPath);
                    OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
                    absOutPath = Paths.resolve((String)outPath);
                }
                Automaton aut = iterator.next();
                int locCount = aut.size();
                if (locCount != (locs = AutomatonHelper.getReachables(aut)).size()) {
                    ok = false;
                }
                reachables.add(locs);
                if (this.isTerminationRequested()) {
                    return 0;
                }
                locs = Sets.set();
                AutomatonHelper.getNonCoreachableCount(aut, locs);
                if (locCount != locs.size()) {
                    ok = false;
                }
                coreachables.add(locs);
            } while (!this.isTerminationRequested());
            return 0;
            exitCode = !ok;
            String result = !exitCode ? "HOLDS" : "FAILS";
            rsltMsg = Strings.fmt((String)"Trim check %s in file \"%s\". See \"%s\" for details.", (Object[])new Object[]{result, InputFileOption.getPath(), outPath});
            FileAppStream stream = new FileAppStream(absOutPath);
            OutputProvider.dbg((String)rsltMsg);
            stream.printf("Trim check %s in file \"%s\".\n", new Object[]{result, InputFileOption.getPath()});
            if (!ok) {
                int i = 0;
                while (i < cte.automata.size()) {
                    Automaton aut = cte.automata.get(i);
                    int locCount = aut.size();
                    Set rl = (Set)reachables.get(i);
                    Set crl = (Set)coreachables.get(i);
                    result = "HOLDS";
                    if (rl.size() != locCount || crl.size() != locCount) {
                        result = "FAILS";
                    }
                    stream.printf("\n", new Object[0]);
                    stream.printf("Trim check %s for automaton \"%s\".\n", new Object[]{result, aut.name});
                    this.outputLocations(aut, rl, locCount, "reachable", (AppStream)stream);
                    this.outputLocations(aut, crl, locCount, "coreachable", (AppStream)stream);
                    ++i;
                }
            }
            stream.close();
        }
        catch (ApplicationException e) {
            String msg = Strings.fmt((String)"Failed to apply trim check for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
            throw new ApplicationException(msg, (Throwable)e);
        }
        if (!exitCode) {
            return 0;
        }
        throw new InvalidInputException(rsltMsg);
    }

    public String getAppName() {
        return "CIF trim check tool";
    }

    public String getAppDescription() {
        return "Verifies whether the automata are trim, that is, in each automaton, the locations must be both reachable and co-reachable.";
    }
}

