/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.List;
import org.eclipse.escet.cif.eventbased.SynchronousProduct;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertFromEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.options.AddStateAnnosOption;
import org.eclipse.escet.cif.eventbased.apps.options.ResultNameOption;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;

public class SynchronousProductApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        SynchronousProductApplication app = new SynchronousProductApplication();
        app.run(args, true);
    }

    public SynchronousProductApplication() {
    }

    public SynchronousProductApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        options.add(Options.getInstance(ResultNameOption.class));
        options.add(Options.getInstance(AddStateAnnosOption.class));
        return new OptionCategory("Synchronous product", "CIF event-based synchronous product options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(SynchronousProductApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based synchronous product tool.";
        return new OptionCategory("Event-based synchronous product options", optDesc, subPages, options);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        String resultName;
        Specification spec;
        CifReader cifReader;
        block11: {
            Automaton aut;
            block10: {
                ConvertToEventBased cte;
                block9: {
                    block8: {
                        try {
                            OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                            cifReader = (CifReader)new CifReader().init();
                            spec = (Specification)cifReader.read();
                            if (!this.isTerminationRequested()) break block8;
                            return 0;
                        }
                        catch (ApplicationException e) {
                            String msg = Strings.fmt((String)"Failed to compute synchronous product for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
                            throw new ApplicationException(msg, (Throwable)e);
                        }
                    }
                    OutputProvider.dbg((String)"Converting to internal representation...");
                    cte = new ConvertToEventBased();
                    cte.convertSpecification(spec, true);
                    if (!this.isTerminationRequested()) break block9;
                    return 0;
                }
                OutputProvider.dbg((String)"Computing synchronous product...");
                aut = SynchronousProduct.product(cte.automata);
                if (!this.isTerminationRequested()) break block10;
                return 0;
            }
            if (OutputProvider.dodbg()) {
                OutputProvider.dbg((String)"Product finished (%s).", (Object[])new Object[]{AutomatonHelper.getAutStatistics(aut)});
            }
            if (aut.initial == null) {
                OutputProvider.warn((String)"Product is empty.");
            }
            OutputProvider.dbg((String)"Converting from internal representation...");
            resultName = "product";
            resultName = ResultNameOption.getRsltName(resultName);
            boolean doAddStateAnnos = AddStateAnnosOption.getStateAnnotationsEnabled();
            ConvertFromEventBased cfe = new ConvertFromEventBased();
            spec = cfe.convertAutomaton(aut, resultName, doAddStateAnnos);
            if (!this.isTerminationRequested()) break block11;
            return 0;
        }
        Object outPath = "_" + resultName + ".cif";
        outPath = OutputFileOption.getDerivedPath((String)".cif", (String)outPath);
        OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
        outPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (String)outPath, (String)cifReader.getAbsDirPath());
        return 0;
    }

    public String getAppName() {
        return "CIF synchronous product tool";
    }

    public String getAppDescription() {
        return "Creates the synchronous product of event-based automata in a CIF specification.";
    }
}

