/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.NfaToDfa;
import org.eclipse.escet.cif.eventbased.apps.conversion.ApplicationHelper;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertFromEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.options.AddStateAnnosOption;
import org.eclipse.escet.cif.eventbased.apps.options.PreservedEventsOption;
import org.eclipse.escet.cif.eventbased.apps.options.ResultNameOption;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class ProjectionApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ProjectionApplication app = new ProjectionApplication();
        app.run(args, true);
    }

    public ProjectionApplication() {
    }

    public ProjectionApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(PreservedEventsOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        options.add(Options.getInstance(ResultNameOption.class));
        options.add(Options.getInstance(AddStateAnnosOption.class));
        return new OptionCategory("Automaton projection", "CIF event-based automaton projection options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(ProjectionApplication.getGeneralOptionCategory());
        List options = Lists.list();
        return new OptionCategory("Event-based automaton projection options", "All options for the event-based automaton project tool.", subPages, options);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        String resultName;
        Specification spec;
        CifReader cifReader;
        block14: {
            Automaton aut;
            block13: {
                Set<Event> preservedEvents;
                ConvertToEventBased cte;
                block12: {
                    block11: {
                        block10: {
                            try {
                                OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                                cifReader = (CifReader)new CifReader().init();
                                spec = (Specification)cifReader.read();
                                if (!this.isTerminationRequested()) break block10;
                                return 0;
                            }
                            catch (ApplicationException e) {
                                String msg = Strings.fmt((String)"Failed to compute projection for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
                                throw new ApplicationException(msg, (Throwable)e);
                            }
                        }
                        OutputProvider.dbg((String)"Converting to internal representation...");
                        cte = new ConvertToEventBased();
                        cte.convertSpecification(spec, true);
                        if (!this.isTerminationRequested()) break block11;
                        return 0;
                    }
                    if (cte.automata.size() != 1) {
                        String msg = Strings.fmt((String)"CIF input file contains %d automata, while projection requires exactly one automaton.", (Object[])new Object[]{cte.automata.size()});
                        throw new InvalidInputException(msg);
                    }
                    String[] preserved = PreservedEventsOption.getEvents();
                    preservedEvents = ApplicationHelper.selectEvents(preserved, cte.automata.get((int)0).alphabet);
                    if (!this.isTerminationRequested()) break block12;
                    return 0;
                }
                OutputProvider.dbg((String)"Computing projection...");
                aut = NfaToDfa.toDFA(cte.automata.get(0), preservedEvents);
                if (!this.isTerminationRequested()) break block13;
                return 0;
            }
            if (OutputProvider.dodbg()) {
                OutputProvider.dbg((String)"Projection finished (%s).", (Object[])new Object[]{AutomatonHelper.getAutStatistics(aut)});
            }
            if (aut.initial == null) {
                OutputProvider.warn((String)"Automaton projection is empty.");
            }
            OutputProvider.dbg((String)"Converting from internal representation...");
            resultName = "projected";
            resultName = ResultNameOption.getRsltName(resultName);
            boolean doAddStateAnnos = AddStateAnnosOption.getStateAnnotationsEnabled();
            ConvertFromEventBased cfe = new ConvertFromEventBased();
            spec = cfe.convertAutomaton(aut, resultName, doAddStateAnnos);
            if (!this.isTerminationRequested()) break block14;
            return 0;
        }
        Object outPath = "_" + resultName + ".cif";
        outPath = OutputFileOption.getDerivedPath((String)".cif", (String)outPath);
        OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
        outPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (String)outPath, (String)cifReader.getAbsDirPath());
        return 0;
    }

    public String getAppName() {
        return "CIF automaton projection tool";
    }

    public String getAppDescription() {
        return "Creates the event-based projected automaton of an automaton in a CIF specification.";
    }
}

