/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.eventbased.LanguageEquivalence;
import org.eclipse.escet.cif.eventbased.apps.conversion.CifOrigin;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.equivalence.CounterExample;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class LanguageEquivalenceCheckApplication
extends Application<IOutputComponent> {
    private final String app = "language equivalence check";

    public static void main(String[] args) {
        LanguageEquivalenceCheckApplication app = new LanguageEquivalenceCheckApplication();
        app.run(args, true);
    }

    public LanguageEquivalenceCheckApplication() {
    }

    public LanguageEquivalenceCheckApplication(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        return new OptionCategory(Strings.makeInitialUppercase((String)"language equivalence check"), "CIF event-based language equivalence checkoptions.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(LanguageEquivalenceCheckApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based language equivalence check tool.";
        return new OptionCategory("Event-based language equivalence check options", optDesc, subPages, options);
    }

    protected int runInternal() {
        Map eventsToCifEventsMap;
        Location loc1;
        Location loc0;
        CounterExample err;
        block15: {
            ConvertToEventBased cte;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            Specification spec;
                            block10: {
                                try {
                                    OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                                    spec = (Specification)((CifReader)new CifReader().init()).read();
                                    if (!this.isTerminationRequested()) break block10;
                                    return 0;
                                }
                                catch (ApplicationException e) {
                                    String msg = Strings.fmt((String)"Failed to apply %s for CIF file \"%s\".", (Object[])new Object[]{"language equivalence check", InputFileOption.getPath()});
                                    throw new ApplicationException(msg, (Throwable)e);
                                }
                            }
                            OutputProvider.dbg((String)"Converting to internal representation...");
                            cte = new ConvertToEventBased();
                            cte.convertSpecification(spec, true);
                            if (!this.isTerminationRequested()) break block11;
                            return 0;
                        }
                        OutputProvider.dbg((String)"Applying language equivalence check....");
                        LanguageEquivalence.preCheck(cte.automata);
                        if (!this.isTerminationRequested()) break block12;
                        return 0;
                    }
                    Assert.check((cte.automata.size() == 2 ? 1 : 0) != 0);
                    err = LanguageEquivalence.doLanguageEquivalenceCheck(cte.automata);
                    if (!this.isTerminationRequested()) break block13;
                    return 0;
                }
                if (err != null) break block14;
                OutputProvider.out((String)"Automata have the same language.");
                return 0;
            }
            loc0 = ((CifOrigin)err.locs[0].origin).cifLoc;
            loc1 = ((CifOrigin)err.locs[1].origin).cifLoc;
            eventsToCifEventsMap = Maps.invert(cte.events);
            if (err.event != null) break block15;
            if (!LanguageEquivalenceCheckApplication.isMarked(loc0)) {
                Location locTmp = loc0;
                loc0 = loc1;
                loc1 = locTmp;
            }
            OutputProvider.out((String)"Automata have a different language!");
            OutputProvider.out((String)Strings.fmt((String)"The %s is marked, but the equivalent %s is not marked.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc0), CifTextUtils.getLocationText1((Location)loc1)}));
            LanguageEquivalenceCheckApplication.printPath(err.path, eventsToCifEventsMap);
            return 1;
        }
        org.eclipse.escet.cif.metamodel.cif.declarations.Event origEvent = (org.eclipse.escet.cif.metamodel.cif.declarations.Event)eventsToCifEventsMap.get(err.event);
        Assert.notNull((Object)origEvent);
        if (CifLocationUtils.getEdges((Location)loc0, (org.eclipse.escet.cif.metamodel.cif.declarations.Event)origEvent).isEmpty()) {
            Location locTmp = loc0;
            loc0 = loc1;
            loc1 = locTmp;
        }
        OutputProvider.out((String)"Automata have a different language!");
        OutputProvider.out((String)Strings.fmt((String)"From %s, event \"%s\" can be performed, but from the equivalent %s, the event cannot be performed.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc0), CifTextUtils.getAbsName((PositionObject)origEvent), CifTextUtils.getLocationText1((Location)loc1)}));
        LanguageEquivalenceCheckApplication.printPath(err.path, eventsToCifEventsMap);
        return 1;
    }

    private static boolean isMarked(Location loc) {
        EList preds = loc.getMarkeds();
        if (preds.isEmpty()) {
            return false;
        }
        Assert.check((preds.size() == 1 ? 1 : 0) != 0);
        BoolExpression be = (BoolExpression)preds.get(0);
        return be.isValue();
    }

    private static void printPath(List<Event> path, Map<Event, org.eclipse.escet.cif.metamodel.cif.declarations.Event> events) {
        if (path == null || path.isEmpty()) {
            return;
        }
        OutputProvider.out((String)"This state pair can be reached with the following sequence of events from the initial state:");
        int step = 1;
        for (Event pathEvent : path) {
            org.eclipse.escet.cif.metamodel.cif.declarations.Event origPathEvent = events.get(pathEvent);
            OutputProvider.out((String)Strings.fmt((String)"%d. \"%s\"", (Object[])new Object[]{step, CifTextUtils.getAbsName((PositionObject)origPathEvent)}));
            ++step;
        }
    }

    public String getAppName() {
        return "CIF language equivalence check tool";
    }

    public String getAppDescription() {
        return "Verifies whether two automata are language equivalent, that is, whether both can produce the same events in the same order.";
    }
}

