/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations.builtin;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class DocAnnotationProvider
extends AnnotationProvider {
    public DocAnnotationProvider(String annotationName) {
        super(annotationName);
    }

    @Override
    public final void checkAnnotation(AnnotatedObject annotatedObject, Annotation annotation, AnnotationProblemReporter reporter) {
        if (annotation.getArguments().isEmpty()) {
            reporter.reportProblem(annotation, "missing an argument.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
        }
        for (AnnotationArgument arg : annotation.getArguments()) {
            if (arg.getName() != null) {
                reporter.reportProblem(annotation, "unsupported named argument.", arg.getPosition(), SemanticProblemSeverity.ERROR);
            }
            boolean doEvaluationCheck = true;
            CifType valueType = CifTypeUtils.normalizeType((CifType)arg.getValue().getType());
            if (!(valueType instanceof StringType)) {
                reporter.reportProblem(annotation, Strings.fmt((String)"argument must have a value of type \"string\", but has a value of type \"%s\".", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)valueType)}), arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
                doEvaluationCheck = false;
            }
            if (!CifValueUtils.hasSingleValue((Expression)arg.getValue(), (boolean)false, (boolean)true)) {
                reporter.reportProblem(annotation, "argument cannot be evaluated statically.", arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
                doEvaluationCheck = false;
            }
            if (!doEvaluationCheck) continue;
            try {
                DocAnnotationProvider.getDoc(annotation);
            }
            catch (InvalidModelException e) {
                CifEvalException evalErr = (CifEvalException)e.getCause();
                Object evalErrMsg = evalErr.toString();
                if (!((String)evalErrMsg).endsWith(".")) {
                    evalErrMsg = (String)evalErrMsg + ".";
                }
                reporter.reportProblem(annotation, Strings.fmt((String)"argument cannot be evaluated statically, as evaluating it results in an evaluation error: %s", (Object[])new Object[]{evalErrMsg}), arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
            }
        }
    }

    @Override
    public final void checkGlobal(Specification spec, AnnotationProblemReporter reporter) {
    }

    public static List<String> getDocs(AnnotatedObject obj) {
        return CifAnnotationUtils.getAnnotations((AnnotatedObject)obj, (String)"doc").map(a -> DocAnnotationProvider.getDoc(a)).toList();
    }

    public static String getDoc(Annotation docAnno) {
        return docAnno.getArguments().stream().map(arg -> DocAnnotationProvider.getDoc(arg)).collect(Collectors.joining("\n"));
    }

    private static String getDoc(AnnotationArgument docAnnoArg) {
        try {
            Object value = CifEvalUtils.eval((Expression)docAnnoArg.getValue(), (boolean)false);
            return (String)value;
        }
        catch (CifEvalException e) {
            AnnotatedObject annotatedObj = (AnnotatedObject)docAnnoArg.eContainer().eContainer();
            if (CifTextUtils.hasName((PositionObject)annotatedObj)) {
                String msg = Strings.fmt((String)"Failed to evaluate an argument of the \"doc\" annotation of \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)annotatedObj)});
                throw new InvalidModelException(msg, (Throwable)e);
            }
            throw new InvalidModelException("Failed to evaluate an argument of a \"doc\" annotation.", (Throwable)e);
        }
    }
}

