/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemovePositionInfo;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.simulator.compiler.AlgVarCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.AutomatonCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.AutomatonKindChecker;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.CifSvgCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ConstCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.DefaultValueCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.DerivativeCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.EnumCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.EventCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.FuncCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.InitPredCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.LiteralCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.OdeStateEventsCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.PrintCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.SamplerCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.SolverCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.SpecCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.StateCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.StateInitCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.StateInvPredCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.UrgEdgesCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.UrgLocsCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.VersionCodeGenerator;
import org.eclipse.escet.cif.simulator.output.DebugOutputOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputType;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.common.app.framework.Paths;

public class CifCompiler {
    private CifCompiler() {
    }

    public static void compileSpec(String cifPath, CifCompilerContext ctxt) {
        String absCifPath = Paths.resolve((String)cifPath);
        boolean debug = DebugOutputOption.doPrint(DebugOutputType.PARSER);
        CifReader cifReader = (CifReader)new CifReader().init(cifPath, absCifPath, debug);
        Specification cifSpec = (Specification)cifReader.read();
        new RemovePositionInfo().transform(cifSpec);
        new RemoveAnnotations().transform(cifSpec);
        if (CifScopeUtils.hasCompDefInst((Group)cifSpec)) {
            new ElimComponentDefInst().transform(cifSpec);
        }
        new RemovePositionInfo().transform(cifSpec);
        String cifSpecFileDir = ((CifTypeChecker)cifReader.getTypeChecker()).getSourceFileDir();
        CifCompiler.compileSpec(cifSpec, ctxt, cifSpecFileDir, (CifTypeChecker)cifReader.getTypeChecker());
    }

    public static void compileSpec(Specification cifSpec, CifCompilerContext ctxt, String cifSpecFileDir, CifTypeChecker tchecker) {
        ctxt.setSpecification(cifSpec, cifSpecFileDir);
        AutomatonKindChecker.checkKinds((ComplexComponent)cifSpec);
        VersionCodeGenerator.gencodeVersion(ctxt);
        EventCodeGenerator.gencodeEvents(cifSpec, ctxt);
        EnumCodeGenerator.gencodeEnums(ctxt);
        StateCodeGenerator.gencodeState(cifSpec, ctxt);
        StateCodeGenerator.gencodeSubStates(cifSpec, ctxt);
        StateInitCodeGenerator.gencodeStateInit(ctxt);
        AutomatonCodeGenerator.gencodeAutomata(ctxt);
        ConstCodeGenerator.gencodeConsts(cifSpec, ctxt);
        AlgVarCodeGenerator.gencodeAlgVars(ctxt);
        DerivativeCodeGenerator.gencodeDerivatives(cifSpec, ctxt);
        StateInvPredCodeGenerator.gencodeStateInvPreds(cifSpec, ctxt);
        InitPredCodeGenerator.gencodeInitPreds(cifSpec, ctxt);
        FuncCodeGenerator.gencodeFuncs((ComplexComponent)cifSpec, ctxt);
        OdeStateEventsCodeGenerator.gencodeOdeStateEvents(cifSpec, ctxt);
        UrgLocsCodeGenerator.gencodeUrgLocs(cifSpec, ctxt);
        UrgEdgesCodeGenerator.gencodeUrgEdges(cifSpec, ctxt);
        SolverCodeGenerator.gencodeSolver(cifSpec, ctxt);
        CifSvgCodeGenerator.gencodeCifSvg(cifSpec, ctxt);
        PrintCodeGenerator.gencodePrint(cifSpec, ctxt);
        SpecCodeGenerator.gencodeSpec(ctxt);
        SamplerCodeGenerator.gencodeSampler(ctxt);
        DefaultValueCodeGenerator.gencodeDefaultValues(ctxt);
        LiteralCodeGenerator.gencodeLiteralReaders(ctxt);
        ctxt.writeSourceCode();
        ctxt.compile();
        ctxt.writeCompiledCode();
    }
}

