/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.output;

import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.StdAppStream;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.java.Strings;

public class StreamOutputComponent
implements IOutputComponent {
    protected final AppStream out;
    protected final AppStream warn;
    protected final AppStream err;

    public StreamOutputComponent() {
        this(StdAppStream.OUT, StdAppStream.ERR, StdAppStream.ERR);
    }

    public StreamOutputComponent(AppStream out, AppStream warn, AppStream err) {
        this.out = out;
        this.warn = warn;
        this.err = err;
    }

    @Override
    public void dbg(String msg, int indent) {
        this.out.println(Strings.spaces((int)(indent * 4)) + msg);
    }

    @Override
    public void out(String msg, int indent) {
        this.out.println(Strings.spaces((int)(indent * 4)) + msg);
    }

    @Override
    public void warn(String msg, int indent) {
        this.warn.println(Strings.spaces((int)(indent * 4)) + "WARNING: " + msg);
    }

    @Override
    public void err(String msg) {
        this.err.println(msg);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void cleanup() {
    }
}

