/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.io.NullAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.JavaCodeUtils;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.setext.generator.JavaHeaderOption;
import org.eclipse.escet.setext.generator.OutputBnfFileOption;
import org.eclipse.escet.setext.generator.OutputDebugFilesOption;
import org.eclipse.escet.setext.generator.OutputJavaFilesOption;
import org.eclipse.escet.setext.generator.parser.EmptySymbol;
import org.eclipse.escet.setext.generator.parser.GrammarItem;
import org.eclipse.escet.setext.generator.parser.LALR1Automaton;
import org.eclipse.escet.setext.generator.parser.LALR1AutomatonState;
import org.eclipse.escet.setext.generator.parser.LALR1ParserGenerator;
import org.eclipse.escet.setext.generator.parser.LookaheadItem;
import org.eclipse.escet.setext.generator.parser.ParserAcceptAction;
import org.eclipse.escet.setext.generator.parser.ParserAction;
import org.eclipse.escet.setext.generator.parser.ParserReduceAction;
import org.eclipse.escet.setext.generator.parser.ParserShiftAction;
import org.eclipse.escet.setext.generator.scanner.Automaton;
import org.eclipse.escet.setext.generator.scanner.AutomatonState;
import org.eclipse.escet.setext.generator.scanner.RegExToDfa;
import org.eclipse.escet.setext.parser.ast.Specification;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.parser.NonTerminal;
import org.eclipse.escet.setext.parser.ast.parser.ParserRule;
import org.eclipse.escet.setext.parser.ast.parser.ParserRulePart;
import org.eclipse.escet.setext.parser.ast.parser.StartSymbol;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsIdentifier;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsTerminal;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;
import org.eclipse.escet.setext.parser.ast.scanner.TerminalsDecl;

public class SeTextGenerator {
    private SeTextGenerator() {
    }

    public static void generateScanner(Specification spec) {
        if (spec.scannerClass == null) {
            throw new InvalidInputException("Scanner class not specified.");
        }
        OutputProvider.out((String)"Generating scanner class \"%s\".", (Object[])new Object[]{spec.scannerClass.toString()});
        String packagePath = spec.scannerClass.getPackageName().replace('.', '/');
        String curWorkDir = Paths.getCurWorkingDir().replace('\\', '/');
        if (!curWorkDir.endsWith(packagePath)) {
            OutputProvider.warn((String)"Current working directory \"%s\" does not end with \"%s\", which is expected for Java type \"%s\".", (Object[])new Object[]{curWorkDir, packagePath, spec.scannerClass.toString()});
        }
        String debugFilePath = InputFileOption.getPath() + "." + spec.scannerClass.getSimpleClassName() + ".dbg";
        AppStream dbgStream = SeTextGenerator.openDebugFile(debugFilePath);
        Map scannerAutomata = Maps.map();
        Assert.check((boolean)((String)spec.states.iterator().next()).equals(""));
        try {
            for (String state : spec.states) {
                List stateTerminals = Lists.copy((List)spec.terminals);
                Iterator terminalsIter = stateTerminals.iterator();
                while (terminalsIter.hasNext()) {
                    Terminal terminal = (Terminal)terminalsIter.next();
                    if (terminal.getStateName().equals(state)) continue;
                    terminalsIter.remove();
                }
                if (stateTerminals.isEmpty()) {
                    String msg = Strings.fmt((String)"No terminals for scanner state \"%s\".", (Object[])new Object[]{state});
                    throw new InvalidInputException(msg);
                }
                Automaton dfa = RegExToDfa.terminalsToDfa(stateTerminals);
                scannerAutomata.put(state, dfa);
                if (!state.equals("")) {
                    dbgStream.println();
                    dbgStream.println();
                }
                String msg = Strings.fmt((String)"*** DFA for scanner state \"%s\". ***", (Object[])new Object[]{state});
                dbgStream.println(msg);
                dfa.print(dbgStream);
            }
        }
        finally {
            dbgStream.close();
        }
        Object scannerFilePath = spec.scannerClass.getSimpleClassName();
        scannerFilePath = (String)scannerFilePath + ".java";
        scannerFilePath = Paths.resolve((String)scannerFilePath);
        SeTextGenerator.writeScannerClass(spec, scannerAutomata, (String)scannerFilePath);
    }

    public static void generateParser(Specification spec, StartSymbol start) {
        LALR1Automaton aut;
        LALR1ParserGenerator generator;
        OutputProvider.out((String)"Generating parser class \"%s\" for %s symbol \"%s\".", (Object[])new Object[]{start.javaType.toString(), start.getStartType(), start.symbol.name});
        String packagePath = start.javaType.getPackageName().replace('.', '/');
        String curWorkDir = Paths.getCurWorkingDir().replace('\\', '/');
        if (!curWorkDir.endsWith(packagePath)) {
            OutputProvider.warn((String)"Current working directory \"%s\" does not end with \"%s\", which is expected for Java type \"%s\".", (Object[])new Object[]{curWorkDir, packagePath, start.javaType.toString()});
        }
        if (OutputBnfFileOption.isEnabled()) {
            SeTextGenerator.writeParserSyntaxBnf(spec);
        }
        String debugFilePath = InputFileOption.getPath() + "." + start.javaType.getSimpleClassName() + ".dbg";
        try (AppStream dbgStream = SeTextGenerator.openDebugFile(debugFilePath);){
            generator = new LALR1ParserGenerator();
            aut = generator.generate(spec, start);
            String msg = Strings.fmt((String)"Parser automaton for %s state \"%s\":", (Object[])new Object[]{start.getStartType(), start.name.id});
            dbgStream.println(msg);
            aut.printTable(dbgStream, generator);
            if (generator.conflicts > 0) {
                msg = generator.getConflictsText();
                throw new InvalidInputException(msg);
            }
        }
        Object javaFilePath = start.javaType.getSimpleClassName();
        javaFilePath = (String)javaFilePath + ".java";
        javaFilePath = Paths.resolve((String)javaFilePath);
        SeTextGenerator.writeParserClass(spec, start, aut, generator, (String)javaFilePath);
    }

    private static boolean scannerHasHooks(Specification spec) {
        for (Terminal terminal : spec.terminals) {
            if (terminal.func == null) continue;
            return true;
        }
        return false;
    }

    public static void writeScannerClass(Specification spec, Map<String, Automaton> scannerAutomata, String javaFilePath) {
        Automaton aut;
        String state;
        Terminal terminal;
        MemoryCodeBox code = new MemoryCodeBox();
        List states = Lists.set2list((Set)spec.states);
        Assert.check((boolean)((String)Lists.first((List)states)).equals(""));
        int[] initials = new int[states.size()];
        initials[0] = 0;
        int i = 0;
        while (i < initials.length - 1) {
            String scannerState = (String)states.get(i);
            int dfaStates = scannerAutomata.get((Object)scannerState).states.size();
            initials[i + 1] = initials[i] + dfaStates;
            ++i;
        }
        List imports = Lists.list();
        imports.add("java.io.IOException");
        imports.add("org.eclipse.escet.setext.runtime.Scanner");
        imports.add("org.eclipse.escet.setext.runtime.Token");
        boolean scannerHasHooks = SeTextGenerator.scannerHasHooks(spec);
        if (scannerHasHooks) {
            imports.add(spec.hooksClass.className);
        }
        Collections.sort(imports);
        Map importNames = Maps.map();
        for (String imp : imports) {
            int idx = imp.lastIndexOf(46);
            String name = idx == -1 ? imp : imp.substring(idx + 1);
            String entry = (String)importNames.get(name);
            if (entry == null) {
                importNames.put(name, imp);
                continue;
            }
            String msg = Strings.fmt((String)"Conflicting class names: \"%s\" and \"%s\".", (Object[])new Object[]{entry, imp});
            throw new UnsupportedException(msg);
        }
        SeTextGenerator.addJavaHeader((CodeBox)code);
        code.add("// Disable Eclipse Java formatter for generated code file:");
        code.add("// @formatter:off");
        code.add();
        String packageName = spec.scannerClass.getPackageName();
        if (!packageName.isEmpty()) {
            code.add("package %s;", new Object[]{packageName});
            code.add();
        }
        for (String imp : JavaCodeUtils.formatImports((Collection)imports, (String)packageName)) {
            code.add(imp);
        }
        code.add();
        code.add("/**");
        code.add(" * %s.", new Object[]{spec.scannerClass.getSimpleClassName()});
        code.add(" *");
        code.add(" * <p>This scanner is generated by SeText.</p>");
        code.add(" */");
        code.add("public final class %s extends Scanner {", new Object[]{spec.scannerClass.getSimpleClassName()});
        code.indent();
        code.add("/** Textual representations of the scanner states, for debugging. */");
        code.add("private static final String[] SCANNER_STATES = new String[] {");
        code.indent();
        int i2 = 0;
        while (i2 < states.size()) {
            String stateTxt = (String)states.get(i2);
            code.add("%s, // %d", new Object[]{Strings.stringToJava((String)stateTxt), i2});
            ++i2;
        }
        code.dedent();
        code.add("};");
        code.add();
        code.add("/** For each terminal, whether it needs post processing. */");
        code.add("private static final boolean[] TERMINAL_NEEDS_POST = new boolean[] {");
        code.indent();
        i2 = 0;
        while (i2 < spec.terminals.size()) {
            terminal = (Terminal)spec.terminals.get(i2);
            boolean needsPost = terminal.newState != null || terminal.func != null;
            code.add("%s, // %d", new Object[]{needsPost, i2});
            ++i2;
        }
        code.dedent();
        code.add("};");
        code.add();
        code.add("/** Textual representations of the terminals, for debugging. */");
        code.add("private static final String[] TERMINALS = new String[] {");
        code.indent();
        i2 = 0;
        while (i2 < spec.terminals.size()) {
            terminal = (Terminal)spec.terminals.get(i2);
            String terminalTxt = "\"" + terminal.regEx.toString() + "\"";
            if (terminal.name != null) {
                terminalTxt = terminal.name + "=" + terminalTxt;
            }
            code.add("%s, // %d", new Object[]{Strings.stringToJava((String)terminalTxt), i2});
            ++i2;
        }
        code.dedent();
        code.add("};");
        code.add();
        code.add("/** Names of the terminals (may be {@code null}), for exceptions. */");
        code.add("private static final String[] TERMINAL_NAMES = new String[] {");
        code.indent();
        i2 = 0;
        while (i2 < spec.terminals.size()) {
            terminal = (Terminal)spec.terminals.get(i2);
            code.add("%s, // %d", new Object[]{terminal.name == null ? "null" : Strings.stringToJava((String)terminal.name), i2});
            ++i2;
        }
        code.dedent();
        code.add("};");
        code.add();
        code.add("/** Descriptions of the terminals (may be {@code null}), for exceptions. */");
        code.add("private static final String[] TERMINAL_DESCRIPTIONS = new String[] {");
        code.indent();
        i2 = 0;
        while (i2 < spec.terminals.size()) {
            Object descr;
            terminal = (Terminal)spec.terminals.get(i2);
            if (terminal.description != null) {
                descr = Strings.slice((String)terminal.description.description, (Integer)1, (Integer)-1);
                descr = ((String)descr).trim();
            } else {
                descr = terminal.isEof() ? "end-of-file" : ((descr = terminal.regEx.getDescriptionText()) == null ? terminal.name : "\"" + (String)descr + "\"");
            }
            code.add("%s, // %d", new Object[]{descr == null ? "null" : Strings.stringToJava((String)descr), i2});
            ++i2;
        }
        code.dedent();
        code.add("};");
        if (scannerHasHooks) {
            code.add();
            code.add("/** Scanner call back hook methods. */");
            code.add("public final %s hooks;", new Object[]{spec.hooksClass.getSimpleClassName()});
        }
        code.add();
        code.add("/** The current DFA state of the scanner. */");
        code.add("private int state;");
        code.add();
        code.add("/** Constructor for the {@link %s} class. */", new Object[]{spec.scannerClass.getSimpleClassName()});
        code.add("public %s() {", new Object[]{spec.scannerClass.getSimpleClassName()});
        code.indent();
        code.add("scannerStates = SCANNER_STATES;");
        code.add("terminalNeedsPost = TERMINAL_NEEDS_POST;");
        code.add("terminals = TERMINALS;");
        code.add("terminalNames = TERMINAL_NAMES;");
        code.add("terminalDescriptions = TERMINAL_DESCRIPTIONS;");
        if (scannerHasHooks) {
            code.add("hooks = new %s();", new Object[]{spec.hooksClass.getSimpleClassName()});
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("@Override");
        code.add("public final Token nextTokenInternal() throws IOException {");
        code.indent();
        if (spec.states.size() == 1) {
            code.add("state = 0;");
        } else {
            code.add("switch (scannerState) {");
            code.indent();
            i2 = 0;
            while (i2 < initials.length) {
                code.add("case %d: state = %d; break;", new Object[]{i2, initials[i2]});
                ++i2;
            }
            code.add("default:");
            code.indent();
            code.add("String msg = \"Unknown scanner state: \" + scannerState;");
            code.add("throw new RuntimeException(msg);");
            code.dedent();
            code.dedent();
            code.add("}");
        }
        code.add("startOffset = curOffset;");
        code.add("startLine = curLine;");
        code.add("startColumn = curColumn;");
        code.add("acceptOffset = -1;");
        code.add("acceptLine = -1;");
        code.add("acceptColumn = -1;");
        code.add("accept = -1;");
        code.add();
        code.add("while (true) {");
        code.indent();
        code.add("// Read next code point (the one for 'curOffset').");
        code.add("int codePoint = getNextCodePoint();");
        code.add();
        code.add("// Process the code point.");
        code.add("Token rslt;");
        code.add("switch (state) {");
        code.indent();
        int stateIdx = 0;
        int autIdx = 0;
        while (autIdx < states.size()) {
            Assert.check((stateIdx == initials[autIdx] ? 1 : 0) != 0);
            state = (String)states.get(autIdx);
            code.add("// Scanner state \"%s\".", new Object[]{state});
            aut = scannerAutomata.get(state);
            for (AutomatonState autState : aut.states.keySet()) {
                Assert.check((autState.id == stateIdx - initials[autIdx] ? 1 : 0) != 0);
                code.add("case %d:", new Object[]{stateIdx});
                code.indent();
                if (autState.edges.isEmpty()) {
                    code.add("return acceptOrError();");
                } else {
                    code.add("rslt = nextToken%d(codePoint);", new Object[]{stateIdx});
                    code.add("if (rslt != null) {");
                    code.indent();
                    code.add("return rslt;");
                    code.dedent();
                    code.add("}");
                    code.add("break;");
                }
                code.dedent();
                ++stateIdx;
            }
            ++autIdx;
        }
        code.add("default:");
        code.indent();
        code.add("String msg = \"Unknown scanner DFA state: \" + state;");
        code.add("throw new RuntimeException(msg);");
        code.dedent();
        code.dedent();
        code.add("}");
        code.add();
        code.add("// The code point has been processed. Move on to the next one.");
        code.add("// Also update line/column tracking information.");
        code.add("curOffset++;");
        code.add("if (codePoint == '\\n') {");
        code.indent();
        code.add("curLine++;");
        code.add("curColumn = 1;");
        code.dedent();
        code.add("} else {");
        code.indent();
        code.add("curColumn++;");
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        stateIdx = 0;
        autIdx = 0;
        while (autIdx < states.size()) {
            Assert.check((stateIdx == initials[autIdx] ? 1 : 0) != 0);
            state = (String)states.get(autIdx);
            aut = scannerAutomata.get(state);
            for (AutomatonState autState : aut.states.keySet()) {
                Assert.check((autState.id == stateIdx - initials[autIdx] ? 1 : 0) != 0);
                if (autState.edges.isEmpty()) {
                    ++stateIdx;
                    continue;
                }
                code.add();
                code.add("@SuppressWarnings(\"javadoc\")");
                code.add("private final Token nextToken%d(int codePoint) {", new Object[]{stateIdx});
                code.indent();
                code.add("switch (codePoint) {");
                code.indent();
                List<Pair<Integer, AutomatonState>> edges = autState.getSortedEdges();
                int edgeIdx = 0;
                while (edgeIdx < edges.size()) {
                    AutomatonState nextTarget;
                    Pair<Integer, AutomatonState> edge = edges.get(edgeIdx);
                    int codePoint = (Integer)edge.left;
                    Assert.check((-1 <= codePoint && codePoint <= 127 ? 1 : 0) != 0, (Object)"Unexpected code point.");
                    Object codePointTxt = codePoint == 10 ? "'\\n'" : (codePoint == 13 ? "'\\r'" : (codePoint == 9 ? "'\\t'" : (codePoint == 39 ? "'\\''" : (codePoint == 92 ? "'\\\\'" : (codePoint <= 31 || codePoint == 127 ? Integer.toString(codePoint) : "'" + Strings.codePointToStr((int)codePoint) + "'")))));
                    code.add("case %s:", new Object[]{codePointTxt});
                    AutomatonState curTarget = (AutomatonState)edge.right;
                    if (edgeIdx + 1 >= edges.size() || curTarget != (nextTarget = (AutomatonState)edges.get((int)(edgeIdx + 1)).right)) {
                        AutomatonState target = (AutomatonState)edge.right;
                        code.indent();
                        if (target.accept != null) {
                            code.add("acceptOffset = curOffset;");
                            code.add("acceptLine = curLine;");
                            code.add("acceptColumn = curColumn;");
                            code.add("accept = %d;", new Object[]{spec.terminals.indexOf(target.accept)});
                        }
                        if (autState != target) {
                            code.add("state = %d;", new Object[]{initials[autIdx] + target.id});
                        }
                        code.add("break;");
                        code.dedent();
                    }
                    ++edgeIdx;
                }
                code.add("default:");
                code.indent();
                code.add("return acceptOrError();");
                code.dedent();
                code.dedent();
                code.add("}");
                code.add("if (debugScanner) {");
                code.indent();
                code.add("debugScanner(codePoint, state);");
                code.dedent();
                code.add("}");
                code.add("return null;");
                code.dedent();
                code.add("}");
                ++stateIdx;
            }
            ++autIdx;
        }
        code.add();
        code.add("@Override");
        code.add("protected final void tokenAccepted(Token token) {");
        code.indent();
        code.add("switch (token.id) {");
        code.indent();
        int i3 = 0;
        while (i3 < spec.terminals.size()) {
            Object terminal2 = (Terminal)spec.terminals.get(i3);
            code.add("case %d:", new Object[]{i3});
            code.indent();
            if (((Terminal)terminal2).newState != null) {
                int newState = ((Terminal)terminal2).newState.id.equals("") ? 0 : states.indexOf(((Terminal)terminal2).newState.id);
                Assert.check((newState >= 0 ? 1 : 0) != 0);
                code.add("scannerState = %d;", new Object[]{newState});
            }
            if (((Terminal)terminal2).func != null) {
                code.add("hooks.%s(token);", new Object[]{((Terminal)terminal2).func.id});
            }
            code.add("return;");
            code.dedent();
            ++i3;
        }
        code.add("default:");
        code.indent();
        code.add("throw new RuntimeException(\"Unknown terminal id: \" + token.id);");
        code.dedent();
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        code.add();
        code.add("/**");
        code.add(" * Returns the keywords in the given category.");
        code.add(" *");
        code.add(" * @param keywordCategory The name of the keyword category.");
        code.add(" * @return The keywords in the given category.");
        code.add(" * @throws IllegalArgumentException If the category does not exist for");
        code.add(" *      this scanner.");
        code.add(" */");
        code.add("public static String[] getKeywords(String keywordCategory) {");
        code.indent();
        for (TerminalsDecl tdecl : Lists.filter((List)spec.decls, TerminalsDecl.class)) {
            List kwterms = Lists.filter((List)tdecl.terminals, KeywordsTerminal.class);
            for (KeywordsTerminal kwterm : kwterms) {
                code.add("if (keywordCategory.equals(%s)) {", new Object[]{Strings.stringToJava((String)kwterm.name)});
                code.indent();
                code.add("return new String[] {");
                code.indent();
                for (KeywordsIdentifier keyword : kwterm.keywords) {
                    code.add("%s,", new Object[]{Strings.stringToJava((String)keyword.keyword.id)});
                }
                code.dedent();
                code.add("};");
                code.dedent();
                code.add("}");
                code.add();
            }
        }
        code.add("String msg = \"Unknown keyword category: \" + keywordCategory;");
        code.add("throw new IllegalArgumentException(msg);");
        code.dedent();
        code.add("}");
        code.dedent();
        if (scannerHasHooks) {
            Set callbackSet = Sets.set();
            for (Object terminal2 : spec.terminals) {
                if (((Terminal)terminal2).func == null) continue;
                callbackSet.add(((Terminal)terminal2).func.id);
            }
            List callbacks = Sets.sortedstrings((Set)callbackSet);
            code.indent();
            code.add();
            code.add("/** Scanner call back hooks for {@link %s}. */", new Object[]{spec.scannerClass.getSimpleClassName()});
            code.add("public interface Hooks {");
            code.indent();
            boolean firstCallback = true;
            for (String callback : callbacks) {
                if (firstCallback) {
                    firstCallback = false;
                } else {
                    code.add();
                }
                code.add("/**");
                code.add(" * Call back hook \"%s\" for {@link %s}.", new Object[]{callback, spec.scannerClass.getSimpleClassName()});
                code.add(" * May perform in-place modifications to the scanned text of the token.");
                code.add(" *");
                code.add(" * @param token The scanned token.");
                code.add(" */");
                code.add("public void %s(Token token);", new Object[]{callback});
            }
            code.dedent();
            code.add("}");
            code.dedent();
        }
        code.add("}");
        if (OutputJavaFilesOption.isEnabled()) {
            code.writeToFile(javaFilePath);
            OutputProvider.out((String)"Scanner class \"%s\" written to file \"%s\".", (Object[])new Object[]{spec.scannerClass.toString(), javaFilePath});
        }
    }

    private static void writeParserSyntaxBnf(Specification spec) {
        Object path = InputFileOption.getPath();
        if (((String)path).endsWith(".setext")) {
            path = Strings.slice((String)path, (Integer)0, (Integer)(-".setext".length()));
        }
        path = (String)path + ".bnf";
        path = Paths.resolve((String)path);
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileAppStream stream = new FileAppStream((String)path);){
            boolean first = true;
            boolean[] blArray = new boolean[2];
            blArray[1] = true;
            boolean[] blArray2 = blArray;
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean generated = blArray2[n2];
                for (NonTerminal nonterm : spec.nonterminals) {
                    if (nonterm.generated != generated) continue;
                    if (first) {
                        first = false;
                    } else {
                        stream.println();
                    }
                    int nameLength = nonterm.name.length();
                    String nameSpaces = Strings.spaces((int)nameLength);
                    if (nonterm.rules.isEmpty()) {
                        stream.printfln("%s : /* empty */", new Object[]{nonterm.name});
                    } else {
                        int i = 0;
                        while (i < nonterm.rules.size()) {
                            ParserRule rule = (ParserRule)nonterm.rules.get(i);
                            String prefix = i == 0 ? nonterm.name : nameSpaces;
                            String sep = i == 0 ? ":" : "|";
                            List parts = Lists.listc((int)rule.symbols.size());
                            for (ParserRulePart part : rule.symbols) {
                                Symbol symbol = part.symbol;
                                if (symbol instanceof NonTerminal) {
                                    parts.add(symbol.name);
                                    continue;
                                }
                                Terminal term = (Terminal)symbol;
                                if (term.regEx.isDescriptionText()) {
                                    String txt = term.regEx.getDescriptionText();
                                    parts.add(Strings.fmt((String)"\"%s\"", (Object[])new Object[]{txt}));
                                    continue;
                                }
                                parts.add(symbol.name);
                            }
                            if (parts.isEmpty()) {
                                parts.add("/* empty */");
                            }
                            stream.printfln("%s %s %s", new Object[]{prefix, sep, String.join((CharSequence)" ", parts)});
                            ++i;
                        }
                    }
                    stream.printfln("%s ;", new Object[]{nameSpaces});
                }
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        OutputProvider.out((String)"Syntax in BNF format written to file \"%s\".", (Object[])new Object[]{path});
    }

    public static void writeParserClass(Specification spec, StartSymbol start, LALR1Automaton aut, LALR1ParserGenerator generator, String javaFilePath) {
        List lines;
        Symbol remainingHead;
        Set<Symbol> first;
        Object item;
        LALR1AutomatonState state;
        MemoryCodeBox code = new MemoryCodeBox();
        Set nonterminalSet = Sets.set();
        for (LALR1AutomatonState state2 : aut.states) {
            nonterminalSet.addAll(state2.gotos.keySet());
        }
        List nonterminals = Lists.copy((List)spec.nonterminals);
        Iterator nontermsIter = nonterminals.iterator();
        while (nontermsIter.hasNext()) {
            NonTerminal nonterminal = (NonTerminal)nontermsIter.next();
            if (nonterminalSet.contains(nonterminal)) continue;
            nontermsIter.remove();
        }
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("static org.eclipse.escet.common.java.Strings.fmt");
        imports.add("java.io.IOException");
        imports.add("org.eclipse.escet.setext.runtime.Parser");
        imports.add("org.eclipse.escet.setext.runtime.ParserHooksBase");
        imports.add("org.eclipse.escet.setext.runtime.Token");
        imports.add(spec.scannerClass.className);
        imports.add(spec.hooksClass.className);
        boolean anyGenericTypes = false;
        for (NonTerminal nonterminal : nonterminals) {
            imports.addAll(nonterminal.returnType.getNames());
            if (!nonterminal.returnType.isGeneric()) continue;
            anyGenericTypes = true;
        }
        Map importNames = Maps.map();
        for (String imp : imports) {
            int idx = imp.lastIndexOf(46);
            String name = idx == -1 ? imp : imp.substring(idx + 1);
            String entry = (String)importNames.get(name);
            if (entry == null) {
                importNames.put(name, imp);
                continue;
            }
            String msg = Strings.fmt((String)"Conflicting class names: \"%s\" and \"%s\".", (Object[])new Object[]{entry, imp});
            throw new UnsupportedException(msg);
        }
        SeTextGenerator.addJavaHeader((CodeBox)code);
        code.add("// Disable Eclipse Java formatter for generated code file:");
        code.add("// @formatter:off");
        code.add();
        String packageName = start.javaType.getPackageName();
        if (!packageName.isEmpty()) {
            code.add("package %s;", new Object[]{packageName});
            code.add();
        }
        for (String imp : JavaCodeUtils.formatImports(imports, (String)packageName)) {
            code.add(imp);
        }
        code.add();
        code.add("/**");
        code.add(" * %s.", new Object[]{start.javaType.getSimpleClassName()});
        code.add(" *");
        code.add(" * <p>This parser is generated by SeText for %s symbol", new Object[]{start.getStartType()});
        code.add(" * \"%s\".</p>", new Object[]{start.name.id});
        code.add(" */");
        if (anyGenericTypes) {
            code.add("@SuppressWarnings(\"unchecked\")");
        }
        code.add("public final class %s extends Parser<%s> {", new Object[]{start.javaType.getSimpleClassName(), start.symbol.returnType.toSimpleString()});
        code.indent();
        code.add("/** The names of the non-terminals, ordered by their unique ids. */");
        code.add("private static final String[] NON_TERMINAL_NAMES = {");
        code.indent();
        for (NonTerminal nonterminal : nonterminals) {
            code.add("\"%s\",", new Object[]{nonterminal.name});
        }
        code.dedent();
        code.add("};");
        code.add();
        code.add("/**");
        code.add(" * The entry symbol names for each of the parser states, and {@code null}");
        code.add(" * for the initial state.");
        code.add(" */");
        code.add("private static final String[] ENTRY_SYMBOL_NAMES = new String[] {");
        code.indent();
        for (LALR1AutomatonState state3 : aut.states) {
            if (state3.id == 0) {
                Assert.check((state3.entrySymbol == null ? 1 : 0) != 0);
                code.add("null,");
                continue;
            }
            Assert.notNull((Object)state3.entrySymbol);
            Assert.notNull((Object)state3.entrySymbol.name);
            code.add("\"%s\",", new Object[]{state3.entrySymbol.name});
        }
        code.dedent();
        code.add("};");
        code.add();
        code.add("/** Parser call back hook methods. */");
        code.add("private final %s hooks;", new Object[]{spec.hooksClass.getSimpleClassName()});
        code.add();
        code.add("/** Whether parsing has completed (final result has been accepted). */");
        code.add("private boolean accept;");
        code.add();
        code.add("/** The parse result, but only if {@code #accept} is {@code true}. */");
        code.add("private %s acceptObject;", new Object[]{start.symbol.returnType.toSimpleString()});
        code.add();
        code.add("/** The current scanner token to process, if any. */");
        code.add("private Token token;");
        code.add();
        code.add("/** Whether parsing has resulted in a reduce action. */");
        code.add("private boolean reduce;");
        code.add();
        code.add("/** The state from which to reduce, if {@code #reduce} is {@code true}. */");
        code.add("private int reduceState;");
        code.add();
        code.add("/** The non-terminal to reduce, if {@code #reduce} is {@code true}. */");
        code.add("private int reduceNonTerminal;");
        boolean scannerHasHooks = SeTextGenerator.scannerHasHooks(spec);
        code.add();
        code.add("/** Constructor for the {@link %s} class. */", new Object[]{start.javaType.getSimpleClassName()});
        code.add("public %s() {", new Object[]{start.javaType.getSimpleClassName()});
        code.indent();
        code.add("super(new %s());", new Object[]{spec.scannerClass.getSimpleClassName()});
        code.add("entrySymbolNames = ENTRY_SYMBOL_NAMES;");
        code.add("firstTerminals = FirstTerminals.FIRST_TERMINALS;");
        code.add("firstTerminalsReduced = FirstTerminalsReduced.FIRST_TERMINALS_REDUCED;");
        code.add("reducibleNonTerminals = ReducibleNonTerminals.REDUCIBLE_NON_TERMINALS;");
        code.add("reducibleNonTerminalsReduced = ReducibleNonTerminalsReduced.REDUCIBLE_NON_TERMINALS_REDUCED;");
        if (scannerHasHooks) {
            code.add("hooks = ((%s)scanner).hooks;", new Object[]{spec.scannerClass.getSimpleClassName()});
        } else {
            code.add("hooks = new %s();", new Object[]{spec.hooksClass.getSimpleClassName()});
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("@Override");
        code.add("public ParserHooksBase getHooks() {");
        code.indent();
        code.add("return hooks;");
        code.dedent();
        code.add("}");
        code.add();
        code.add("@Override");
        code.add("protected final %s parse() throws IOException {", new Object[]{start.symbol.returnType.toSimpleString()});
        code.indent();
        code.add("token = nextToken();");
        code.add("int state;");
        code.add();
        code.add("accept = false;");
        code.add();
        code.add("while (true) {");
        code.indent();
        code.add("// Perform action.");
        code.add("state = getCurrentState();");
        code.add("reduce = false;");
        code.add();
        code.add("switch (state) {");
        code.indent();
        for (LALR1AutomatonState state4 : aut.states) {
            code.add("case %d:", new Object[]{state4.id});
            code.indent();
            code.add("action%d();", new Object[]{state4.id});
            code.add("break;");
            code.dedent();
        }
        code.add("default:");
        code.indent();
        code.add("String msg = \"Unknown parser state: \" + state;");
        code.add("throw new RuntimeException(msg);");
        code.dedent();
        code.dedent();
        code.add("}");
        code.add();
        code.add("// Accept action.");
        code.add("if (accept) {");
        code.indent();
        code.add("return acceptObject;");
        code.dedent();
        code.add("}");
        code.add();
        code.add("// Shift action.");
        code.add("if (!reduce) {");
        code.indent();
        code.add("continue;");
        code.dedent();
        code.add("}");
        code.add();
        code.add("// Perform goto (as part of a reduce action).");
        code.add("switch (reduceState) {");
        code.indent();
        for (LALR1AutomatonState state2 : aut.states) {
            code.add("case %d:", new Object[]{state2.id});
            code.indent();
            code.add("goto%d();", new Object[]{state2.id});
            code.add("break;");
            code.dedent();
        }
        code.add("default:");
        code.indent();
        code.add("String msg = fmt(\"Unknown reduce state %d.\", reduceState);");
        code.add("throw new RuntimeException(msg);");
        code.dedent();
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        for (LALR1AutomatonState state2 : aut.states) {
            code.add();
            code.add("/**");
            code.add(" * Parser action code for parser state %d.", new Object[]{state2.id});
            code.add(" *");
            code.add(" * @throws IOException If reading the input failed due to an I/O error.");
            code.add(" */");
            code.add("private final void action%d() throws IOException {", new Object[]{state2.id});
            code.indent();
            code.add("switch (token.id) {");
            code.indent();
            List<Pair<Terminal, ParserAction>> actionEntries = state2.getSortedActions(spec.terminals, nonterminals);
            int actIdx = 0;
            while (actIdx < actionEntries.size()) {
                ParserAction nextAction;
                Iterator entry = actionEntries.get(actIdx);
                Terminal terminal = (Terminal)((Pair)entry).left;
                ParserAction action = (ParserAction)((Pair)entry).right;
                int termId = spec.terminals.indexOf(terminal);
                if (actIdx + 1 < actionEntries.size() && action.equals(nextAction = (ParserAction)actionEntries.get((int)(actIdx + 1)).right)) {
                    code.add("case %d:", new Object[]{termId});
                } else {
                    code.add("case %d: {", new Object[]{termId});
                    code.indent();
                    if (action instanceof ParserShiftAction) {
                        ParserShiftAction shift = (ParserShiftAction)action;
                        code.add("// Shift %d.", new Object[]{shift.target.id});
                        code.add("token = doShift(token, %d);", new Object[]{shift.target.id});
                        code.add("return;");
                    } else if (action instanceof ParserAcceptAction) {
                        code.add("// Accept.");
                        code.add("Object rslt = doAccept(token);");
                        code.add("accept = true;");
                        code.add("acceptObject = (%s)rslt;", new Object[]{start.symbol.returnType.toSimpleString()});
                        code.add("return;");
                    } else {
                        Assert.check((boolean)(action instanceof ParserReduceAction));
                        ParserReduceAction reduce = (ParserReduceAction)action;
                        int reduceId = nonterminals.indexOf(reduce.nonterminal);
                        code.add("// Reduce %s : %s;", new Object[]{reduce.nonterminal.name, reduce.rule.toString()});
                        code.add("doReduce1(token, %d);", new Object[]{reduceId});
                        List symbols = reduce.rule.symbols;
                        int i = symbols.size() - 1;
                        while (i >= 0) {
                            if (((ParserRulePart)symbols.get((int)i)).callBackArg) {
                                code.add("Object o%d = doReduce2();", new Object[]{i + 1});
                            } else {
                                code.add("doReduce2();");
                            }
                            --i;
                        }
                        if (!symbols.isEmpty()) {
                            code.add();
                        }
                        List paramTxts = Lists.list();
                        int i2 = 0;
                        while (i2 < symbols.size()) {
                            ParserRulePart part = (ParserRulePart)symbols.get(i2);
                            if (part.callBackArg) {
                                Symbol symbol = part.symbol;
                                String argTypeTxt = symbol instanceof Terminal ? "Token" : ((NonTerminal)symbol).returnType.toSimpleString();
                                paramTxts.add("(" + argTypeTxt + ")o" + Integer.toString(i2 + 1));
                            }
                            ++i2;
                        }
                        int maxRuleNr = reduce.nonterminal.rules.size();
                        int maxRuleNrLen = Integer.toString(maxRuleNr).length();
                        int ruleNr = reduce.nonterminal.rules.indexOf(reduce.rule);
                        Iterator ruleNrStr = Integer.toString(ruleNr + 1);
                        ruleNrStr = StringUtils.leftPad((String)((Object)ruleNrStr), (int)maxRuleNrLen, (char)'0');
                        String hookName = "hooks.parse" + reduce.nonterminal.name + (String)((Object)ruleNrStr);
                        code.add("%s o = %s(%s);", new Object[]{reduce.nonterminal.returnType.toSimpleString(), hookName, String.join((CharSequence)", ", paramTxts)});
                        code.add();
                        code.add("reduce = true;");
                        code.add("reduceNonTerminal = %d;", new Object[]{reduceId});
                        code.add("reduceState = doReduce3(o);");
                        code.add("return;");
                    }
                    code.dedent();
                    code.add("}");
                    code.add();
                }
                ++actIdx;
            }
            code.add("default:");
            code.indent();
            code.add("parsingFailed(token);");
            code.dedent();
            code.dedent();
            code.add("}");
            code.dedent();
            code.add("}");
        }
        for (LALR1AutomatonState state2 : aut.states) {
            code.add();
            code.add("/** Parser goto code for parser state %d. */", new Object[]{state2.id});
            code.add("private final void goto%d() {", new Object[]{state2.id});
            code.indent();
            code.add("switch (reduceNonTerminal) {");
            code.indent();
            int nonTerminalId = 0;
            for (NonTerminal nonterminal : nonterminals) {
                LALR1AutomatonState lALR1AutomatonState = state2.gotos.get(nonterminal);
                if (lALR1AutomatonState != null) {
                    code.add("case %d:", new Object[]{nonTerminalId});
                    code.indent();
                    code.add("// %s", new Object[]{nonterminal.name});
                    code.add("doGoto(%d);", new Object[]{lALR1AutomatonState.id});
                    code.add("return;");
                    code.add();
                    code.dedent();
                }
                ++nonTerminalId;
            }
            code.add("default:");
            code.indent();
            code.add("String msg = fmt(\"Unknown non-terminal %d (%s) for reduce \" +");
            code.add("                 \"state %d.\", reduceNonTerminal,");
            code.add("                 NON_TERMINAL_NAMES[reduceNonTerminal],");
            code.add("                 reduceState);");
            code.add("throw new RuntimeException(msg);");
            code.dedent();
            code.dedent();
            code.add("}");
            code.dedent();
            code.add("}");
        }
        code.add();
        code.add("@Override");
        code.add("protected final String getNonTerminalName(int nonTerminalId) {");
        code.indent();
        code.add("return NON_TERMINAL_NAMES[nonTerminalId];");
        code.dedent();
        code.add("}");
        code.add();
        code.add("/** See {@code Parser.firstTerminals}. */");
        code.add("private static final class FirstTerminals {");
        code.indent();
        code.add("/** See {@code Parser.firstTerminals}. */");
        code.add("private static final int[][] FIRST_TERMINALS = new int[%d][];", new Object[]{aut.states.size()});
        code.add();
        code.add("static {");
        code.indent();
        int si = 0;
        while (si < aut.states.size()) {
            code.add("init%d();", new Object[]{si});
            ++si;
        }
        code.dedent();
        code.add("}");
        si = 0;
        while (si < aut.states.size()) {
            state = aut.states.get(si);
            Set<LookaheadItem> productions = state.itemsClosure;
            Set termIdSet = Sets.set();
            for (LookaheadItem production : productions) {
                item = production.item;
                List<Symbol> remainingSymbols = ((GrammarItem)item).remainder();
                first = remainingSymbols.isEmpty() ? Sets.set((Object)((Object)EmptySymbol.EMPTY_SYMBOL)) : generator.getFirst(remainingSymbols);
                boolean hasEmpty = false;
                for (Symbol symbol : first) {
                    if (symbol instanceof EmptySymbol) {
                        hasEmpty = true;
                        continue;
                    }
                    if (symbol instanceof NonTerminal) continue;
                    Assert.check((boolean)(symbol instanceof Terminal));
                    termIdSet.add(spec.terminals.indexOf(symbol));
                }
                if (!((GrammarItem)item).nonterminal.isAugmentedStartSymbol() || !hasEmpty) continue;
                for (Terminal eofTerminal : spec.getEofTerminals()) {
                    termIdSet.add(spec.terminals.indexOf(eofTerminal));
                }
            }
            code.add();
            code.add("/** Initialize {@link #FIRST_TERMINALS}{@code [%d]}. */", new Object[]{si});
            code.add("private static void init%d() {", new Object[]{si});
            code.indent();
            code.add("FIRST_TERMINALS[%d] = new int[] {%s};", new Object[]{si, SeTextGenerator.intsToStr(Sets.sortedgeneric((Set)termIdSet))});
            code.dedent();
            code.add("}");
            ++si;
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("/** See {@code Parser.firstTerminalsReduced}. */");
        code.add("private static final class FirstTerminalsReduced {");
        code.indent();
        code.add("/** See {@code Parser.firstTerminalsReduced}. */");
        code.add("private static final int[][][] FIRST_TERMINALS_REDUCED = new int[%d][][];", new Object[]{aut.states.size()});
        code.add();
        code.add("static {");
        code.indent();
        si = 0;
        while (si < aut.states.size()) {
            code.add("init%d();", new Object[]{si});
            ++si;
        }
        code.dedent();
        code.add("}");
        si = 0;
        while (si < aut.states.size()) {
            state = aut.states.get(si);
            Set<LookaheadItem> productions = state.itemsClosure;
            Map termIdMap = Maps.map();
            for (LookaheadItem production : productions) {
                item = production.item;
                List<Symbol> remainingSymbols = ((GrammarItem)item).remainder();
                if (remainingSymbols.isEmpty() || !((remainingHead = (Symbol)Lists.first(remainingSymbols)) instanceof NonTerminal)) continue;
                NonTerminal reducedNonTerm = (NonTerminal)remainingHead;
                int reducedIdx = spec.nonterminals.indexOf(reducedNonTerm);
                Assert.check((reducedIdx != -1 ? 1 : 0) != 0);
                remainingSymbols.remove(0);
                Object termIdSet = (Set)termIdMap.get(reducedIdx);
                if (termIdSet == null) {
                    termIdSet = Sets.set();
                    termIdMap.put(reducedIdx, termIdSet);
                }
                Set<Symbol> first2 = remainingSymbols.isEmpty() ? Sets.set((Object)((Object)EmptySymbol.EMPTY_SYMBOL)) : generator.getFirst(remainingSymbols);
                boolean hasEmpty = false;
                for (Symbol symbol : first2) {
                    if (symbol instanceof EmptySymbol) {
                        hasEmpty = true;
                        continue;
                    }
                    if (symbol instanceof NonTerminal) continue;
                    Assert.check((boolean)(symbol instanceof Terminal));
                    termIdSet.add(spec.terminals.indexOf(symbol));
                }
                if (!((GrammarItem)item).nonterminal.isAugmentedStartSymbol() || !hasEmpty) continue;
                for (Terminal eofTerminal : spec.getEofTerminals()) {
                    termIdSet.add(spec.terminals.indexOf(eofTerminal));
                }
            }
            lines = Lists.list();
            for (Map.Entry entry : termIdMap.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                List termIds = Sets.sortedgeneric((Set)((Set)entry.getValue()));
                lines.add(Strings.fmt((String)"{%d, %s},", (Object[])new Object[]{entry.getKey(), SeTextGenerator.intsToStr(termIds)}));
            }
            code.add();
            code.add("/** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [%d]}. */", new Object[]{si});
            code.add("private static void init%d() {", new Object[]{si});
            code.indent();
            if (lines.isEmpty()) {
                code.add("FIRST_TERMINALS_REDUCED[%d] = new int[][] {};", new Object[]{si});
            } else {
                code.add("FIRST_TERMINALS_REDUCED[%d] = new int[][] {", new Object[]{si});
                code.indent();
                Collections.sort(lines, Strings.SORTER);
                for (String string : lines) {
                    code.add(string);
                }
                code.dedent();
                code.add("};");
            }
            code.dedent();
            code.add("}");
            ++si;
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("/** See {@code Parser.reducibleNonTerminals}. */");
        code.add("private static final class ReducibleNonTerminals {");
        code.indent();
        code.add("/** See {@code Parser.reducibleNonTerminals}. */");
        code.add("private static final int[][][] REDUCIBLE_NON_TERMINALS = new int[%d][][];", new Object[]{aut.states.size()});
        code.add();
        code.add("static {");
        code.indent();
        si = 0;
        while (si < aut.states.size()) {
            code.add("init%d();", new Object[]{si});
            ++si;
        }
        code.dedent();
        code.add("}");
        si = 0;
        while (si < aut.states.size()) {
            state = aut.states.get(si);
            Set<LookaheadItem> productions = state.itemsClosure;
            Map nontermIdMap = Maps.map();
            for (LookaheadItem production : productions) {
                item = production.item;
                List<Symbol> remainingSymbols = ((GrammarItem)item).remainder();
                first = remainingSymbols.isEmpty() ? Sets.set((Object)((Object)EmptySymbol.EMPTY_SYMBOL)) : generator.getFirst(remainingSymbols);
                boolean isEmpty = false;
                for (Symbol symbol : first) {
                    if (!(symbol instanceof EmptySymbol)) continue;
                    isEmpty = true;
                    break;
                }
                if (!isEmpty || ((GrammarItem)item).nonterminal.isAugmentedStartSymbol()) continue;
                int ntId = spec.nonterminals.indexOf(((GrammarItem)item).nonterminal);
                Set nonTermPopCnts = (Set)nontermIdMap.get(ntId);
                if (nonTermPopCnts == null) {
                    nonTermPopCnts = Sets.set();
                    nontermIdMap.put(ntId, nonTermPopCnts);
                }
                nonTermPopCnts.add(((GrammarItem)item).progress);
            }
            lines = Lists.list();
            for (Map.Entry entry : nontermIdMap.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                List popCnts = Sets.sortedgeneric((Set)((Set)entry.getValue()));
                lines.add(Strings.fmt((String)"{%d, %s},", (Object[])new Object[]{entry.getKey(), SeTextGenerator.intsToStr(popCnts)}));
            }
            code.add();
            code.add("/** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [%d]}. */", new Object[]{si});
            code.add("private static void init%d() {", new Object[]{si});
            code.indent();
            if (lines.isEmpty()) {
                code.add("REDUCIBLE_NON_TERMINALS[%d] = new int[][] {};", new Object[]{si});
            } else {
                code.add("REDUCIBLE_NON_TERMINALS[%d] = new int[][] {", new Object[]{si});
                code.indent();
                Collections.sort(lines, Strings.SORTER);
                for (String string : lines) {
                    code.add(string);
                }
                code.dedent();
                code.add("};");
            }
            code.dedent();
            code.add("}");
            ++si;
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("/** See {@code Parser.reducibleNonTerminalsReduced}. */");
        code.add("private static final class ReducibleNonTerminalsReduced {");
        code.indent();
        code.add("/** See {@code Parser.reducibleNonTerminalsReduced}. */");
        code.add("private static final int[][][] REDUCIBLE_NON_TERMINALS_REDUCED = new int[%d][][];", new Object[]{aut.states.size()});
        code.add();
        code.add("static {");
        code.indent();
        si = 0;
        while (si < aut.states.size()) {
            code.add("init%d();", new Object[]{si});
            ++si;
        }
        code.dedent();
        code.add("}");
        si = 0;
        while (si < aut.states.size()) {
            state = aut.states.get(si);
            Set<LookaheadItem> productions = state.itemsClosure;
            Map outerMap = Maps.map();
            for (LookaheadItem production : productions) {
                int ntId;
                Set nonTermPopCnts;
                item = production.item;
                List<Symbol> remainingSymbols = ((GrammarItem)item).remainder();
                if (remainingSymbols.isEmpty() || !((remainingHead = (Symbol)Lists.first(remainingSymbols)) instanceof NonTerminal)) continue;
                NonTerminal reducedNonTerm = (NonTerminal)remainingHead;
                int reducedIdx = spec.nonterminals.indexOf(reducedNonTerm);
                Assert.check((reducedIdx != -1 ? 1 : 0) != 0);
                remainingSymbols.remove(0);
                Set<Symbol> first3 = remainingSymbols.isEmpty() ? Sets.set((Object)((Object)EmptySymbol.EMPTY_SYMBOL)) : generator.getFirst(remainingSymbols);
                boolean isEmpty = false;
                for (Symbol symbol : first3) {
                    if (!(symbol instanceof EmptySymbol)) continue;
                    isEmpty = true;
                    break;
                }
                if (!isEmpty || ((GrammarItem)item).nonterminal.isAugmentedStartSymbol()) continue;
                Map innerMap = (Map)outerMap.get(reducedIdx);
                if (innerMap == null) {
                    innerMap = Maps.map();
                    outerMap.put(reducedIdx, innerMap);
                }
                if ((nonTermPopCnts = (Set)innerMap.get(ntId = spec.nonterminals.indexOf(((GrammarItem)item).nonterminal))) == null) {
                    nonTermPopCnts = Sets.set();
                    innerMap.put(ntId, nonTermPopCnts);
                }
                nonTermPopCnts.add(((GrammarItem)item).progress);
            }
            lines = Lists.list();
            Set set = outerMap.entrySet();
            for (Map.Entry outer : set) {
                Set inners = ((Map)outer.getValue()).entrySet();
                for (Map.Entry inner : inners) {
                    if (((Set)inner.getValue()).isEmpty()) continue;
                    List popCnts = Sets.sortedgeneric((Set)((Set)inner.getValue()));
                    lines.add(Strings.fmt((String)"{%d, %d, %s},", (Object[])new Object[]{outer.getKey(), inner.getKey(), SeTextGenerator.intsToStr(popCnts)}));
                }
            }
            code.add();
            code.add("/** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [%d]}. */", new Object[]{si});
            code.add("private static void init%d() {", new Object[]{si});
            code.indent();
            if (lines.isEmpty()) {
                code.add("REDUCIBLE_NON_TERMINALS_REDUCED[%d] = new int[][] {};", new Object[]{si});
            } else {
                code.add("REDUCIBLE_NON_TERMINALS_REDUCED[%d] = new int[][] {", new Object[]{si});
                code.indent();
                Collections.sort(lines, Strings.SORTER);
                for (String line : lines) {
                    code.add(line);
                }
                code.dedent();
                code.add("};");
            }
            code.dedent();
            code.add("}");
            ++si;
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("/** Parser call back hooks for {@link %s}. */", new Object[]{start.javaType.getSimpleClassName()});
        code.add("public interface Hooks extends ParserHooksBase {");
        code.indent();
        boolean firstMethod = true;
        for (NonTerminal nonterminal : nonterminals) {
            int ri = 0;
            while (ri < nonterminal.rules.size()) {
                ParserRule rule = (ParserRule)nonterminal.rules.get(ri);
                if (firstMethod) {
                    firstMethod = false;
                } else {
                    code.add();
                }
                List list = Lists.list();
                for (ParserRulePart part : rule.symbols) {
                    if (part.symbol instanceof Terminal) {
                        Terminal terminal = (Terminal)part.symbol;
                        list.add((part.callBackArg ? "@" : "") + terminal.name);
                        continue;
                    }
                    list.add(((NonTerminal)part.symbol).name);
                }
                code.add("/**");
                code.add(" * Parser call back hook for rule/production:");
                code.add(" *");
                code.add(" * <p>{@code %s : %s;}</p>", new Object[]{nonterminal.name, String.join((CharSequence)" ", list)});
                code.add(" *");
                List argTxts = Lists.list();
                int pi = 0;
                while (pi < rule.symbols.size()) {
                    ParserRulePart part = (ParserRulePart)rule.symbols.get(pi);
                    if (part.callBackArg) {
                        String typeTxt = part.symbol instanceof Terminal ? "Token" : ((NonTerminal)part.symbol).returnType.toSimpleString();
                        Object argName = typeTxt.substring(0, 1).toLowerCase(Locale.US);
                        argName = (String)argName + Strings.str((Object)(pi + 1));
                        code.add(" * @param %s {@code %s}.", new Object[]{argName, part.name});
                        argTxts.add(typeTxt + " " + (String)argName);
                    }
                    ++pi;
                }
                code.add(" * @return The parser call back hook result.");
                code.add(" */");
                int maxRuleNr = nonterminal.rules.size();
                int maxRuleNrLen = Integer.toString(maxRuleNr).length();
                String ruleNrStr = Integer.toString(ri + 1);
                ruleNrStr = StringUtils.leftPad((String)ruleNrStr, (int)maxRuleNrLen, (char)'0');
                code.add("public %s parse%s%s(%s);", new Object[]{nonterminal.returnType.toSimpleString(), nonterminal.name, ruleNrStr, String.join((CharSequence)", ", argTxts)});
                ++ri;
            }
        }
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        if (OutputJavaFilesOption.isEnabled()) {
            code.writeToFile(javaFilePath);
            OutputProvider.out((String)"Parser class \"%s\" for %s symbol \"%s\" written to file \"%s\".", (Object[])new Object[]{start.javaType.toString(), start.getStartType(), start.symbol.name, javaFilePath});
        }
    }

    private static String intsToStr(List<Integer> integers) {
        return integers.stream().map(String::valueOf).collect(Collectors.joining(", "));
    }

    public static void writeHooksSkeleton(Specification spec, String filePath) {
        OutputProvider.out((String)"Generating hooks skeleton class \"%s\".", (Object[])new Object[]{spec.hooksClass.className});
        MemoryCodeBox code = new MemoryCodeBox();
        boolean scannerHooksNeeded = false;
        for (Terminal terminal : spec.terminals) {
            if (terminal.func == null) continue;
            scannerHooksNeeded = true;
            break;
        }
        TreeSet<String> imports = new TreeSet<String>();
        if (scannerHooksNeeded) {
            imports.add("org.eclipse.escet.setext.runtime.Token");
        }
        if (scannerHooksNeeded) {
            imports.add(spec.scannerClass.className);
        }
        if (!spec.getStartSymbols().isEmpty()) {
            imports.add("org.eclipse.escet.setext.runtime.Parser");
        }
        for (NonTerminal nonterminal : spec.nonterminals) {
            imports.addAll(nonterminal.returnType.getNames());
            for (ParserRule rule : nonterminal.rules) {
                for (ParserRulePart part : rule.symbols) {
                    if (!part.callBackArg || !(part.symbol instanceof Terminal)) continue;
                    imports.add("org.eclipse.escet.setext.runtime.Token");
                }
            }
        }
        for (StartSymbol start : spec.getStartSymbols()) {
            imports.add(start.javaType.className);
        }
        Map importNames = Maps.map();
        for (String imp : imports) {
            int idx = imp.lastIndexOf(46);
            String name = idx == -1 ? imp : imp.substring(idx + 1);
            String entry = (String)importNames.get(name);
            if (entry == null) {
                importNames.put(name, imp);
                continue;
            }
            String msg = Strings.fmt((String)"Conflicting class names: \"%s\" and \"%s\".", (Object[])new Object[]{entry, imp});
            throw new UnsupportedException(msg);
        }
        SeTextGenerator.addJavaHeader((CodeBox)code);
        String packageName = spec.hooksClass.getPackageName();
        if (!packageName.isEmpty()) {
            code.add("package %s;", new Object[]{packageName});
            code.add();
        }
        for (String imp : JavaCodeUtils.formatImports(imports, (String)packageName)) {
            code.add(imp);
        }
        List interfaceClasses = Lists.list();
        if (scannerHooksNeeded) {
            interfaceClasses.add(spec.scannerClass.getSimpleClassName());
        }
        for (StartSymbol start : spec.getStartSymbols()) {
            interfaceClasses.add(start.javaType.getSimpleClassName());
        }
        code.add();
        code.add("/**");
        code.add(" * Call back hook methods for:");
        code.add(" * <ul>");
        for (String interfaceClass : interfaceClasses) {
            code.add(" *  <li>{@link %s}</li>", new Object[]{interfaceClass});
        }
        code.add(" * </ul>");
        code.add(" */");
        code.add("public final class %s", new Object[]{spec.hooksClass.getSimpleClassName()});
        int i = 0;
        while (i < interfaceClasses.size()) {
            String preFix = i == 0 ? "implements" : "          ";
            String postFix = i == interfaceClasses.size() - 1 ? "" : ",";
            code.add("%s %s.Hooks%s", new Object[]{preFix, interfaceClasses.get(i), postFix});
            ++i;
        }
        code.add("{");
        boolean firstMethod = true;
        if (!spec.getStartSymbols().isEmpty()) {
            code.indent();
            code.add("@Override");
            code.add("public void setParser(Parser<?> parser) {");
            code.add("}");
            code.dedent();
            firstMethod = false;
        }
        Set callbackSet = Sets.set();
        for (Terminal terminal : spec.terminals) {
            if (terminal.func == null) continue;
            callbackSet.add(terminal.func.id);
        }
        List callbacks = Sets.sortedstrings((Set)callbackSet);
        for (String callback : callbacks) {
            if (firstMethod) {
                firstMethod = false;
            } else {
                code.add();
            }
            code.indent();
            code.add("@Override");
            code.add("public void %s(Token token) {", new Object[]{callback});
            code.add("}");
            code.dedent();
        }
        for (NonTerminal nonterminal : spec.nonterminals) {
            int ri = 0;
            while (ri < nonterminal.rules.size()) {
                ParserRule rule = (ParserRule)nonterminal.rules.get(ri);
                if (firstMethod) {
                    firstMethod = false;
                } else {
                    code.add();
                }
                List ruleTxts = Lists.list();
                for (ParserRulePart part : rule.symbols) {
                    if (part.symbol instanceof Terminal) {
                        Terminal terminal = (Terminal)part.symbol;
                        ruleTxts.add((part.callBackArg ? "@" : "") + terminal.name);
                        continue;
                    }
                    ruleTxts.add(((NonTerminal)part.symbol).name);
                }
                code.indent();
                code.add("@Override // %s : %s;", new Object[]{nonterminal.name, String.join((CharSequence)" ", ruleTxts)});
                code.dedent();
                List argTxts = Lists.list();
                int pi = 0;
                while (pi < rule.symbols.size()) {
                    ParserRulePart part = (ParserRulePart)rule.symbols.get(pi);
                    if (part.callBackArg) {
                        String typeTxt = part.symbol instanceof Terminal ? "Token" : ((NonTerminal)part.symbol).returnType.toSimpleString();
                        Object argName = typeTxt.substring(0, 1).toLowerCase(Locale.US);
                        argName = (String)argName + Strings.str((Object)(pi + 1));
                        argTxts.add(typeTxt + " " + (String)argName);
                    }
                    ++pi;
                }
                int maxRuleNr = nonterminal.rules.size();
                int maxRuleNrLen = Integer.toString(maxRuleNr).length();
                String ruleNrStr = Integer.toString(ri + 1);
                ruleNrStr = StringUtils.leftPad((String)ruleNrStr, (int)maxRuleNrLen, (char)'0');
                code.indent();
                code.add("public %s parse%s%s(%s) {", new Object[]{nonterminal.returnType.toSimpleString(), nonterminal.name, ruleNrStr, String.join((CharSequence)", ", argTxts)});
                code.indent();
                code.add("// return null;");
                code.dedent();
                code.add("}");
                code.dedent();
                ++ri;
            }
        }
        code.add("}");
        if (OutputJavaFilesOption.isEnabled()) {
            code.writeToFile(filePath);
            OutputProvider.out((String)"Hooks skeleton class \"%s\" written to file \"%s\".", (Object[])new Object[]{spec.hooksClass.className, filePath});
        }
    }

    private static void addJavaHeader(CodeBox code) {
        List lines;
        if (JavaHeaderOption.getPath() == null) {
            return;
        }
        String headerPath = JavaHeaderOption.getPath();
        String absHeaderPath = Paths.resolve((String)headerPath);
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(absHeaderPath));){
                lines = IOUtils.readLines((InputStream)stream, (String)"UTF-8");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Failed to read Java header file \"%s\".", (Object[])new Object[]{headerPath});
            throw new InputOutputException(msg, (Throwable)e);
        }
        for (String line : lines) {
            code.add(line);
        }
        if (!lines.isEmpty() && ((String)Lists.last((List)lines)).length() > 0) {
            code.add();
        }
    }

    public static AppStream openDebugFile(String path) {
        Object dbgStream;
        path = Paths.resolve((String)path);
        try {
            dbgStream = OutputDebugFilesOption.isEnabled() ? new FileAppStream(path) : NullAppStream.NULL_APP_STREAM;
        }
        catch (InputOutputException e) {
            String msg = Strings.fmt((String)"Failed to create debug file \"%s\".", (Object[])new Object[]{path});
            throw new InputOutputException(msg, (Throwable)e);
        }
        return dbgStream;
    }
}

