/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ExpressionsPackage;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExprNoSpecificExprsCheck
extends CifCheck {
    private static final EReference FCE_FUNC_REF = ExpressionsPackage.eINSTANCE.getFunctionCallExpression_Function();
    private final EnumSet<NoSpecificExpr> disalloweds;
    private boolean ignoreAnnotations;

    public ExprNoSpecificExprsCheck(NoSpecificExpr ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public ExprNoSpecificExprsCheck(EnumSet<NoSpecificExpr> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public ExprNoSpecificExprsCheck ignoreAnnotations() {
        return this.ignoreAnnotations(true);
    }

    public ExprNoSpecificExprsCheck ignoreAnnotations(boolean ignore) {
        this.ignoreAnnotations = ignore;
        return this;
    }

    protected void preprocessAlgVariableExpression(AlgVariableExpression algRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)algRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.ALG_VAR_REFS)) {
            violations.add((PositionObject)algRef, "An algebraic variable reference is used", new Object[0]);
        }
    }

    protected void preprocessFunctionExpression(FunctionExpression userDefFuncRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)userDefFuncRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS)) {
            violations.add((PositionObject)userDefFuncRef, "A function reference is used", new Object[0]);
        } else if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF)) {
            violations.add((PositionObject)userDefFuncRef, "A user-defined function reference is used", new Object[0]);
        } else {
            boolean asData = !this.isUsedInFunctionCallContext(userDefFuncRef);
            boolean isInternal = userDefFuncRef.getFunction() instanceof InternalFunction;
            boolean isExternal = userDefFuncRef.getFunction() instanceof ExternalFunction;
            if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF_AS_DATA) && asData) {
                violations.add((PositionObject)userDefFuncRef, "A user-defined function reference is used as a data value", new Object[0]);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF_INT) && isInternal) {
                violations.add((PositionObject)userDefFuncRef, "An internal user-defined function reference is used", new Object[0]);
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF_INT_AS_DATA) && isInternal && asData) {
                violations.add((PositionObject)userDefFuncRef, "An internal user-defined function reference is used as a data value", new Object[0]);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF_EXT) && isExternal) {
                violations.add((PositionObject)userDefFuncRef, "An external user-defined function reference is used", new Object[0]);
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF_EXT_AS_DATA) && isExternal && asData) {
                violations.add((PositionObject)userDefFuncRef, "An external user-defined function reference is used as a data value", new Object[0]);
            }
        }
    }

    private boolean isUsedInFunctionCallContext(FunctionExpression funcExpr) {
        return funcExpr.eContainer() instanceof FunctionCallExpression && funcExpr.eContainmentFeature() == FCE_FUNC_REF;
    }

    protected void preprocessStdLibFunctionExpression(StdLibFunctionExpression stdLibRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)stdLibRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS)) {
            violations.add((PositionObject)stdLibRef, "A function reference is used", new Object[0]);
        } else if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_STD_LIB)) {
            violations.add((PositionObject)stdLibRef, "A standard library function reference is used", new Object[0]);
        }
    }

    protected void preprocessBinaryExpression(BinaryExpression binExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)binExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.BINARY_EXPRS)) {
            violations.add((PositionObject)binExpr, "A binary expression is used", new Object[0]);
        }
    }

    protected void preprocessBoolExpression(BoolExpression boolLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)boolLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.BOOL_LITS)) {
            violations.add((PositionObject)boolLit, "A boolean literal is used", new Object[0]);
        }
    }

    protected void preprocessCastExpression(CastExpression castExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)castExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS)) {
            violations.add((PositionObject)castExpr, "A cast expression is used", new Object[0]);
            return;
        }
        CifType childType = castExpr.getChild().getType();
        CifType resultType = castExpr.getType();
        if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_NON_EQUAL_TYPE)) {
            if (!CifTypeUtils.checkTypeCompat((CifType)childType, (CifType)resultType, (RangeCompat)RangeCompat.EQUAL)) {
                violations.add((PositionObject)castExpr, "A type-changing cast expression is used", new Object[0]);
            }
            return;
        }
        childType = CifTypeUtils.normalizeType((CifType)childType);
        if ((resultType = CifTypeUtils.normalizeType((CifType)resultType)) instanceof StringType) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_TO_STRING)) {
                violations.add((PositionObject)castExpr, "A cast expression to string is used", new Object[0]);
                return;
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_INT_TO_STRING)) {
                if (childType instanceof IntType) {
                    violations.add((PositionObject)castExpr, "A cast expression from integer to string is used", new Object[0]);
                    return;
                }
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_REAL_TO_STRING)) {
                if (childType instanceof RealType) {
                    violations.add((PositionObject)castExpr, "A cast expression from real to string is used", new Object[0]);
                    return;
                }
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_BOOLEAN_TO_STRING)) {
                if (childType instanceof BoolType) {
                    violations.add((PositionObject)castExpr, "A cast expression from boolean to string is used", new Object[0]);
                    return;
                }
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_AUTOMATON_TO_STRING)) {
                if (!(castExpr.getChild() instanceof SelfExpression) && CifTypeUtils.isAutRefExpr((Expression)castExpr.getChild())) {
                    violations.add((PositionObject)castExpr, "A cast expression from explicit automaton reference to string is used", new Object[0]);
                    return;
                }
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_SELF_TO_STRING) && castExpr.getChild() instanceof SelfExpression) {
                violations.add((PositionObject)castExpr, "A cast expression from automaton self reference to string is used", new Object[0]);
                return;
            }
        }
        if (childType instanceof StringType) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_FROM_STRING)) {
                violations.add((PositionObject)castExpr, "A cast expression from string is used", new Object[0]);
                return;
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_STRING_TO_INT)) {
                if (resultType instanceof IntType) {
                    violations.add((PositionObject)castExpr, "A cast expression from string to integer is used", new Object[0]);
                    return;
                }
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_STRING_TO_REAL)) {
                if (resultType instanceof RealType) {
                    violations.add((PositionObject)castExpr, "A cast expression from string to real is used", new Object[0]);
                    return;
                }
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_STRING_TO_BOOLEAN) && resultType instanceof BoolType) {
                violations.add((PositionObject)castExpr, "A cast expression from string to boolean is used", new Object[0]);
                return;
            }
        }
        if (childType instanceof IntType && this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_INT_TO_REAL) && resultType instanceof RealType) {
            violations.add((PositionObject)castExpr, "A cast expression from integer to real is used", new Object[0]);
            return;
        }
    }

    protected void preprocessComponentExpression(ComponentExpression compRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)compRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS)) {
            violations.add((PositionObject)compRef, "A component reference is used", new Object[0]);
        } else if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS_EXPLICIT)) {
            violations.add((PositionObject)compRef, "An explicit component reference is used", new Object[0]);
        }
    }

    protected void preprocessCompParamExpression(CompParamExpression compParamRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)compParamRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_PARAM_REFS)) {
            violations.add((PositionObject)compParamRef, "A component parameter reference is used", new Object[0]);
        }
    }

    protected void preprocessConstantExpression(ConstantExpression constRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)constRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.CONST_REFS)) {
            violations.add((PositionObject)constRef, "A constant reference is used", new Object[0]);
        }
    }

    protected void preprocessContVariableExpression(ContVariableExpression contRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)contRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.CONT_VAR_REFS)) {
            violations.add((PositionObject)contRef, "A continuous variable reference is used", new Object[0]);
        }
    }

    protected void preprocessDictExpression(DictExpression dictLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)dictLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.DICT_LITS)) {
            violations.add((PositionObject)dictLit, "A dictionary literal is used", new Object[0]);
        }
    }

    protected void preprocessDiscVariableExpression(DiscVariableExpression discRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)discRef)) {
            return;
        }
        EObject parent = discRef.getVariable().eContainer();
        if (parent instanceof ComplexComponent) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.DISC_VAR_REFS)) {
                violations.add((PositionObject)discRef, "A discrete variable reference is used", new Object[0]);
            }
        } else if (parent instanceof FunctionParameter) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.USER_DEF_FUNC_PARAM_REFS)) {
                violations.add((PositionObject)discRef, "A user-defined function parameter reference is used", new Object[0]);
            }
        } else if (parent instanceof InternalFunction) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.INT_USER_DEF_FUNC_LOCAL_VAR_REFS)) {
                violations.add((PositionObject)discRef, "An internal user-defined function local variable reference is used", new Object[0]);
            }
        } else {
            throw new RuntimeException("Unexpected disc var parent: " + String.valueOf(parent));
        }
    }

    protected void preprocessEnumLiteralExpression(EnumLiteralExpression enumLitRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)enumLitRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.ENUM_LIT_REFS)) {
            violations.add((PositionObject)enumLitRef, "An enumeration literal reference is used", new Object[0]);
        }
    }

    protected void preprocessFieldExpression(FieldExpression fieldRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)fieldRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.TUPLE_FIELD_REFS)) {
            violations.add((PositionObject)fieldRef, "A tuple field reference is used", new Object[0]);
        }
    }

    protected void preprocessFunctionCallExpression(FunctionCallExpression funcCall, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)funcCall)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_CALLS)) {
            violations.add((PositionObject)funcCall, "A function call is used", new Object[0]);
        }
    }

    protected void preprocessIfExpression(IfExpression ifExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)ifExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.IF_EXPRS)) {
            violations.add((PositionObject)ifExpr, "An 'if' expression is used", new Object[0]);
        }
    }

    protected void preprocessInputVariableExpression(InputVariableExpression inputRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)inputRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.INPUT_VAR_REFS)) {
            violations.add((PositionObject)inputRef, "An input variable reference is used", new Object[0]);
        }
    }

    protected void preprocessIntExpression(IntExpression intLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)intLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.INT_LITS)) {
            violations.add((PositionObject)intLit, "An integer number literal is used", new Object[0]);
        }
    }

    protected void preprocessListExpression(ListExpression listLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)listLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.LIST_LITS)) {
            violations.add((PositionObject)listLit, "A list literal is used", new Object[0]);
        }
    }

    protected void preprocessLocationExpression(LocationExpression locRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)locRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.LOC_REFS)) {
            violations.add((PositionObject)locRef, "A location reference is used", new Object[0]);
        }
    }

    protected void preprocessProjectionExpression(ProjectionExpression projExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)projExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS)) {
            violations.add((PositionObject)projExpr, "A projection expression is used", new Object[0]);
        } else {
            CifType ctype;
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_LISTS)) {
                ctype = CifTypeUtils.normalizeType((CifType)projExpr.getChild().getType());
                if (ctype instanceof ListType) {
                    violations.add((PositionObject)projExpr, "A list projection expression is used", new Object[0]);
                }
            } else if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_LISTS_NON_ARRAY) && (ctype = CifTypeUtils.normalizeType((CifType)projExpr.getChild().getType())) instanceof ListType && !CifTypeUtils.isArrayType((ListType)((ListType)ctype))) {
                violations.add((PositionObject)projExpr, "A non-array list projection expression is used", new Object[0]);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_DICTS) && (ctype = CifTypeUtils.normalizeType((CifType)projExpr.getChild().getType())) instanceof DictType) {
                violations.add((PositionObject)projExpr, "A dictionary projection expression is used", new Object[0]);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_STRINGS) && (ctype = CifTypeUtils.normalizeType((CifType)projExpr.getChild().getType())) instanceof StringType) {
                violations.add((PositionObject)projExpr, "A string projection expression is used", new Object[0]);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_TUPLES)) {
                ctype = CifTypeUtils.normalizeType((CifType)projExpr.getChild().getType());
                if (ctype instanceof TupleType) {
                    violations.add((PositionObject)projExpr, "A tuple projection expression is used", new Object[0]);
                }
            } else {
                if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_TUPLES_INDEX)) {
                    ctype = CifTypeUtils.normalizeType((CifType)projExpr.getChild().getType());
                    CifType itype = CifTypeUtils.normalizeType((CifType)projExpr.getIndex().getType());
                    if (ctype instanceof TupleType && itype instanceof IntType) {
                        violations.add((PositionObject)projExpr, "A tuple index-projection expression is used", new Object[0]);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_TUPLES_FIELD) && (ctype = CifTypeUtils.normalizeType((CifType)projExpr.getChild().getType())) instanceof TupleType && projExpr.getIndex() instanceof FieldExpression) {
                    violations.add((PositionObject)projExpr, "A tuple field-projection expression is used", new Object[0]);
                }
            }
        }
    }

    protected void preprocessRealExpression(RealExpression realLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)realLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.REAL_LITS)) {
            violations.add((PositionObject)realLit, "A real number literal is used", new Object[0]);
        }
    }

    protected void preprocessReceivedExpression(ReceivedExpression receivedExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)receivedExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.RECEIVE_EXPRS)) {
            violations.add((PositionObject)receivedExpr, "A received value expression is used", new Object[0]);
        }
    }

    protected void preprocessSelfExpression(SelfExpression selfRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)selfRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS)) {
            violations.add((PositionObject)selfRef, "A component reference is used", new Object[0]);
        } else if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS_SELF)) {
            violations.add((PositionObject)selfRef, "A component 'self' reference is used", new Object[0]);
        }
    }

    protected void preprocessSetExpression(SetExpression setLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)setLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.SET_LITS)) {
            violations.add((PositionObject)setLit, "A set literal is used", new Object[0]);
        }
    }

    protected void preprocessSliceExpression(SliceExpression sliceExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)sliceExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.SLICE_EXPRS)) {
            violations.add((PositionObject)sliceExpr, "A slice expression is used", new Object[0]);
        }
    }

    protected void preprocessStringExpression(StringExpression stringLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)stringLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.STRING_LITS)) {
            violations.add((PositionObject)stringLit, "A string literal is used", new Object[0]);
        }
    }

    protected void preprocessSwitchExpression(SwitchExpression switchExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)switchExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS)) {
            violations.add((PositionObject)switchExpr, "A switch expression is used", new Object[0]);
        } else {
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_BOOL) && CifTypeUtils.isAutRefExpr((Expression)switchExpr.getValue())) {
                violations.add((PositionObject)switchExpr, "A switch expression is used on an automaton", new Object[0]);
            }
            CifType valueType = CifTypeUtils.normalizeType((CifType)switchExpr.getValue().getType());
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_BOOL)) {
                if (CifTypeUtils.hasType((CifType)valueType, BoolType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "a boolean typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_DICT)) {
                if (CifTypeUtils.hasType((CifType)valueType, DictType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "a dictionary typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_ENUM)) {
                if (CifTypeUtils.hasType((CifType)valueType, EnumType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "an enumeration typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_INT)) {
                if (CifTypeUtils.hasType((CifType)valueType, IntType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "an integer typed", violations);
                }
            } else {
                if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_INT_RANGED) && CifTypeUtils.hasType((CifType)valueType, t -> {
                    void itype;
                    CifType cifType = t;
                    if (!(cifType instanceof IntType)) return false;
                    IntType intType = (IntType)cifType;
                    IntType cfr_ignored_0 = (IntType)cifType;
                    if (CifTypeUtils.isRangeless((IntType)itype)) return false;
                    return true;
                })) {
                    this.addSwitchValueViolation(switchExpr, "a ranged integer typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_INT_RANGELESS) && CifTypeUtils.hasType((CifType)valueType, t -> {
                    void itype;
                    CifType cifType = t;
                    if (!(cifType instanceof IntType)) return false;
                    IntType intType = (IntType)cifType;
                    IntType cfr_ignored_0 = (IntType)cifType;
                    if (!CifTypeUtils.isRangeless((IntType)itype)) return false;
                    return true;
                })) {
                    this.addSwitchValueViolation(switchExpr, "a rangeless integer typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_LIST)) {
                if (CifTypeUtils.hasType((CifType)valueType, ListType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "a list typed", violations);
                }
            } else {
                if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_LIST_ARRAY) && CifTypeUtils.hasType((CifType)valueType, t -> {
                    void ltype;
                    CifType cifType = t;
                    if (!(cifType instanceof ListType)) return false;
                    ListType listType = (ListType)cifType;
                    ListType cfr_ignored_0 = (ListType)cifType;
                    if (!CifTypeUtils.isArrayType((ListType)ltype)) return false;
                    return true;
                })) {
                    this.addSwitchValueViolation(switchExpr, "an array list typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_LIST_NON_ARRAY) && CifTypeUtils.hasType((CifType)valueType, t -> {
                    void ltype;
                    CifType cifType = t;
                    if (!(cifType instanceof ListType)) return false;
                    ListType listType = (ListType)cifType;
                    ListType cfr_ignored_0 = (ListType)cifType;
                    if (CifTypeUtils.isArrayType((ListType)ltype)) return false;
                    return true;
                })) {
                    this.addSwitchValueViolation(switchExpr, "a non-array list typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_REAL)) {
                if (CifTypeUtils.hasType((CifType)valueType, RealType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "a real typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_SET)) {
                if (CifTypeUtils.hasType((CifType)valueType, SetType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "a set typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_STRING)) {
                if (CifTypeUtils.hasType((CifType)valueType, StringType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "a string typed", violations);
                }
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS_TUPLE)) {
                if (CifTypeUtils.hasType((CifType)valueType, TupleType.class::isInstance)) {
                    this.addSwitchValueViolation(switchExpr, "a tuple typed", violations);
                }
            }
        }
    }

    private void addSwitchValueViolation(SwitchExpression expr, String typeDescription, CifCheckViolations violations) {
        violations.add((PositionObject)expr, Strings.fmt((String)"A switch expression is used with %s (part of its) value", (Object[])new Object[]{typeDescription}), new Object[0]);
    }

    protected void preprocessTimeExpression(TimeExpression timeRef, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)timeRef)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.TIME_VAR_REFS)) {
            violations.add((PositionObject)timeRef, "A 'time' variable reference is used", new Object[0]);
        }
    }

    protected void preprocessTupleExpression(TupleExpression tupleLit, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)tupleLit)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.TUPLE_LITS)) {
            violations.add((PositionObject)tupleLit, "A tuple literal is used", new Object[0]);
        }
    }

    protected void preprocessUnaryExpression(UnaryExpression unExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)unExpr)) {
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificExpr.UNARY_EXPRS)) {
            violations.add((PositionObject)unExpr, "A unary expression is used", new Object[0]);
        }
    }

    public static enum NoSpecificExpr {
        ALG_VAR_REFS,
        FUNC_REFS,
        FUNC_REFS_USER_DEF,
        FUNC_REFS_USER_DEF_AS_DATA,
        FUNC_REFS_USER_DEF_INT,
        FUNC_REFS_USER_DEF_INT_AS_DATA,
        FUNC_REFS_USER_DEF_EXT,
        FUNC_REFS_USER_DEF_EXT_AS_DATA,
        FUNC_REFS_STD_LIB,
        BINARY_EXPRS,
        BOOL_LITS,
        CAST_EXPRS,
        CAST_EXPRS_NON_EQUAL_TYPE,
        CAST_EXPRS_TO_STRING,
        CAST_EXPRS_INT_TO_STRING,
        CAST_EXPRS_REAL_TO_STRING,
        CAST_EXPRS_BOOLEAN_TO_STRING,
        CAST_EXPRS_AUTOMATON_TO_STRING,
        CAST_EXPRS_SELF_TO_STRING,
        CAST_EXPRS_FROM_STRING,
        CAST_EXPRS_STRING_TO_INT,
        CAST_EXPRS_STRING_TO_REAL,
        CAST_EXPRS_STRING_TO_BOOLEAN,
        CAST_EXPRS_INT_TO_REAL,
        COMP_REFS,
        COMP_REFS_EXPLICIT,
        COMP_REFS_SELF,
        COMP_PARAM_REFS,
        CONST_REFS,
        CONT_VAR_REFS,
        DICT_LITS,
        DISC_VAR_REFS,
        USER_DEF_FUNC_PARAM_REFS,
        INT_USER_DEF_FUNC_LOCAL_VAR_REFS,
        ENUM_LIT_REFS,
        TUPLE_FIELD_REFS,
        FUNC_CALLS,
        IF_EXPRS,
        INPUT_VAR_REFS,
        INT_LITS,
        LIST_LITS,
        LOC_REFS,
        PROJECTION_EXPRS,
        PROJECTION_EXPRS_LISTS,
        PROJECTION_EXPRS_LISTS_NON_ARRAY,
        PROJECTION_EXPRS_DICTS,
        PROJECTION_EXPRS_STRINGS,
        PROJECTION_EXPRS_TUPLES,
        PROJECTION_EXPRS_TUPLES_INDEX,
        PROJECTION_EXPRS_TUPLES_FIELD,
        REAL_LITS,
        RECEIVE_EXPRS,
        SET_LITS,
        SLICE_EXPRS,
        STRING_LITS,
        SWITCH_EXPRS,
        SWITCH_EXPRS_AUT,
        SWITCH_EXPRS_BOOL,
        SWITCH_EXPRS_DICT,
        SWITCH_EXPRS_ENUM,
        SWITCH_EXPRS_INT,
        SWITCH_EXPRS_INT_RANGED,
        SWITCH_EXPRS_INT_RANGELESS,
        SWITCH_EXPRS_LIST,
        SWITCH_EXPRS_LIST_ARRAY,
        SWITCH_EXPRS_LIST_NON_ARRAY,
        SWITCH_EXPRS_REAL,
        SWITCH_EXPRS_SET,
        SWITCH_EXPRS_STRING,
        SWITCH_EXPRS_TUPLE,
        TIME_VAR_REFS,
        TUPLE_LITS,
        UNARY_EXPRS;

    }
}

