/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers;

import java.util.List;
import java.util.function.BooleanSupplier;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.checkers.CifChecker;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;

public class CifPreconditionChecker
extends CifChecker {
    public CifPreconditionChecker(BooleanSupplier shouldTerminate, List<CifCheck> preconditions) {
        super(shouldTerminate, preconditions);
    }

    public CifPreconditionChecker(BooleanSupplier shouldTerminate, CifCheck ... preconditions) {
        super(shouldTerminate, preconditions);
    }

    public void reportPreconditionViolations(Specification spec, String absSpecPath, String toolName) {
        CifCheckViolations violations = this.check(spec, absSpecPath);
        if (violations.hasViolations()) {
            String incompleteTxt = "";
            if (violations.isIncomplete()) {
                incompleteTxt = " (checking was prematurely terminated, so the report below may be incomplete)";
            }
            List lines = Lists.list();
            lines.add(toolName + Strings.fmt((String)" failed due to unsatisfied preconditions%s:", (Object[])new Object[]{incompleteTxt}));
            lines.addAll(violations.createReport());
            throw new UnsupportedException(String.join((CharSequence)"\n", lines));
        }
    }
}

