/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates.tree;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.updates.tree.LhsListProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsTupleProjection;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class SingleVariableAssignment {
    public final Declaration variable;
    public final CifType variableType;
    private final CifType addressableType;
    public final LhsProjection[] lhsProjections;
    public final int[] rhsProjections;
    public final CifType valueType;

    public SingleVariableAssignment(Expression addressable, CifType valueType, int[] rhsProjections) {
        this.lhsProjections = SingleVariableAssignment.getLhsProjections(addressable);
        this.variable = SingleVariableAssignment.getFullVariable(addressable);
        this.variableType = SingleVariableAssignment.getFullVariableType(addressable);
        this.rhsProjections = rhsProjections;
        this.addressableType = addressable.getType();
        this.valueType = valueType;
    }

    protected ExprCode doAssignment(Destination lhs, ExprCode rhsValue, TupleTypeInfo rhsTi, CodeContext readCtxt) {
        Assert.check((boolean)rhsValue.hasDataValue());
        if (this.rhsProjections != null) {
            int lastProj = this.rhsProjections.length - 1;
            int projIndex = 0;
            while (projIndex < this.rhsProjections.length) {
                rhsValue = rhsTi.getProjectedValue(rhsValue, this.rhsProjections[projIndex], null, readCtxt);
                if (projIndex >= lastProj) {
                    rhsTi = null;
                    break;
                }
                rhsTi = (TupleTypeInfo)rhsTi.childInfos[this.rhsProjections[projIndex]];
                ++projIndex;
            }
        }
        ExprCode result = new ExprCode();
        result.add(rhsValue);
        result.setDestination(lhs);
        result.setDataValue(rhsValue.getRawDataValue());
        return result;
    }

    public CifType getAssignedType() {
        return this.addressableType;
    }

    public boolean needsRangeBoundCheck() {
        return !CifTypeUtils.checkTypeCompat((CifType)this.getAssignedType(), (CifType)this.valueType, (RangeCompat)RangeCompat.CONTAINED);
    }

    private static LhsProjection[] getLhsProjections(Expression lhs) {
        if (lhs instanceof ProjectionExpression) {
            List reverseProjs = Lists.list();
            while (lhs instanceof ProjectionExpression) {
                ProjectionExpression projExpr = (ProjectionExpression)lhs;
                Expression indexExpr = projExpr.getIndex();
                lhs = projExpr.getChild();
                CifType containerType = CifTypeUtils.normalizeType((CifType)lhs.getType());
                if (containerType instanceof TupleType) {
                    reverseProjs.add(new LhsTupleProjection((TupleType)containerType, indexExpr));
                    continue;
                }
                Assert.check((boolean)(containerType instanceof ListType));
                reverseProjs.add(new LhsListProjection((ListType)containerType, indexExpr));
            }
            LhsProjection[] projections = new LhsProjection[reverseProjs.size()];
            int last = reverseProjs.size() - 1;
            int i = 0;
            while (i < reverseProjs.size()) {
                projections[i] = (LhsProjection)reverseProjs.get(last - i);
                ++i;
            }
            return projections;
        }
        return null;
    }

    private static Declaration getFullVariable(Expression lhs) {
        ContVariableExpression varExpr;
        while (lhs instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)lhs;
            lhs = projExpr.getChild();
        }
        if (lhs instanceof ContVariableExpression) {
            varExpr = (ContVariableExpression)lhs;
            return varExpr.getVariable();
        }
        if (lhs instanceof DiscVariableExpression) {
            varExpr = (DiscVariableExpression)lhs;
            return varExpr.getVariable();
        }
        throw new RuntimeException("Unexpected type of lhs variable encountered: " + Strings.str((Object)lhs));
    }

    private static CifType getFullVariableType(Expression lhs) {
        while (lhs instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)lhs;
            lhs = projExpr.getChild();
        }
        return CifTypeUtils.normalizeType((CifType)lhs.getType());
    }

    public String toString() {
        Object w;
        int n;
        Object u;
        String s = "SingleVarAsg var    : " + this.variable.getName() + "\n";
        String t = "addressable-type    : " + CifTextUtils.typeToStr((CifType)this.addressableType) + "\n";
        if (this.lhsProjections == null) {
            u = "No lhs projections\n";
        } else {
            u = Strings.fmt((String)"lhs-projections (#%d): ", (Object[])new Object[]{this.lhsProjections.length});
            boolean first = true;
            LhsProjection[] lhsProjectionArray = this.lhsProjections;
            n = this.lhsProjections.length;
            int n2 = 0;
            while (n2 < n) {
                LhsProjection lp = lhsProjectionArray[n2];
                if (!first) {
                    u = (String)u + " -> ";
                }
                first = false;
                u = (String)u + lp.toString();
                ++n2;
            }
            u = (String)u + "\n";
        }
        String v = "rhs-type            : " + CifTextUtils.typeToStr((CifType)this.valueType) + "\n";
        if (this.rhsProjections == null) {
            w = "No rhs projections";
        } else {
            w = Strings.fmt((String)"rhs-projections (#%d):   ", (Object[])new Object[]{this.rhsProjections.length});
            int[] nArray = this.rhsProjections;
            int n3 = this.rhsProjections.length;
            n = 0;
            while (n < n3) {
                int rp = nArray[n];
                w = (String)w + Strings.fmt((String)"[%d]", (Object[])new Object[]{rp});
                ++n;
            }
        }
        return s + t + (String)u + v + (String)w;
    }
}

