/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.javascript;

import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.SvgCodeGen;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptCodeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.svg.SvgUtils;
import org.w3c.dom.Document;

public class JavaScriptSvgCodeGen
extends SvgCodeGen {
    CodeBox codeSvgContent;
    CodeBox codeSvgToggles;
    CodeBox codeCopyApply;
    CodeBox codeMoveApply;
    CodeBox codeInClickHandlers;
    CodeBox codeInEventSetters;
    CodeBox codeInSetup;
    CodeBox codeInCss;
    CodeBox codeOutDeclarations;
    CodeBox codeOutAssignments;
    CodeBox codeOutApply;

    /*
     * WARNING - void declaration
     */
    void genCodeCifSvg(CodeContext ctxt, String cifSpecFileDir, List<IoDecl> svgDecls, List<Event> events) {
        Map eventMap = Maps.mapc((int)events.size());
        int i = 0;
        while (i < events.size()) {
            eventMap.put(events.get(i), i);
            ++i;
        }
        Map svgPathsAbsToNormRel = Maps.map();
        Map svgPathsRelToAbs = Maps.map();
        for (IoDecl decl : svgDecls) {
            SvgFile file = null;
            IoDecl ioDecl = decl;
            if (ioDecl instanceof SvgCopy) {
                void svgCopy;
                SvgCopy cfr_ignored_0 = (SvgCopy)ioDecl;
                SvgCopy cfr_ignored_1 = (SvgCopy)ioDecl;
                file = svgCopy.getSvgFile();
            } else {
                IoDecl ioDecl2 = decl;
                if (ioDecl2 instanceof SvgMove) {
                    SvgMove svgMove;
                    SvgMove cfr_ignored_2 = (SvgMove)ioDecl2;
                    SvgMove cfr_ignored_3 = (SvgMove)ioDecl2;
                    file = svgMove.getSvgFile();
                } else {
                    IoDecl ioDecl3 = decl;
                    if (ioDecl3 instanceof SvgIn) {
                        void svgIn;
                        SvgIn cfr_ignored_4 = (SvgIn)ioDecl3;
                        SvgIn cfr_ignored_5 = (SvgIn)ioDecl3;
                        file = svgIn.getSvgFile();
                    } else {
                        IoDecl ioDecl4 = decl;
                        if (ioDecl4 instanceof SvgOut) {
                            void svgOut;
                            SvgOut cfr_ignored_6 = (SvgOut)ioDecl4;
                            SvgOut cfr_ignored_7 = (SvgOut)ioDecl4;
                            file = svgOut.getSvgFile();
                        } else {
                            throw new AssertionError((Object)("Unexpected CIF/SVG declaration: " + String.valueOf(decl)));
                        }
                    }
                }
            }
            String svgRelPath = file.getPath();
            String svgAbsPath = Paths.resolve((String)svgRelPath, (String)cifSpecFileDir);
            String svgNormRelPath = Paths.getRelativePath((String)svgAbsPath, (String)cifSpecFileDir);
            svgPathsAbsToNormRel.put(svgAbsPath, svgNormRelPath);
            svgPathsRelToAbs.put(svgRelPath, svgAbsPath);
        }
        Map svgAbsPathsToWrapperElemIds = Maps.map();
        Map svgOutElemQueriesToFields = Maps.map();
        AtomicInteger nextSvgInId = new AtomicInteger();
        int svgImageNumber = 0;
        int declsProcessed = 0;
        for (Map.Entry entry : svgPathsAbsToNormRel.entrySet()) {
            String svgWrapElemId;
            String svgAbsPath = (String)entry.getKey();
            String svgNormRelPath = (String)entry.getValue();
            ++svgImageNumber;
            Document document = SvgUtils.loadSvgFile((String)svgAbsPath);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            StringWriter svgContentWriter = new StringWriter();
            try {
                Transformer transformer = transFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(svgContentWriter));
            }
            catch (TransformerException e) {
                throw new RuntimeException("Failed to transform SVG document to text: " + svgNormRelPath, e);
            }
            String svgContent = svgContentWriter.toString();
            String svgWrapperElementId = Strings.fmt((String)"cif-svg-wrapper-%d", (Object[])new Object[]{svgImageNumber});
            svgAbsPathsToWrapperElemIds.put(svgAbsPath, svgWrapperElementId);
            this.codeSvgContent.add("<div id=\"%s\" class=\"svg-visible\">%s</div>", new Object[]{svgWrapperElementId, svgContent});
            if (svgPathsAbsToNormRel.size() > 1) {
                this.codeSvgToggles.add("<input type=\"checkbox\" onclick=\"toggleSVG('%s');\" checked>Image %d</input>", new Object[]{svgWrapperElementId, svgImageNumber});
            }
            SvgCodeGen.CifSvgDecls imgSvgDecls = JavaScriptSvgCodeGen.filterAndGroup(svgDecls, svgAbsPath, svgPathsRelToAbs);
            declsProcessed += imgSvgDecls.size();
            if (imgSvgDecls.svgOuts.isEmpty() && imgSvgDecls.svgIns.isEmpty()) {
                OutputProvider.warn((String)"SVG file \"%s\" has no CIF/SVG input/output mappings that apply to it.", (Object[])new Object[]{svgNormRelPath});
            }
            for (SvgCopy svgCopy : imgSvgDecls.svgCopies) {
                svgWrapElemId = (String)svgAbsPathsToWrapperElemIds.get(svgPathsRelToAbs.get(svgCopy.getSvgFile().getPath()));
                this.gencodeSvgCopy(svgCopy, svgWrapElemId, ctxt);
            }
            for (SvgMove svgMove : imgSvgDecls.svgMoves) {
                svgWrapElemId = (String)svgAbsPathsToWrapperElemIds.get(svgPathsRelToAbs.get(svgMove.getSvgFile().getPath()));
                this.gencodeSvgMove(svgMove, svgWrapElemId, ctxt);
            }
            for (SvgIn svgIn : imgSvgDecls.svgIns) {
                svgWrapElemId = (String)svgAbsPathsToWrapperElemIds.get(svgPathsRelToAbs.get(svgIn.getSvgFile().getPath()));
                this.gencodeSvgIn(svgIn, svgWrapElemId, nextSvgInId, eventMap, ctxt);
            }
            for (SvgOut svgOut : imgSvgDecls.svgOuts) {
                svgWrapElemId = (String)svgAbsPathsToWrapperElemIds.get(svgPathsRelToAbs.get(svgOut.getSvgFile().getPath()));
                this.gencodeSvgOut(svgOut, svgWrapElemId, svgOutElemQueriesToFields, ctxt);
            }
        }
        Assert.areEqual((Object)declsProcessed, (Object)svgDecls.size());
    }

    private void gencodeSvgCopy(SvgCopy svgCopy, String svgWrapElemId, CodeContext ctxt) {
        String copyId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgCopy.getId());
        String pre = svgCopy.getPre() == null ? "" : JavaScriptSvgCodeGen.evalSvgStringExpr(svgCopy.getPre());
        String post = svgCopy.getPost() == null ? "" : JavaScriptSvgCodeGen.evalSvgStringExpr(svgCopy.getPost());
        this.codeCopyApply.add("applySvgCopy(%s, %s, %s, %s);", new Object[]{Strings.stringToJava((String)svgWrapElemId), Strings.stringToJava((String)copyId), Strings.stringToJava((String)pre), Strings.stringToJava((String)post)});
    }

    private void gencodeSvgMove(SvgMove svgMove, String svgWrapElemId, CodeContext ctxt) {
        String moveId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgMove.getId());
        double x = JavaScriptSvgCodeGen.evalSvgNumberExpr(svgMove.getX());
        double y = JavaScriptSvgCodeGen.evalSvgNumberExpr(svgMove.getY());
        this.codeMoveApply.add("applySvgMove(%s, %s, %s, %s);", new Object[]{Strings.stringToJava((String)svgWrapElemId), Strings.stringToJava((String)moveId), x, y});
    }

    private void gencodeSvgOut(SvgOut svgOut, String svgWrapElemId, Map<String, String> svgOutElemQueriesToFields, CodeContext ctxt) {
        block14: {
            String fieldName;
            block12: {
                String outId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgOut.getId());
                String querySelector = Strings.fmt((String)"#%s #%s", (Object[])new Object[]{JavaScriptCodeUtils.escapeCssIdentifier(svgWrapElemId), JavaScriptCodeUtils.escapeCssIdentifier(outId)});
                fieldName = svgOutElemQueriesToFields.get(querySelector);
                if (fieldName == null) {
                    fieldName = Strings.fmt((String)"outElem%d", (Object[])new Object[]{svgOutElemQueriesToFields.size()});
                    this.codeOutDeclarations.add(Strings.fmt((String)"%s;", (Object[])new Object[]{fieldName}));
                    this.codeOutAssignments.add("%s.%s = document.querySelector(%s);", new Object[]{ctxt.getPrefix(), fieldName, Strings.stringToJava((String)querySelector)});
                    svgOutElemQueriesToFields.put(querySelector, fieldName);
                }
                ExprCode exprCode = ctxt.exprToTarget(svgOut.getValue(), null);
                this.codeOutApply.add("var value = %s;", new Object[]{exprCode.getData()});
                if (svgOut.getAttr() == null) break block12;
                switch (svgOut.getAttr()) {
                    case "opacity": 
                    case "fill": 
                    case "visibility": {
                        this.codeOutApply.add("%s.%s.style.%s = value;", new Object[]{ctxt.getPrefix(), fieldName, svgOut.getAttr()});
                        break;
                    }
                    default: {
                        this.codeOutApply.add("%s.%s.setAttribute(%s, value);", new Object[]{ctxt.getPrefix(), fieldName, Strings.stringToJava((String)svgOut.getAttr())});
                        break;
                    }
                }
                break block14;
            }
            this.codeOutApply.add("if (%s.%s.hasChildNodes()) {", new Object[]{ctxt.getPrefix(), fieldName});
            this.codeOutApply.indent();
            this.codeOutApply.add("%s.%s.childNodes[0].textContent = value;", new Object[]{ctxt.getPrefix(), fieldName});
            this.codeOutApply.dedent();
            this.codeOutApply.add("} else {");
            this.codeOutApply.indent();
            this.codeOutApply.add("%s.%s.textContent = value;", new Object[]{ctxt.getPrefix(), fieldName});
            this.codeOutApply.dedent();
            this.codeOutApply.add("}");
        }
    }

    private void gencodeSvgIn(SvgIn svgIn, String svgWrapElemId, AtomicInteger nextSvgInId, Map<Event, Integer> eventMap, CodeContext ctxt) {
        int uniqueId = nextSvgInId.getAndIncrement();
        String inId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgIn.getId());
        String querySelector = Strings.fmt((String)"#%s #%s", (Object[])new Object[]{JavaScriptCodeUtils.escapeCssIdentifier(svgWrapElemId), JavaScriptCodeUtils.escapeCssIdentifier(inId)});
        String clickEventHandlerName = Strings.fmt((String)"cif_svgin_%d_Click", (Object[])new Object[]{uniqueId});
        String eventSetterName = Strings.fmt((String)"cif_svgin_%d_EventSetter", (Object[])new Object[]{uniqueId});
        this.codeInSetup.add("var elem = document.querySelector(%s);", new Object[]{Strings.stringToJava((String)querySelector)});
        this.codeInSetup.add("elem.addEventListener(\"click\", %s.%s);", new Object[]{ctxt.getPrefix(), clickEventHandlerName});
        this.codeInSetup.add("elem.style.cursor = \"pointer\";");
        this.codeInCss.add("%s:hover { stroke-width: 1 !important; stroke: rgb(255, 0, 0) !important; }", new Object[]{querySelector});
        this.codeInCss.add("%s:hover > * { stroke-width: 1 !important; stroke: rgb(255, 0, 0) !important; }", new Object[]{querySelector});
        this.codeInClickHandlers.add();
        this.codeInClickHandlers.add("%s() { // %s", new Object[]{clickEventHandlerName, inId});
        this.codeInClickHandlers.indent();
        this.codeInClickHandlers.add("if (%s.playing) {", new Object[]{ctxt.getPrefix()});
        this.codeInClickHandlers.indent();
        this.codeInClickHandlers.add("%s.svgInQueue.push(%s.%s);", new Object[]{ctxt.getPrefix(), ctxt.getPrefix(), eventSetterName});
        this.codeInClickHandlers.dedent();
        this.codeInClickHandlers.add("}");
        this.codeInClickHandlers.dedent();
        this.codeInClickHandlers.add("}");
        this.codeInEventSetters.add();
        this.codeInEventSetters.add("%s() { // %s", new Object[]{eventSetterName, inId});
        this.codeInEventSetters.indent();
        this.codeInEventSetters.add("%s.svgInId = '%s';", new Object[]{ctxt.getPrefix(), inId});
        SvgInEvent event = svgIn.getEvent();
        if (event != null) {
            if (event instanceof SvgInEventSingle) {
                SvgInEventSingle singleEvt = (SvgInEventSingle)event;
                Event evt = ((EventExpression)singleEvt.getEvent()).getEvent();
                int eventIdx = eventMap.get(evt);
                String absEventName = CifTextUtils.getAbsName((PositionObject)evt);
                this.codeInEventSetters.add("%s.svgInEvent = %d; // %s", new Object[]{ctxt.getPrefix(), eventIdx, absEventName});
            } else if (event instanceof SvgInEventIf) {
                SvgInEventIf ifEvent = (SvgInEventIf)event;
                for (SvgInEventIfEntry entry : ifEvent.getEntries()) {
                    Event evt = ((EventExpression)entry.getEvent()).getEvent();
                    int eventIdx = eventMap.get(evt);
                    String absEventName = CifTextUtils.getAbsName((PositionObject)evt);
                    if (entry.getGuard() == null) {
                        this.codeInEventSetters.add("else {");
                        this.codeInEventSetters.indent();
                        this.codeInEventSetters.add("%s.svgInEvent = %d; // %s", new Object[]{ctxt.getPrefix(), eventIdx, absEventName});
                        this.codeInEventSetters.dedent();
                        this.codeInEventSetters.add("}");
                        continue;
                    }
                    this.codeInEventSetters.add("%s (%s) {", new Object[]{entry == ifEvent.getEntries().get(0) ? "if" : "else if", ctxt.exprToTarget(entry.getGuard(), null).getData()});
                    this.codeInEventSetters.indent();
                    this.codeInEventSetters.add("%s.svgInEvent = %d; // %s", new Object[]{ctxt.getPrefix(), eventIdx, absEventName});
                    this.codeInEventSetters.dedent();
                    this.codeInEventSetters.add("}");
                }
            } else {
                throw new RuntimeException("Unknown SVG input mapping event: " + String.valueOf(event));
            }
        }
        this.codeInEventSetters.dedent();
        this.codeInEventSetters.add("}");
        EList updates = svgIn.getUpdates();
        updates.isEmpty();
    }

    static Set<Integer> getInteractiveEventIndices(List<SvgIn> svgIns, List<Event> events) {
        Map eventMap = Maps.mapc((int)events.size());
        int i = 0;
        while (i < events.size()) {
            eventMap.put(events.get(i), i);
            ++i;
        }
        Set interactiveEventIndices = Sets.set();
        for (SvgIn svgIn : svgIns) {
            SvgInEvent event = svgIn.getEvent();
            if (event == null) continue;
            if (event instanceof SvgInEventSingle) {
                SvgInEventSingle singleEvt = (SvgInEventSingle)event;
                Event evt = ((EventExpression)singleEvt.getEvent()).getEvent();
                int eventIdx = (Integer)eventMap.get(evt);
                interactiveEventIndices.add(eventIdx);
                continue;
            }
            if (event instanceof SvgInEventIf) {
                SvgInEventIf ifEvent = (SvgInEventIf)event;
                for (SvgInEventIfEntry entry : ifEvent.getEntries()) {
                    Event evt = ((EventExpression)entry.getEvent()).getEvent();
                    int eventIdx = (Integer)eventMap.get(evt);
                    interactiveEventIndices.add(eventIdx);
                }
                continue;
            }
            throw new RuntimeException("Unknown SVG input mapping event: " + String.valueOf(event));
        }
        return interactiveEventIndices;
    }
}

