/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.javascript;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.FunctionCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.common.FuncLocalVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.typechecker.annotations.builtin.DocAnnotationProvider;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class JavaScriptFunctionCodeGen
extends FunctionCodeGen {
    public JavaScriptFunctionCodeGen(InternalFunction function) {
        super(function);
    }

    public void generate(CodeBox code, CodeContext ctxt) {
        String funcName = ctxt.getFunctionName(this.function);
        EList params = this.function.getParameters();
        List paramTxts = Lists.listc((int)params.size());
        for (FunctionParameter param : params) {
            DiscVariable var = param.getParameter();
            VariableInformation varInfo = ctxt.getReadVarInfo(new VariableWrapper((Declaration)var, false));
            String name = varInfo.targetVariableName;
            paramTxts.add(name);
        }
        String origFuncName = ctxt.getOrigFunctionName(this.function);
        if (origFuncName == null) {
            origFuncName = this.function.getName();
        }
        List docs = DocAnnotationProvider.getDocs((AnnotatedObject)this.function);
        code.add();
        code.add("/**");
        code.add(" * Function \"%s\".", new Object[]{origFuncName});
        for (String doc : docs) {
            code.add(" *");
            code.add(" * <p>");
            String[] stringArray = doc.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                code.add(" * %s", new Object[]{line});
                ++n2;
            }
            code.add(" * </p>");
        }
        code.add(" *");
        int i = 0;
        while (i < params.size()) {
            DiscVariable param = ((FunctionParameter)params.get(i)).getParameter();
            VariableInformation varInfo = ctxt.getReadVarInfo(new VariableWrapper((Declaration)param, false));
            code.add(" * @param %s Function parameter \"%s\".", new Object[]{varInfo.targetVariableName, varInfo.name});
            List paramDocs = DocAnnotationProvider.getDocs((AnnotatedObject)param);
            for (String doc : paramDocs) {
                code.add(" *     <p>");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String line = stringArray[n3];
                    code.add(" *     %s", new Object[]{line});
                    ++n3;
                }
                code.add(" *     </p>");
            }
            ++i;
        }
        code.add(" * @return The return value of the function.");
        code.add(" */");
        code.add("%s(%s) {", new Object[]{funcName, String.join((CharSequence)", ", paramTxts)});
        code.indent();
        this.addFunctionBody(this.function, code, ctxt);
        code.dedent();
        code.add("}");
    }

    private void addFunctionBody(InternalFunction func, CodeBox code, CodeContext ctxt) {
        Object localVars = func.getVariables();
        localVars = new FuncLocalVarOrderer().computeOrder((Collection)localVars);
        Assert.notNull((Object)localVars);
        Iterator iterator = localVars.iterator();
        while (iterator.hasNext()) {
            DiscVariable var = (DiscVariable)iterator.next();
            VariableInformation varInfo = ctxt.getReadVarInfo(new VariableWrapper((Declaration)var, false));
            code.add("// Variable \"%s\".", new Object[]{varInfo.name});
            List docs = DocAnnotationProvider.getDocs((AnnotatedObject)var);
            for (String doc : docs) {
                code.add("//");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    code.add("// %s", new Object[]{line});
                    ++n2;
                }
            }
            Assert.check((var.getValue() != null ? 1 : 0) != 0);
            Assert.check((var.getValue().getValues().size() == 1 ? 1 : 0) != 0);
            Expression value = (Expression)Lists.first((List)var.getValue().getValues());
            ExprCode valueCode = ctxt.exprToTarget(value, null);
            code.add((Box)valueCode.getCode());
            Destination dest = ctxt.makeDestination((Declaration)var);
            TypeInfo varTi = ctxt.typeToTarget(var.getType());
            varTi.declareInit(code, valueCode.getRawDataValue(), dest);
            code.add();
        }
        code.add("// Execute statements in the function body.");
        this.addFuncStatements((List<FunctionStatement>)func.getStatements(), code, ctxt);
        code.add("throw new Error('No return statement at end of function.');");
    }

    @Override
    protected IfElseGenerator getIfElseFuncGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    protected void generateBreakFuncStatement(CodeBox code) {
        code.add("break;");
    }

    @Override
    protected void generateContinueFuncStatement(CodeBox code) {
        code.add("continue;");
    }

    @Override
    protected void generateReturnFuncStatement(Expression retValue, CodeBox code, boolean safeScope, CodeContext ctxt) {
        ExprCode retCode = ctxt.exprToTarget(retValue, null);
        code.add((Box)retCode.getCode());
        code.add("return %s;", new Object[]{retCode.getData()});
    }

    @Override
    protected boolean generateWhileFuncStatement(ExprCode guardCode, CodeBox code, boolean safeScope) {
        if (!guardCode.hasCode()) {
            code.add("while (%s) {", new Object[]{guardCode.getData()});
            code.indent();
            return safeScope;
        }
        code.add("while (true) {");
        code.indent();
        code.add((Box)guardCode.getCode());
        code.add("if (!(%s)) break;", new Object[]{guardCode.getData()});
        return false;
    }

    @Override
    protected void generateEndWhileFuncStatement(CodeBox code) {
        code.dedent();
        code.add("}");
    }
}

