/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.List;
import java.util.function.BooleanSupplier;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifPreconditionChecker;
import org.eclipse.escet.cif.checkers.checks.AutOnlyWithOneInitLocCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoInitPredsCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificBinaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificUnaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificStdLibCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificUserDefCheck;
import org.eclipse.escet.cif.checkers.checks.InvNoSpecificInvsCheck;
import org.eclipse.escet.cif.checkers.checks.LocNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.PrintNoSpecificPrintDeclsCheck;
import org.eclipse.escet.cif.checkers.checks.SpecAutomataCountsCheck;
import org.eclipse.escet.cif.checkers.checks.SvgInNoUpdatesCheck;
import org.eclipse.escet.cif.checkers.checks.TypeNoSpecificTypesCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoDiscWithMultiInitValuesCheck;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.simulink.VarInputOnlySimulinkCompatibleTypesCheck;
import org.eclipse.escet.common.java.Lists;

public class CodeGenPreChecker
extends CifPreconditionChecker {
    public CodeGenPreChecker(TargetLanguage language, BooleanSupplier shouldTerminate) {
        super(shouldTerminate, CodeGenPreChecker.getChecks(language));
    }

    private static List<CifCheck> getChecks(TargetLanguage language) {
        List checks = Lists.list();
        checks.add(new SpecAutomataCountsCheck().setMinMaxAuts(1, Integer.MAX_VALUE));
        checks.add(new CompNoInitPredsCheck(true));
        checks.add(new InvNoSpecificInvsCheck().ignoreNeverBlockingInvariants().disallow(NoInvariantSupKind.ALL_KINDS, NoInvariantKind.STATE, NoInvariantPlaceKind.ALL_PLACES));
        checks.add(new VarNoDiscWithMultiInitValuesCheck());
        checks.add(new FuncNoSpecificUserDefCheck(new FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc[]{FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.EXTERNAL}));
        checks.add(new LocNoUrgentCheck());
        checks.add(new AutOnlyWithOneInitLocCheck());
        checks.add(new EdgeNoUrgentCheck());
        checks.add(new SvgInNoUpdatesCheck());
        checks.add(new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.DICT_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES_AS_DATA, TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES_NON_ARRAY, TypeNoSpecificTypesCheck.NoSpecificType.SET_TYPES}).ignoreAnnotations());
        checks.add(new ExprNoSpecificExprsCheck(new ExprNoSpecificExprsCheck.NoSpecificExpr[]{ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_DICTS, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_LISTS_NON_ARRAY, ExprNoSpecificExprsCheck.NoSpecificExpr.SLICE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_REFS_USER_DEF_AS_DATA, ExprNoSpecificExprsCheck.NoSpecificExpr.SET_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.DICT_LITS}).ignoreAnnotations());
        checks.add(new ExprNoSpecificUnaryExprsCheck(new ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp[]{ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.SAMPLE}).ignoreAnnotations());
        checks.add(new ExprNoSpecificBinaryExprsCheck(new ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp[]{ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.CONJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DISJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ELEMENT_OF, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBSET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_TUPLE, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_TUPLE, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_DICTS}).ignoreAnnotations());
        checks.add(new FuncNoSpecificStdLibCheck(new FuncNoSpecificStdLibCheck.NoSpecificStdLib[]{FuncNoSpecificStdLibCheck.NoSpecificStdLib.DELETE, FuncNoSpecificStdLibCheck.NoSpecificStdLib.POP, FuncNoSpecificStdLibCheck.NoSpecificStdLib.ACOSH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.ASINH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.ATANH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.COSH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.SINH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.TANH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.EMPTY_DICT, FuncNoSpecificStdLibCheck.NoSpecificStdLib.EMPTY_LIST_NON_ARRAY, FuncNoSpecificStdLibCheck.NoSpecificStdLib.EMPTY_SET, FuncNoSpecificStdLibCheck.NoSpecificStdLib.SIZE_DICT, FuncNoSpecificStdLibCheck.NoSpecificStdLib.SIZE_LIST_NON_ARRAY, FuncNoSpecificStdLibCheck.NoSpecificStdLib.SIZE_SET, FuncNoSpecificStdLibCheck.NoSpecificStdLib.ALL_STOCHASTIC}).ignoreAnnotations());
        checks.add(new PrintNoSpecificPrintDeclsCheck(new PrintNoSpecificPrintDeclsCheck.NoSpecificPrintDecl[]{PrintNoSpecificPrintDeclsCheck.NoSpecificPrintDecl.TEXT_POST_FILTER_PRE, PrintNoSpecificPrintDeclsCheck.NoSpecificPrintDecl.TEXT_PRE_FILTER_POST}));
        if (language == TargetLanguage.SIMULINK) {
            checks.add(new VarInputOnlySimulinkCompatibleTypesCheck());
        }
        return checks;
    }
}

