/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public abstract class DirectedGraphCycleFinder<G, V, E extends GraphEdge<V>, C> {
    private List<E> stack;
    private Map<V, Integer> stackIndex;
    private Set<V> visitedVertices;
    private Set<C> foundCycles;
    private final BooleanSupplier isTerminationRequested;

    public DirectedGraphCycleFinder(BooleanSupplier isTerminationRequested) {
        this.isTerminationRequested = isTerminationRequested;
    }

    public Set<C> findSimpleCycles(G graph) {
        List<V> vertices = this.getVertices(graph);
        this.stack = Lists.listc(vertices.size() + 1);
        this.stackIndex = Maps.mapc(vertices.size());
        this.visitedVertices = Sets.setc(vertices.size());
        Set foundCycles = Sets.set();
        this.foundCycles = foundCycles;
        for (V vertex : vertices) {
            if (this.visitedVertices.contains(vertex)) continue;
            this.expandVertexPath(graph, vertex);
            if (this.isTerminationRequested == null || !this.isTerminationRequested.getAsBoolean()) continue;
            return null;
        }
        this.visitedVertices = null;
        this.stackIndex = null;
        this.stack = null;
        this.foundCycles = null;
        return foundCycles;
    }

    private void expandVertexPath(G graph, V vertex) {
        if (this.isTerminationRequested != null && this.isTerminationRequested.getAsBoolean()) {
            return;
        }
        this.visitedVertices.add(vertex);
        int vertexStackPos = this.stack.size();
        this.stackIndex.put((Integer)vertex, vertexStackPos);
        this.stack.add(null);
        for (GraphEdge edge : this.getOutgoingEdges(graph, vertex)) {
            Object edgeTargetVertex = edge.destinationVertex;
            Integer cycleStartIndex = this.stackIndex.get(edgeTargetVertex);
            if (cycleStartIndex == null) {
                this.stack.set(vertexStackPos, edge);
                this.expandVertexPath(graph, edgeTargetVertex);
            } else {
                this.stack.set(vertexStackPos, edge);
                this.addCycle(graph, this.stack.subList(cycleStartIndex, vertexStackPos + 1), this.foundCycles);
            }
            if (this.isTerminationRequested == null || !this.isTerminationRequested.getAsBoolean()) continue;
            return;
        }
        this.stack.remove(vertexStackPos);
        this.stackIndex.remove(vertex);
    }

    protected abstract List<V> getVertices(G var1);

    protected abstract List<E> getOutgoingEdges(G var1, V var2);

    protected abstract void addCycle(G var1, List<E> var2, Set<C> var3);

    public static class GraphEdge<V> {
        public final V startVertex;
        public final V destinationVertex;

        public GraphEdge(V startVertex, V destinationVertex) {
            this.startVertex = startVertex;
            this.destinationVertex = destinationVertex;
        }
    }
}

