/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.io.StringReader;
import java.util.List;
import org.eclipse.escet.common.java.CsvParser;

public class CsvUtils {
    private CsvUtils() {
    }

    public static CsvParser makeParser(String text) {
        return new CsvParser(new StringReader(text));
    }

    public static int getNumRows(List<List<String>> rows) {
        return rows.size();
    }

    public static int getNumColumns(List<List<String>> rows) {
        return rows.isEmpty() ? 0 : rows.get(0).size();
    }

    public static boolean isRectangular(List<List<String>> rows) {
        if (rows.isEmpty()) {
            return true;
        }
        int numColumns = rows.get(0).size();
        int i = 1;
        while (i < rows.size()) {
            if (rows.get(i).size() != numColumns) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCsvFormat(List<List<String>> rows) {
        return CsvUtils.getNumRows(rows) > 0 && CsvUtils.getNumColumns(rows) > 0 && CsvUtils.isRectangular(rows);
    }

    public static String rowsToString(List<List<String>> rows) {
        return CsvUtils.rowsToString(rows, false);
    }

    public static String rowsToString(List<List<String>> rows, boolean useRfcEol) {
        StringBuilder sb = new StringBuilder();
        String eolSequence = useRfcEol ? "\r\n" : "\n";
        boolean firstRow = true;
        for (List<String> columns : rows) {
            if (firstRow) {
                firstRow = false;
            } else {
                sb.append(eolSequence);
            }
            boolean firstColumn = true;
            for (String column : columns) {
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    sb.append(",");
                }
                sb.append("\"" + column.replace("\"", "\"\"") + "\"");
            }
        }
        return sb.toString();
    }
}

