/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDBitVector;
import com.github.javabdd.BDDException;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDVarSet;
import java.math.BigInteger;

public abstract class BDDDomain {
    protected String name;
    protected int index;
    protected BigInteger realsize;
    protected int[] ivar;
    protected BDDVarSet var;

    protected BDDDomain(int index, BigInteger range) {
        BigInteger calcsize = BigInteger.valueOf(2L);
        if (range.signum() <= 0) {
            throw new BDDException();
        }
        this.name = Integer.toString(index);
        this.index = index;
        this.realsize = range;
        int binsize = 1;
        while (calcsize.compareTo(range) < 0) {
            ++binsize;
            calcsize = calcsize.shiftLeft(1);
        }
        this.ivar = new int[binsize];
    }

    public abstract BDDFactory getFactory();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public BDD domain() {
        BDDFactory factory = this.getFactory();
        BigInteger val = this.size().subtract(BigInteger.ONE);
        BDD d = factory.universe();
        int[] ivar = this.vars();
        for (int n = 0; n < this.varNum(); ++n) {
            if (val.testBit(0)) {
                d.orWith(factory.nithVar(ivar[n]));
            } else {
                d.andWith(factory.nithVar(ivar[n]));
            }
            val = val.shiftRight(1);
        }
        return d;
    }

    public BigInteger size() {
        return this.realsize;
    }

    public BDD buildAdd(BDDDomain that, long value) {
        if (this.varNum() != that.varNum()) {
            throw new BDDException();
        }
        return this.buildAdd(that, this.varNum(), value);
    }

    public BDD buildAdd(BDDDomain that, int bits, long value) {
        BDD b;
        int n;
        if (bits > this.varNum() || bits > that.varNum()) {
            throw new BDDException("Number of bits requested (" + bits + ") is larger than domain sizes " + this.varNum() + "," + that.varNum());
        }
        BDDFactory bdd = this.getFactory();
        if (value == 0L) {
            BDD b2;
            int n2;
            BDD result = bdd.universe();
            for (n2 = 0; n2 < bits; ++n2) {
                b2 = bdd.ithVar(this.ivar[n2]);
                b2.biimpWith(bdd.ithVar(that.ivar[n2]));
                result.andWith(b2);
            }
            while (n2 < Math.max(this.varNum(), that.varNum())) {
                b2 = n2 < this.varNum() ? bdd.nithVar(this.ivar[n2]) : bdd.one();
                b2.andWith(n2 < that.varNum() ? bdd.nithVar(that.ivar[n2]) : bdd.one());
                result.andWith(b2);
                ++n2;
            }
            return result;
        }
        int[] vars = new int[bits];
        System.arraycopy(this.ivar, 0, vars, 0, vars.length);
        BDDBitVector y = bdd.buildVector(vars);
        BDDBitVector v = bdd.constantVector(bits, value);
        BDDBitVector z = y.add(v);
        int[] thatvars = new int[bits];
        System.arraycopy(that.ivar, 0, thatvars, 0, thatvars.length);
        BDDBitVector x = bdd.buildVector(thatvars);
        BDD result = bdd.one();
        for (n = 0; n < x.size(); ++n) {
            b = x.bitvec[n].biimp(z.bitvec[n]);
            result.andWith(b);
        }
        while (n < Math.max(this.varNum(), that.varNum())) {
            b = n < this.varNum() ? bdd.nithVar(this.ivar[n]) : bdd.one();
            b.andWith(n < that.varNum() ? bdd.nithVar(that.ivar[n]) : bdd.one());
            result.andWith(b);
            ++n;
        }
        x.free();
        y.free();
        z.free();
        v.free();
        return result;
    }

    public BDD buildEquals(BDDDomain that) {
        if (!this.size().equals(that.size())) {
            throw new BDDException("Size of " + this + " != size of that " + that + "( " + this.size() + " vs " + that.size() + ")");
        }
        BDDFactory factory = this.getFactory();
        BDD e = factory.universe();
        int[] this_ivar = this.vars();
        int[] that_ivar = that.vars();
        for (int n = 0; n < this.varNum(); ++n) {
            BDD a = factory.ithVar(this_ivar[n]);
            BDD b = factory.ithVar(that_ivar[n]);
            a.biimpWith(b);
            e.andWith(a);
        }
        return e;
    }

    public BDDVarSet set() {
        return this.var.id();
    }

    public BDD ithVar(long val) {
        return this.ithVar(BigInteger.valueOf(val));
    }

    public BDD ithVar(BigInteger val) {
        if (val.signum() < 0 || val.compareTo(this.size()) >= 0) {
            throw new BDDException(val + " is out of range");
        }
        BDDFactory factory = this.getFactory();
        BDD v = factory.universe();
        int[] ivar = this.vars();
        for (int n = 0; n < ivar.length; ++n) {
            if (val.testBit(0)) {
                v.andWith(factory.ithVar(ivar[n]));
            } else {
                v.andWith(factory.nithVar(ivar[n]));
            }
            val = val.shiftRight(1);
        }
        return v;
    }

    public BDD varRange(long lo, long hi) {
        return this.varRange(BigInteger.valueOf(lo), BigInteger.valueOf(hi));
    }

    public BDD varRange(BigInteger lo, BigInteger hi) {
        if (lo.signum() < 0 || hi.compareTo(this.size()) >= 0 || lo.compareTo(hi) > 0) {
            throw new BDDException("range <" + lo + ", " + hi + "> is invalid");
        }
        BDDFactory factory = this.getFactory();
        BDD result = factory.zero();
        int[] ivar = this.vars();
        while (lo.compareTo(hi) <= 0) {
            BigInteger mask;
            BDD v = factory.universe();
            int n = ivar.length - 1;
            while (true) {
                if (lo.testBit(n)) {
                    v.andWith(factory.ithVar(ivar[n]));
                } else {
                    v.andWith(factory.nithVar(ivar[n]));
                }
                mask = BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
                if (!lo.testBit(n) && lo.or(mask).compareTo(hi) <= 0) break;
                --n;
            }
            lo = lo.or(mask).add(BigInteger.ONE);
            result.orWith(v);
        }
        return result;
    }

    public int varNum() {
        return this.ivar.length;
    }

    public int[] vars() {
        return this.ivar;
    }

    public int ensureCapacity(long range) {
        return this.ensureCapacity(BigInteger.valueOf(range));
    }

    public int ensureCapacity(BigInteger range) {
        BigInteger calcsize = BigInteger.valueOf(2L);
        if (range.signum() < 0) {
            throw new BDDException();
        }
        if (range.compareTo(this.realsize) < 0) {
            return this.ivar.length;
        }
        this.realsize = range.add(BigInteger.ONE);
        int binsize = 1;
        while (calcsize.compareTo(range) <= 0) {
            ++binsize;
            calcsize = calcsize.shiftLeft(1);
        }
        if (this.ivar.length == binsize) {
            return binsize;
        }
        throw new BDDException("Can't add bits to domains, requested domain " + this.name + " upper limit " + range);
    }

    public String toString() {
        return this.getName();
    }

    public BigInteger[] getVarIndices(BDD that) {
        return this.getVarIndices(that, -1);
    }

    public BigInteger[] getVarIndices(BDD that, int max) {
        BDDVarSet myvarset = this.set();
        int n = (int)that.satCount(myvarset);
        if (max != -1 && n > max) {
            n = max;
        }
        BigInteger[] res = new BigInteger[n];
        BDD.BDDIterator it = that.iterator(myvarset);
        myvarset.free();
        for (int i = 0; i < n; ++i) {
            res[i] = it.nextValue(this);
        }
        return res;
    }
}

