/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.sequencing;

import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.escet.common.dsm.sequencing.graph.Cycle;
import org.eclipse.escet.common.dsm.sequencing.graph.Edge;
import org.eclipse.escet.common.dsm.sequencing.graph.Graph;
import org.eclipse.escet.common.dsm.sequencing.graph.Vertex;
import org.eclipse.escet.common.java.DirectedGraphCycleFinder;
import org.eclipse.escet.common.java.Lists;

public class GraphCycleFinder
extends DirectedGraphCycleFinder<Graph, Integer, CycleFinderEdge, Cycle> {
    public GraphCycleFinder() {
        super(null);
    }

    protected List<Integer> getVertices(Graph graph) {
        return IntStream.range(0, graph.vertices.size()).boxed().toList();
    }

    protected List<CycleFinderEdge> getOutgoingEdges(Graph graph, Integer vertex) {
        Vertex v = graph.vertices.get(vertex);
        return v.outputs.stream().map(CycleFinderEdge::new).toList();
    }

    protected void addCycle(Graph g, List<CycleFinderEdge> edges, Set<Cycle> foundCycles) {
        Cycle cycle = new Cycle((List)edges.stream().map(e -> e.edge).collect(Lists.toList()));
        foundCycles.add(cycle);
    }

    public static class CycleFinderEdge
    extends DirectedGraphCycleFinder.GraphEdge<Integer> {
        public final Edge edge;

        public CycleFinderEdge(Edge edge) {
            super((Object)edge.producingVertex, (Object)edge.consumingVertex);
            this.edge = edge;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            void cfe;
            Object object = other;
            if (!(object instanceof CycleFinderEdge)) {
                return false;
            }
            CycleFinderEdge cycleFinderEdge = (CycleFinderEdge)((Object)object);
            CycleFinderEdge cfr_ignored_0 = (CycleFinderEdge)((Object)object);
            return this.edge.equals(cfe.edge);
        }

        public int hashCode() {
            return this.edge.hashCode();
        }
    }
}

