/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.io;

import java.util.Arrays;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.Strings;

public class WriteMatrix {
    private WriteMatrix() {
    }

    public static void writeMatrixFile(AppStream outHandle, RealMatrix adjacencies, Label[] labels) {
        int size = adjacencies.getRowDimension();
        StringBuilder[] lines = new StringBuilder[size];
        int i = 0;
        while (i < size) {
            lines[i] = new StringBuilder(16 + size * 3);
            ++i;
        }
        String[] texts = new String[size];
        int i2 = 0;
        while (i2 < size) {
            texts[i2] = "\"" + labels[i2].toString() + "\"";
            ++i2;
        }
        WriteMatrix.appendLeftAlignedColumn(texts, lines);
        int col = 0;
        while (col < size) {
            WriteMatrix.appendColumn(", ", lines);
            int i3 = 0;
            while (i3 < size) {
                double value = adjacencies.getEntry(i3, col);
                texts[i3] = value <= 0.0 ? "" : Double.toString(value);
                ++i3;
            }
            WriteMatrix.appendRightAlignedColumn(texts, lines);
            ++col;
        }
        i2 = 0;
        while (i2 < size) {
            outHandle.println(Strings.trimRight((String)lines[i2].toString()));
            ++i2;
        }
    }

    private static void appendColumn(String text, StringBuilder[] lines) {
        int i = 0;
        while (i < lines.length) {
            lines[i].append(text);
            ++i;
        }
    }

    private static void appendLeftAlignedColumn(String[] texts, StringBuilder[] lines) {
        if (texts.length == 0) {
            return;
        }
        int maxLength = Arrays.stream(texts).map(String::length).reduce(Integer::max).get();
        int i = 0;
        while (i < texts.length) {
            lines[i].append(texts[i] + Strings.spaces((int)(maxLength - texts[i].length())));
            ++i;
        }
    }

    private static void appendRightAlignedColumn(String[] texts, StringBuilder[] lines) {
        if (texts.length == 0) {
            return;
        }
        int maxLength = Arrays.stream(texts).map(String::length).reduce(Integer::max).get();
        int i = 0;
        while (i < texts.length) {
            lines[i].append(Strings.spaces((int)(maxLength - texts[i].length())) + texts[i]);
            ++i;
        }
    }

    public static void writeGroups(AppStream outHandle, Group rootGroup) {
        outHandle.println();
        outHandle.println("Groups:");
        WriteMatrix.writeGroups(outHandle, rootGroup, "");
    }

    private static void writeGroups(AppStream outHandle, Group group, String indent) {
        if (group.childGroups.isEmpty() && group.getShuffledSize() == 1) {
            return;
        }
        switch (group.groupType) {
            case BUS: {
                outHandle.print(indent + "- bus");
                break;
            }
            case CLUSTER: {
                outHandle.print(indent + "- cluster");
                break;
            }
            case COLLECTION: {
                outHandle.print(indent + "- collection");
                break;
            }
            default: {
                throw new RuntimeException(Strings.fmt((String)"Unexpected groupType \"%s\" found.", (Object[])new Object[]{group.groupType}));
            }
        }
        int base = group.getShuffledBase();
        int size = group.getShuffledSize();
        if (base >= 0) {
            outHandle.printf(" from %d to %d", new Object[]{base + 1, base + size});
        }
        outHandle.newLine();
        for (Group child : group.childGroups) {
            WriteMatrix.writeGroups(outHandle, child, indent + "- ");
        }
    }
}

