/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.nonblockingundercontrol;

import com.github.javabdd.BDD;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.utils.CifBddReachability;
import org.eclipse.escet.cif.controllercheck.nonblockingundercontrol.NonBlockingUnderControlCheckConclusion;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class NonBlockingUnderControlChecker {
    public NonBlockingUnderControlCheckConclusion checkSystem(CifBddSpec cifBddSpec) {
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        Supplier shouldTerminate = cifBddSpec.settings.getShouldTerminate();
        dbg.line("Computing the condition for no controllable event to be enabled...");
        BDD notGc = this.computeNotGc(cifBddSpec);
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        dbg.line("Condition under which no controllable event is enabled: %s", new Object[]{BddUtils.bddToStr((BDD)notGc, (CifBddSpec)cifBddSpec)});
        dbg.line();
        dbg.line("Computing the controllable-complete path states...");
        BDD ccp = this.computeCcp(cifBddSpec, notGc);
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        dbg.line("Controllable-complete path states: %s", new Object[]{BddUtils.bddToStr((BDD)ccp, (CifBddSpec)cifBddSpec)});
        dbg.line();
        dbg.line("Computing the bad states...");
        BDD bad = this.computeBad(cifBddSpec, ccp);
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        dbg.line("Bad states: %s", new Object[]{BddUtils.bddToStr((BDD)bad, (CifBddSpec)cifBddSpec)});
        dbg.line();
        dbg.line("Computing the result of the non-blocking under control check...");
        BDD initialAndBad = cifBddSpec.initial.id().andWith(bad);
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        dbg.line("Initial states: %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initial, (CifBddSpec)cifBddSpec)});
        dbg.line("Bad initial states: %s", new Object[]{BddUtils.bddToStr((BDD)initialAndBad, (CifBddSpec)cifBddSpec)});
        boolean isNonBlockingUnderControl = initialAndBad.isZero();
        initialAndBad.free();
        return new NonBlockingUnderControlCheckConclusion(isNonBlockingUnderControl);
    }

    private BDD computeNotGc(CifBddSpec cifBddSpec) {
        Supplier shouldTerminate = cifBddSpec.settings.getShouldTerminate();
        BDD gc = cifBddSpec.factory.zero();
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (!edge.event.getControllable().booleanValue()) continue;
            gc = gc.orWith(edge.guard.id());
            if (!((Boolean)shouldTerminate.get()).booleanValue()) continue;
            return null;
        }
        BDD notGc = gc.not();
        gc.free();
        return notGc;
    }

    private BDD computeCcp(CifBddSpec cifBddSpec, BDD notGc) {
        Supplier shouldTerminate = cifBddSpec.settings.getShouldTerminate();
        List<CifBddEdge> unctrlEdges = cifBddSpec.edges.stream().filter(e -> e.event.getControllable() == false).toList();
        Map unctrlEdgeGuards = Maps.mapc((int)unctrlEdges.size());
        for (CifBddEdge unctrlEdge : unctrlEdges) {
            unctrlEdgeGuards.put(unctrlEdge, unctrlEdge.guard);
        }
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        for (CifBddEdge unctrlEdge : unctrlEdges) {
            unctrlEdge.guard = unctrlEdge.guard.and(notGc);
            if (((Boolean)shouldTerminate.get()).booleanValue()) {
                return null;
            }
            unctrlEdge.reinitApply();
            if (!((Boolean)shouldTerminate.get()).booleanValue()) continue;
            return null;
        }
        String predName = "controllable-complete path states";
        String initValName = "controllable-complete path end states";
        String restrictionName = null;
        BDD restriction = null;
        boolean applyForward = false;
        boolean inclCtrl = true;
        boolean inclUnctrl = true;
        boolean inclInputVars = true;
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        CifBddReachability reachability = new CifBddReachability(cifBddSpec, predName, initValName, restrictionName, restriction, applyForward, inclCtrl, inclUnctrl, inclInputVars, dbgEnabled);
        BDD initPred = cifBddSpec.marked.id().andWith(notGc);
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        BDD reachabilityResult = reachability.performReachability(initPred);
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        for (Map.Entry entry : unctrlEdgeGuards.entrySet()) {
            CifBddEdge edge = (CifBddEdge)entry.getKey();
            edge.guard.free();
            edge.guard = (BDD)entry.getValue();
            if (((Boolean)shouldTerminate.get()).booleanValue()) {
                return null;
            }
            edge.reinitApply();
            if (!((Boolean)shouldTerminate.get()).booleanValue()) continue;
            return null;
        }
        return reachabilityResult;
    }

    private BDD computeBad(CifBddSpec cifBddSpec, BDD ccp) {
        Supplier shouldTerminate = cifBddSpec.settings.getShouldTerminate();
        String predName = "bad states";
        String initValName = "not controllable-complete path states";
        String restrictionName = null;
        BDD restriction = null;
        boolean applyForward = false;
        boolean inclCtrl = true;
        boolean inclUnctrl = true;
        boolean inclInputVars = true;
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        CifBddReachability reachability = new CifBddReachability(cifBddSpec, predName, initValName, restrictionName, restriction, applyForward, inclCtrl, inclUnctrl, inclInputVars, dbgEnabled);
        BDD initPred = ccp.not();
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        ccp.free();
        if (((Boolean)shouldTerminate.get()).booleanValue()) {
            return null;
        }
        BDD reachabilityResult = reachability.performReachability(initPred);
        return reachabilityResult;
    }
}

