/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.boundedresponse;

import com.github.javabdd.BDD;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.utils.CifBddReachability;
import org.eclipse.escet.cif.controllercheck.boundedresponse.Bound;
import org.eclipse.escet.cif.controllercheck.boundedresponse.BoundedResponseCheckConclusion;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;

public class BoundedResponseChecker {
    public BoundedResponseCheckConclusion checkSystem(CifBddSpec cifBddSpec) {
        cifBddSpec.settings.getDebugOutput().line("Computing reachable states...");
        BDD reachableStates = this.computeReachableStates(cifBddSpec);
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return null;
        }
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("Computing bound for uncontrollable events...");
        Bound uncontrollablesBound = this.computeBound(cifBddSpec, reachableStates, false);
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return null;
        }
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("Computing bound for controllable events...");
        Bound controllablesBound = this.computeBound(cifBddSpec, reachableStates, true);
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return null;
        }
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("Bounded response check completed.");
        reachableStates.free();
        return new BoundedResponseCheckConclusion(uncontrollablesBound, controllablesBound);
    }

    private BDD computeReachableStates(CifBddSpec cifBddSpec) {
        String predName = "reachable states";
        String initName = "initial states";
        String restrictionName = null;
        BDD restriction = null;
        boolean applyForward = true;
        boolean inclCtrl = true;
        boolean inclUnctrl = true;
        boolean inclInputVars = true;
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        BDD initPred = cifBddSpec.initial.id();
        CifBddReachability reachability = new CifBddReachability(cifBddSpec, predName, initName, restrictionName, restriction, applyForward, inclCtrl, inclUnctrl, inclInputVars, dbgEnabled);
        BDD reachabilityResult = reachability.performReachability(initPred);
        return reachabilityResult;
    }

    private Bound computeBound(CifBddSpec cifBddSpec, BDD reachableStates, boolean controllableEvents) {
        List orderedEdges = cifBddSpec.orderedEdgesForward;
        Predicate<CifBddEdge> edgeShouldBeApplied = edge -> {
            if (controllableEvents) {
                return edge.event.getControllable();
            }
            return edge.event.getControllable() == false && !cifBddSpec.inputVarEvents.contains(edge.event);
        };
        List<CifBddEdge> edgesToApply = orderedEdges.stream().filter(edgeShouldBeApplied).toList();
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return null;
        }
        Integer round = 0;
        BDD prevRoundStates = cifBddSpec.factory.zero();
        BDD roundStates = reachableStates.id();
        while (!roundStates.isZero()) {
            round = round + 1;
            prevRoundStates.free();
            prevRoundStates = roundStates;
            roundStates = null;
            if (round < 0) {
                throw new UnsupportedException("Failed to compute bounded response, as the bound is too high.");
            }
            cifBddSpec.settings.getDebugOutput().line("Bounded response check round %,d (states before round: %s).", new Object[]{round, BddUtils.bddToStr((BDD)prevRoundStates, (CifBddSpec)cifBddSpec)});
            roundStates = cifBddSpec.factory.zero();
            for (CifBddEdge edge2 : edgesToApply) {
                boolean forward = true;
                BDD restriction = null;
                BDD edgePred = edge2.apply(prevRoundStates.id(), forward, restriction);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return null;
                }
                roundStates = roundStates.id().orWith(edgePred);
                if (!((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) continue;
                return null;
            }
            if (roundStates.equalsBDD(prevRoundStates)) {
                round = null;
                break;
            }
            if (!((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) continue;
            return null;
        }
        prevRoundStates.free();
        roundStates.free();
        if (round == null) {
            return new Bound(true, false, null);
        }
        return new Bound(round > 0, true, Math.max(0, round - 1));
    }
}

