/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.boundedresponse;

import org.eclipse.escet.cif.controllercheck.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.boundedresponse.Bound;
import org.eclipse.escet.common.app.framework.output.OutputProvider;

public class BoundedResponseCheckConclusion
implements CheckConclusion {
    public final Bound uncontrollablesBound;
    public final Bound controllablesBound;

    public BoundedResponseCheckConclusion(Bound uncontrollablesBound, Bound controllablesBound) {
        this.uncontrollablesBound = uncontrollablesBound;
        this.controllablesBound = controllablesBound;
    }

    @Override
    public boolean propertyHolds() {
        return this.uncontrollablesBound.isBounded() && this.controllablesBound.isBounded();
    }

    @Override
    public boolean hasDetails() {
        return true;
    }

    @Override
    public void printResult() {
        int bound;
        if (!this.uncontrollablesBound.hasInitialState() || !this.controllablesBound.hasInitialState()) {
            OutputProvider.warn((String)"The specification cannot be initialized.");
        }
        if (this.propertyHolds()) {
            OutputProvider.out((String)"[OK] The specification has bounded response:");
        } else {
            OutputProvider.out((String)"[ERROR] The specification does NOT have bounded response:");
        }
        OutputProvider.out();
        OutputProvider.iout();
        if (this.uncontrollablesBound.isBounded()) {
            bound = this.uncontrollablesBound.getBound();
            if (bound == 0) {
                OutputProvider.out((String)"- No transitions are possible for uncontrollable events.");
            } else {
                OutputProvider.out((String)"- A sequence of at most %,d transition%s is possible for uncontrollable events.", (Object[])new Object[]{bound, bound == 1 ? "" : "s"});
            }
        } else {
            OutputProvider.out((String)"- An infinite sequence of transitions is possible for uncontrollable events.");
        }
        if (this.controllablesBound.isBounded()) {
            bound = this.controllablesBound.getBound();
            if (bound == 0) {
                OutputProvider.out((String)"- No transitions are possible for controllable events.");
            } else {
                OutputProvider.out((String)"- A sequence of at most %,d transition%s is possible for controllable events.", (Object[])new Object[]{bound, bound == 1 ? "" : "s"});
            }
        } else {
            OutputProvider.out((String)"- An infinite sequence of transitions is possible for controllable events.");
        }
        OutputProvider.dout();
    }
}

