/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import com.github.javabdd.BDDFactory;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.conversion.CifToBddConverter;
import org.eclipse.escet.cif.bdd.settings.AllowNonDeterminism;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.CifBddStatistics;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.CifBddApplyPlantInvariants;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimIfUpdates;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.EnumsToInts;
import org.eclipse.escet.cif.cif2cif.RelabelSupervisorsAsPlants;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.controllercheck.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerPreChecker;
import org.eclipse.escet.cif.controllercheck.boundedresponse.BoundedResponseCheckConclusion;
import org.eclipse.escet.cif.controllercheck.boundedresponse.BoundedResponseChecker;
import org.eclipse.escet.cif.controllercheck.confluence.ConfluenceChecker;
import org.eclipse.escet.cif.controllercheck.finiteresponse.FiniteResponseChecker;
import org.eclipse.escet.cif.controllercheck.mdd.MddDeterminismChecker;
import org.eclipse.escet.cif.controllercheck.mdd.MddPreChecker;
import org.eclipse.escet.cif.controllercheck.mdd.MddPrepareChecks;
import org.eclipse.escet.cif.controllercheck.nonblockingundercontrol.NonBlockingUnderControlCheckConclusion;
import org.eclipse.escet.cif.controllercheck.nonblockingundercontrol.NonBlockingUnderControlChecker;
import org.eclipse.escet.cif.controllercheck.options.EnableBoundedResponseChecking;
import org.eclipse.escet.cif.controllercheck.options.EnableConfluenceChecking;
import org.eclipse.escet.cif.controllercheck.options.EnableFiniteResponseChecking;
import org.eclipse.escet.cif.controllercheck.options.EnableNonBlockingUnderControlChecking;
import org.eclipse.escet.cif.controllercheck.options.PrintControlLoopsOutputOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.typechecker.annotations.builtin.ControllerPropertiesAnnotationProvider;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifToolPostCheckEnv;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.typechecker.SemanticException;

public class ControllerCheckerApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ControllerCheckerApp app = new ControllerCheckerApp();
        app.run(args, true);
    }

    public ControllerCheckerApp() {
    }

    public ControllerCheckerApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF controller properties checker tool";
    }

    public String getAppDescription() {
        return "Checks whether a CIF specification meets certain properties for being a proper controller.";
    }

    protected int runInternal() {
        boolean hasMddBasedChecks;
        boolean checkBoundedResponse = EnableBoundedResponseChecking.checkBoundedResponse();
        boolean checkNonBlockingUnderControl = EnableNonBlockingUnderControlChecking.checkNonBlockingUnderControl();
        boolean checkFiniteResponse = EnableFiniteResponseChecking.checkFiniteResponse();
        boolean checkConfluence = EnableConfluenceChecking.checkConfluence();
        boolean hasBddBasedChecks = checkBoundedResponse || checkNonBlockingUnderControl;
        boolean bl = hasMddBasedChecks = checkFiniteResponse || checkConfluence;
        if (!(checkBoundedResponse || checkNonBlockingUnderControl || checkFiniteResponse || checkConfluence)) {
            throw new InvalidOptionException("No checks enabled. Enable one of the checks for the controller properties checker to check.");
        }
        OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
        CifReader cifReader = new CifReader();
        Specification origSpec = (Specification)((CifReader)cifReader.init()).read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        new ElimComponentDefInst().transform(origSpec);
        Specification outputSpec = origSpec;
        Specification spec = (Specification)EMFHelper.deepclone((EObject)origSpec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        ControllerCheckerPreChecker checker = new ControllerCheckerPreChecker(() -> AppEnv.isTerminationRequested());
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF controller properties checker");
        if (this.isTerminationRequested()) {
            return 0;
        }
        Set specAlphabet = CifEventUtils.getAlphabet((Specification)spec);
        if (specAlphabet.stream().allMatch(e -> e.getControllable() == false)) {
            OutputProvider.warn((String)"The alphabet of the specification contains no controllable events.");
        }
        if (specAlphabet.stream().allMatch(e -> e.getControllable())) {
            OutputProvider.warn((String)"The alphabet of the specification contains no uncontrollable events.");
        }
        Specification bddSpec = null;
        Specification mddSpec = null;
        CifBddSpec cifBddSpec = null;
        MddPrepareChecks prepareChecks = null;
        if (hasBddBasedChecks) {
            OutputProvider.dbg((String)"Preparing for BDD-based checks...");
            bddSpec = (Specification)EMFHelper.deepclone((EObject)spec);
            if (this.isTerminationRequested()) {
                return 0;
            }
            new RelabelSupervisorsAsPlants().transform(bddSpec);
            CifBddSettings settings = new CifBddSettings();
            settings.setShouldTerminate(() -> AppEnv.isTerminationRequested());
            settings.setDebugOutput(OutputProvider.getDebugOutputStream());
            settings.setNormalOutput(OutputProvider.getNormalOutputStream());
            settings.setWarnOutput(OutputProvider.getWarningOutputStream());
            settings.setAllowNonDeterminism(AllowNonDeterminism.ALL);
            settings.setCifBddStatistics(EnumSet.noneOf(CifBddStatistics.class));
            settings.setDoPlantsRefReqsWarn(false);
            settings.setModificationAllowed(false);
            CifToBddConverter.preprocess((Specification)bddSpec, (WarnOutput)settings.getWarnOutput(), (boolean)settings.getDoPlantsRefReqsWarn());
            BDDFactory factory = CifToBddConverter.createFactory((CifBddSettings)settings, Collections.emptyList(), Collections.emptyList());
            CifToBddConverter converter = new CifToBddConverter("CIF controller properties checker");
            cifBddSpec = converter.convert(bddSpec, settings, factory);
            if (this.isTerminationRequested()) {
                return 0;
            }
            cifBddSpec.freeIntermediateBDDs(true);
            if (this.isTerminationRequested()) {
                return 0;
            }
            CifBddApplyPlantInvariants.applyStateEvtExclPlantsInvs((CifBddSpec)cifBddSpec, (String)"system", () -> null, (boolean)settings.getDebugOutput().isEnabled());
            if (this.isTerminationRequested()) {
                return 0;
            }
            for (CifBddEdge edge : cifBddSpec.edges) {
                edge.initApply();
                if (!this.isTerminationRequested()) continue;
                return 0;
            }
        }
        if (hasBddBasedChecks && hasMddBasedChecks) {
            OutputProvider.dbg();
        }
        if (hasMddBasedChecks) {
            OutputProvider.dbg((String)"Preparing for MDD-based checks...");
            mddSpec = (Specification)EMFHelper.deepclone((EObject)spec);
            if (this.isTerminationRequested()) {
                return 0;
            }
            new ElimStateEvtExclInvs().transform(mddSpec);
            new ElimMonitors().transform(mddSpec);
            new ElimSelf().transform(mddSpec);
            new ElimTypeDecls().transform(mddSpec);
            Function<Automaton, String> varNamingFunction = a -> "LP_" + a.getName();
            Function<Automaton, String> enumNamingFunction = a -> "LOCS_" + a.getName();
            Function<Location, String> litNamingFunction = l -> "LOC_" + l.getName();
            boolean considerLocsForRename = true;
            boolean addInitPreds = true;
            boolean optimized = false;
            Map lpVarToAbsAutNameMap = null;
            boolean optInits = true;
            boolean addEdgeGuards = true;
            boolean copyAutAnnosToEnum = false;
            boolean copyLocAnnosToEnumLits = false;
            new ElimLocRefExprs(varNamingFunction, enumNamingFunction, litNamingFunction, true, true, false, lpVarToAbsAutNameMap, true, true, false, false).transform(mddSpec);
            new EnumsToInts().transform(mddSpec);
            if (this.isTerminationRequested()) {
                return 0;
            }
            new ElimAlgVariables().transform(mddSpec);
            new ElimConsts().transform(mddSpec);
            new SimplifyValues().transform(mddSpec);
            if (this.isTerminationRequested()) {
                return 0;
            }
            new MddPreChecker(() -> AppEnv.isTerminationRequested()).reportPreconditionViolations(mddSpec, absSpecPath, "CIF controller properties checker");
            if (this.isTerminationRequested()) {
                return 0;
            }
            new ElimIfUpdates().transform(mddSpec);
            if (this.isTerminationRequested()) {
                return 0;
            }
            new MddDeterminismChecker(() -> AppEnv.isTerminationRequested()).reportPreconditionViolations(mddSpec, absSpecPath, "CIF controller properties checker");
            if (this.isTerminationRequested()) {
                return 0;
            }
            boolean computeGlobalGuardedUpdates = checkConfluence;
            prepareChecks = new MddPrepareChecks(computeGlobalGuardedUpdates);
            if (!prepareChecks.compute(mddSpec)) {
                return 0;
            }
        }
        boolean dbgEnabled = OutputModeOption.getOutputMode() == OutputMode.DEBUG;
        int checksPerformed = 0;
        boolean allChecksHold = true;
        BoundedResponseCheckConclusion boundedResponseConclusion = null;
        boolean boundedResponseHolds = true;
        if (checkBoundedResponse) {
            if (dbgEnabled || checksPerformed > 0) {
                OutputProvider.out();
            }
            OutputProvider.out((String)"Checking for bounded response...");
            boundedResponseConclusion = new BoundedResponseChecker().checkSystem(cifBddSpec);
            ++checksPerformed;
            if (boundedResponseConclusion == null || this.isTerminationRequested()) {
                return 0;
            }
            boundedResponseHolds = boundedResponseConclusion.propertyHolds();
        }
        allChecksHold &= boundedResponseHolds;
        NonBlockingUnderControlCheckConclusion nonBlockingUnderControlConclusion = null;
        boolean nonBlockingUnderControlHolds = true;
        if (checkNonBlockingUnderControl) {
            if (dbgEnabled || checksPerformed > 0) {
                OutputProvider.out();
            }
            OutputProvider.out((String)"Checking for non-blocking under control...");
            nonBlockingUnderControlConclusion = new NonBlockingUnderControlChecker().checkSystem(cifBddSpec);
            ++checksPerformed;
            if (nonBlockingUnderControlConclusion == null || this.isTerminationRequested()) {
                return 0;
            }
            nonBlockingUnderControlHolds = nonBlockingUnderControlConclusion.propertyHolds();
        }
        allChecksHold &= nonBlockingUnderControlHolds;
        if (cifBddSpec != null) {
            for (CifBddEdge edge : cifBddSpec.edges) {
                edge.cleanupApply();
            }
            cifBddSpec.freeAllBDDs();
            cifBddSpec = null;
            if (this.isTerminationRequested()) {
                return 0;
            }
        }
        CheckConclusion finiteResponseConclusion = null;
        boolean finiteResponseHolds = true;
        if (checkFiniteResponse) {
            if (dbgEnabled || checksPerformed > 0) {
                OutputProvider.out();
            }
            OutputProvider.out((String)"Checking for finite response...");
            finiteResponseConclusion = new FiniteResponseChecker().checkSystem(prepareChecks);
            ++checksPerformed;
            if (finiteResponseConclusion == null || this.isTerminationRequested()) {
                return 0;
            }
            finiteResponseHolds = finiteResponseConclusion.propertyHolds();
        }
        allChecksHold &= finiteResponseHolds;
        CheckConclusion confluenceConclusion = null;
        boolean confluenceHolds = true;
        if (checkConfluence) {
            if (dbgEnabled || checksPerformed > 0) {
                OutputProvider.out();
            }
            OutputProvider.out((String)"Checking for confluence...");
            confluenceConclusion = new ConfluenceChecker().checkSystem(prepareChecks);
            ++checksPerformed;
            if (confluenceConclusion == null || this.isTerminationRequested()) {
                return 0;
            }
            confluenceHolds = confluenceConclusion.propertyHolds();
        }
        allChecksHold &= confluenceHolds;
        OutputProvider.out();
        OutputProvider.out((String)"CONCLUSION:");
        OutputProvider.iout();
        if (boundedResponseConclusion != null) {
            boundedResponseConclusion.printResult();
        } else {
            OutputProvider.out((String)"[UNKNOWN] Bounded response checking was disabled, bounded response property is unknown.");
        }
        OutputProvider.dout();
        if (boundedResponseConclusion != null && boundedResponseConclusion.hasDetails() || nonBlockingUnderControlConclusion != null && nonBlockingUnderControlConclusion.hasDetails()) {
            OutputProvider.out();
        }
        OutputProvider.iout();
        if (nonBlockingUnderControlConclusion != null) {
            nonBlockingUnderControlConclusion.printResult();
        } else {
            OutputProvider.out((String)"[UNKNOWN] Non-blocking under control checking was disabled, non-blocking under control property is unknown.");
        }
        OutputProvider.dout();
        if (nonBlockingUnderControlConclusion != null && nonBlockingUnderControlConclusion.hasDetails() || finiteResponseConclusion != null && finiteResponseConclusion.hasDetails()) {
            OutputProvider.out();
        }
        OutputProvider.iout();
        if (finiteResponseConclusion != null) {
            finiteResponseConclusion.printResult();
        } else {
            OutputProvider.out((String)"[UNKNOWN] Finite response checking was disabled, finite response property is unknown.");
        }
        OutputProvider.dout();
        if (finiteResponseConclusion != null && finiteResponseConclusion.hasDetails() || confluenceConclusion != null && confluenceConclusion.hasDetails()) {
            OutputProvider.out();
        }
        OutputProvider.iout();
        if (confluenceConclusion != null) {
            confluenceConclusion.printResult();
        } else {
            OutputProvider.out((String)"[UNKNOWN] Confluence checking was disabled, confluence property is unknown.");
        }
        OutputProvider.dout();
        if (boundedResponseConclusion != null) {
            Integer unctrlBound = boundedResponseConclusion.propertyHolds() ? Integer.valueOf(boundedResponseConclusion.uncontrollablesBound.getBound()) : null;
            Integer ctrlBound = boundedResponseConclusion.propertyHolds() ? Integer.valueOf(boundedResponseConclusion.controllablesBound.getBound()) : null;
            ControllerPropertiesAnnotationProvider.setBoundedResponse((Specification)outputSpec, (Integer)unctrlBound, (Integer)ctrlBound);
        }
        if (confluenceConclusion != null) {
            ControllerPropertiesAnnotationProvider.setConfluence((Specification)outputSpec, (boolean)confluenceHolds);
        }
        if (finiteResponseConclusion != null) {
            ControllerPropertiesAnnotationProvider.setFiniteResponse((Specification)outputSpec, (boolean)finiteResponseHolds);
        }
        if (nonBlockingUnderControlConclusion != null) {
            ControllerPropertiesAnnotationProvider.setNonBlockingUnderControl((Specification)outputSpec, (boolean)nonBlockingUnderControlHolds);
        }
        CifToolPostCheckEnv env = new CifToolPostCheckEnv(cifReader.getAbsDirPath(), "output");
        try {
            new CifAnnotationsPostChecker((CifPostCheckEnv)env).check(outputSpec);
        }
        catch (SemanticException ctrlBound) {
            // empty catch block
        }
        env.throwUnsupportedExceptionIfAnyErrors("Checking the specification for the requested properties failed.");
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".checked.cif");
        String absOutPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)outputSpec, (String)absOutPath, (String)cifReader.getAbsDirPath());
        OutputProvider.out();
        OutputProvider.out((String)"The model with the check results has been written to \"%s\".", (Object[])new Object[]{outPath});
        return allChecksHold ? 0 : 1;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = ControllerCheckerApp.getGeneralOptionCategory();
        List checkOpts = Lists.list();
        checkOpts.add(Options.getInstance(InputFileOption.class));
        checkOpts.add(Options.getInstance(EnableBoundedResponseChecking.class));
        checkOpts.add(Options.getInstance(EnableNonBlockingUnderControlChecking.class));
        checkOpts.add(Options.getInstance(EnableFiniteResponseChecking.class));
        checkOpts.add(Options.getInstance(PrintControlLoopsOutputOption.class));
        checkOpts.add(Options.getInstance(EnableConfluenceChecking.class));
        checkOpts.add(Options.getInstance(OutputFileOption.class));
        OptionCategory checksCat = new OptionCategory("Checks", "Controller properties checker options.", Lists.list(), checkOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, checksCat});
        OptionCategory options = new OptionCategory("CIF Controller properties checker Options", "All options for the CIF controller properties checker tool.", cats, Lists.list());
        return options;
    }
}

