/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import com.github.javabdd.BDDFactory;
import java.util.List;
import org.eclipse.escet.cif.bdd.conversion.CifToBddConverter;
import org.eclipse.escet.cif.bdd.settings.AllowNonDeterminism;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.datasynth.CifDataSynthesis;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisResult;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisTiming;
import org.eclipse.escet.cif.datasynth.conversion.SynthesisToCifConverter;
import org.eclipse.escet.cif.datasynth.options.BddAdvancedVariableOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddDcshVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxNodesOption;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxPathsOption;
import org.eclipse.escet.cif.datasynth.options.BddForceVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddHyperEdgeAlgoOption;
import org.eclipse.escet.cif.datasynth.options.BddInitNodeTableSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddOpCacheRatioOption;
import org.eclipse.escet.cif.datasynth.options.BddOpCacheSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddOutputNamePrefixOption;
import org.eclipse.escet.cif.datasynth.options.BddOutputOption;
import org.eclipse.escet.cif.datasynth.options.BddSimplifyOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddVariableOrderOption;
import org.eclipse.escet.cif.datasynth.options.ContinuousPerformanceStatisticsFileOption;
import org.eclipse.escet.cif.datasynth.options.EdgeGranularityOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderBackwardOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderDuplicateEventsOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderForwardOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderOption;
import org.eclipse.escet.cif.datasynth.options.EdgeWorksetAlgoOption;
import org.eclipse.escet.cif.datasynth.options.EventWarnOption;
import org.eclipse.escet.cif.datasynth.options.FixedPointComputationsOrderOption;
import org.eclipse.escet.cif.datasynth.options.ForwardReachOption;
import org.eclipse.escet.cif.datasynth.options.PlantsRefReqsWarnOption;
import org.eclipse.escet.cif.datasynth.options.StateReqInvEnforceOption;
import org.eclipse.escet.cif.datasynth.options.SupervisorNameOption;
import org.eclipse.escet.cif.datasynth.options.SupervisorNamespaceOption;
import org.eclipse.escet.cif.datasynth.options.SynthesisStatisticsOption;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettings;
import org.eclipse.escet.cif.datasynth.settings.SynthesisStatistics;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifToolPostCheckEnv;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifDataSynthesisApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifDataSynthesisApp app = new CifDataSynthesisApp();
        app.run(args, true);
    }

    public CifDataSynthesisApp() {
    }

    public CifDataSynthesisApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF data-based supervisory controller synthesis tool";
    }

    public String getAppDescription() {
        return "Synthesizes a supervisory controller for a CIF specification with data.";
    }

    protected int runInternal() {
        CifDataSynthesisSettings settings = new CifDataSynthesisSettings();
        settings.setShouldTerminate(() -> AppEnv.isTerminationRequested());
        settings.setDebugOutput(OutputProvider.getDebugOutputStream());
        settings.setNormalOutput(OutputProvider.getNormalOutputStream());
        settings.setWarnOutput(OutputProvider.getWarningOutputStream());
        settings.setDoPlantsRefReqsWarn(PlantsRefReqsWarnOption.isEnabled());
        settings.setAllowNonDeterminism(AllowNonDeterminism.UNCONTROLLABLE);
        settings.setBddInitNodeTableSize(BddInitNodeTableSizeOption.getInitialSize());
        settings.setBddOpCacheRatio(BddOpCacheRatioOption.getCacheRatio());
        settings.setBddOpCacheSize(BddOpCacheSizeOption.getCacheSize());
        settings.setBddVarOrderInit(BddVariableOrderOption.getOrder());
        settings.setBddDcshEnabled(BddDcshVarOrderOption.isEnabled());
        settings.setBddForceEnabled(BddForceVarOrderOption.isEnabled());
        settings.setBddSlidingWindowEnabled(BddSlidingWindowVarOrderOption.isEnabled());
        settings.setBddSlidingWindowMaxLen(BddSlidingWindowSizeOption.getMaxLen());
        settings.setBddVarOrderAdvanced(BddAdvancedVariableOrderOption.getOrder());
        settings.setBddHyperEdgeAlgo(BddHyperEdgeAlgoOption.getAlgo());
        settings.setBddDebugMaxNodes(BddDebugMaxNodesOption.getMaximum());
        settings.setBddDebugMaxPaths(BddDebugMaxPathsOption.getMaximum());
        settings.setEdgeGranularity(EdgeGranularityOption.getGranularity());
        settings.setEdgeOrderBackward(EdgeOrderBackwardOption.getOrder());
        settings.setEdgeOrderForward(EdgeOrderForwardOption.getOrder());
        settings.setEdgeOrderAllowDuplicateEvents(EdgeOrderDuplicateEventsOption.getAllowance());
        settings.setDoUseEdgeWorksetAlgo(EdgeWorksetAlgoOption.isEnabled());
        settings.setCifBddStatistics(SynthesisStatistics.toCifBdd(SynthesisStatisticsOption.getStatistics()));
        settings.setDoNeverEnabledEventsWarn(EventWarnOption.isEnabled());
        settings.setStateReqInvEnforceMode(StateReqInvEnforceOption.getMode());
        settings.setFixedPointComputationsOrder(FixedPointComputationsOrderOption.getOrder());
        settings.setDoForwardReach(ForwardReachOption.isEnabled());
        settings.setSupervisorName(SupervisorNameOption.getSupervisorName());
        settings.setSupervisorNamespace(SupervisorNamespaceOption.getNamespace());
        settings.setBddOutputMode(BddOutputOption.getMode());
        settings.setBddOutputNamePrefix(BddOutputNamePrefixOption.getPrefix());
        settings.setBddSimplifications(BddSimplifyOption.getSimplifications());
        settings.setSynthesisStatistics(SynthesisStatisticsOption.getStatistics());
        settings.setContinuousPerformanceStatisticsFilePath(ContinuousPerformanceStatisticsFileOption.getPath());
        settings.setContinuousPerformanceStatisticsFileAbsPath(Paths.resolve((String)ContinuousPerformanceStatisticsFileOption.getPath()));
        settings.setModificationAllowed(false);
        boolean doTiming = settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.TIMING);
        CifDataSynthesisTiming timing = new CifDataSynthesisTiming();
        if (doTiming) {
            timing.total.start();
        }
        try {
            this.doSynthesis(settings, doTiming, timing);
        }
        finally {
            if (doTiming) {
                timing.total.stop();
                timing.print(settings.getDebugOutput(), settings.getNormalOutput());
            }
        }
        return 0;
    }

    private void doSynthesis(CifDataSynthesisSettings settings, boolean doTiming, CifDataSynthesisTiming timing) {
        Specification rslt;
        Specification spec;
        boolean dbgEnabled = settings.getDebugOutput().isEnabled();
        String inputPath = InputFileOption.getPath();
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Reading CIF file \"%s\".", (Object[])new Object[]{inputPath});
        }
        CifReader cifReader = (CifReader)new CifReader().init();
        if (doTiming) {
            timing.inputRead.start();
        }
        try {
            spec = (Specification)cifReader.read();
        }
        finally {
            if (doTiming) {
                timing.inputRead.stop();
            }
        }
        if (this.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Preprocessing CIF specification.");
        }
        if (doTiming) {
            timing.inputPreProcess.start();
        }
        try {
            CifToBddConverter.preprocess((Specification)spec, (WarnOutput)settings.getWarnOutput(), (boolean)settings.getDoPlantsRefReqsWarn());
        }
        finally {
            if (doTiming) {
                timing.inputPreProcess.stop();
            }
        }
        if (this.isTerminationRequested()) {
            return;
        }
        List continuousOpMisses = Lists.list();
        List continuousUsedBddNodes = Lists.list();
        BDDFactory factory = CifToBddConverter.createFactory((CifBddSettings)settings, (List)continuousOpMisses, (List)continuousUsedBddNodes);
        try {
            CifBddSpec cifBddSpec;
            if (dbgEnabled) {
                OutputProvider.dbg((String)"Converting CIF specification to internal format.");
            }
            CifToBddConverter converter1 = new CifToBddConverter("Data-based supervisory controller synthesis");
            if (doTiming) {
                timing.inputConvert.start();
            }
            try {
                cifBddSpec = converter1.convert(spec, (CifBddSettings)settings, factory);
            }
            finally {
                if (doTiming) {
                    timing.inputConvert.stop();
                }
            }
            if (this.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                OutputProvider.dbg((String)"Starting data-based synthesis.");
            }
            CifDataSynthesisResult synthResult = CifDataSynthesis.synthesize(cifBddSpec, settings, timing);
            if (this.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                OutputProvider.dbg((String)"Constructing output CIF specification.");
            }
            SynthesisToCifConverter converter2 = new SynthesisToCifConverter();
            if (doTiming) {
                timing.outputConvert.start();
            }
            try {
                rslt = converter2.convert(synthResult, spec);
            }
            finally {
                if (doTiming) {
                    timing.outputConvert.stop();
                }
            }
            if (this.isTerminationRequested()) {
                return;
            }
            BddUtils.printStats((BDDFactory)factory, (CifBddSettings)settings, (List)continuousOpMisses, (List)continuousUsedBddNodes, (String)settings.getContinuousPerformanceStatisticsFilePath(), (String)settings.getContinuousPerformanceStatisticsFileAbsPath());
            if (this.isTerminationRequested()) {
                return;
            }
        }
        finally {
            factory.done();
        }
        CifToolPostCheckEnv env = new CifToolPostCheckEnv(cifReader.getAbsDirPath(), "synthesized");
        try {
            new CifAnnotationsPostChecker((CifPostCheckEnv)env).check(spec);
        }
        catch (SemanticException cifBddSpec) {
            // empty catch block
        }
        env.throwUnsupportedExceptionIfAnyErrors("Supervisory controller synthesis failed.");
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".ctrlsys.cif");
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Writing output CIF file \"%s\".", (Object[])new Object[]{outPath});
        }
        outPath = Paths.resolve((String)outPath);
        if (doTiming) {
            timing.outputWrite.start();
        }
        try {
            CifWriter.writeCifSpec((Specification)rslt, (String)outPath, (String)cifReader.getAbsDirPath());
        }
        finally {
            if (doTiming) {
                timing.outputWrite.stop();
            }
        }
        if (this.isTerminationRequested()) {
            return;
        }
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifDataSynthesisApp.getGeneralOptionCategory();
        List bddOpts = Lists.list();
        bddOpts.add(Options.getInstance(BddOutputOption.class));
        bddOpts.add(Options.getInstance(BddOutputNamePrefixOption.class));
        bddOpts.add(Options.getInstance(BddVariableOrderOption.class));
        bddOpts.add(Options.getInstance(BddHyperEdgeAlgoOption.class));
        bddOpts.add(Options.getInstance(BddDcshVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddForceVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddSlidingWindowVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddSlidingWindowSizeOption.class));
        bddOpts.add(Options.getInstance(BddAdvancedVariableOrderOption.class));
        bddOpts.add(Options.getInstance(BddSimplifyOption.class));
        bddOpts.add(Options.getInstance(BddInitNodeTableSizeOption.class));
        bddOpts.add(Options.getInstance(BddOpCacheSizeOption.class));
        bddOpts.add(Options.getInstance(BddOpCacheRatioOption.class));
        bddOpts.add(Options.getInstance(BddDebugMaxNodesOption.class));
        bddOpts.add(Options.getInstance(BddDebugMaxPathsOption.class));
        OptionCategory bddCat = new OptionCategory("BDD", "BDD options.", Lists.list(), bddOpts);
        List synthOpts = Lists.list();
        synthOpts.add(Options.getInstance(InputFileOption.class));
        synthOpts.add(Options.getInstance(OutputFileOption.class));
        synthOpts.add(Options.getInstance(SupervisorNameOption.class));
        synthOpts.add(Options.getInstance(SupervisorNamespaceOption.class));
        synthOpts.add(Options.getInstance(ForwardReachOption.class));
        synthOpts.add(Options.getInstance(FixedPointComputationsOrderOption.class));
        synthOpts.add(Options.getInstance(EdgeGranularityOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderBackwardOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderForwardOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderDuplicateEventsOption.class));
        synthOpts.add(Options.getInstance(EdgeWorksetAlgoOption.class));
        synthOpts.add(Options.getInstance(StateReqInvEnforceOption.class));
        synthOpts.add(Options.getInstance(SynthesisStatisticsOption.class));
        synthOpts.add(Options.getInstance(ContinuousPerformanceStatisticsFileOption.class));
        synthOpts.add(Options.getInstance(EventWarnOption.class));
        synthOpts.add(Options.getInstance(PlantsRefReqsWarnOption.class));
        OptionCategory synthCat = new OptionCategory("Synthesis", "Synthesis options.", Lists.list((Object)bddCat), synthOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, synthCat});
        OptionCategory options = new OptionCategory("CIF Data-based Synthesis Options", "All options for the CIF data-based supervisory controller synthesis tool.", cats, Lists.list());
        return options;
    }
}

