/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.utils.CifBddApplyPlantInvariants;
import org.eclipse.escet.cif.bdd.utils.CifBddReachability;
import org.eclipse.escet.cif.bdd.workset.dependencies.BddBasedEdgeDependencySetCreator;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisResult;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisTiming;
import org.eclipse.escet.cif.datasynth.settings.BddSimplify;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettings;
import org.eclipse.escet.cif.datasynth.settings.FixedPointComputation;
import org.eclipse.escet.cif.datasynth.settings.StateReqInvEnforceMode;
import org.eclipse.escet.cif.datasynth.settings.SynthesisStatistics;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Stopwatch;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifDataSynthesis {
    private CifDataSynthesis() {
    }

    public static CifDataSynthesisResult synthesize(CifBddSpec cifBddSpec, CifDataSynthesisSettings settings, CifDataSynthesisTiming timing) {
        CifDataSynthesisResult synthResult = new CifDataSynthesisResult(cifBddSpec, settings);
        boolean doTiming = synthResult.settings.getSynthesisStatistics().contains((Object)SynthesisStatistics.TIMING);
        boolean doForward = synthResult.settings.getDoForwardReach();
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        Set<Event> disabledEvents = null;
        if (doTiming) {
            timing.preSynth.start();
        }
        try {
            List<CifBddEdge> restrictedEdges;
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return null;
            }
            CifDataSynthesis.checkSystem(cifBddSpec, synthResult, dbgEnabled);
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return null;
            }
            if (dbgEnabled && !(restrictedEdges = cifBddSpec.edges.stream().filter(e -> !e.origGuard.equals((Object)e.guard)).toList()).isEmpty()) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Restricting edge guards to prevent runtime errors:");
                restrictedEdges.forEach(e -> cifBddSpec.settings.getDebugOutput().line(e.toString(1, "Edge: ")));
            }
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return null;
            }
            CifBddApplyPlantInvariants.applyStateEvtExclPlantsInvs((CifBddSpec)cifBddSpec, (String)"uncontrolled system", () -> synthResult.getCtrlBehText(1), (boolean)dbgEnabled);
            for (CifBddEdge edge : cifBddSpec.edges) {
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return null;
                }
                edge.initApply();
            }
            if (!cifBddSpec.plantInv.isOne()) {
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return null;
                }
                CifBddApplyPlantInvariants.applyStatePlantInvs((CifBddSpec)cifBddSpec, (String)"uncontrolled system", (boolean)dbgEnabled);
            }
        }
        finally {
            if (doTiming) {
                timing.preSynth.stop();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkSystem(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            for (BDD bDD : cifBddSpec.plantInvsComps) {
                cifBddSpec.settings.getDebugOutput().line("Invariant (component state plant invariant): %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Invariant (components state plant inv):      %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.plantInvComps, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : cifBddSpec.plantInvsLocs) {
                cifBddSpec.settings.getDebugOutput().line("Invariant (location state plant invariant):  %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Invariant (locations state plant invariant): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.plantInvLocs, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Invariant (system state plant invariant):    %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.plantInv, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (cifBddSpec.plantInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no states (taking into account only the state plant invariants).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            for (BDD bDD : cifBddSpec.reqInvsComps) {
                cifBddSpec.settings.getDebugOutput().line("Invariant (component state req invariant):   %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Invariant (components state req invariant):  %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.reqInvComps, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : cifBddSpec.reqInvsLocs) {
                cifBddSpec.settings.getDebugOutput().line("Invariant (location state req invariant):    %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Invariant (locations state req invariant):   %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.reqInvLocs, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Invariant (system state req invariant):      %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.reqInv, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (cifBddSpec.reqInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The controlled system has no states (taking into account only the state requirement invariants).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            void var3_12;
            cifBddSpec.settings.getDebugOutput().line();
            boolean bl = false;
            while (var3_12 < cifBddSpec.variables.length) {
                CifBddVariable var = cifBddSpec.variables[var3_12];
                if (var instanceof CifBddDiscVariable) {
                    String nr = String.valueOf((int)var3_12);
                    cifBddSpec.settings.getDebugOutput().line("Initial   (discrete variable %s):%s%s", new Object[]{nr, Strings.spaces((int)(14 - nr.length())), BddUtils.bddToStr((BDD)((BDD)cifBddSpec.initialsVars.get((int)var3_12)), (CifBddSpec)cifBddSpec)});
                }
                ++var3_12;
            }
            cifBddSpec.settings.getDebugOutput().line("Initial   (discrete variables):              %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialVars, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : cifBddSpec.initialsComps) {
                cifBddSpec.settings.getDebugOutput().line("Initial   (component init predicate):        %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Initial   (components init predicate):       %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialComps, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : cifBddSpec.initialsLocs) {
                cifBddSpec.settings.getDebugOutput().line("Initial   (aut/locs init predicate):         %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Initial   (auts/locs init predicate):        %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialLocs, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Initial   (uncontrolled system):             %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initial, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Initial   (system, combined init/plant inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialPlantInv, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Initial   (system, combined init/state inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initialInv, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (cifBddSpec.initial.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no initial state (taking into account only initialization).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (!cifBddSpec.initial.isZero() && !cifBddSpec.plantInv.isZero() && cifBddSpec.initialPlantInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no initial state (taking into account only initialization and state plant invariants).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (!(cifBddSpec.initialPlantInv.isZero() || cifBddSpec.initial.isZero() || cifBddSpec.plantInv.isZero() || cifBddSpec.reqInv.isZero() || !cifBddSpec.initialInv.isZero())) {
            cifBddSpec.settings.getWarnOutput().line("The controlled system has no initial state (taking into account both initialization and state invariants).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            for (BDD bDD : cifBddSpec.markedsComps) {
                cifBddSpec.settings.getDebugOutput().line("Marked    (component marker predicate):      %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Marked    (components marker predicate):     %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedComps, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : cifBddSpec.markedsLocs) {
                cifBddSpec.settings.getDebugOutput().line("Marked    (aut/locs marker predicate):       %s", new Object[]{BddUtils.bddToStr((BDD)bDD, (CifBddSpec)cifBddSpec)});
            }
            cifBddSpec.settings.getDebugOutput().line("Marked    (auts/locs marker predicate):      %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedLocs, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Marked    (uncontrolled system):             %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.marked, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Marked    (system, combined mark/plant inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedPlantInv, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Marked    (system, combined mark/state inv): %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.markedInv, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (cifBddSpec.marked.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no marked state (taking into account only marking).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (!cifBddSpec.marked.isZero() && !cifBddSpec.plantInv.isZero() && cifBddSpec.markedPlantInv.isZero()) {
            cifBddSpec.settings.getWarnOutput().line("The uncontrolled system has no marked state (taking into account only marking and state plant invariants).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (!(cifBddSpec.markedPlantInv.isZero() || cifBddSpec.marked.isZero() || cifBddSpec.plantInv.isZero() || cifBddSpec.reqInv.isZero() || !cifBddSpec.markedInv.isZero())) {
            cifBddSpec.settings.getWarnOutput().line("The controlled system has no marked state (taking into account both marking and state invariants).");
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("State/event exclusion plants:");
            if (cifBddSpec.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                cifBddSpec.settings.getDebugOutput().line("  None");
            }
            for (Map.Entry entry : cifBddSpec.stateEvtExclPlantLists.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                cifBddSpec.settings.getDebugOutput().line("  Event \"%s\" needs:", new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
                for (BDD pred : (List)entry.getValue()) {
                    cifBddSpec.settings.getDebugOutput().line("    %s", new Object[]{BddUtils.bddToStr((BDD)pred, (CifBddSpec)cifBddSpec)});
                }
            }
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("State/event exclusion requirements:");
            if (cifBddSpec.stateEvtExclReqLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                cifBddSpec.settings.getDebugOutput().line("  None");
            }
            for (Map.Entry entry : cifBddSpec.stateEvtExclReqLists.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                cifBddSpec.settings.getDebugOutput().line("  Event \"%s\" needs:", new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
                for (BDD pred : (List)entry.getValue()) {
                    cifBddSpec.settings.getDebugOutput().line("    %s", new Object[]{BddUtils.bddToStr((BDD)pred, (CifBddSpec)cifBddSpec)});
                }
            }
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            if (cifBddSpec.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                cifBddSpec.settings.getDebugOutput().line("Uncontrolled system:");
            } else {
                cifBddSpec.settings.getDebugOutput().line("Uncontrolled system (state/event exclusion plants not applied yet):");
            }
            cifBddSpec.settings.getDebugOutput().line(synthResult.getCtrlBehText(1));
            if (!cifBddSpec.edges.isEmpty()) {
                cifBddSpec.settings.getDebugOutput().line(cifBddSpec.getEdgesText(2, true));
            }
        }
        boolean bl = synthResult.settings.getStateReqInvEnforceMode() == StateReqInvEnforceMode.ALL_CTRL_BEH;
        cifBddSpec.freeIntermediateBDDs(bl);
    }

    private static void applyStateReqInvs(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting behavior using state requirements.");
        }
        switch (synthResult.settings.getStateReqInvEnforceMode()) {
            case ALL_CTRL_BEH: {
                BDD newCtrlBeh = synthResult.ctrlBeh.and(cifBddSpec.reqInv);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                if (synthResult.ctrlBeh.equals((Object)newCtrlBeh)) {
                    newCtrlBeh.free();
                    break;
                }
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [state requirements: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)cifBddSpec.reqInv, (CifBddSpec)cifBddSpec)});
                }
                synthResult.ctrlBeh.free();
                synthResult.ctrlBeh = newCtrlBeh;
                break;
            }
            case PER_EDGE: {
                List reqInvs = Lists.concat((List)cifBddSpec.reqInvsComps, (List)cifBddSpec.reqInvsLocs);
                Function<CifBddEdge, Stream<BDD>> reqsPerEdge = edge -> reqInvs.stream().map(reqInv -> {
                    BDD updPred = reqInv.id();
                    if ((updPred = edge.apply(updPred, false, null)).isOne()) {
                        return updPred;
                    }
                    if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                        return updPred;
                    }
                    BDD guardAndReqInv = cifBddEdge.guard.and(reqInv);
                    BDD implication = guardAndReqInv.imp(updPred);
                    boolean skip = implication.isOne();
                    guardAndReqInv.free();
                    implication.free();
                    if (skip) {
                        updPred.free();
                        updPred = cifBddSpec.factory.one();
                    }
                    return updPred;
                });
                CifDataSynthesis.applyReqsPerEdge(cifBddSpec, synthResult, reqsPerEdge, true, dbgEnabled, "state");
                BDD newInitialCtrl = synthResult.initialCtrl.and(cifBddSpec.reqInv);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                if (synthResult.initialCtrl.equals((Object)newInitialCtrl)) {
                    newInitialCtrl.free();
                } else {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().line("Controlled initialization: %s -> %s [state requirements: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.initialCtrl, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newInitialCtrl, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)cifBddSpec.reqInv, (CifBddSpec)cifBddSpec)});
                    }
                    synthResult.initialCtrl.free();
                    synthResult.initialCtrl = newInitialCtrl;
                }
                for (BDD bdd : cifBddSpec.reqInvsComps) {
                    bdd.free();
                }
                for (BDD bdd : cifBddSpec.reqInvsLocs) {
                    bdd.free();
                }
                cifBddSpec.reqInvsComps = null;
                cifBddSpec.reqInvsLocs = null;
                break;
            }
            default: {
                throw new RuntimeException("Unknown mode: " + String.valueOf((Object)synthResult.settings.getStateReqInvEnforceMode()));
            }
        }
    }

    private static void applyVarRanges(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Extending controlled-behavior predicate using variable ranges.");
        }
        boolean firstDbg = true;
        boolean changed = false;
        CifBddVariable[] cifBddVariableArray = cifBddSpec.variables;
        int n = cifBddSpec.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable var = cifBddVariableArray[n2];
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            BDD range = BddUtils.getVarDomain((CifBddVariable)var, (boolean)false, (BDDFactory)cifBddSpec.factory);
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            BDD newCtrlBeh = synthResult.ctrlBeh.and(range);
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            if (synthResult.ctrlBeh.equals((Object)newCtrlBeh)) {
                newCtrlBeh.free();
                range.free();
            } else {
                if (dbgEnabled) {
                    if (firstDbg) {
                        firstDbg = false;
                        cifBddSpec.settings.getDebugOutput().line();
                    }
                    cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [range: %s, variable: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)range, (CifBddSpec)cifBddSpec), var.toString(0, "")});
                }
                range.free();
                synthResult.ctrlBeh.free();
                synthResult.ctrlBeh = newCtrlBeh;
                changed = true;
            }
            ++n2;
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled && changed) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Extended controlled-behavior predicate using variable ranges: %s.", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec)});
        }
    }

    private static void applyStateEvtExclReqs(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting behavior using state/event exclusion requirements.");
        }
        Function<CifBddEdge, Stream<BDD>> reqsPerEdge = edge -> {
            BDD req = (BDD)cifBddSpec.stateEvtExclReqs.get(edge.event);
            return req == null ? Stream.empty() : Stream.of(req);
        };
        CifDataSynthesis.applyReqsPerEdge(cifBddSpec, synthResult, reqsPerEdge, false, dbgEnabled, "state/event exclusion");
        for (BDD bdd : cifBddSpec.stateEvtExclReqs.values()) {
            bdd.free();
        }
        cifBddSpec.stateEvtExclReqs = null;
    }

    private static void applyRuntimeErrorReqs(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting behavior using implicit runtime error requirements.");
        }
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            if (edge.event.getControllable().booleanValue()) continue;
            BDD guardError = edge.origGuard.and(edge.error);
            BDD guardErrorNot = guardError.not();
            guardError.free();
            BDD newCtrlBeh = synthResult.ctrlBeh.and(guardErrorNot);
            if (!newCtrlBeh.equals((Object)synthResult.ctrlBeh)) {
                cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [runtime error requirement (event: %s): %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), edge.event.getName(), BddUtils.bddToStr((BDD)guardErrorNot, (CifBddSpec)cifBddSpec)});
            }
            guardErrorNot.free();
            synthResult.ctrlBeh.free();
            synthResult.ctrlBeh = newCtrlBeh;
        }
    }

    private static void applyReqsPerEdge(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, Function<CifBddEdge, Stream<BDD>> reqsPerEdge, boolean freeReqs, boolean dbgEnabled, String dbgDescription) {
        boolean firstDbg = true;
        boolean changed = false;
        boolean guardChanged = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            Stream<BDD> reqsStream = reqsPerEdge.apply(edge);
            Iterable reqsIterable = () -> reqsStream.iterator();
            for (BDD req : reqsIterable) {
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                if (req.isOne()) continue;
                if (edge.event.getControllable().booleanValue()) {
                    BDD newGuard = edge.guard.and(req);
                    if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                        return;
                    }
                    if (edge.guard.equals((Object)newGuard)) {
                        newGuard.free();
                    } else {
                        if (dbgEnabled) {
                            if (firstDbg) {
                                firstDbg = false;
                                cifBddSpec.settings.getDebugOutput().line();
                            }
                            cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s [%s requirement: %s].", new Object[]{edge.toString(0, ""), BddUtils.bddToStr((BDD)edge.guard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newGuard, (CifBddSpec)cifBddSpec), dbgDescription, BddUtils.bddToStr((BDD)req, (CifBddSpec)cifBddSpec)});
                        }
                        edge.guard.free();
                        edge.guard = newGuard;
                        changed = true;
                        guardChanged = true;
                    }
                } else {
                    BDD reqGood = edge.guard.imp(req);
                    if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                        return;
                    }
                    BDD newCtrlBeh = synthResult.ctrlBeh.id().andWith(reqGood);
                    if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                        return;
                    }
                    if (synthResult.ctrlBeh.equals((Object)newCtrlBeh)) {
                        newCtrlBeh.free();
                    } else {
                        if (dbgEnabled) {
                            if (firstDbg) {
                                firstDbg = false;
                                cifBddSpec.settings.getDebugOutput().line();
                            }
                            cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s [%s requirement: %s, edge: %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec), dbgDescription, BddUtils.bddToStr((BDD)req, (CifBddSpec)cifBddSpec), edge.toString(0, "")});
                        }
                        synthResult.ctrlBeh.free();
                        synthResult.ctrlBeh = newCtrlBeh;
                        changed = true;
                    }
                }
                if (!freeReqs) continue;
                req.free();
            }
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled && changed) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricted behavior using %s requirements:", new Object[]{dbgDescription});
            cifBddSpec.settings.getDebugOutput().line(synthResult.getCtrlBehText(1));
            if (guardChanged && !cifBddSpec.edges.isEmpty()) {
                cifBddSpec.settings.getDebugOutput().line(cifBddSpec.getEdgesText(2));
            }
        }
    }

    private static Set<Event> checkInputEdges(CifBddSpec cifBddSpec) {
        Set disabledEvents = Sets.setc((int)cifBddSpec.alphabet.size());
        for (Event event : cifBddSpec.alphabet) {
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return disabledEvents;
            }
            if (cifBddSpec.inputVarEvents.contains(event)) continue;
            if (cifBddSpec.eventEdges.get(event) == null) {
                disabledEvents.add(event);
                continue;
            }
            if (((BDD)cifBddSpec.stateEvtExclPlants.get(event)).isZero()) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion plants.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            if (event.getControllable().booleanValue() && ((BDD)cifBddSpec.stateEvtExclsReqInvs.get(event)).isZero()) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion requirements.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            if (((List)cifBddSpec.eventEdges.get(event)).stream().filter(edge -> !edge.origGuard.isZero()).count() == 0L) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account only automaton guards.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            boolean alwaysDisabled = true;
            for (CifBddEdge edge2 : (List)cifBddSpec.eventEdges.get(event)) {
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return disabledEvents;
                }
                BDD enabledExpression = edge2.guard.and(cifBddSpec.reqInv);
                if ((enabledExpression = enabledExpression.andWith(cifBddSpec.plantInv.id())).isZero()) continue;
                enabledExpression.free();
                alwaysDisabled = false;
                break;
            }
            if (!alwaysDisabled) continue;
            cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is never enabled in the input specification, taking into account automaton guards, prevention of runtime errors, and invariants.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            disabledEvents.add(event);
        }
        return disabledEvents;
    }

    private static void prepareWorksetAlgorithm(CifBddSpec cifBddSpec, boolean forwardEnabled, boolean dbgEnabled) {
        int edgeCnt;
        BddBasedEdgeDependencySetCreator creator = new BddBasedEdgeDependencySetCreator();
        creator.createAndStore(cifBddSpec, forwardEnabled);
        if (dbgEnabled && (edgeCnt = cifBddSpec.worksetDependenciesBackward.size()) > 0) {
            Object bitset;
            GridBox box;
            if (forwardEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Edge workset algorithm forward dependencies:");
                box = new GridBox(edgeCnt, 4, 0, 1);
                int i = 0;
                while (i < edgeCnt) {
                    bitset = (BitSet)cifBddSpec.worksetDependenciesForward.get(i);
                    box.set(i, 0, " -");
                    box.set(i, 1, Integer.toString(i + 1) + ":");
                    box.set(i, 2, CifTextUtils.getAbsName((PositionObject)((CifBddEdge)cifBddSpec.orderedEdgesForward.get((int)i)).event));
                    box.set(i, 3, BitSets.bitsetToStr((BitSet)bitset, (int)edgeCnt));
                    ++i;
                }
                for (String line : box.getLines()) {
                    cifBddSpec.settings.getDebugOutput().line(line);
                }
            }
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Edge workset algorithm backward dependencies:");
            box = new GridBox(edgeCnt, 4, 0, 1);
            int i = 0;
            while (i < edgeCnt) {
                bitset = (BitSet)cifBddSpec.worksetDependenciesBackward.get(i);
                box.set(i, 0, " -");
                box.set(i, 1, Integer.toString(i + 1) + ":");
                box.set(i, 2, CifTextUtils.getAbsName((PositionObject)((CifBddEdge)cifBddSpec.orderedEdgesBackward.get((int)i)).event));
                box.set(i, 3, BitSets.bitsetToStr((BitSet)bitset, (int)edgeCnt));
                ++i;
            }
            for (String line : box.getLines()) {
                cifBddSpec.settings.getDebugOutput().line(line);
            }
        }
    }

    private static void synthesizeFixedPoints(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean doForward, boolean dbgEnabled, boolean doTiming, CifDataSynthesisTiming timing) {
        List<FixedPointComputation> computationsInOrder = synthResult.settings.getFixedPointComputationsOrder().computations;
        if (!doForward) {
            computationsInOrder = computationsInOrder.stream().filter(c -> c != FixedPointComputation.REACH).toList();
        }
        int numberOfComputations = computationsInOrder.size();
        int round = 0;
        int stableCount = 0;
        block31: while (true) {
            ++round;
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Round %d: started.", new Object[]{round});
            }
            for (FixedPointComputation fixedPointComputation : computationsInOrder) {
                boolean changed;
                BDD newCtrlBeh;
                BDD reachabilityResult;
                boolean applyForward;
                BDD restriction;
                String restrictionName;
                String initName;
                String predName;
                BDD startPred = switch (fixedPointComputation) {
                    case FixedPointComputation.NONBLOCK -> cifBddSpec.marked.id();
                    case FixedPointComputation.CTRL -> synthResult.ctrlBeh.not();
                    case FixedPointComputation.REACH -> synthResult.initialCtrl.id();
                    default -> throw new IncompatibleClassChangeError();
                };
                if (fixedPointComputation == FixedPointComputation.CTRL && ((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                boolean inclUnctrl = true;
                boolean inclInputVars = true;
                boolean inclCtrl = switch (fixedPointComputation) {
                    case FixedPointComputation.NONBLOCK -> {
                        predName = "backward controlled-behavior";
                        initName = "marker";
                        restrictionName = "current/previous controlled-behavior";
                        restriction = synthResult.ctrlBeh;
                        applyForward = false;
                        yield true;
                    }
                    case FixedPointComputation.CTRL -> {
                        predName = "backward uncontrolled bad-state";
                        initName = "current/previous controlled behavior";
                        restrictionName = null;
                        restriction = null;
                        applyForward = false;
                        yield false;
                    }
                    case FixedPointComputation.REACH -> {
                        predName = "forward controlled-behavior";
                        initName = "initialization";
                        restrictionName = "current/previous controlled-behavior";
                        restriction = synthResult.ctrlBeh;
                        applyForward = true;
                        yield true;
                    }
                    default -> throw new RuntimeException("Unknown fixed-point computation: " + String.valueOf((Object)fixedPointComputation));
                };
                if (doTiming) {
                    Stopwatch stopwatch = switch (fixedPointComputation) {
                        case FixedPointComputation.NONBLOCK -> timing.mainBwMarked;
                        case FixedPointComputation.CTRL -> timing.mainBwBadState;
                        case FixedPointComputation.REACH -> timing.mainFwInit;
                        default -> throw new IncompatibleClassChangeError();
                    };
                    stopwatch.start();
                }
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Round %d: computing %s predicate.", new Object[]{round, predName});
                }
                try {
                    CifBddReachability reachability = new CifBddReachability(cifBddSpec, predName, initName, restrictionName, restriction, applyForward, inclCtrl, true, true, dbgEnabled);
                    reachabilityResult = reachability.performReachability(startPred);
                }
                catch (Throwable throwable) {
                    if (doTiming) {
                        Stopwatch stopwatch = switch (fixedPointComputation) {
                            case FixedPointComputation.NONBLOCK -> timing.mainBwMarked;
                            case FixedPointComputation.CTRL -> timing.mainBwBadState;
                            case FixedPointComputation.REACH -> timing.mainFwInit;
                            default -> throw new IncompatibleClassChangeError();
                        };
                        stopwatch.stop();
                    }
                    throw throwable;
                }
                if (doTiming) {
                    Stopwatch stopwatch = switch (fixedPointComputation) {
                        case FixedPointComputation.NONBLOCK -> timing.mainBwMarked;
                        case FixedPointComputation.CTRL -> timing.mainBwBadState;
                        case FixedPointComputation.REACH -> timing.mainFwInit;
                        default -> throw new IncompatibleClassChangeError();
                    };
                    stopwatch.stop();
                }
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                switch (fixedPointComputation) {
                    case NONBLOCK: 
                    case REACH: {
                        newCtrlBeh = reachabilityResult;
                        break;
                    }
                    case CTRL: {
                        newCtrlBeh = reachabilityResult.not();
                        reachabilityResult.free();
                        if (!((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) break;
                        return;
                    }
                    default: {
                        throw new RuntimeException("Unknown fixed-point computation: " + String.valueOf((Object)fixedPointComputation));
                    }
                }
                boolean unchanged = synthResult.ctrlBeh.equals((Object)newCtrlBeh);
                boolean bl = changed = !unchanged;
                if (unchanged) {
                    newCtrlBeh.free();
                    ++stableCount;
                } else {
                    if (dbgEnabled) {
                        cifBddSpec.settings.getDebugOutput().line("Controlled behavior: %s -> %s.", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newCtrlBeh, (CifBddSpec)cifBddSpec)});
                    }
                    synthResult.ctrlBeh.free();
                    synthResult.ctrlBeh = newCtrlBeh;
                    stableCount = 1;
                }
                BDD ctrlStates = synthResult.ctrlBeh.and(cifBddSpec.plantInv);
                boolean noCtrlStates = ctrlStates.isZero();
                ctrlStates.free();
                if (noCtrlStates) {
                    if (!dbgEnabled) break block31;
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Round %d: finished, all states are bad.", new Object[]{round});
                    break block31;
                }
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                if (stableCount == numberOfComputations) {
                    if (!dbgEnabled) break block31;
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Round %d: finished, controlled behavior is stable.", new Object[]{round});
                    break block31;
                }
                if (!changed || fixedPointComputation == FixedPointComputation.REACH) continue;
                BDD init = synthResult.initialCtrl.and(synthResult.ctrlBeh);
                boolean noInit = init.isZero();
                init.free();
                if (noInit) {
                    if (!dbgEnabled) break block31;
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Round %d: finished, no initialization possible.", new Object[]{round});
                    break block31;
                }
                if (!((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) continue;
                return;
            }
            if (!dbgEnabled) continue;
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Round %d: finished, need another round.", new Object[]{round});
        }
    }

    private static void determineCtrlSysGuards(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Computing controlled system guards.");
        }
        boolean guardUpdated = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (!edge.event.getControllable().booleanValue()) continue;
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            BDD updPred = synthResult.ctrlBeh.id();
            updPred = edge.apply(updPred, false, null);
            edge.cleanupApply();
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            BDD newGuard = edge.guard.id().andWith(updPred);
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                if (!guardUpdated) {
                    cifBddSpec.settings.getDebugOutput().line();
                }
                cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s.", new Object[]{edge.toString(0, ""), BddUtils.bddToStr((BDD)edge.guard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newGuard, (CifBddSpec)cifBddSpec)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardUpdated = true;
        }
    }

    private static void determineCtrlSysInit(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult) {
        synthResult.initialCtrl = synthResult.initialCtrl.andWith(synthResult.ctrlBeh.id());
        cifBddSpec.initialPlantInv.free();
        cifBddSpec.initialPlantInv = null;
    }

    private static boolean checkInitStatePresent(CifDataSynthesisResult synthResult) {
        boolean emptySup = synthResult.initialCtrl.isZero();
        return !emptySup;
    }

    private static void printNumberStates(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean emptySup, boolean doForward, boolean dbgEnabled) {
        boolean isExact;
        double nr;
        if (emptySup) {
            nr = 0.0;
        } else if (cifBddSpec.variables.length == 0) {
            Assert.check((synthResult.ctrlBeh.isZero() || synthResult.ctrlBeh.isOne() ? 1 : 0) != 0);
            nr = synthResult.ctrlBeh.isOne() ? 1 : 0;
        } else {
            nr = synthResult.ctrlBeh.satCount(cifBddSpec.varSetOld);
        }
        Assert.check((emptySup || nr > 0.0 ? 1 : 0) != 0);
        boolean bl = isExact = emptySup || doForward;
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
        }
        synthResult.settings.getNormalOutput().line("Controlled system: %s %,.0f state%s.", new Object[]{isExact ? "exactly" : "at most", nr, nr == 1.0 ? "" : "s"});
    }

    private static void determineOutputInitial(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Initial (synthesis result):            %s", new Object[]{BddUtils.bddToStr((BDD)synthResult.ctrlBeh, (CifBddSpec)cifBddSpec)});
            cifBddSpec.settings.getDebugOutput().line("Initial (uncontrolled system):         %s", new Object[]{BddUtils.bddToStr((BDD)cifBddSpec.initial, (CifBddSpec)cifBddSpec)});
            cifBddSpec.settings.getDebugOutput().line("Initial (controlled system):           %s", new Object[]{BddUtils.bddToStr((BDD)synthResult.initialCtrl, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        BDD initialRemoved = cifBddSpec.initial.id().andWith(synthResult.initialCtrl.not());
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        BDD initialAdded = initialRemoved.not();
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line("Initial (removed by supervisor):       %s", new Object[]{BddUtils.bddToStr((BDD)initialRemoved, (CifBddSpec)cifBddSpec)});
            cifBddSpec.settings.getDebugOutput().line("Initial (added by supervisor):         %s", new Object[]{BddUtils.bddToStr((BDD)initialAdded, (CifBddSpec)cifBddSpec)});
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        EnumSet<BddSimplify> simplifications = synthResult.settings.getBddSimplifications();
        List assumptionTxts = Lists.list();
        if (!initialRemoved.isZero()) {
            BDD extra;
            synthResult.initialOutput = synthResult.initialCtrl.id();
            BDD assumption = cifBddSpec.factory.one();
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            if (simplifications.contains((Object)BddSimplify.INITIAL_UNCTRL)) {
                assumptionTxts.add("uncontrolled system initialization predicates");
                extra = cifBddSpec.initial.id();
                assumption = assumption.andWith(extra);
            }
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            if (simplifications.contains((Object)BddSimplify.INITIAL_STATE_PLANT_INVS)) {
                assumptionTxts.add("state plant invariants");
                extra = cifBddSpec.plantInv.id();
                assumption = assumption.andWith(extra);
            }
            if (!assumptionTxts.isEmpty()) {
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                String assumptionsTxt = CifDataSynthesis.combineAssumptionTexts(assumptionTxts);
                BDD newInitial = synthResult.initialOutput.simplify(assumption);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                if (dbgEnabled && !synthResult.initialOutput.equals((Object)newInitial)) {
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Simplification of controlled system initialization predicate under the assumption of the %s:", new Object[]{assumptionsTxt});
                    cifBddSpec.settings.getDebugOutput().line("  Initial: %s -> %s [assume %s].", new Object[]{BddUtils.bddToStr((BDD)synthResult.initialOutput, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newInitial, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)assumption, (CifBddSpec)cifBddSpec)});
                }
                synthResult.initialOutput.free();
                synthResult.initialOutput = newInitial;
            }
            assumption.free();
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        synthResult.initialCtrl.free();
        cifBddSpec.initial.free();
        initialRemoved.free();
        initialAdded.free();
        synthResult.initialCtrl = null;
        cifBddSpec.initial = null;
    }

    private static Map<Event, BDD> determineGuards(CifBddSpec cifBddSpec, Set<Event> events, boolean useOrigGuards) {
        Map guards = Maps.mapc((int)events.size());
        for (Event event : events) {
            guards.put(event, cifBddSpec.factory.zero());
        }
        for (CifBddEdge cifBddEdge : cifBddSpec.edges) {
            if (!events.contains(cifBddEdge.event)) continue;
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return null;
            }
            BDD guard = (BDD)guards.get(cifBddEdge.event);
            guard = useOrigGuards ? guard.orWith(cifBddEdge.origGuard) : guard.orWith(cifBddEdge.guard);
            guards.put(cifBddEdge.event, guard);
        }
        return guards;
    }

    private static void checkOutputEdges(CifBddSpec cifBddSpec, Set<Event> disabledEvents, CifDataSynthesisResult synthResult, Map<Event, BDD> ctrlGuards) {
        Set uncontrollables = Sets.difference((Collection)cifBddSpec.alphabet, (Collection[])new Collection[]{cifBddSpec.controllables, cifBddSpec.inputVarEvents});
        Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(cifBddSpec, uncontrollables, false);
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(cifBddSpec, disabledEvents, synthResult, ctrlGuards);
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(cifBddSpec, disabledEvents, synthResult, unctrlGuards);
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        for (BDD bdd : unctrlGuards.values()) {
            bdd.free();
        }
    }

    private static void warnEventsDisabled(CifBddSpec cifBddSpec, Set<Event> disabledEvents, CifDataSynthesisResult synthResult, Map<Event, BDD> guards) {
        BDD ctrlBehPlantInv = synthResult.ctrlBeh.and(cifBddSpec.plantInv);
        for (Event event : guards.keySet()) {
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            BDD ctrlBehGuard = guards.get(event).and(ctrlBehPlantInv);
            if (ctrlBehGuard.isZero() && !disabledEvents.contains(event)) {
                cifBddSpec.settings.getWarnOutput().line("Event \"%s\" is disabled in the controlled system.", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                disabledEvents.add(event);
                continue;
            }
            ctrlBehGuard.free();
        }
        ctrlBehPlantInv.free();
    }

    private static void determineOutputGuards(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, Map<Event, BDD> ctrlGuards, boolean dbgEnabled) {
        BDD extra;
        BDD assumption;
        EnumSet<BddSimplify> simplifications = synthResult.settings.getBddSimplifications();
        List assumptionTxts = Lists.list();
        Map assumptions = Maps.mapc((int)cifBddSpec.controllables.size());
        for (Event controllable : cifBddSpec.controllables) {
            assumptions.put(controllable, cifBddSpec.factory.one());
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_PLANTS)) {
            assumptionTxts.add("plants");
            Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(cifBddSpec, cifBddSpec.controllables, true);
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            for (Event controllable : cifBddSpec.controllables) {
                BDD assumption2 = (BDD)assumptions.get(controllable);
                BDD extra2 = unctrlGuards.get(controllable);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                assumption2 = assumption2.andWith(extra2);
                assumptions.put(controllable, assumption2);
            }
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_REQ_AUTS)) {
            assumptionTxts.add("requirement automata");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = (BDD)cifBddSpec.stateEvtExclsReqAuts.get(controllable);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.stateEvtExclsReqAuts = null;
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_PLANT_INVS)) {
            assumptionTxts.add("state/event exclusion plant invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = (BDD)cifBddSpec.stateEvtExclPlants.get(controllable);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.stateEvtExclPlants = null;
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_REQ_INVS)) {
            assumptionTxts.add("state/event exclusion requirement invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = (BDD)cifBddSpec.stateEvtExclsReqInvs.get(controllable);
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.stateEvtExclsReqInvs = null;
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_STATE_PLANT_INVS)) {
            assumptionTxts.add("state plant invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = cifBddSpec.plantInv.id();
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.plantInv.free();
        cifBddSpec.plantInv = null;
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_STATE_REQ_INVS)) {
            assumptionTxts.add("state requirement invariants");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = cifBddSpec.reqInv.id();
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        cifBddSpec.reqInv.free();
        cifBddSpec.reqInv = null;
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_CTRL_BEH)) {
            assumptionTxts.add("controlled behavior");
            for (Event controllable : cifBddSpec.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = synthResult.ctrlBeh.id();
                if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        synthResult.ctrlBeh.free();
        synthResult.ctrlBeh = null;
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        synthResult.outputGuards = ctrlGuards;
        if (assumptionTxts.isEmpty()) {
            return;
        }
        if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
            return;
        }
        String assumptionsTxt = CifDataSynthesis.combineAssumptionTexts(assumptionTxts);
        CifDataSynthesis.simplifyOutputGuards(cifBddSpec, synthResult, dbgEnabled, assumptions, assumptionsTxt);
    }

    private static String combineAssumptionTexts(List<String> texts) {
        if (texts.size() == 0) {
            return "";
        }
        if (texts.size() == 1) {
            return texts.get(0);
        }
        StringBuilder txt = new StringBuilder();
        int i = 0;
        while (i < texts.size()) {
            if (i > 0) {
                if (texts.size() > 2) {
                    txt.append(",");
                }
                txt.append(" ");
            }
            if (i == texts.size() - 1) {
                txt.append("and ");
            }
            txt.append(texts.get(i));
            ++i;
        }
        return txt.toString();
    }

    private static void simplifyOutputGuards(CifBddSpec cifBddSpec, CifDataSynthesisResult synthResult, boolean dbgEnabled, Map<Event, BDD> assumptions, String assumptionsTxt) {
        boolean dbgPrinted = false;
        for (Event controllable : cifBddSpec.controllables) {
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            BDD guard = synthResult.outputGuards.get(controllable);
            BDD assumption = assumptions.get(controllable);
            BDD newGuard = assumption.isZero() && guard.isZero() ? cifBddSpec.factory.one() : guard.simplify(assumption);
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            synthResult.outputGuards.put(controllable, newGuard);
            if (dbgEnabled && !guard.equals((Object)newGuard)) {
                if (!dbgPrinted) {
                    dbgPrinted = true;
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("Simplification of controlled system under the assumption of the %s:", new Object[]{assumptionsTxt});
                }
                cifBddSpec.settings.getDebugOutput().line("  Event %s: guard: %s -> %s [assume %s].", new Object[]{CifTextUtils.getAbsName((PositionObject)controllable), BddUtils.bddToStr((BDD)guard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newGuard, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)assumption, (CifBddSpec)cifBddSpec)});
            }
            if (((Boolean)cifBddSpec.settings.getShouldTerminate().get()).booleanValue()) {
                return;
            }
            assumption.free();
            guard.free();
        }
    }
}

