/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.workset.dependencies;

import com.github.javabdd.BDD;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.workset.dependencies.EdgeDependencySetCreator;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class BddBasedEdgeDependencySetCreator
implements EdgeDependencySetCreator {
    @Override
    public void createAndStore(CifBddSpec cifBddSpec, boolean forwardEnabled) {
        int edgeCnt = cifBddSpec.edges.size();
        Map followEvents = Maps.mapc((int)edgeCnt);
        for (CifBddEdge precedingEdge : cifBddSpec.orderedEdgesForward) {
            Event precedingEvent = precedingEdge.event;
            BDD precedingEdgeReachableStates = precedingEdge.apply(cifBddSpec.factory.one(), true, null);
            for (CifBddEdge followingEdge : cifBddSpec.orderedEdgesForward) {
                Event followingEvent = followingEdge.event;
                if (precedingEvent == followingEvent) continue;
                BDD enabled = precedingEdgeReachableStates.and(followingEdge.guard);
                if (!enabled.isZero()) {
                    followEvents.computeIfAbsent(precedingEvent, e -> Sets.set()).add(followingEvent);
                }
                enabled.free();
            }
            precedingEdgeReachableStates.free();
        }
        cifBddSpec.worksetDependenciesBackward = this.create(followEvents, cifBddSpec.orderedEdgesBackward, false);
        if (forwardEnabled) {
            cifBddSpec.worksetDependenciesForward = this.create(followEvents, cifBddSpec.orderedEdgesForward, true);
        }
    }

    private List<BitSet> create(Map<Event, Set<Event>> followEvents, List<CifBddEdge> edges, boolean forward) {
        List dependencies = Lists.listc((int)edges.size());
        for (CifBddEdge edge1 : edges) {
            BitSet dependencies1 = new BitSet(edges.size());
            int i = 0;
            while (i < edges.size()) {
                CifBddEdge edge2 = edges.get(i);
                boolean isDependency = forward ? followEvents.computeIfAbsent(edge1.event, e -> Sets.set()).contains(edge2.event) : followEvents.computeIfAbsent(edge2.event, e -> Sets.set()).contains(edge1.event);
                if (isDependency) {
                    dependencies1.set(i);
                }
                ++i;
            }
            dependencies.add(dependencies1);
        }
        return dependencies;
    }
}

