/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.helper;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.varorder.graph.Graph;
import org.eclipse.escet.cif.bdd.varorder.graph.Node;
import org.eclipse.escet.cif.bdd.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.bdd.varorder.helper.RepresentationKind;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.HyperEdgeCreator;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.LegacyHyperEdgeCreator;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.LinearizedHyperEdgeCreator;
import org.eclipse.escet.cif.bdd.varorder.metrics.TotalSpanMetric;
import org.eclipse.escet.cif.bdd.varorder.metrics.WesMetric;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class VarOrderHelper {
    private final Specification spec;
    private final List<CifBddVariable> variables;
    private final DebugNormalOutput debugOutput;
    private final Map<CifBddVariable, Integer> origIndices;
    private final List<List<BitSet>> hyperEdges;
    private final List<Graph> graphs;
    private final List<Integer> metricLengthsTotalSpan = Lists.listc((int)RelationsKind.values().length);
    private final List<Integer> metricLengthsTotalSpanAvg = Lists.listc((int)RelationsKind.values().length);
    private final List<Integer> metricLengthsWes = Lists.listc((int)RelationsKind.values().length);
    private final List<Integer> metricLengthsWesAvg = Lists.listc((int)RelationsKind.values().length);

    public VarOrderHelper(Specification spec, List<CifBddVariable> variables, DebugNormalOutput debugOutput) {
        this.spec = spec;
        this.variables = Collections.unmodifiableList(variables);
        this.debugOutput = debugOutput;
        List<BitSet> legacyHyperEdges = this.createHyperEdges(new LegacyHyperEdgeCreator(spec, variables));
        List<BitSet> linearizedHyperEdges = this.createHyperEdges(new LinearizedHyperEdgeCreator(spec, variables));
        this.hyperEdges = Lists.list((Object[])new List[]{legacyHyperEdges, linearizedHyperEdges});
        Graph legacyGraph = this.createGraph(legacyHyperEdges);
        Graph linearizedGraph = this.createGraph(linearizedHyperEdges);
        this.graphs = Lists.list((Object[])new Graph[]{legacyGraph, linearizedGraph});
        this.origIndices = IntStream.range(0, variables.size()).boxed().collect(Collectors.toMap(i -> (CifBddVariable)variables.get((int)i), i -> i));
        for (List<BitSet> edges : this.hyperEdges) {
            int[] indices = this.getNewIndicesForVarOrder(variables);
            this.metricLengthsTotalSpan.add(Strings.fmt((String)"%,d", (Object[])new Object[]{TotalSpanMetric.compute(indices, edges)}).length() + 2);
            this.metricLengthsTotalSpanAvg.add(Strings.fmt((String)"%,.2f", (Object[])new Object[]{(double)TotalSpanMetric.compute(indices, edges) / (double)edges.size()}).length() + 2);
            this.metricLengthsWes.add(Strings.fmt((String)"%,.6f", (Object[])new Object[]{WesMetric.compute(indices, edges)}).length() + 2);
            this.metricLengthsWesAvg.add(Strings.fmt((String)"%,.6f", (Object[])new Object[]{WesMetric.compute(indices, edges) / (double)edges.size()}).length() + 2);
        }
    }

    public VarOrderHelper(VarOrderHelper helper, List<CifBddVariable> variables) {
        this(helper.spec, variables, helper.debugOutput);
    }

    public int size() {
        return this.variables.size();
    }

    private List<BitSet> createHyperEdges(HyperEdgeCreator creator) {
        List<BitSet> hyperEdges = creator.getHyperEdges();
        Assert.check((boolean)hyperEdges.stream().allMatch(edge -> !edge.isEmpty()));
        return Collections.unmodifiableList(hyperEdges);
    }

    public List<BitSet> getHyperEdges(RelationsKind relationsKind) {
        return this.hyperEdges.get(relationsKind.ordinal());
    }

    private Graph createGraph(List<BitSet> hyperEdges) {
        Map graphEdges = Maps.mapc((int)hyperEdges.size());
        for (BitSet edge : hyperEdges) {
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Iterator iterator2 = BitSets.iterateTrueBits((BitSet)edge, (int)(i + 1)).iterator();
                while (iterator2.hasNext()) {
                    int j = (Integer)iterator2.next();
                    graphEdges.merge(Pair.pair((Object)i, (Object)j), 1, (a, b) -> a + b);
                }
            }
        }
        Graph graph = new Graph(this.variables.size());
        for (Map.Entry graphEdge : graphEdges.entrySet()) {
            Node ni = graph.node((Integer)((Pair)graphEdge.getKey()).left);
            Node nj = graph.node((Integer)((Pair)graphEdge.getKey()).right);
            int weight = (Integer)graphEdge.getValue();
            ni.addEdge(nj, weight, true);
        }
        return graph;
    }

    public Graph getGraph(RelationsKind relationsKind) {
        return this.graphs.get(relationsKind.ordinal());
    }

    public void dbg() {
        this.debugOutput.line();
    }

    public void dbg(int dbgLevel, String msg, Object ... args) {
        this.debugOutput.line(Strings.spaces((int)(dbgLevel * 2)) + msg, args);
    }

    public void dbgRepresentation(int dbgLevel, RepresentationKind representationKind, RelationsKind relationsKind) {
        switch (representationKind) {
            case GRAPH: {
                this.dbg(dbgLevel, "Number of graph edges: %,d", this.getGraph(relationsKind).edgeCount());
                return;
            }
            case HYPER_EDGES: {
                this.dbg(dbgLevel, "Number of hyper-edges: %,d", this.getHyperEdges(relationsKind).size());
                return;
            }
        }
        throw new RuntimeException("Unknown representation: " + String.valueOf((Object)representationKind));
    }

    public void dbgMetricsForVarOrder(int dbgLevel, List<CifBddVariable> order, String annotation, RelationsKind relationsKind) {
        int[] newIndices = this.getNewIndicesForVarOrder(order);
        this.dbgMetricsForNewIndices(dbgLevel, newIndices, annotation, relationsKind);
    }

    public void dbgMetricsForNodeOrder(int dbgLevel, List<Node> order, String annotation, RelationsKind relationsKind) {
        int[] newIndices = this.getNewIndicesForNodeOrder(order);
        this.dbgMetricsForNewIndices(dbgLevel, newIndices, annotation, relationsKind);
    }

    public void dbgMetricsForNewIndices(int dbgLevel, int[] newIndices, String annotation, RelationsKind relationsKind) {
        String msg = this.fmtMetrics(newIndices, annotation, relationsKind);
        this.dbg(dbgLevel, msg, new Object[0]);
    }

    public String fmtMetrics(int[] newIndices, String annotation, RelationsKind relationsKind) {
        List<BitSet> hyperEdges = this.getHyperEdges(relationsKind);
        long totalSpan = TotalSpanMetric.compute(newIndices, hyperEdges);
        double wes = WesMetric.compute(newIndices, hyperEdges);
        String fmtTotalSpan = Strings.fmt((String)("%," + String.valueOf(this.metricLengthsTotalSpan.get(relationsKind.ordinal())) + "d"), (Object[])new Object[]{totalSpan});
        String fmtTotalSpanAvg = Strings.fmt((String)("%," + String.valueOf(this.metricLengthsTotalSpanAvg.get(relationsKind.ordinal())) + ".2f"), (Object[])new Object[]{(double)totalSpan / (double)hyperEdges.size()});
        String fmtWes = Strings.fmt((String)("%," + String.valueOf(this.metricLengthsWes.get(relationsKind.ordinal())) + ".6f"), (Object[])new Object[]{wes});
        String fmtWesAvg = Strings.fmt((String)("%," + String.valueOf(this.metricLengthsWesAvg.get(relationsKind.ordinal())) + ".6f"), (Object[])new Object[]{wes / (double)hyperEdges.size()});
        return Strings.fmt((String)"Total span: %s (total) %s (avg/edge) / WES: %s (total) %s (avg/edge) [%s]", (Object[])new Object[]{fmtTotalSpan, fmtTotalSpanAvg, fmtWes, fmtWesAvg, annotation});
    }

    public int[] getNewIndicesForVarOrder(List<CifBddVariable> order) {
        int[] newIndices = new int[order.size()];
        int i = 0;
        while (i < order.size()) {
            newIndices[this.origIndices.get((Object)order.get((int)i)).intValue()] = i;
            ++i;
        }
        return newIndices;
    }

    public int[] getNewIndicesForNodeOrder(List<Node> order) {
        int[] newIndices = new int[order.size()];
        int i = 0;
        while (i < order.size()) {
            newIndices[order.get((int)i).index] = i;
            ++i;
        }
        return newIndices;
    }

    public List<CifBddVariable> reorderForNodeOrder(List<Node> order) {
        int[] varOrder = this.getNewIndicesForNodeOrder(order);
        return this.reorderForNewIndices(varOrder);
    }

    public List<CifBddVariable> reorderForNewIndices(int[] newIndices) {
        Assert.areEqual((Object)this.variables.size(), (Object)newIndices.length);
        CifBddVariable[] result = new CifBddVariable[this.variables.size()];
        int i = 0;
        while (i < newIndices.length) {
            result[newIndices[i]] = this.variables.get(i);
            ++i;
        }
        return Arrays.asList(result);
    }
}

