/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.utils;

import com.github.javabdd.BDD;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.workset.pruners.MaxCardinalityEdgePruner;
import org.eclipse.escet.cif.bdd.workset.pruners.RewardBasedEdgePruner;
import org.eclipse.escet.cif.bdd.workset.pruners.SequentialEdgePruner;
import org.eclipse.escet.cif.bdd.workset.selectors.EdgeSelector;
import org.eclipse.escet.cif.bdd.workset.selectors.FirstEdgeSelector;
import org.eclipse.escet.cif.bdd.workset.selectors.PruningEdgeSelector;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;

public class CifBddReachability {
    private final CifBddSpec cifBddSpec;
    private final String predName;
    private final String initName;
    private final String restrictionName;
    private final BDD restriction;
    private final boolean forward;
    private final boolean ctrl;
    private final boolean unctrl;
    private final boolean inputVars;
    private final boolean dbgEnabled;

    public CifBddReachability(CifBddSpec cifBddSpec, String predName, String initName, String restrictionName, BDD restriction, boolean forward, boolean ctrl, boolean unctrl, boolean inputVars, boolean dbgEnabled) {
        Assert.areEqual((Object)(restrictionName == null ? 1 : 0), (Object)(restriction == null ? 1 : 0));
        this.cifBddSpec = cifBddSpec;
        this.predName = predName;
        this.initName = initName;
        this.restrictionName = restrictionName;
        this.restriction = restriction;
        this.forward = forward;
        this.ctrl = ctrl;
        this.unctrl = unctrl;
        this.inputVars = inputVars;
        this.dbgEnabled = dbgEnabled;
    }

    public BDD performReachability(BDD pred) {
        BitSet edgesToApplyMask;
        if (this.dbgEnabled) {
            this.cifBddSpec.settings.getDebugOutput().line("%s: %s [%s predicate]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), this.initName});
        }
        boolean changed = false;
        if (this.restriction != null) {
            BDD restrictedPred = pred.and(this.restriction);
            if (this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return null;
            }
            if (pred.equals((Object)restrictedPred)) {
                restrictedPred.free();
            } else {
                if (this.dbgEnabled) {
                    Assert.notNull((Object)this.restrictionName);
                    this.cifBddSpec.settings.getDebugOutput().line("%s: %s -> %s [restricted to %s predicate: %s]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), BddUtils.bddToStr(restrictedPred, this.cifBddSpec), this.restrictionName, BddUtils.bddToStr(this.restriction, this.cifBddSpec)});
                }
                pred.free();
                pred = restrictedPred;
                changed = true;
            }
        }
        boolean useWorkSetAlgo = this.cifBddSpec.settings.getDoUseEdgeWorksetAlgo();
        List<CifBddEdge> orderedEdges = this.forward ? this.cifBddSpec.orderedEdgesForward : this.cifBddSpec.orderedEdgesBackward;
        Predicate<CifBddEdge> edgeShouldBeApplied = e -> this.ctrl && e.event.getControllable() != false || this.unctrl && e.event.getControllable() == false && !e.isInputVarEdge() || this.inputVars && e.event.getControllable() == false && e.isInputVarEdge();
        List<CifBddEdge> edgesToApply = orderedEdges.stream().filter(edgeShouldBeApplied).toList();
        BitSet bitSet = edgesToApplyMask = useWorkSetAlgo ? (BitSet)IntStream.range(0, orderedEdges.size()).filter(i -> edgeShouldBeApplied.test((CifBddEdge)orderedEdges.get(i))).boxed().collect(BitSets.toBitSet()) : null;
        if (this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return null;
        }
        Pair<BDD, Boolean> reachabilityResult = useWorkSetAlgo ? this.performReachabilityWorkset(pred, orderedEdges, edgesToApplyMask) : this.performReachabilityFixedOrder(pred, edgesToApply);
        if (reachabilityResult == null || this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return null;
        }
        pred = (BDD)reachabilityResult.left;
        changed |= ((Boolean)reachabilityResult.right).booleanValue();
        if (this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return null;
        }
        if (this.dbgEnabled && changed) {
            this.cifBddSpec.settings.getDebugOutput().line("%s: %s [fixed point].", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec)});
        }
        return pred;
    }

    private Pair<BDD, Boolean> performReachabilityWorkset(BDD pred, List<CifBddEdge> edges, BitSet edgesMask) {
        boolean changed = false;
        List<BitSet> dependencies = this.forward ? this.cifBddSpec.worksetDependenciesForward : this.cifBddSpec.worksetDependenciesBackward;
        PruningEdgeSelector edgeSelector = new PruningEdgeSelector(new SequentialEdgePruner(new MaxCardinalityEdgePruner(dependencies), new RewardBasedEdgePruner(edges.size(), 1, -1)), new FirstEdgeSelector());
        BitSet workset = BitSets.copy((BitSet)edgesMask);
        while (!workset.isEmpty()) {
            BDD newPred;
            int edgeIdx = edgeSelector.select(workset);
            CifBddEdge edge = edges.get(edgeIdx);
            boolean changedByEdge = false;
            while (true) {
                BDD updPred = pred.id();
                updPred = edge.apply(updPred, this.forward, this.restriction);
                if (this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                    return null;
                }
                newPred = pred.id().orWith(updPred);
                if (this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                    return null;
                }
                if (pred.equals((Object)newPred)) break;
                if (this.dbgEnabled) {
                    String restrTxt;
                    if (this.restriction == null) {
                        restrTxt = "";
                    } else {
                        Assert.notNull((Object)this.restrictionName);
                        restrTxt = Strings.fmt((String)", restricted to %s predicate: %s", (Object[])new Object[]{this.restrictionName, BddUtils.bddToStr(this.restriction, this.cifBddSpec)});
                    }
                    this.cifBddSpec.settings.getDebugOutput().line("%s: %s -> %s [%s reach with edge: %s%s]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), BddUtils.bddToStr(newPred, this.cifBddSpec), this.forward ? "forward" : "backward", edge.toString(0, ""), restrTxt});
                }
                pred.free();
                pred = newPred;
                changed = true;
                changedByEdge = true;
            }
            newPred.free();
            if (changedByEdge) {
                BitSet dependents = BitSets.copy((BitSet)dependencies.get(edgeIdx));
                dependents.and(edgesMask);
                workset.or(dependents);
            }
            workset.clear(edgeIdx);
            ((EdgeSelector)edgeSelector).update(edgeIdx, changedByEdge);
        }
        return Pair.pair((Object)pred, (Object)changed);
    }

    private Pair<BDD, Boolean> performReachabilityFixedOrder(BDD pred, List<CifBddEdge> edges) {
        boolean changed = false;
        int iter = 0;
        int remainingEdges = edges.size();
        block0: while (remainingEdges > 0) {
            ++iter;
            if (this.dbgEnabled) {
                this.cifBddSpec.settings.getDebugOutput().line("%s reachability: iteration %d.", new Object[]{this.forward ? "Forward" : "Backward", iter});
            }
            for (CifBddEdge edge : edges) {
                BDD updPred = pred.id();
                updPred = edge.apply(updPred, this.forward, this.restriction);
                if (this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                    return null;
                }
                BDD newPred = pred.id().orWith(updPred);
                if (this.cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                    return null;
                }
                if (pred.equals((Object)newPred)) {
                    newPred.free();
                    if (--remainingEdges != 0) continue;
                    continue block0;
                }
                if (this.dbgEnabled) {
                    String restrTxt;
                    if (this.restriction == null) {
                        restrTxt = "";
                    } else {
                        Assert.notNull((Object)this.restrictionName);
                        restrTxt = Strings.fmt((String)", restricted to %s predicate: %s", (Object[])new Object[]{this.restrictionName, BddUtils.bddToStr(this.restriction, this.cifBddSpec)});
                    }
                    this.cifBddSpec.settings.getDebugOutput().line("%s: %s -> %s [%s reach with edge: %s%s]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), BddUtils.bddToStr(newPred, this.cifBddSpec), this.forward ? "forward" : "backward", edge.toString(0, ""), restrTxt});
                }
                pred.free();
                pred = newPred;
                changed = true;
                remainingEdges = edges.size();
            }
        }
        return Pair.pair((Object)pred, (Object)changed);
    }
}

