/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.utils;

import com.github.javabdd.BDD;
import java.util.function.Supplier;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.common.java.Strings;

public class CifBddApplyPlantInvariants {
    private CifBddApplyPlantInvariants() {
    }

    public static void applyStateEvtExclPlantsInvs(CifBddSpec cifBddSpec, String behaviorName, Supplier<String> sysBehTextSupplier, boolean dbgEnabled) {
        String sysBehText;
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting %s behavior using state/event exclusion plant invariants.", new Object[]{behaviorName});
        }
        boolean firstDbg = true;
        boolean guardChanged = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            BDD plant = cifBddSpec.stateEvtExclPlants.get(edge.event);
            if (plant == null || plant.isOne() || edge.guard.isZero()) continue;
            BDD newGuard = edge.guard.and(plant);
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                if (firstDbg) {
                    firstDbg = false;
                    cifBddSpec.settings.getDebugOutput().line();
                }
                cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s [plant: %s].", new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, cifBddSpec), BddUtils.bddToStr(newGuard, cifBddSpec), BddUtils.bddToStr(plant, cifBddSpec)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardChanged = true;
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return;
        }
        if (dbgEnabled && guardChanged && ((sysBehText = sysBehTextSupplier.get()) != null || !cifBddSpec.edges.isEmpty())) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("%s:", new Object[]{Strings.makeInitialUppercase((String)behaviorName)});
            if (sysBehText != null) {
                cifBddSpec.settings.getDebugOutput().line(sysBehText);
            }
            if (!cifBddSpec.edges.isEmpty()) {
                cifBddSpec.settings.getDebugOutput().line(cifBddSpec.getEdgesText(2));
            }
        }
    }

    public static void applyStatePlantInvs(CifBddSpec cifBddSpec, String behaviorName, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting %s behavior using state plant invariants.", new Object[]{behaviorName});
        }
        boolean guardUpdated = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            BDD updPred = cifBddSpec.plantInv.id();
            updPred = edge.apply(updPred, false, null);
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            BDD guardAndPlantInv = edge.guard.and(cifBddSpec.plantInv);
            BDD implication = guardAndPlantInv.imp(updPred);
            boolean skip = implication.isOne();
            guardAndPlantInv.free();
            implication.free();
            if (skip) {
                updPred.free();
                updPred = cifBddSpec.factory.one();
            }
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            BDD newGuard = edge.guard.id().andWith(updPred);
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                if (!guardUpdated) {
                    cifBddSpec.settings.getDebugOutput().line();
                }
                cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s.", new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, cifBddSpec), BddUtils.bddToStr(newGuard, cifBddSpec)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardUpdated = true;
        }
    }
}

