/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.utils;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDVarSet;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.escet.cif.bdd.conversion.BddToCif;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.CifBddStatistics;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FileSizes;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class BddUtils {
    private BddUtils() {
    }

    public static BDD free(BDD bdd) {
        if (bdd != null) {
            bdd.free();
        }
        return null;
    }

    public static List<BDD> free(List<BDD> bdds) {
        if (bdds != null) {
            for (BDD bdd : bdds) {
                if (bdd == null) continue;
                bdd.free();
            }
        }
        return null;
    }

    public static <K, V> Map<K, V> free(Map<K, V> map, Function<Map.Entry<K, V>, Collection<BDD>> getBddFunc) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Collection<BDD> bdds = getBddFunc.apply(entry);
                for (BDD bdd : bdds) {
                    if (bdd == null) continue;
                    bdd.free();
                }
            }
        }
        return null;
    }

    public static BDDVarSet free(BDDVarSet varSet) {
        if (varSet != null) {
            varSet.free();
        }
        return null;
    }

    public static int getMinimumBits(int value) {
        int count = 0;
        while (value > 0) {
            ++count;
            value >>= 1;
        }
        return count;
    }

    public static BDD getVarDomain(CifBddVariable variable, boolean newDomain, BDDFactory factory) {
        int min = variable.lower;
        int max = variable.upper;
        BDDDomain domain = newDomain ? variable.domainNew : variable.domain;
        BDD rslt = factory.zero();
        int i = min;
        while (i <= max) {
            rslt = rslt.orWith(domain.ithVar((long)i));
            ++i;
        }
        return rslt;
    }

    public static String bddToStr(BDD bdd, CifBddSpec cifBddSpec) {
        if (cifBddSpec.settings.getBddDebugMaxNodes() != null || cifBddSpec.settings.getBddDebugMaxPaths() != null) {
            boolean skip;
            int nc = bdd.nodeCount();
            double tpc = bdd.pathCount();
            boolean bl = skip = cifBddSpec.settings.getBddDebugMaxNodes() != null && nc > cifBddSpec.settings.getBddDebugMaxNodes() || cifBddSpec.settings.getBddDebugMaxPaths() != null && tpc > cifBddSpec.settings.getBddDebugMaxPaths();
            if (skip) {
                return Strings.fmt((String)"<bdd %,dn %,.0fp>", (Object[])new Object[]{nc, tpc});
            }
        }
        Expression pred = BddToCif.bddToCifPred(bdd, cifBddSpec);
        return CifTextUtils.exprToStr((Expression)pred);
    }

    public static void registerBddCallbacks(BDDFactory factory, boolean doGcStats, boolean doResizeStats, boolean doContinuousPerformanceStats, DebugNormalOutput normalOutput, List<Long> continuousOpMisses, List<Integer> continuousUsedBddNodes) {
        if (doGcStats && normalOutput.isEnabled()) {
            factory.registerGcStatsCallback((stats, pre) -> BddUtils.bddGcStatsCallback(stats, pre, normalOutput));
        }
        if (doResizeStats && normalOutput.isEnabled()) {
            factory.registerResizeStatsCallback((oldSize, newSize) -> BddUtils.bddResizeStatsCallback(oldSize, newSize, normalOutput));
        }
        if (doContinuousPerformanceStats) {
            factory.registerContinuousStatsCallback((n, o) -> {
                continuousOpMisses.add(o);
                continuousUsedBddNodes.add(n);
            });
        }
    }

    private static void bddGcStatsCallback(BDDFactory.GCStats stats, boolean pre, DebugNormalOutput normalOutput) {
        StringBuilder txt = new StringBuilder();
        txt.append("BDD ");
        txt.append(pre ? "pre " : "post");
        txt.append(" garbage collection: #");
        txt.append(Strings.fmt((String)"%,d", (Object[])new Object[]{stats.num + 1 - (pre ? 0 : 1)}));
        txt.append(", ");
        txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.freenodes}));
        txt.append(" of ");
        txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.nodes}));
        txt.append(" nodes free");
        if (!pre) {
            txt.append(", ");
            txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.time}));
            txt.append(" ms, ");
            txt.append(Strings.fmt((String)"%,13d", (Object[])new Object[]{stats.sumtime}));
            txt.append(" ms total");
        }
        normalOutput.line(txt.toString());
    }

    private static void bddResizeStatsCallback(int oldSize, int newSize, DebugNormalOutput normalOutput) {
        normalOutput.line("BDD node table resize: from %,13d nodes to %,13d nodes", new Object[]{oldSize, newSize});
    }

    public static void printStats(BDDFactory factory, CifBddSettings settings, List<Long> continuousOpMisses, List<Integer> continuousUsedBddNodes, String continuousPerformanceStatisticsFilePath, String continuousPerformanceStatisticsFileAbsPath) {
        boolean doCacheStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CACHE);
        boolean doContinuousPerformanceStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CONT);
        boolean doMaxBddNodesStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_MAX_NODES);
        boolean doMaxMemoryStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.MAX_MEMORY);
        if (doCacheStats) {
            BddUtils.printBddCacheStats(factory.getCacheStats(), settings.getNormalOutput());
        }
        if (doContinuousPerformanceStats) {
            settings.getDebugOutput().line("Writing continuous BDD performance statistics file \"%s\".", new Object[]{continuousPerformanceStatisticsFilePath});
            BddUtils.writeBddContinuousPerformanceStatsFile(continuousOpMisses, continuousUsedBddNodes, continuousPerformanceStatisticsFilePath, continuousPerformanceStatisticsFileAbsPath);
        }
        if (doMaxBddNodesStats) {
            BddUtils.printBddMaxUsedBddNodesStats(factory.getMaxUsedBddNodesStats(), settings.getNormalOutput());
        }
        if (doMaxMemoryStats) {
            BddUtils.printMaxMemoryStats(factory.getMaxMemoryStats(), settings.getNormalOutput());
        }
    }

    public static void printBddCacheStats(BDDFactory.CacheStats stats, DebugNormalOutput normalOutput) {
        GridBox grid = new GridBox(7, 2, 0, 1);
        grid.set(0, 0, "Node creation requests:");
        grid.set(1, 0, "Node creation chain accesses:");
        grid.set(2, 0, "Node creation cache hits:");
        grid.set(3, 0, "Node creation cache misses:");
        grid.set(4, 0, "Operation count:");
        grid.set(5, 0, "Operation cache hits:");
        grid.set(6, 0, "Operation cache misses:");
        grid.set(0, 1, Strings.str((Object)stats.uniqueAccess));
        grid.set(1, 1, Strings.str((Object)stats.uniqueChain));
        grid.set(2, 1, Strings.str((Object)stats.uniqueHit));
        grid.set(3, 1, Strings.str((Object)stats.uniqueMiss));
        grid.set(4, 1, Strings.str((Object)stats.opAccess));
        grid.set(5, 1, Strings.str((Object)stats.opHit));
        grid.set(6, 1, Strings.str((Object)stats.opMiss));
        normalOutput.line("BDD cache statistics:");
        for (String line : grid.getLines()) {
            normalOutput.line("  " + line);
        }
    }

    public static void printBddMaxUsedBddNodesStats(BDDFactory.MaxUsedBddNodesStats stats, DebugNormalOutput normalOutput) {
        normalOutput.line(Strings.fmt((String)"Maximum used BDD nodes: %d.", (Object[])new Object[]{stats.getMaxUsedBddNodes()}));
    }

    public static void printMaxMemoryStats(BDDFactory.MaxMemoryStats stats, DebugNormalOutput normalOutput) {
        long maxMemoryBytes = stats.getMaxMemoryBytes();
        normalOutput.line(Strings.fmt((String)"Maximum used memory: %d bytes = %s.", (Object[])new Object[]{maxMemoryBytes, FileSizes.formatFileSize((long)maxMemoryBytes, (boolean)false)}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeBddContinuousPerformanceStatsFile(List<Long> operationsSamples, List<Integer> nodesSamples, String filePath, String absFilePath) {
        Assert.notNull((Object)filePath);
        Assert.notNull((Object)absFilePath);
        Assert.areEqual((Object)operationsSamples.size(), (Object)nodesSamples.size());
        int numberOfDataPoints = operationsSamples.size();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(absFilePath));
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                        writer.write("Operations,Used BBD nodes");
                        writer.write(Strings.NL);
                        long lastOperations = -1L;
                        int lastNodes = -1;
                        int i = 0;
                        while (i < numberOfDataPoints) {
                            long nextOperations = operationsSamples.get(i);
                            int nextNodes = nodesSamples.get(i);
                            if (nextOperations != lastOperations || nextNodes != lastNodes) {
                                lastOperations = nextOperations;
                                lastNodes = nextNodes;
                                writer.write(Strings.fmt((String)"%d,%d", (Object[])new Object[]{lastOperations, lastNodes}));
                                writer.write(Strings.NL);
                            }
                            ++i;
                        }
                    }
                    if (stream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    ((OutputStream)stream).close();
                    throw throwable;
                }
                ((OutputStream)stream).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new InputOutputException(Strings.fmt((String)"Failed to write continuous BDD performance statistics file \"%s\".", (Object[])new Object[]{filePath}), (Throwable)e);
        }
    }
}

