/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.JFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.conversion.CifBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.CifBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.CifBddLocationPointerManager;
import org.eclipse.escet.cif.bdd.conversion.PlantsRefsReqsChecker;
import org.eclipse.escet.cif.bdd.settings.AllowNonDeterminism;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.CifBddStatistics;
import org.eclipse.escet.cif.bdd.settings.EdgeGranularity;
import org.eclipse.escet.cif.bdd.settings.EdgeOrderDuplicateEventAllowance;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddInputVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddLocPtrVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddTypedVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrder;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrderHelper;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;
import org.eclipse.escet.cif.bdd.varorder.parser.VarOrdererParser;
import org.eclipse.escet.cif.bdd.varorder.parser.VarOrdererTypeChecker;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.LinearizeProduct;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;

public class CifToBddConverter {
    private final String appName;
    private final Set<String> problems = Sets.set();
    private Map<Automaton, Monitors> originalMonitors;

    public CifToBddConverter(String appName) {
        this.appName = appName;
    }

    public static void preprocess(Specification spec, WarnOutput warnOutput, boolean doPlantsRefReqsWarn) {
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            warnOutput.line("The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new ElimComponentDefInst().transform(spec);
        if (doPlantsRefReqsWarn) {
            new PlantsRefsReqsChecker(warnOutput).checkPlantRefToRequirement(spec);
        }
    }

    public static BDDFactory createFactory(CifBddSettings settings, List<Long> continuousOpMisses, List<Integer> continuousUsedBddNodes) {
        double bddOpCacheRatio = settings.getBddOpCacheRatio();
        Integer bddOpCacheSize = settings.getBddOpCacheSize();
        if (bddOpCacheSize == null) {
            bddOpCacheSize = (int)((double)settings.getBddInitNodeTableSize() * bddOpCacheRatio);
            if (bddOpCacheSize < 2) {
                bddOpCacheSize = 2;
            }
        } else {
            bddOpCacheRatio = -1.0;
        }
        BDDFactory factory = JFactory.init((int)settings.getBddInitNodeTableSize(), (int)bddOpCacheSize);
        if (bddOpCacheRatio != -1.0) {
            factory.setCacheRatio(bddOpCacheRatio);
        }
        boolean doGcStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_GC_COLLECT);
        boolean doResizeStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_GC_RESIZE);
        boolean doContinuousPerformanceStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CONT);
        BddUtils.registerBddCallbacks(factory, doGcStats, doResizeStats, doContinuousPerformanceStats, settings.getNormalOutput(), continuousOpMisses, continuousUsedBddNodes);
        boolean doCacheStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_CACHE);
        boolean doMaxBddNodesStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.BDD_PERF_MAX_NODES);
        boolean doMaxMemoryStats = settings.getCifBddStatistics().contains((Object)CifBddStatistics.MAX_MEMORY);
        if (doCacheStats || doContinuousPerformanceStats) {
            factory.getCacheStats().enableMeasurements();
        }
        if (doMaxBddNodesStats) {
            factory.getMaxUsedBddNodesStats().enableMeasurements();
        }
        if (doMaxMemoryStats) {
            factory.getMaxMemoryStats().enableMeasurements();
        }
        return factory;
    }

    public CifBddSpec convert(Specification spec, CifBddSettings settings, BDDFactory factory) {
        CifBddSpec cifBddSpec = this.convertSpec(spec, settings, factory);
        if (this.problems.isEmpty()) {
            return cifBddSpec;
        }
        String msg = Strings.fmt((String)"%s failed due to unsatisfied preconditions:\n - ", (Object[])new Object[]{this.appName}) + String.join((CharSequence)"\n - ", Sets.sortedstrings(this.problems));
        throw new UnsupportedException(msg);
    }

    private CifBddSpec convertSpec(Specification spec, CifBddSettings settings, BDDFactory factory) {
        CifEventUtils.Alphabets alphabets;
        CifBddSpec cifBddSpec = new CifBddSpec(settings);
        cifBddSpec.factory = factory;
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        List events = Lists.list();
        CifToBddConverter.collectEvents((ComplexComponent)spec, events);
        for (Event event : events) {
            if (event.getControllable() != null) continue;
            String msg = Strings.fmt((String)"Unsupported event \"%s\": event is not declared as controllable or uncontrollable.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            this.problems.add(msg);
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        List automata = Lists.list();
        CifToBddConverter.collectAutomata((ComplexComponent)spec, automata);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        List plants = Lists.list();
        List requirements = Lists.list();
        for (Automaton cifAut : automata) {
            switch (cifAut.getKind()) {
                case PLANT: {
                    plants.add(cifAut);
                    break;
                }
                case REQUIREMENT: {
                    requirements.add(cifAut);
                    break;
                }
                default: {
                    String msg = Strings.fmt((String)"Unsupported automaton \"%s\": only plant and requirement automata are supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)cifAut)});
                    this.problems.add(msg);
                }
            }
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        if (plants.isEmpty()) {
            String msg = "Unsupported specification: no plant automata found.";
            this.problems.add(msg);
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        automata = Lists.concat((List)plants, (List)requirements);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        List plantAlphabets = Lists.listc((int)plants.size());
        List reqAlphabets = Lists.listc((int)requirements.size());
        Set plantAlphabet = Sets.set();
        Set reqAlphabet = Sets.set();
        for (Automaton plant : plants) {
            alphabets = CifEventUtils.getAllAlphabets((Automaton)plant, null);
            plantAlphabets.add(alphabets);
            plantAlphabet.addAll(alphabets.syncAlphabet);
            plantAlphabet.addAll(alphabets.sendAlphabet);
            plantAlphabet.addAll(alphabets.recvAlphabet);
        }
        for (Automaton req : requirements) {
            alphabets = CifEventUtils.getAllAlphabets((Automaton)req, null);
            reqAlphabets.add(alphabets);
            reqAlphabet.addAll(alphabets.syncAlphabet);
            reqAlphabet.addAll(alphabets.sendAlphabet);
            reqAlphabet.addAll(alphabets.recvAlphabet);
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.alphabet = Sets.union((Set)plantAlphabet, (Set)reqAlphabet);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        int i = 0;
        while (i < requirements.size()) {
            Set commEvents = Sets.union((Set)((CifEventUtils.Alphabets)reqAlphabets.get((int)i)).sendAlphabet, (Set)((CifEventUtils.Alphabets)reqAlphabets.get((int)i)).recvAlphabet);
            if (!commEvents.isEmpty()) {
                List names = Lists.listc((int)commEvents.size());
                Iterator iterator = commEvents.iterator();
                while (iterator.hasNext()) {
                    Event extra = (Event)iterator.next();
                    names.add("\"" + CifTextUtils.getAbsName((PositionObject)extra) + "\"");
                }
                String msg = Strings.fmt((String)"Unsupported %s: requirement uses channel%s: %s.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)((ComplexComponent)requirements.get(i))), commEvents.size() == 1 ? "" : "s", String.join((CharSequence)", ", names)});
                this.problems.add(msg);
            }
            ++i;
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.controllables = Sets.set();
        for (Event event : cifBddSpec.alphabet) {
            if (event.getControllable() == null || !event.getControllable().booleanValue()) continue;
            cifBddSpec.controllables.add(event);
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        List cifVarObjs = Lists.list();
        CifToBddConverter.collectVariableObjects((ComplexComponent)spec, cifVarObjs);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        List lpAuts = Lists.filter((List)cifVarObjs, Automaton.class);
        CifBddLocationPointerManager locPtrManager = new CifBddLocationPointerManager(lpAuts);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.variables = new CifBddVariable[cifVarObjs.size()];
        int i2 = 0;
        while (i2 < cifBddSpec.variables.length) {
            PositionObject positionObject = (PositionObject)cifVarObjs.get(i2);
            if (positionObject instanceof Automaton) {
                Automaton lpAut = (Automaton)positionObject;
                DiscVariable lpVar = locPtrManager.getLocationPointer(lpAut);
                cifBddSpec.variables[i2] = this.createLpVar(lpAut, lpVar);
            } else {
                cifBddSpec.variables[i2] = this.convertTypedVar((Declaration)positionObject);
            }
            ++i2;
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.orderVars(cifBddSpec, spec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.createVarDomains(cifBddSpec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.createUpdateAuxiliaries(cifBddSpec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.initialsVars = Lists.listc((int)cifBddSpec.variables.length);
        int i3 = 0;
        while (i3 < cifBddSpec.variables.length) {
            cifBddSpec.initialsVars.add(null);
            ++i3;
        }
        cifBddSpec.initialsComps = Lists.list();
        cifBddSpec.initialsLocs = Lists.list();
        cifBddSpec.initialVars = cifBddSpec.factory.one();
        cifBddSpec.initialComps = cifBddSpec.factory.one();
        cifBddSpec.initialLocs = cifBddSpec.factory.one();
        this.convertInit((ComplexComponent)spec, cifBddSpec, locPtrManager);
        BDD initialCompsAndLocs = cifBddSpec.initialComps.and(cifBddSpec.initialLocs);
        cifBddSpec.initial = cifBddSpec.initialVars.and(initialCompsAndLocs);
        initialCompsAndLocs.free();
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.markedsComps = Lists.list();
        cifBddSpec.markedsLocs = Lists.list();
        cifBddSpec.markedComps = cifBddSpec.factory.one();
        cifBddSpec.markedLocs = cifBddSpec.factory.one();
        this.convertMarked((ComplexComponent)spec, cifBddSpec, locPtrManager);
        cifBddSpec.marked = cifBddSpec.markedComps.and(cifBddSpec.markedLocs);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.plantInvsComps = Lists.list();
        cifBddSpec.plantInvsLocs = Lists.list();
        cifBddSpec.plantInvComps = cifBddSpec.factory.one();
        cifBddSpec.plantInvLocs = cifBddSpec.factory.one();
        cifBddSpec.reqInvsComps = Lists.list();
        cifBddSpec.reqInvsLocs = Lists.list();
        cifBddSpec.reqInvComps = cifBddSpec.factory.one();
        cifBddSpec.reqInvLocs = cifBddSpec.factory.one();
        this.convertStateInvs((ComplexComponent)spec, cifBddSpec, locPtrManager);
        cifBddSpec.plantInv = cifBddSpec.plantInvComps.and(cifBddSpec.plantInvLocs);
        cifBddSpec.reqInv = cifBddSpec.reqInvComps.and(cifBddSpec.reqInvLocs);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.initialPlantInv = cifBddSpec.initial.and(cifBddSpec.plantInv);
        cifBddSpec.initialInv = cifBddSpec.initialPlantInv.and(cifBddSpec.reqInv);
        cifBddSpec.markedPlantInv = cifBddSpec.marked.and(cifBddSpec.plantInv);
        cifBddSpec.markedInv = cifBddSpec.markedPlantInv.and(cifBddSpec.reqInv);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        cifBddSpec.stateEvtExclPlants = Maps.mapc((int)cifBddSpec.alphabet.size());
        cifBddSpec.stateEvtExclPlantLists = Maps.mapc((int)cifBddSpec.alphabet.size());
        for (Event event : cifBddSpec.alphabet) {
            cifBddSpec.stateEvtExclPlants.put(event, cifBddSpec.factory.one());
            cifBddSpec.stateEvtExclPlantLists.put(event, Lists.list());
        }
        cifBddSpec.stateEvtExclsReqAuts = Maps.mapc((int)cifBddSpec.controllables.size());
        cifBddSpec.stateEvtExclsReqInvs = Maps.mapc((int)cifBddSpec.controllables.size());
        for (Event event : cifBddSpec.controllables) {
            cifBddSpec.stateEvtExclsReqAuts.put(event, cifBddSpec.factory.one());
            cifBddSpec.stateEvtExclsReqInvs.put(event, cifBddSpec.factory.one());
        }
        cifBddSpec.stateEvtExclReqs = Maps.mapc((int)cifBddSpec.alphabet.size());
        cifBddSpec.stateEvtExclReqLists = Maps.mapc((int)cifBddSpec.alphabet.size());
        for (Event event : cifBddSpec.alphabet) {
            cifBddSpec.stateEvtExclReqs.put(event, cifBddSpec.factory.one());
            cifBddSpec.stateEvtExclReqLists.put(event, Lists.list());
        }
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.convertStateEvtExclInvs((ComplexComponent)spec, cifBddSpec, locPtrManager);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.preconvertReqAuts(requirements, reqAlphabets, cifBddSpec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.convertPlantReqAuts(plants, requirements, plantAlphabets, reqAlphabets, locPtrManager, cifBddSpec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        for (Map.Entry entry : this.originalMonitors.entrySet()) {
            ((Automaton)entry.getKey()).setMonitors((Monitors)entry.getValue());
        }
        this.originalMonitors = null;
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.addInputVariableEdges(cifBddSpec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.mergeEdges(cifBddSpec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.orderEdges(cifBddSpec);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        this.checkEdgeWorksetAlgorithmSettings(cifBddSpec.settings);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return cifBddSpec;
        }
        return cifBddSpec;
    }

    private CifBddVariable convertTypedVar(Declaration var) {
        int upper;
        int lower;
        int count;
        CifType type;
        if (var instanceof DiscVariable) {
            type = ((DiscVariable)var).getType();
        } else if (var instanceof InputVariable) {
            type = ((InputVariable)var).getType();
        } else {
            throw new RuntimeException("Unexpected variable: " + String.valueOf(var));
        }
        type = CifTypeUtils.normalizeType((CifType)type);
        if (type instanceof BoolType) {
            count = 2;
            lower = 0;
            upper = 1;
        } else if (type instanceof IntType) {
            IntType intType = (IntType)type;
            if (CifTypeUtils.isRangeless((IntType)intType)) {
                String msg = Strings.fmt((String)"Unsupported variable \"%s\": variables with rangeless integer types are not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
                this.problems.add(msg);
                return null;
            }
            lower = intType.getLower();
            upper = intType.getUpper();
            if (lower < 0) {
                String msg = Strings.fmt((String)"Unsupported variable \"%s\": variables with integer type ranges that include negative values are not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
                this.problems.add(msg);
                return null;
            }
            count = upper - lower + 1;
        } else if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            count = enumDecl.getLiterals().size();
            lower = 0;
            upper = count - 1;
        } else {
            String msg = Strings.fmt((String)"Unsupported variable \"%s\": variables of type \"%s\" are not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var), CifTextUtils.typeToStr((CifType)type)});
            this.problems.add(msg);
            return null;
        }
        if (var instanceof DiscVariable) {
            DiscVariable discVar = (DiscVariable)var;
            return new CifBddDiscVariable(discVar, type, count, lower, upper);
        }
        if (var instanceof InputVariable) {
            InputVariable inputVar = (InputVariable)var;
            return new CifBddInputVariable(inputVar, type, count, lower, upper);
        }
        throw new RuntimeException("Unexpected variable: " + String.valueOf(var));
    }

    private CifBddVariable createLpVar(Automaton aut, DiscVariable var) {
        int count = aut.getLocations().size();
        Assert.check((count > 1 ? 1 : 0) != 0);
        return new CifBddLocPtrVariable(aut, var);
    }

    private void orderVars(CifBddSpec cifBddSpec, Specification spec) {
        List parseResult;
        if (Arrays.asList(cifBddSpec.variables).contains(null)) {
            return;
        }
        String varOrderTxt = cifBddSpec.settings.getBddVarOrderAdvanced();
        try {
            parseResult = (List)new VarOrdererParser().parseString(varOrderTxt, "/in-memory.varorder", null, DebugMode.NONE);
        }
        catch (SyntaxException ex) {
            throw new InvalidOptionException("Invalid BDD variable ordering configuration.", (Throwable)ex);
        }
        VarOrdererTypeChecker typeChecker = new VarOrdererTypeChecker(Arrays.asList(cifBddSpec.variables), cifBddSpec.settings);
        VarOrderer varOrderer = (VarOrderer)typeChecker.typeCheck(parseResult);
        Assert.check((!typeChecker.hasWarning() ? 1 : 0) != 0);
        if (varOrderer == null) {
            Assert.check((boolean)typeChecker.hasError());
            Assert.check((typeChecker.getProblems().size() == 1 ? 1 : 0) != 0);
            InvalidOptionException ex = new InvalidOptionException(((SemanticProblem)typeChecker.getProblems().get(0)).toString());
            throw new InvalidOptionException("Invalid BDD variable ordering configuration.", (Throwable)ex);
        }
        int varCnt = cifBddSpec.variables.length;
        if (varCnt == 0) {
            return;
        }
        int i = 0;
        while (i < cifBddSpec.variables.length) {
            cifBddSpec.variables[i].group = i;
            ++i;
        }
        boolean dbgEnabled = cifBddSpec.settings.getDebugOutput().isEnabled();
        if (dbgEnabled) {
            CifToBddConverter.debugCifVars(cifBddSpec);
        }
        if (cifBddSpec.variables.length < 2) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line();
                cifBddSpec.settings.getDebugOutput().line("Skipping variable ordering: only one variable present.");
                cifBddSpec.settings.getDebugOutput().line();
            }
            return;
        }
        List<CifBddVariable> varsInModelOrder = Collections.unmodifiableList(Arrays.asList(cifBddSpec.variables));
        VarOrderHelper helper = new VarOrderHelper(spec, varsInModelOrder, cifBddSpec.settings.getDebugOutput());
        VarOrder curOrder = VarOrder.createFromOrderedVars(varsInModelOrder);
        List<CifBddVariable> varsInCurOrder = curOrder.getOrderedVars();
        VarOrdererData data = new VarOrdererData(varsInModelOrder, curOrder, helper);
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Applying variable ordering:");
        }
        VarOrdererData orderingResult = varOrderer.order(data, dbgEnabled, 1);
        VarOrder newOrder = orderingResult.varOrder;
        List<CifBddVariable> varsInNewOrder = newOrder.getOrderedVars();
        Assert.check((boolean)curOrder.getVarOrder().stream().allMatch(grp -> !grp.isEmpty()));
        Assert.check((boolean)newOrder.getVarOrder().stream().allMatch(grp -> !grp.isEmpty()));
        Assert.areEqual((Object)varsInCurOrder.size(), (Object)Sets.list2set(varsInCurOrder).size());
        Assert.areEqual((Object)varsInNewOrder.size(), (Object)Sets.list2set(varsInNewOrder).size());
        Assert.areEqual((Object)varsInCurOrder.size(), (Object)varsInNewOrder.size());
        Assert.areEqual((Object)Sets.list2set(varsInCurOrder), (Object)Sets.list2set(varsInNewOrder));
        cifBddSpec.variables = (CifBddVariable[])varsInNewOrder.toArray(CifBddVariable[]::new);
        int i2 = 0;
        while (i2 < newOrder.getVarOrder().size()) {
            List<CifBddVariable> group = newOrder.getVarOrder().get(i2);
            for (CifBddVariable var : group) {
                var.group = i2;
            }
            ++i2;
        }
        if (dbgEnabled) {
            boolean orderChanged = !curOrder.equals(newOrder);
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Variable order %schanged.", new Object[]{orderChanged ? "" : "un"});
            if (orderChanged) {
                CifToBddConverter.debugCifVars(cifBddSpec);
            }
            cifBddSpec.settings.getDebugOutput().line();
        }
    }

    private static void debugCifVars(CifBddSpec cifBddSpec) {
        int cifVarCnt = cifBddSpec.variables.length;
        GridBox grid = new GridBox(cifVarCnt + 4, 9, 0, 2);
        grid.set(0, 0, "Nr");
        grid.set(0, 1, "Kind");
        grid.set(0, 2, "Type");
        grid.set(0, 3, "Name");
        grid.set(0, 4, "Group");
        grid.set(0, 5, "BDD vars");
        grid.set(0, 6, "CIF values");
        grid.set(0, 7, "BDD values");
        grid.set(0, 8, "Values used");
        Set groups = Sets.set();
        int totalBddVarCnt = 0;
        int totalUsedCnt = 0;
        int totalReprCnt = 0;
        int i = 0;
        while (i < cifVarCnt) {
            CifBddVariable var = cifBddSpec.variables[i];
            String typeTxt = var.getTypeText();
            if (typeTxt == null) {
                typeTxt = "n/a";
            }
            int bddCnt = var.getBddVarCount();
            int usedCnt = var.count;
            int reprCnt = 1 << bddCnt;
            grid.set(i + 2, 0, Strings.str((Object)(i + 1)));
            grid.set(i + 2, 1, var.getKindText());
            grid.set(i + 2, 2, typeTxt);
            grid.set(i + 2, 3, var.name);
            grid.set(i + 2, 4, Strings.str((Object)var.group));
            grid.set(i + 2, 5, Strings.str((Object)bddCnt) + " * 2");
            grid.set(i + 2, 6, Strings.str((Object)usedCnt) + " * 2");
            grid.set(i + 2, 7, Strings.str((Object)reprCnt) + " * 2");
            grid.set(i + 2, 8, CifToBddConverter.getPercentageText(usedCnt, reprCnt));
            groups.add(var.group);
            totalBddVarCnt += bddCnt * 2;
            totalUsedCnt += usedCnt * 2;
            totalReprCnt += reprCnt * 2;
            ++i;
        }
        grid.set(cifVarCnt + 3, 0, "Total");
        grid.set(cifVarCnt + 3, 1, "");
        grid.set(cifVarCnt + 3, 2, "");
        grid.set(cifVarCnt + 3, 3, "");
        grid.set(cifVarCnt + 3, 4, Strings.str((Object)groups.size()));
        grid.set(cifVarCnt + 3, 5, Strings.str((Object)totalBddVarCnt));
        grid.set(cifVarCnt + 3, 6, Strings.str((Object)totalUsedCnt));
        grid.set(cifVarCnt + 3, 7, Strings.str((Object)totalReprCnt));
        grid.set(cifVarCnt + 3, 8, CifToBddConverter.getPercentageText(totalUsedCnt, totalReprCnt));
        GridBox.GridBoxLayout layout = grid.computeLayout();
        int i2 = 0;
        while (i2 < layout.numCols) {
            String bar = Strings.duplicate((String)"-", (int)layout.widths[i2]);
            grid.set(1, i2, bar);
            grid.set(cifVarCnt + 2, i2, bar);
            ++i2;
        }
        cifBddSpec.settings.getDebugOutput().line();
        cifBddSpec.settings.getDebugOutput().line("CIF variables and location pointers:");
        for (String line : grid.getLines()) {
            cifBddSpec.settings.getDebugOutput().line("  " + line);
        }
    }

    private static String getPercentageText(int part, int total) {
        double percentage = 100.0 * (double)part / (double)total;
        if (Double.isNaN(percentage)) {
            return "n/a";
        }
        Object txt = Strings.fmt((String)"%.0f", (Object[])new Object[]{percentage});
        if ((double)((int)Math.floor(percentage)) != percentage) {
            txt = "~" + (String)txt;
        }
        txt = (String)txt + "%";
        return txt;
    }

    private void createVarDomains(CifBddSpec cifBddSpec) {
        CifBddVariable var;
        int varCnt = cifBddSpec.variables.length;
        if (varCnt == 0) {
            return;
        }
        boolean ordered = true;
        int i = 0;
        while (i < varCnt) {
            var = cifBddSpec.variables[i];
            if (var == null || var.group == -1) {
                ordered = false;
                break;
            }
            ++i;
        }
        if (!ordered) {
            i = 0;
            while (i < varCnt) {
                var = cifBddSpec.variables[i];
                if (var != null) {
                    int size = var.getDomainSize();
                    var.domain = cifBddSpec.factory.extDomain((long)size);
                    var.domainNew = cifBddSpec.factory.extDomain((long)size);
                    var.group = i;
                }
                ++i;
            }
            return;
        }
        int cur = 0;
        int i2 = 0;
        while (i2 < varCnt) {
            int group = cifBddSpec.variables[i2].group;
            if (group != cur) {
                if (group == cur + 1) {
                    cur = group;
                } else {
                    Assert.fail((Object)Strings.fmt((String)"Invalid cur/group: %d/%d.", (Object[])new Object[]{cur, group}));
                }
            }
            ++i2;
        }
        CifBddVariable lastVar = cifBddSpec.variables[varCnt - 1];
        int[] counts = new int[lastVar.group + 1];
        int i3 = 0;
        while (i3 < varCnt) {
            int n = cifBddSpec.variables[i3].group;
            counts[n] = counts[n] + 1;
            ++i3;
        }
        int offset = 0;
        int grpIdx = 0;
        while (grpIdx < counts.length) {
            int grpVarCnt = counts[grpIdx];
            int[] sizes = new int[grpVarCnt * 2];
            int varIdx = 0;
            while (varIdx < grpVarCnt) {
                int size;
                sizes[2 * varIdx + 0] = size = cifBddSpec.variables[offset + varIdx].getDomainSize();
                sizes[2 * varIdx + 1] = size;
                ++varIdx;
            }
            BDDDomain[] domains = cifBddSpec.factory.extDomain(sizes);
            int varIdx2 = 0;
            while (varIdx2 < grpVarCnt) {
                cifBddSpec.variables[offset + varIdx2].domain = domains[2 * varIdx2 + 0];
                cifBddSpec.variables[offset + varIdx2].domainNew = domains[2 * varIdx2 + 1];
                ++varIdx2;
            }
            offset += grpVarCnt;
            ++grpIdx;
        }
    }

    private void createUpdateAuxiliaries(CifBddSpec cifBddSpec) {
        int cifVarCnt = cifBddSpec.variables.length;
        int domainCnt = cifBddSpec.factory.numberOfDomains();
        if (cifVarCnt * 2 != domainCnt) {
            return;
        }
        BDDDomain[] oldDomains = new BDDDomain[cifVarCnt];
        BDDDomain[] newDomains = new BDDDomain[cifVarCnt];
        int i = 0;
        while (i < cifVarCnt) {
            oldDomains[i] = cifBddSpec.variables[i].domain;
            newDomains[i] = cifBddSpec.variables[i].domainNew;
            ++i;
        }
        cifBddSpec.oldToNewVarsPairing = cifBddSpec.factory.makePair();
        cifBddSpec.newToOldVarsPairing = cifBddSpec.factory.makePair();
        cifBddSpec.oldToNewVarsPairing.set(oldDomains, newDomains);
        cifBddSpec.newToOldVarsPairing.set(newDomains, oldDomains);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return;
        }
        int bddVarCnt = cifBddSpec.factory.varNum();
        Assert.check((bddVarCnt % 2 == 0 ? 1 : 0) != 0);
        int[] varIdxsOld = new int[bddVarCnt / 2];
        int[] varIdxsNew = new int[bddVarCnt / 2];
        int varIdx = 0;
        int i2 = 0;
        while (i2 < oldDomains.length) {
            BDDDomain oldDomain = oldDomains[i2];
            BDDDomain newDomain = newDomains[i2];
            int[] domainVarIdxsOld = oldDomain.vars();
            int[] domainVarIdxsNew = newDomain.vars();
            System.arraycopy(domainVarIdxsOld, 0, varIdxsOld, varIdx, domainVarIdxsOld.length);
            System.arraycopy(domainVarIdxsNew, 0, varIdxsNew, varIdx, domainVarIdxsNew.length);
            varIdx += domainVarIdxsOld.length;
            ++i2;
        }
        cifBddSpec.varSetOld = cifBddSpec.factory.makeSet(varIdxsOld);
        cifBddSpec.varSetNew = cifBddSpec.factory.makeSet(varIdxsNew);
        if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
            return;
        }
    }

    private void convertInit(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        for (Expression pred : comp.getInitials()) {
            BDD initial;
            try {
                initial = CifToBddConverter.convertPred(pred, true, cifBddSpec);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of initialization predicate \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            cifBddSpec.initialsComps.add(initial);
            cifBddSpec.initialComps = cifBddSpec.initialComps.andWith(initial.id());
        }
        if (comp instanceof Automaton) {
            for (Declaration cifDecl : comp.getDeclarations()) {
                BDD pred;
                List values;
                DiscVariable cifVar;
                int varIdx;
                if (!(cifDecl instanceof DiscVariable) || (varIdx = CifToBddConverter.getDiscVarIdx(cifBddSpec.variables, cifVar = (DiscVariable)cifDecl)) == -1) continue;
                CifBddVariable cifBddVar = cifBddSpec.variables[varIdx];
                Assert.check((boolean)(cifBddVar instanceof CifBddDiscVariable));
                CifBddDiscVariable var = (CifBddDiscVariable)cifBddVar;
                if (cifVar.getValue() == null) {
                    CifType type = cifVar.getType();
                    values = Lists.list((Object)CifValueUtils.getDefaultValue((CifType)type, null));
                } else {
                    values = cifVar.getValue().getValues().isEmpty() ? null : cifVar.getValue().getValues();
                }
                if (values == null) {
                    pred = BddUtils.getVarDomain(var, false, cifBddSpec.factory);
                } else {
                    pred = cifBddSpec.factory.zero();
                    for (Expression value : values) {
                        CifBddBitVectorAndCarry valueRslt;
                        if (var.type instanceof BoolType) {
                            BDD valueBdd;
                            try {
                                valueBdd = CifToBddConverter.convertPred(value, true, cifBddSpec);
                            }
                            catch (UnsupportedPredicateException ex) {
                                if (ex.expr != null) {
                                    String msg = Strings.fmt((String)"Unsupported variable \"%s\": unsupported part \"%s\" of initial value \"%s\": %s", (Object[])new Object[]{var.name, CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)value), ex.getMessage()});
                                    this.problems.add(msg);
                                }
                                pred.free();
                                pred = cifBddSpec.factory.one();
                                continue;
                            }
                            Assert.check((var.domain.varNum() == 1 ? 1 : 0) != 0);
                            int varVar = var.domain.vars()[0];
                            BDD varBdd = cifBddSpec.factory.ithVar(varVar);
                            BDD relation = varBdd.biimpWith(valueBdd);
                            pred = pred.orWith(relation);
                            continue;
                        }
                        Supplier<String> partMsg = () -> Strings.fmt((String)"initial value \"%s\" of variable \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)value), cifBddDiscVariable.name});
                        try {
                            valueRslt = CifToBddConverter.convertExpr(value, true, cifBddSpec, false, partMsg);
                        }
                        catch (UnsupportedPredicateException ex) {
                            if (ex.expr != null) {
                                String msg = Strings.fmt((String)"Unsupported variable \"%s\": unsupported part \"%s\" of initial value \"%s\": %s", (Object[])new Object[]{var.name, CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)value), ex.getMessage()});
                                this.problems.add(msg);
                            }
                            pred.free();
                            pred = cifBddSpec.factory.one();
                            continue;
                        }
                        CifBddBitVector valueVec = valueRslt.vector;
                        Assert.check((boolean)valueRslt.carry.isZero());
                        CifBddBitVector varVec = CifBddBitVector.createDomain(var.domain);
                        Assert.check((varVec.length() >= valueVec.length() ? 1 : 0) != 0);
                        valueVec.resize(varVec.length());
                        BDD relation = varVec.equalTo(valueVec);
                        varVec.free();
                        valueVec.free();
                        pred = pred.orWith(relation);
                    }
                }
                cifBddSpec.initialsVars.set(varIdx, pred);
                cifBddSpec.initialVars = cifBddSpec.initialVars.andWith(pred.id());
            }
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            BDD autInit = cifBddSpec.factory.zero();
            for (Location loc : aut.getLocations()) {
                BDD srcLocPred;
                if (loc.getInitials().isEmpty()) continue;
                BDD locInit = cifBddSpec.factory.one();
                EList locInits = loc.getInitials();
                try {
                    locInit = CifToBddConverter.convertPreds((List<Expression>)locInits, true, cifBddSpec);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of initialization predicate(s) \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprsToStr((List)locInits), ex.getMessage()});
                    this.problems.add(msg);
                    continue;
                }
                try {
                    Expression srcLocRef = locPtrManager.createLocRef(loc);
                    srcLocPred = CifToBddConverter.convertPred(srcLocRef, true, cifBddSpec);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    throw new RuntimeException(ex);
                }
                locInit = locInit.and(srcLocPred);
                autInit = autInit.or(locInit);
            }
            cifBddSpec.initialsLocs.add(autInit);
            cifBddSpec.initialLocs = cifBddSpec.initialLocs.andWith(autInit.id());
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertInit((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void convertMarked(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        for (Expression pred : comp.getMarkeds()) {
            BDD marked;
            try {
                marked = CifToBddConverter.convertPred(pred, false, cifBddSpec);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of marker predicate \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            cifBddSpec.markedsComps.add(marked);
            cifBddSpec.markedComps = cifBddSpec.markedComps.andWith(marked.id());
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            BDD autMarked = cifBddSpec.factory.zero();
            for (Location loc : aut.getLocations()) {
                BDD srcLocPred;
                if (loc.getMarkeds().isEmpty()) continue;
                BDD locMarked = cifBddSpec.factory.one();
                EList locMarkeds = loc.getMarkeds();
                try {
                    locMarked = CifToBddConverter.convertPreds((List<Expression>)locMarkeds, false, cifBddSpec);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of marker predicate(s) \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprsToStr((List)locMarkeds), ex.getMessage()});
                    this.problems.add(msg);
                    continue;
                }
                try {
                    Expression srcLocRef = locPtrManager.createLocRef(loc);
                    srcLocPred = CifToBddConverter.convertPred(srcLocRef, false, cifBddSpec);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    throw new RuntimeException(ex);
                }
                locMarked = locMarked.andWith(srcLocPred);
                autMarked = autMarked.orWith(locMarked);
            }
            cifBddSpec.markedsLocs.add(autMarked);
            cifBddSpec.markedLocs = cifBddSpec.markedLocs.andWith(autMarked.id());
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertMarked((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void convertStateInvs(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        String msg;
        for (Invariant inv : comp.getInvariants()) {
            BDD invComp;
            if (inv.getInvKind() != InvKind.STATE) continue;
            if (inv.getSupKind() != SupKind.PLANT && inv.getSupKind() != SupKind.REQUIREMENT) {
                String msg2 = Strings.fmt((String)"Unsupported %s: for state invariants, only plant and requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
                this.problems.add(msg2);
                continue;
            }
            Expression pred = inv.getPredicate();
            try {
                invComp = CifToBddConverter.convertPred(pred, false, cifBddSpec);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of state invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            switch (inv.getSupKind()) {
                case PLANT: {
                    cifBddSpec.plantInvsComps.add(invComp);
                    cifBddSpec.plantInvComps = cifBddSpec.plantInvComps.andWith(invComp.id());
                    break;
                }
                case REQUIREMENT: {
                    cifBddSpec.reqInvsComps.add(invComp);
                    cifBddSpec.reqInvComps = cifBddSpec.reqInvComps.andWith(invComp.id());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                }
            }
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    BDD srcLocPred;
                    BDD invLoc;
                    if (inv.getInvKind() != InvKind.STATE) continue;
                    if (inv.getSupKind() != SupKind.PLANT && inv.getSupKind() != SupKind.REQUIREMENT) {
                        msg = Strings.fmt((String)"Unsupported %s: for state invariants, only plant and requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg);
                        continue;
                    }
                    Expression pred = inv.getPredicate();
                    try {
                        invLoc = CifToBddConverter.convertPred(pred, false, cifBddSpec);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        String msg3 = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of state invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                        this.problems.add(msg3);
                        continue;
                    }
                    try {
                        Expression srcLocRef = locPtrManager.createLocRef(loc);
                        srcLocPred = CifToBddConverter.convertPred(srcLocRef, false, cifBddSpec);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        throw new RuntimeException(ex);
                    }
                    invLoc = srcLocPred.not().orWith(invLoc);
                    srcLocPred.free();
                    switch (inv.getSupKind()) {
                        case PLANT: {
                            cifBddSpec.plantInvsLocs.add(invLoc);
                            cifBddSpec.plantInvLocs = cifBddSpec.plantInvLocs.andWith(invLoc.id());
                            break;
                        }
                        case REQUIREMENT: {
                            cifBddSpec.reqInvsLocs.add(invLoc);
                            cifBddSpec.reqInvLocs = cifBddSpec.reqInvLocs.andWith(invLoc.id());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                        }
                    }
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertStateInvs((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void convertStateEvtExclInvs(ComplexComponent comp, CifBddSpec cifBddSpec, LocationPointerManager locPtrManager) {
        for (Invariant inv : comp.getInvariants()) {
            BDD compInv;
            if (inv.getInvKind() == InvKind.STATE) continue;
            if (inv.getSupKind() != SupKind.PLANT && inv.getSupKind() != SupKind.REQUIREMENT) {
                String msg = Strings.fmt((String)"Unsupported %s: for state/event exclusion invariants, only plant and requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
                this.problems.add(msg);
                continue;
            }
            Event event = ((EventExpression)inv.getEvent()).getEvent();
            if (!cifBddSpec.alphabet.contains(event)) continue;
            Expression pred = inv.getPredicate();
            try {
                compInv = CifToBddConverter.convertPred(pred, false, cifBddSpec);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.invToStr((Invariant)inv, (boolean)false), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            if (inv.getInvKind() == InvKind.EVENT_DISABLES) {
                BDD compInvNot = compInv.not();
                compInv.free();
                compInv = compInvNot;
            }
            switch (inv.getSupKind()) {
                case PLANT: {
                    this.storeStateEvtExclInv(cifBddSpec.stateEvtExclPlantLists, event, compInv.id());
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclPlants, event, compInv.id());
                    break;
                }
                case REQUIREMENT: {
                    this.storeStateEvtExclInv(cifBddSpec.stateEvtExclReqLists, event, compInv.id());
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclReqs, event, compInv.id());
                    if (!Boolean.TRUE.equals(event.getControllable())) break;
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclsReqInvs, event, compInv.id());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                }
            }
            compInv.free();
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    BDD srcLocPred;
                    BDD locInv;
                    if (inv.getInvKind() == InvKind.STATE) continue;
                    if (inv.getSupKind() != SupKind.PLANT && inv.getSupKind() != SupKind.REQUIREMENT) {
                        String msg = Strings.fmt((String)"Unsupported %s: for state/event exclusion invariants, only plant and requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg);
                        continue;
                    }
                    Event event = ((EventExpression)inv.getEvent()).getEvent();
                    if (!cifBddSpec.alphabet.contains(event)) continue;
                    Expression pred = inv.getPredicate();
                    try {
                        locInv = CifToBddConverter.convertPred(pred, false, cifBddSpec);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.invToStr((Invariant)inv, (boolean)false), ex.getMessage()});
                        this.problems.add(msg);
                        continue;
                    }
                    try {
                        Expression srcLocRef = locPtrManager.createLocRef(loc);
                        srcLocPred = CifToBddConverter.convertPred(srcLocRef, false, cifBddSpec);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        throw new RuntimeException(ex);
                    }
                    locInv = srcLocPred.not().orWith(locInv);
                    srcLocPred.free();
                    if (inv.getInvKind() == InvKind.EVENT_DISABLES) {
                        BDD locInvNot = locInv.not();
                        locInv.free();
                        locInv = locInvNot;
                    }
                    switch (inv.getSupKind()) {
                        case PLANT: {
                            this.storeStateEvtExclInv(cifBddSpec.stateEvtExclPlantLists, event, locInv.id());
                            this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclPlants, event, locInv.id());
                            break;
                        }
                        case REQUIREMENT: {
                            this.storeStateEvtExclInv(cifBddSpec.stateEvtExclReqLists, event, locInv.id());
                            this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclReqs, event, locInv.id());
                            if (!Boolean.TRUE.equals(event.getControllable())) break;
                            this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclsReqInvs, event, locInv.id());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected kind: " + String.valueOf(inv.getSupKind()));
                        }
                    }
                    locInv.free();
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertStateEvtExclInvs((ComplexComponent)child, cifBddSpec, locPtrManager);
            }
        }
    }

    private void storeStateEvtExclInv(Map<Event, List<BDD>> eventInvs, Event event, BDD inv) {
        List<BDD> invs = eventInvs.get(event);
        invs.add(inv);
    }

    private void conjunctAndStoreStateEvtExclInv(Map<Event, BDD> eventInvs, Event event, BDD inv) {
        BDD invs = eventInvs.get(event);
        invs = invs.andWith(inv);
        eventInvs.put(event, invs);
    }

    private void preconvertReqAuts(List<Automaton> requirements, List<CifEventUtils.Alphabets> alphabets, CifBddSpec cifBddSpec) {
        this.originalMonitors = Maps.mapc((int)requirements.size());
        int i = 0;
        while (i < requirements.size()) {
            Automaton requirement = requirements.get(i);
            CifEventUtils.Alphabets reqAlphabets = alphabets.get(i);
            for (Event event : reqAlphabets.syncAlphabet) {
                BDD cifBddGuard;
                if (reqAlphabets.moniAlphabet.contains(event)) continue;
                Expression cifGuard = CifGuardUtils.mergeGuards((Automaton)requirement, (Event)event, EdgeEventImpl.class, (CifGuardUtils.LocRefExprCreator)CifGuardUtils.LocRefExprCreator.DEFAULT);
                try {
                    cifBddGuard = CifToBddConverter.convertPred(cifGuard, false, cifBddSpec);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of combined guard \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)requirement), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)cifGuard), ex.getMessage()});
                    this.problems.add(msg);
                    continue;
                }
                this.storeStateEvtExclInv(cifBddSpec.stateEvtExclReqLists, event, cifBddGuard.id());
                this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclReqs, event, cifBddGuard.id());
                if (Boolean.TRUE.equals(event.getControllable())) {
                    this.conjunctAndStoreStateEvtExclInv(cifBddSpec.stateEvtExclsReqAuts, event, cifBddGuard.id());
                }
                cifBddGuard.free();
            }
            if (!reqAlphabets.syncAlphabet.isEmpty()) {
                this.originalMonitors.put(requirement, requirement.getMonitors());
                requirement.setMonitors(CifConstructors.newMonitors());
                reqAlphabets.moniAlphabet = Sets.copy((Set)reqAlphabets.syncAlphabet);
            }
            ++i;
        }
    }

    private void convertPlantReqAuts(List<Automaton> plants, List<Automaton> requirements, List<CifEventUtils.Alphabets> plantAlphabets, List<CifEventUtils.Alphabets> reqAlphabets, CifBddLocationPointerManager locPtrManager, CifBddSpec cifBddSpec) {
        List automata = Lists.concat(plants, requirements);
        List alphabets = Lists.concat(plantAlphabets, reqAlphabets);
        boolean tauOk = this.checkNoTauEdges(automata);
        if (tauOk) {
            List cifEdges = Lists.list();
            LinearizeProduct.linearizeEdges((List)automata, (List)alphabets, (List)Lists.set2list(cifBddSpec.alphabet), (LocationPointerManager)locPtrManager, (boolean)false, (boolean)true, (List)cifEdges);
            cifBddSpec.edges = Lists.listc((int)cifEdges.size());
            cifBddSpec.eventEdges = Maps.mapc((int)cifBddSpec.alphabet.size());
            for (Edge cifEdge : cifEdges) {
                BDD guard;
                Event event;
                if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) break;
                CifBddEdge cifBddEdge = new CifBddEdge(cifBddSpec);
                cifBddEdge.edges = Lists.list((Object)cifEdge);
                Assert.check((cifEdge.getEvents().size() == 1 ? 1 : 0) != 0);
                EdgeEvent edgeEvent = (EdgeEvent)Lists.first((List)cifEdge.getEvents());
                cifBddEdge.event = event = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                cifBddSpec.edges.add(cifBddEdge);
                List cifBddEdges = cifBddSpec.eventEdges.get(event);
                if (cifBddEdges == null) {
                    cifBddEdges = Lists.list();
                    cifBddSpec.eventEdges.put(event, cifBddEdges);
                }
                cifBddEdges.add(cifBddEdge);
                try {
                    guard = CifToBddConverter.convertPreds((List<Expression>)cifEdge.getGuards(), false, cifBddSpec);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr != null) {
                        String msg = Strings.fmt((String)"Unsupported linearized guard: unsupported part \"%s\" of guard(s) \"%s\": %s", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprsToStr((List)cifEdge.getGuards()), ex.getMessage()});
                        this.problems.add(msg);
                    }
                    guard = cifBddSpec.factory.zero();
                }
                cifBddEdge.guard = guard;
                cifBddEdge.origGuard = guard.id();
                EList updates = cifEdge.getUpdates();
                CifToBddConverter.convertUpdates((List<Update>)updates, cifBddEdge, locPtrManager, cifBddSpec, this.problems);
                cifBddEdge.guard = cifBddEdge.guard.andWith(cifBddEdge.error.not());
            }
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            this.checkNonDeterminism(cifBddSpec.edges, cifBddSpec.settings.getAllowNonDeterminism());
        }
    }

    private boolean checkNoTauEdges(List<Automaton> automata) {
        boolean tauOk = true;
        for (Automaton aut : automata) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    if (edge.getEvents().isEmpty()) {
                        String msg = Strings.fmt((String)"Unsupported %s: edges without events (implicitly event \"tau\") are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg);
                        tauOk = false;
                    }
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Expression eventRef = edgeEvent.getEvent();
                        if (!(eventRef instanceof TauExpression)) continue;
                        String msg = Strings.fmt((String)"Unsupported %s: edges with \"tau\" events are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg);
                        tauOk = false;
                    }
                }
            }
        }
        return tauOk;
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonDeterminism(List<CifBddEdge> edges, AllowNonDeterminism allowNonDeterminism) {
        Map eventGuards = Maps.map();
        Set conflicts = Sets.setc((int)0);
        for (CifBddEdge edge : edges) {
            Event evt = edge.event;
            Boolean controllable = evt.getControllable();
            if (controllable == null || allowNonDeterminism.allowFor(controllable) || conflicts.contains(evt)) continue;
            BDD curGuard = (BDD)eventGuards.get(evt);
            BDD bDD = edge.guard;
            if (curGuard == null) {
                eventGuards.put(evt, bDD.id());
                continue;
            }
            BDD overlap = curGuard.and(bDD);
            if (overlap.isZero()) {
                eventGuards.put(evt, curGuard.orWith(bDD.id()));
            } else {
                conflicts.add(evt);
            }
            overlap.free();
        }
        for (BDD guard : eventGuards.values()) {
            guard.free();
        }
        for (Event conflict : conflicts) {
            void var10_16;
            List eventEdges = Lists.list();
            for (CifBddEdge edge : edges) {
                if (edge.event != conflict) continue;
                eventEdges.add(edge);
            }
            List<List<CifBddEdge>> groups = CifToBddConverter.groupOnGuardOverlap(eventEdges);
            List guardsTxts = Lists.list();
            for (List list : groups) {
                if (list.size() < 2) continue;
                List guardTxts = Lists.list();
                for (CifBddEdge edge : list) {
                    Assert.check((edge.edges.size() == 1 ? 1 : 0) != 0);
                    EList guards = ((Edge)Lists.first(edge.edges)).getGuards();
                    String guardsTxt = guards.isEmpty() ? "true" : CifTextUtils.exprsToStr((List)guards);
                    guardTxts.add("\"" + guardsTxt + "\"");
                }
                Assert.check((!guardTxts.isEmpty() ? 1 : 0) != 0);
                guardsTxts.add(String.join((CharSequence)", ", guardTxts));
            }
            Assert.check((!guardsTxts.isEmpty() ? 1 : 0) != 0);
            if (guardsTxts.size() == 1) {
                String string = " " + (String)guardsTxts.get(0) + ".";
            } else {
                int i = 0;
                while (i < guardsTxts.size()) {
                    String txt = (String)guardsTxts.get(i);
                    txt = Strings.fmt((String)"\n    Group %d: %s", (Object[])new Object[]{i + 1, txt});
                    guardsTxts.set(i, txt);
                    ++i;
                }
                String string = String.join((CharSequence)"", guardsTxts);
            }
            String eventKind = switch (allowNonDeterminism) {
                case AllowNonDeterminism.ALL -> throw new AssertionError((Object)"Should not get here, as non-determinism is allowed.");
                case AllowNonDeterminism.NONE -> "";
                case AllowNonDeterminism.CONTROLLABLE -> "uncontrollable ";
                case AllowNonDeterminism.UNCONTROLLABLE -> "controllable ";
                default -> throw new IncompatibleClassChangeError();
            };
            String msg = Strings.fmt((String)"Unsupported linearized edges: non-determinism detected for edges of %sevent \"%s\" with overlapping guards:%s", (Object[])new Object[]{eventKind, CifTextUtils.getAbsName((PositionObject)conflict), var10_16});
            this.problems.add(msg);
        }
    }

    private static List<List<CifBddEdge>> groupOnGuardOverlap(List<CifBddEdge> edges) {
        List groups = Lists.listc((int)edges.size());
        int i = 0;
        while (i < edges.size()) {
            groups.add(Lists.list((Object)edges.get(i)));
            ++i;
        }
        i = 0;
        while (i < groups.size()) {
            Assert.check((((List)groups.get(i)).size() == 1 ? 1 : 0) != 0);
            BDD curGuard = ((CifBddEdge)((List)groups.get((int)i)).get((int)0)).guard.id();
            boolean changed = true;
            while (changed) {
                changed = false;
                int j = i + 1;
                while (j < groups.size()) {
                    Assert.check((((List)groups.get(j)).size() == 1 ? 1 : 0) != 0);
                    BDD newGuard = ((CifBddEdge)((List)groups.get((int)j)).get((int)0)).guard;
                    BDD overlapPred = curGuard.and(newGuard);
                    boolean disjoint = overlapPred.isZero();
                    overlapPred.free();
                    if (!disjoint) {
                        changed = true;
                        ((List)groups.get(i)).add((CifBddEdge)((List)groups.get(j)).get(0));
                        groups.remove(j);
                        curGuard = curGuard.andWith(newGuard.id());
                    }
                    ++j;
                }
            }
            curGuard.free();
            ++i;
        }
        return groups;
    }

    public static void convertUpdates(List<Update> updates, CifBddEdge cifBddEdge, CifBddLocationPointerManager locPtrManager, CifBddSpec cifBddSpec, Set<String> problems) {
        List assignments = Lists.listc((int)updates.size());
        boolean[] assigned = new boolean[cifBddSpec.variables.length];
        BDD relation = cifBddSpec.factory.one();
        BDD error = cifBddSpec.factory.zero();
        for (Update update : updates) {
            Pair<BDD, BDD> rslt = CifToBddConverter.convertUpdate(update, assignments, assigned, locPtrManager, cifBddSpec, problems);
            if (cifBddSpec.settings.getShouldTerminate().get().booleanValue()) {
                return;
            }
            if (rslt != null) {
                BDD updateRelation = (BDD)rslt.left;
                relation = relation.andWith(updateRelation);
                BDD updateError = (BDD)rslt.right;
                error = error.orWith(updateError);
            }
            if (!cifBddSpec.settings.getShouldTerminate().get().booleanValue()) continue;
            return;
        }
        int i = 0;
        while (i < assigned.length) {
            if (assigned[i]) {
                cifBddEdge.assignedVariables.add(cifBddSpec.variables[i]);
            }
            ++i;
        }
        cifBddEdge.assignments = Lists.list((Object)assignments);
        cifBddEdge.update = relation;
        cifBddEdge.error = error;
    }

    public static Pair<BDD, BDD> convertUpdate(Update update, List<Assignment> assignments, boolean[] assigned, CifBddLocationPointerManager locPtrManager, CifBddSpec cifBddSpec, Set<String> problems) {
        CifBddBitVectorAndCarry rhsRslt;
        if (update instanceof IfUpdate) {
            String msg = "Unsupported update: conditional updates ('if' updates) are not supported.";
            problems.add(msg);
            return null;
        }
        Assignment asgn = (Assignment)update;
        assignments.add(asgn);
        Expression addr = asgn.getAddressable();
        if (addr instanceof TupleExpression) {
            String msg = "Unsupported update: multi-assignments are not supported.";
            problems.add(msg);
            return null;
        }
        if (addr instanceof ProjectionExpression) {
            String msg = "Unsupported update: partial variable assignments are not supported.";
            problems.add(msg);
            return null;
        }
        if (addr instanceof ContVariableExpression) {
            String msg = "Unsupported update: assignments to continuous variables are not supported.";
            problems.add(msg);
            return null;
        }
        DiscVariable cifVar = ((DiscVariableExpression)addr).getVariable();
        Automaton cifAut = locPtrManager.getAutomaton(cifVar);
        if (cifAut != null) {
            int varIdx = CifToBddConverter.getLpVarIdx(cifBddSpec.variables, cifAut);
            if (varIdx == -1) {
                return null;
            }
            CifBddVariable var = cifBddSpec.variables[varIdx];
            Assert.check((boolean)(var instanceof CifBddLocPtrVariable));
            Assert.check((!assigned[varIdx] ? 1 : 0) != 0);
            assigned[varIdx] = true;
            Assert.check((boolean)(asgn.getValue() instanceof IntExpression));
            int locIdx = ((IntExpression)asgn.getValue()).getValue();
            CifBddBitVector varVector = CifBddBitVector.createDomain(var.domainNew);
            CifBddBitVector locVector = CifBddBitVector.createInt(cifBddSpec.factory, locIdx);
            Assert.check((locVector.length() <= varVector.length() ? 1 : 0) != 0);
            locVector.resize(varVector.length());
            BDD relation = varVector.equalTo(locVector);
            varVector.free();
            locVector.free();
            return Pair.pair((Object)relation, (Object)cifBddSpec.factory.zero());
        }
        int varIdx = CifToBddConverter.getTypedVarIdx(cifBddSpec.variables, (Declaration)cifVar);
        if (varIdx == -1) {
            return null;
        }
        CifBddVariable cifBddVar = cifBddSpec.variables[varIdx];
        Assert.check((boolean)(cifBddVar instanceof CifBddTypedVariable));
        CifBddTypedVariable var = (CifBddTypedVariable)cifBddVar;
        Assert.check((!assigned[varIdx] ? 1 : 0) != 0);
        assigned[varIdx] = true;
        if (var.type instanceof BoolType) {
            BDD rhsBdd;
            Expression rhsExpr = asgn.getValue();
            try {
                rhsBdd = CifToBddConverter.convertPred(rhsExpr, false, cifBddSpec);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr != null) {
                    String msg = Strings.fmt((String)"Unsupported assignment: unsupported part \"%s\" of assignment \"%s := %s\": %s", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)addr), CifTextUtils.exprToStr((Expression)rhsExpr), ex.getMessage()});
                    problems.add(msg);
                }
                return Pair.pair((Object)cifBddSpec.factory.one(), (Object)cifBddSpec.factory.zero());
            }
            Assert.check((var.domainNew.varNum() == 1 ? 1 : 0) != 0);
            int lhsVar = var.domainNew.vars()[0];
            BDD lhsBdd = cifBddSpec.factory.ithVar(lhsVar);
            BDD relation = lhsBdd.biimpWith(rhsBdd);
            return Pair.pair((Object)relation, (Object)cifBddSpec.factory.zero());
        }
        Expression rhsExpr = asgn.getValue();
        Supplier<String> partMsg = () -> Strings.fmt((String)"assignment \"%s := %s\"", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)addr), CifTextUtils.exprToStr((Expression)rhsExpr)});
        try {
            rhsRslt = CifToBddConverter.convertExpr(rhsExpr, false, cifBddSpec, true, partMsg);
        }
        catch (UnsupportedPredicateException ex) {
            if (ex.expr != null) {
                String msg = Strings.fmt((String)"Unsupported assignment: unsupported part \"%s\" of assignment \"%s := %s\": %s", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)addr), CifTextUtils.exprToStr((Expression)rhsExpr), ex.getMessage()});
                problems.add(msg);
            }
            return Pair.pair((Object)cifBddSpec.factory.one(), (Object)cifBddSpec.factory.zero());
        }
        CifBddBitVector rhsVec = rhsRslt.vector;
        BDD error = rhsRslt.carry;
        CifBddBitVector lhsVec = CifBddBitVector.createDomain(var.domainNew);
        int lhsLen = lhsVec.length();
        int len = Math.max(lhsVec.length(), rhsVec.length());
        lhsVec.resize(len);
        rhsVec.resize(len);
        BDD relation = lhsVec.equalTo(rhsVec);
        lhsVec.free();
        int i = lhsLen;
        while (i < len) {
            error = error.orWith(rhsVec.getBit(i).id());
            ++i;
        }
        rhsVec.free();
        return Pair.pair((Object)relation, (Object)error);
    }

    private void addInputVariableEdges(CifBddSpec cifBddSpec) {
        cifBddSpec.inputVarEvents = Sets.set();
        CifBddVariable[] cifBddVariableArray = cifBddSpec.variables;
        int n = cifBddSpec.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable var = cifBddVariableArray[n2];
            if (var != null && var instanceof CifBddInputVariable) {
                CifBddInputVariable cifBddInputVar = (CifBddInputVariable)var;
                Event event = CifConstructors.newEvent();
                event.setControllable(Boolean.valueOf(false));
                event.setName(cifBddInputVar.var.getName());
                cifBddSpec.alphabet.add(event);
                ComplexComponent comp = (ComplexComponent)cifBddInputVar.var.eContainer();
                comp.getDeclarations().add((Object)event);
                cifBddSpec.inputVarEvents.add(event);
                CifBddEdge edge = new CifBddEdge(cifBddSpec);
                edge.edges = Lists.list(null);
                edge.event = event;
                edge.origGuard = cifBddSpec.factory.one();
                edge.guard = cifBddSpec.factory.one();
                edge.error = cifBddSpec.factory.zero();
                cifBddSpec.edges.add(edge);
                cifBddSpec.eventEdges.put(event, Lists.list((Object)edge));
                InputVariableExpression addr = CifConstructors.newInputVariableExpression();
                addr.setVariable(cifBddInputVar.var);
                Assignment asgn = CifConstructors.newAssignment();
                asgn.setAddressable((Expression)addr);
                edge.assignments = Lists.list((Object)Lists.list((Object)asgn));
                CifBddBitVector vectorOld = CifBddBitVector.createDomain(var.domain);
                CifBddBitVector vectorNew = CifBddBitVector.createDomain(var.domainNew);
                edge.update = vectorOld.unequalTo(vectorNew);
                edge.update = edge.update.andWith(BddUtils.getVarDomain(var, true, cifBddSpec.factory));
                vectorOld.free();
                vectorNew.free();
                edge.assignedVariables.add(var);
            }
            ++n2;
        }
    }

    private void mergeEdges(CifBddSpec cifBddSpec) {
        if (cifBddSpec.eventEdges == null) {
            return;
        }
        switch (cifBddSpec.settings.getEdgeGranularity()) {
            case PER_EDGE: {
                return;
            }
            case PER_EVENT: {
                int eventCount = cifBddSpec.eventEdges.size();
                cifBddSpec.edges = Lists.listc((int)eventCount);
                for (Map.Entry<Event, List<CifBddEdge>> entry : cifBddSpec.eventEdges.entrySet()) {
                    CifBddEdge mergedEdge = (CifBddEdge)entry.getValue().stream().reduce(CifBddEdge::mergeEdges).get();
                    cifBddSpec.edges.add(mergedEdge);
                    entry.setValue(Lists.list((Object)mergedEdge));
                }
                return;
            }
        }
        throw new RuntimeException("Unknown granularity: " + String.valueOf((Object)cifBddSpec.settings.getEdgeGranularity()));
    }

    private void orderEdges(CifBddSpec cifBddSpec) {
        cifBddSpec.orderedEdgesBackward = CifToBddConverter.orderEdgesForDirection(cifBddSpec.edges, cifBddSpec.settings.getEdgeOrderBackward(), cifBddSpec.settings.getEdgeOrderAllowDuplicateEvents(), false);
        cifBddSpec.orderedEdgesForward = CifToBddConverter.orderEdgesForDirection(cifBddSpec.edges, cifBddSpec.settings.getEdgeOrderForward(), cifBddSpec.settings.getEdgeOrderAllowDuplicateEvents(), true);
    }

    private static List<CifBddEdge> orderEdgesForDirection(List<CifBddEdge> edges, String orderTxt, EdgeOrderDuplicateEventAllowance edgeOrderAllowDuplicateEvents, boolean forForwardReachability) {
        if (orderTxt.toLowerCase(Locale.US).equals("model")) {
            return edges;
        }
        if (orderTxt.toLowerCase(Locale.US).equals("reverse-model")) {
            return Lists.reverse(edges);
        }
        if (orderTxt.toLowerCase(Locale.US).equals("sorted")) {
            return edges.stream().sorted((v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false))).toList();
        }
        if (orderTxt.toLowerCase(Locale.US).equals("reverse-sorted")) {
            return Lists.reverse(edges.stream().sorted((v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false))).toList());
        }
        if (orderTxt.toLowerCase(Locale.US).equals("random") || orderTxt.toLowerCase(Locale.US).startsWith("random:")) {
            Long seed = null;
            if (orderTxt.contains(":")) {
                int idx = orderTxt.indexOf(":");
                String seedTxt = orderTxt.substring(idx + 1);
                try {
                    seed = Long.parseUnsignedLong(seedTxt);
                }
                catch (NumberFormatException ex) {
                    String msg = Strings.fmt((String)"Invalid random %s edge order seed number: \"%s\".", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", orderTxt});
                    throw new InvalidOptionException(msg, (Throwable)ex);
                }
            }
            List orderedEdges = Lists.copy(edges);
            if (seed == null) {
                Collections.shuffle(orderedEdges);
            } else {
                Collections.shuffle(orderedEdges, new Random(seed));
            }
            return orderedEdges;
        }
        List orderedEdges = Lists.listc((int)edges.size());
        Set processedEdges = Sets.set();
        String[] stringArray = StringUtils.split((String)orderTxt, (String)",");
        int msg = stringArray.length;
        int ex = 0;
        while (ex < msg) {
            String elemTxt = stringArray[ex];
            if (!(elemTxt = elemTxt.trim()).isEmpty()) {
                String regEx = elemTxt.replace(".", "\\.");
                regEx = regEx.replace("*", ".*");
                Pattern pattern = Pattern.compile("^" + regEx + "$");
                List matches = Lists.list();
                for (CifBddEdge edge : edges) {
                    String name = CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false);
                    if (!pattern.matcher(name).matches()) continue;
                    matches.add(edge);
                }
                if (matches.isEmpty()) {
                    String msg2 = Strings.fmt((String)"Invalid custom %s edge order: can't find a match for \"%s\". There is no supported event or input variable in the specification that matches the given name pattern.", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", elemTxt});
                    throw new InvalidOptionException(msg2);
                }
                Collections.sort(matches, (v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false)));
                if (edgeOrderAllowDuplicateEvents == EdgeOrderDuplicateEventAllowance.DISALLOWED) {
                    for (CifBddEdge edge : matches) {
                        if (!processedEdges.contains(edge)) continue;
                        String msg3 = Strings.fmt((String)"Invalid custom %s edge order: event \"%s\" is included more than once. If the duplicate event is intentional, enable allowing duplicate events in the custom event order.", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false)});
                        throw new InvalidOptionException(msg3);
                    }
                }
                processedEdges.addAll(matches);
                orderedEdges.addAll(matches);
            }
            ++ex;
        }
        Set missingEdges = Sets.difference(edges, (Collection)processedEdges);
        if (!missingEdges.isEmpty()) {
            Set names = Sets.set();
            for (CifBddEdge edge : missingEdges) {
                names.add("\"" + CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false) + "\"");
            }
            List sortedNames = Sets.sortedgeneric((Set)names, (Comparator)Strings.SORTER);
            String msg4 = Strings.fmt((String)"Invalid custom %s edge order: the following event(s) are missing from the specified order: %s.", (Object[])new Object[]{forForwardReachability ? "forward" : "backward", String.join((CharSequence)", ", sortedNames)});
            throw new InvalidOptionException(msg4);
        }
        return orderedEdges;
    }

    private void checkEdgeWorksetAlgorithmSettings(CifBddSettings settings) {
        if (!settings.getDoUseEdgeWorksetAlgo()) {
            return;
        }
        if (settings.getEdgeGranularity() != EdgeGranularity.PER_EVENT) {
            throw new InvalidOptionException("The edge workset algorithm can only be used with per-event edge granularity. Either disable the edge workset algorithm, or configure per-event edge granularity.");
        }
        if (settings.getEdgeOrderAllowDuplicateEvents() == EdgeOrderDuplicateEventAllowance.ALLOWED) {
            throw new InvalidOptionException("The edge workset algorithm can not be used with duplicate events in the edge order. Either disable the edge workset algorithm, or disable duplicates for custom edge orders.");
        }
    }

    public static BDD convertPreds(List<Expression> preds, boolean initial, CifBddSpec cifBddSpec) throws UnsupportedPredicateException {
        BDD rslt = cifBddSpec.factory.one();
        for (Expression pred : preds) {
            rslt = rslt.andWith(CifToBddConverter.convertPred(pred, initial, cifBddSpec));
        }
        return rslt;
    }

    public static BDD convertPred(Expression pred, boolean initial, CifBddSpec cifBddSpec) throws UnsupportedPredicateException {
        if (pred instanceof BoolExpression) {
            boolean value = ((BoolExpression)pred).isValue();
            return value ? cifBddSpec.factory.one() : cifBddSpec.factory.zero();
        }
        if (pred instanceof DiscVariableExpression) {
            DiscVariable cifVar = ((DiscVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)cifVar.getType()) instanceof BoolType));
            int varIdx = CifToBddConverter.getDiscVarIdx(cifBddSpec.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            CifBddVariable var = cifBddSpec.variables[varIdx];
            return var.domain.ithVar(1L);
        }
        if (pred instanceof InputVariableExpression) {
            InputVariable cifVar = ((InputVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)cifVar.getType()) instanceof BoolType));
            int varIdx = CifToBddConverter.getInputVarIdx(cifBddSpec.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            CifBddVariable var = cifBddSpec.variables[varIdx];
            return var.domain.ithVar(1L);
        }
        if (pred instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)var.getType()) instanceof BoolType));
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            return CifToBddConverter.convertPred(value, initial, cifBddSpec);
        }
        if (pred instanceof LocationExpression) {
            Location loc = ((LocationExpression)pred).getLocation();
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            int varIdx = CifToBddConverter.getLpVarIdx(cifBddSpec.variables, aut);
            if (varIdx == -1) {
                if (aut.getLocations().size() == 1) {
                    return cifBddSpec.factory.one();
                }
                throw new UnsupportedPredicateException();
            }
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            CifBddVariable var = cifBddSpec.variables[varIdx];
            int locIdx = aut.getLocations().indexOf((Object)loc);
            Assert.check((locIdx >= 0 ? 1 : 0) != 0);
            return var.domain.ithVar((long)locIdx);
        }
        if (pred instanceof ConstantExpression) {
            Object valueObj;
            Constant constant = ((ConstantExpression)pred).getConstant();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)constant.getType()) instanceof BoolType));
            try {
                valueObj = CifEvalUtils.eval((Expression)constant.getValue(), (boolean)initial);
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to statically evaluate the value of constant \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)constant)});
                throw new InvalidInputException(msg, (Throwable)ex);
            }
            return (Boolean)valueObj != false ? cifBddSpec.factory.one() : cifBddSpec.factory.zero();
        }
        if (pred instanceof UnaryExpression) {
            UnaryExpression upred = (UnaryExpression)pred;
            UnaryOperator op = upred.getOperator();
            if (op != UnaryOperator.INVERSE) {
                String msg = Strings.fmt((String)"unary operator \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((UnaryOperator)op)});
                throw new UnsupportedPredicateException(msg, (Expression)upred);
            }
            BDD child = CifToBddConverter.convertPred(upred.getChild(), initial, cifBddSpec);
            BDD rslt = child.not();
            child.free();
            return rslt;
        }
        if (pred instanceof BinaryExpression) {
            BinaryExpression bpred = (BinaryExpression)pred;
            BinaryOperator op = ((BinaryExpression)pred).getOperator();
            Expression lhs = bpred.getLeft();
            Expression rhs = bpred.getRight();
            if (op == BinaryOperator.CONJUNCTION) {
                CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) {
                    String msg = Strings.fmt((String)"binary operator \"%s\" on values of types \"%s\" and \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
                    throw new UnsupportedPredicateException(msg, (Expression)bpred);
                }
                BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                return left.andWith(right);
            }
            if (op == BinaryOperator.DISJUNCTION) {
                CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) {
                    String msg = Strings.fmt((String)"binary operator \"%s\" on values of types \"%s\" and \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
                    throw new UnsupportedPredicateException(msg, (Expression)bpred);
                }
                BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                return left.orWith(right);
            }
            if (op == BinaryOperator.IMPLICATION) {
                BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                return left.impWith(right);
            }
            if (op == BinaryOperator.BI_CONDITIONAL) {
                BDD left = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
                BDD right = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
                return left.biimpWith(right);
            }
            switch (op) {
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case EQUAL: 
                case UNEQUAL: {
                    break;
                }
                default: {
                    String msg = Strings.fmt((String)"binary operator \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op)});
                    throw new UnsupportedPredicateException(msg, (Expression)bpred);
                }
            }
            return CifToBddConverter.convertCmpPred(lhs, rhs, op, pred, bpred, initial, cifBddSpec);
        }
        if (pred instanceof IfExpression) {
            IfExpression ifPred = (IfExpression)pred;
            BDD rslt = CifToBddConverter.convertPred(ifPred.getElse(), initial, cifBddSpec);
            int i = ifPred.getElifs().size() - 1;
            while (i >= 0) {
                ElifExpression elifPred = (ElifExpression)ifPred.getElifs().get(i);
                BDD elifGuards = CifToBddConverter.convertPreds((List<Expression>)elifPred.getGuards(), initial, cifBddSpec);
                BDD elifThen = CifToBddConverter.convertPred(elifPred.getThen(), initial, cifBddSpec);
                BDD elifRslt = elifGuards.ite(elifThen, rslt);
                elifGuards.free();
                elifThen.free();
                rslt.free();
                rslt = elifRslt;
                --i;
            }
            BDD ifGuards = CifToBddConverter.convertPreds((List<Expression>)ifPred.getGuards(), initial, cifBddSpec);
            BDD ifThen = CifToBddConverter.convertPred(ifPred.getThen(), initial, cifBddSpec);
            BDD elifRslt = ifGuards.ite(ifThen, rslt);
            ifGuards.free();
            ifThen.free();
            rslt.free();
            rslt = elifRslt;
            return rslt;
        }
        if (pred instanceof SwitchExpression) {
            SwitchExpression switchPred = (SwitchExpression)pred;
            Expression value = switchPred.getValue();
            EList cases = switchPred.getCases();
            BDD rslt = CifToBddConverter.convertPred(((SwitchCase)Lists.last((List)cases)).getValue(), initial, cifBddSpec);
            int i = cases.size() - 2;
            while (i >= 0) {
                SwitchCase cse = (SwitchCase)cases.get(i);
                Expression caseGuardExpr = CifTypeUtils.isAutRefExpr((Expression)value) ? cse.getKey() : CifConstructors.newBinaryExpression((Expression)((Expression)EMFHelper.deepclone((EObject)value)), (BinaryOperator)BinaryOperator.EQUAL, null, (Expression)((Expression)EMFHelper.deepclone((EObject)cse.getKey())), (CifType)CifConstructors.newBoolType());
                BDD caseGuard = CifToBddConverter.convertPred(caseGuardExpr, initial, cifBddSpec);
                BDD caseThen = CifToBddConverter.convertPred(cse.getValue(), initial, cifBddSpec);
                BDD caseRslt = caseGuard.ite(caseThen, rslt);
                caseGuard.free();
                caseThen.free();
                rslt.free();
                rslt = caseRslt;
                --i;
            }
            return rslt;
        }
        String msg = Strings.fmt((String)"predicate is not supported.", (Object[])new Object[0]);
        throw new UnsupportedPredicateException(msg, pred);
    }

    public static BDD convertCmpPred(Expression lhs, Expression rhs, BinaryOperator op, Expression pred, BinaryExpression bpred, boolean initial, CifBddSpec cifBddSpec) throws UnsupportedPredicateException {
        CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
        if (!(ltype instanceof BoolType && rtype instanceof BoolType || ltype instanceof EnumType && rtype instanceof EnumType || ltype instanceof IntType && rtype instanceof IntType)) {
            String msg = Strings.fmt((String)"binary operator \"%s\" on values of types \"%s\" and \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
            throw new UnsupportedPredicateException(msg, (Expression)bpred);
        }
        if (ltype instanceof BoolType && rtype instanceof BoolType) {
            BDD lbdd = CifToBddConverter.convertPred(lhs, initial, cifBddSpec);
            BDD rbdd = CifToBddConverter.convertPred(rhs, initial, cifBddSpec);
            switch (op) {
                case EQUAL: {
                    return lbdd.biimpWith(rbdd);
                }
                case UNEQUAL: {
                    BDD eq = lbdd.biimpWith(rbdd);
                    BDD rslt = eq.not();
                    eq.free();
                    return rslt;
                }
            }
            throw new RuntimeException("Unexpected op: " + String.valueOf(op));
        }
        Supplier<String> partMsg = () -> Strings.fmt((String)"predicate \"%s\"", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)pred)});
        CifBddBitVectorAndCarry lrslt = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec, false, partMsg);
        CifBddBitVectorAndCarry rrslt = CifToBddConverter.convertExpr(rhs, initial, cifBddSpec, false, partMsg);
        Assert.check((boolean)lrslt.carry.isZero());
        Assert.check((boolean)rrslt.carry.isZero());
        CifBddBitVector lvec = lrslt.vector;
        CifBddBitVector rvec = rrslt.vector;
        int length = Math.max(lvec.length(), rvec.length());
        lvec.resize(length);
        rvec.resize(length);
        BDD rslt = switch (op) {
            case BinaryOperator.LESS_THAN -> lvec.lessThan(rvec);
            case BinaryOperator.LESS_EQUAL -> lvec.lessOrEqual(rvec);
            case BinaryOperator.GREATER_THAN -> lvec.greaterThan(rvec);
            case BinaryOperator.GREATER_EQUAL -> lvec.greaterOrEqual(rvec);
            case BinaryOperator.EQUAL -> lvec.equalTo(rvec);
            case BinaryOperator.UNEQUAL -> lvec.unequalTo(rvec);
            default -> throw new RuntimeException("Unexpected op: " + String.valueOf(op));
        };
        lvec.free();
        rvec.free();
        return rslt;
    }

    public static CifBddBitVectorAndCarry convertExpr(Expression expr, boolean initial, CifBddSpec cifBddSpec, boolean allowSubtract, Supplier<String> partMsg) throws UnsupportedPredicateException {
        String msg;
        Object valueObj;
        if (expr instanceof DiscVariableExpression) {
            DiscVariable cifVar = ((DiscVariableExpression)expr).getVariable();
            int varIdx = CifToBddConverter.getDiscVarIdx(cifBddSpec.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            CifBddVariable var = cifBddSpec.variables[varIdx];
            CifBddBitVector vector = CifBddBitVector.createDomain(var.domain);
            return new CifBddBitVectorAndCarry(vector, cifBddSpec.factory.zero());
        }
        if (expr instanceof InputVariableExpression) {
            InputVariable cifVar = ((InputVariableExpression)expr).getVariable();
            int varIdx = CifToBddConverter.getInputVarIdx(cifBddSpec.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            CifBddVariable var = cifBddSpec.variables[varIdx];
            CifBddBitVector vector = CifBddBitVector.createDomain(var.domain);
            return new CifBddBitVectorAndCarry(vector, cifBddSpec.factory.zero());
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            return CifToBddConverter.convertExpr(value, initial, cifBddSpec, allowSubtract, partMsg);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            switch (uexpr.getOperator()) {
                case PLUS: {
                    return CifToBddConverter.convertExpr(uexpr.getChild(), initial, cifBddSpec, false, partMsg);
                }
            }
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            Expression lhs = bexpr.getLeft();
            Expression rhs = bexpr.getRight();
            switch (bexpr.getOperator()) {
                case ADDITION: {
                    CifBddBitVectorAndCarry lrslt = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec, false, partMsg);
                    CifBddBitVectorAndCarry rrslt = CifToBddConverter.convertExpr(rhs, initial, cifBddSpec, false, partMsg);
                    Assert.check((boolean)lrslt.carry.isZero());
                    Assert.check((boolean)rrslt.carry.isZero());
                    CifBddBitVector lvec = lrslt.vector;
                    CifBddBitVector rvec = rrslt.vector;
                    int length = Math.max(lvec.length(), rvec.length()) + 1;
                    lvec.resize(length);
                    rvec.resize(length);
                    CifBddBitVectorAndCarry rslt = lvec.add(rvec);
                    Assert.check((boolean)rslt.carry.isZero());
                    lvec.free();
                    rvec.free();
                    return rslt;
                }
                case SUBTRACTION: {
                    if (!allowSubtract) break;
                    CifBddBitVectorAndCarry lrslt = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec, false, partMsg);
                    CifBddBitVectorAndCarry rrslt = CifToBddConverter.convertExpr(rhs, initial, cifBddSpec, false, partMsg);
                    Assert.check((boolean)lrslt.carry.isZero());
                    Assert.check((boolean)rrslt.carry.isZero());
                    CifBddBitVector lvec = lrslt.vector;
                    CifBddBitVector rvec = rrslt.vector;
                    int length = Math.max(lvec.length(), rvec.length());
                    lvec.resize(length);
                    rvec.resize(length);
                    CifBddBitVectorAndCarry rslt = lvec.subtract(rvec);
                    lvec.free();
                    rvec.free();
                    return rslt;
                }
                case MODULUS: 
                case INTEGER_DIVISION: {
                    Object rhsValueObj;
                    CifBddBitVectorAndCarry lrslt = CifToBddConverter.convertExpr(lhs, initial, cifBddSpec, false, partMsg);
                    Assert.check((boolean)lrslt.carry.isZero());
                    CifBddBitVector lvec = lrslt.vector;
                    if (!CifValueUtils.hasSingleValue((Expression)rhs, (boolean)initial, (boolean)true)) {
                        String msg2 = "value is too complex to be statically evaluated.";
                        throw new UnsupportedPredicateException(msg2, rhs);
                    }
                    try {
                        rhsValueObj = CifEvalUtils.eval((Expression)rhs, (boolean)initial);
                    }
                    catch (CifEvalException ex) {
                        String msg3 = Strings.fmt((String)"Failed to statically evaluate the \"%s\" part of %s.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)rhs), partMsg.get()});
                        throw new InvalidInputException(msg3, (Throwable)ex);
                    }
                    int divisor = (Integer)rhsValueObj;
                    if (divisor == 0) {
                        String msg4 = Strings.fmt((String)"\"%s\" always results in division by zero.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
                        throw new UnsupportedPredicateException(msg4, expr);
                    }
                    if (divisor < 0) {
                        String msg5 = Strings.fmt((String)"\"%s\" performs division/modulus by a negative value, which is not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
                        throw new UnsupportedPredicateException(msg5, expr);
                    }
                    boolean isDiv = bexpr.getOperator() == BinaryOperator.INTEGER_DIVISION;
                    int lhsLen = lvec.length();
                    if (!isDiv) {
                        ++lhsLen;
                    }
                    int rhsLen = BddUtils.getMinimumBits(divisor);
                    int length = Math.max(lhsLen, rhsLen);
                    lvec.resize(length);
                    CifBddBitVector rslt = lvec.divmod(divisor, isDiv);
                    lvec.free();
                    return new CifBddBitVectorAndCarry(rslt, cifBddSpec.factory.zero());
                }
            }
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            CifBddBitVectorAndCarry elseRslt = CifToBddConverter.convertExpr(ifExpr.getElse(), initial, cifBddSpec, false, partMsg);
            Assert.check((boolean)elseRslt.carry.isZero());
            CifBddBitVector rslt = elseRslt.vector;
            int i = ifExpr.getElifs().size() - 1;
            while (i >= 0) {
                ElifExpression elifExpr = (ElifExpression)ifExpr.getElifs().get(i);
                BDD elifGuards = CifToBddConverter.convertPreds((List<Expression>)elifExpr.getGuards(), initial, cifBddSpec);
                CifBddBitVectorAndCarry elifThen = CifToBddConverter.convertExpr(elifExpr.getThen(), initial, cifBddSpec, false, partMsg);
                Assert.check((boolean)elifThen.carry.isZero());
                CifBddBitVector elifVector = elifThen.vector;
                int len = Math.max(rslt.length(), elifVector.length());
                rslt.resize(len);
                elifVector.resize(len);
                CifBddBitVector elifRslt = elifVector.ifThenElse(rslt, elifGuards);
                elifGuards.free();
                elifVector.free();
                rslt.free();
                rslt = elifRslt;
                --i;
            }
            BDD ifGuards = CifToBddConverter.convertPreds((List<Expression>)ifExpr.getGuards(), initial, cifBddSpec);
            CifBddBitVectorAndCarry ifThen = CifToBddConverter.convertExpr(ifExpr.getThen(), initial, cifBddSpec, false, partMsg);
            Assert.check((boolean)ifThen.carry.isZero());
            CifBddBitVector ifVector = ifThen.vector;
            int len = Math.max(rslt.length(), ifVector.length());
            rslt.resize(len);
            ifVector.resize(len);
            CifBddBitVector ifRslt = ifVector.ifThenElse(rslt, ifGuards);
            ifGuards.free();
            ifVector.free();
            rslt.free();
            rslt = ifRslt;
            return new CifBddBitVectorAndCarry(rslt, cifBddSpec.factory.zero());
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            EList cases = switchExpr.getCases();
            CifBddBitVectorAndCarry elseRslt = CifToBddConverter.convertExpr(((SwitchCase)Lists.last((List)cases)).getValue(), initial, cifBddSpec, false, partMsg);
            Assert.check((boolean)elseRslt.carry.isZero());
            CifBddBitVector rslt = elseRslt.vector;
            int i = cases.size() - 2;
            while (i >= 0) {
                SwitchCase cse = (SwitchCase)cases.get(i);
                Expression caseGuardExpr = CifTypeUtils.isAutRefExpr((Expression)value) ? cse.getKey() : CifConstructors.newBinaryExpression((Expression)((Expression)EMFHelper.deepclone((EObject)value)), (BinaryOperator)BinaryOperator.EQUAL, null, (Expression)((Expression)EMFHelper.deepclone((EObject)cse.getKey())), (CifType)CifConstructors.newBoolType());
                BDD caseGuard = CifToBddConverter.convertPred(caseGuardExpr, initial, cifBddSpec);
                CifBddBitVectorAndCarry caseThen = CifToBddConverter.convertExpr(cse.getValue(), initial, cifBddSpec, false, partMsg);
                Assert.check((boolean)caseThen.carry.isZero());
                CifBddBitVector caseVector = caseThen.vector;
                int len = Math.max(rslt.length(), caseVector.length());
                rslt.resize(len);
                caseVector.resize(len);
                CifBddBitVector caseRslt = caseVector.ifThenElse(rslt, caseGuard);
                caseGuard.free();
                caseVector.free();
                rslt.free();
                rslt = caseRslt;
                --i;
            }
            return new CifBddBitVectorAndCarry(rslt, cifBddSpec.factory.zero());
        }
        if (!CifValueUtils.hasSingleValue((Expression)expr, (boolean)initial, (boolean)true)) {
            String msg6 = "value is too complex to be statically evaluated.";
            throw new UnsupportedPredicateException(msg6, expr);
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)expr, (boolean)initial);
        }
        catch (CifEvalException ex) {
            msg = Strings.fmt((String)"Failed to statically evaluate the \"%s\" part of %s.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), partMsg.get()});
            throw new InvalidInputException(msg, (Throwable)ex);
        }
        if (valueObj instanceof Integer) {
            int value = (Integer)valueObj;
            if (value < 0) {
                msg = Strings.fmt((String)"value \"%d\" is unsupported, as it is negative.", (Object[])new Object[]{value});
                throw new UnsupportedPredicateException(msg, expr);
            }
            CifBddBitVector vector = CifBddBitVector.createInt(cifBddSpec.factory, value);
            return new CifBddBitVectorAndCarry(vector, cifBddSpec.factory.zero());
        }
        Assert.check((boolean)(valueObj instanceof CifEnumLiteral));
        EnumLiteral lit = ((CifEnumLiteral)valueObj).literal;
        EnumDecl enumDecl = (EnumDecl)lit.eContainer();
        int litIdx = enumDecl.getLiterals().indexOf((Object)lit);
        CifBddBitVector vector = CifBddBitVector.createInt(cifBddSpec.factory, litIdx);
        return new CifBddBitVectorAndCarry(vector, cifBddSpec.factory.zero());
    }

    public static void collectEvents(ComplexComponent comp, List<Event> events) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            events.add((Event)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToBddConverter.collectEvents((ComplexComponent)child, events);
            }
        }
    }

    private static void collectAutomata(ComplexComponent comp, List<Automaton> automata) {
        if (comp instanceof Automaton) {
            automata.add((Automaton)comp);
        } else {
            for (Component child : ((Group)comp).getComponents()) {
                CifToBddConverter.collectAutomata((ComplexComponent)child, automata);
            }
        }
    }

    private static void collectVariableObjects(ComplexComponent comp, List<PositionObject> objs) {
        Automaton aut;
        if (comp instanceof Automaton && (aut = (Automaton)comp).getLocations().size() > 1) {
            objs.add((PositionObject)aut);
        }
        for (Declaration decl : comp.getDeclarations()) {
            if (decl instanceof DiscVariable) {
                objs.add((PositionObject)decl);
            }
            if (!(decl instanceof InputVariable)) continue;
            objs.add((PositionObject)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToBddConverter.collectVariableObjects((ComplexComponent)child, objs);
            }
        }
    }

    public static int getDiscVarIdx(CifBddVariable[] vars, DiscVariable var) {
        Assert.check((var.getType() != null ? 1 : 0) != 0);
        return CifToBddConverter.getTypedVarIdx(vars, (Declaration)var);
    }

    public static int getInputVarIdx(CifBddVariable[] vars, InputVariable var) {
        return CifToBddConverter.getTypedVarIdx(vars, (Declaration)var);
    }

    public static int getTypedVarIdx(CifBddVariable[] vars, Declaration var) {
        int i = 0;
        while (i < vars.length) {
            CifBddVariable cifBddVar = vars[i];
            if (cifBddVar != null && cifBddVar instanceof CifBddTypedVariable) {
                CifBddTypedVariable cifBddVarTypedVar = (CifBddTypedVariable)cifBddVar;
                if (cifBddVarTypedVar.obj == var) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int getLpVarIdx(CifBddVariable[] vars, Automaton aut) {
        int i = 0;
        while (i < vars.length) {
            CifBddVariable cifBddVar = vars[i];
            if (cifBddVar != null && cifBddVar instanceof CifBddLocPtrVariable) {
                CifBddLocPtrVariable cifBddLpVar = (CifBddLocPtrVariable)cifBddVar;
                if (cifBddLpVar.aut == aut) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static class UnsupportedPredicateException
    extends Exception {
        public final Expression expr;

        public UnsupportedPredicateException() {
            this((String)null, (Expression)null);
        }

        public UnsupportedPredicateException(String msg, Expression expr) {
            super(msg);
            this.expr = expr;
        }
    }
}

