/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.ciftodmm;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.cif.metamodel.java.CifWithArgWalker;
import org.eclipse.escet.cif.multilevel.ciftodmm.DisjunctGroupsBuilder;
import org.eclipse.escet.cif.multilevel.ciftodmm.OwnedAndAccessedElements;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class RelationsCollector
extends CifWalker {
    private static final int INVALID_INDEX = -1;
    private Map<PositionObject, Integer> elementsToIndex = Maps.map();
    private List<PositionObject> elementsByIndex = Lists.list();
    private BitSet irrelevantRequirementAccessRelations = new BitSet();
    private BitSet plantElementIndices = new BitSet();
    private BitSet requirementElementIndices = new BitSet();
    private Map<Integer, OwnedAndAccessedElements> relationsByGroupElement = Maps.map();
    private ExpressionCollector exprCollector = new ExpressionCollector();

    public void collect(Specification spec) {
        CifCollectUtils.getComplexComponentsStream((ComplexComponent)spec).forEach(cc -> this.collectComponent((ComplexComponent)cc));
    }

    /*
     * WARNING - void declaration
     */
    private void collectComponent(ComplexComponent cc) {
        boolean ownerIsRequirement;
        int ownerIndex;
        Automaton aut;
        block13: {
            block12: {
                if (!(cc instanceof Automaton)) break block12;
                aut = (Automaton)cc;
                switch (aut.getKind()) {
                    case PLANT: {
                        ownerIndex = this.registerPlantElement((PositionObject)aut);
                        ownerIsRequirement = false;
                        break block13;
                    }
                    case REQUIREMENT: {
                        ownerIndex = this.registerRequirementElement((PositionObject)aut);
                        ownerIsRequirement = true;
                        break block13;
                    }
                    default: {
                        throw new AssertionError((Object)Strings.fmt((String)"Unexpected automaton kind \"%s\" found.", (Object[])new Object[]{aut.getKind()}));
                    }
                }
            }
            aut = null;
            ownerIndex = -1;
            ownerIsRequirement = false;
        }
        this.collectDeclarations((List<Declaration>)cc.getDeclarations(), ownerIndex);
        this.collectInvariants((List<Invariant>)cc.getInvariants());
        if (aut != null) {
            for (Event evt : CifEventUtils.getAlphabet((Automaton)aut)) {
                this.registerAccessedRelation((PositionObject)evt, ownerIndex);
            }
            for (Location loc : aut.getLocations()) {
                this.registerOwnedRelation((PositionObject)loc, ownerIndex);
                if (!ownerIsRequirement) {
                    this.irrelevantRequirementAccessRelations.set(this.getIndex((PositionObject)loc));
                }
                this.expressionAccess((List<Expression>)loc.getMarkeds(), ownerIndex);
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent ee : edge.getEvents()) {
                        EdgeEvent edgeEvent = ee;
                        if (edgeEvent instanceof EdgeSend) {
                            void edgeSend;
                            EdgeSend cfr_ignored_0 = (EdgeSend)edgeEvent;
                            EdgeSend cfr_ignored_1 = (EdgeSend)edgeEvent;
                            if (edgeSend.getValue() != null) {
                                this.expressionAccess(edgeSend.getValue(), ownerIndex);
                            }
                        }
                        Expression evtExpr = ee.getEvent();
                        Assert.check((boolean)(evtExpr instanceof EventExpression));
                        Event evt = ((EventExpression)evtExpr).getEvent();
                        this.registerAccessedRelation((PositionObject)evt, ownerIndex);
                    }
                    this.expressionAccess((List<Expression>)edge.getGuards(), ownerIndex);
                    this.updateAccess((List<Update>)edge.getUpdates(), ownerIndex);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateAccess(List<Update> updates, int accessingGroupIndex) {
        ArrayDeque<Update> notDoneUpdates = new ArrayDeque<Update>();
        notDoneUpdates.addAll(updates);
        while (!notDoneUpdates.isEmpty()) {
            Update upd = (Update)notDoneUpdates.poll();
            Update update = upd;
            if (update instanceof Assignment) {
                void asg;
                Assignment cfr_ignored_0 = (Assignment)update;
                Assignment cfr_ignored_1 = (Assignment)update;
                this.expressionAccess(asg.getAddressable(), accessingGroupIndex);
                this.expressionAccess(asg.getValue(), accessingGroupIndex);
                continue;
            }
            Assert.check((boolean)(upd instanceof IfUpdate));
            IfUpdate ifUpd = (IfUpdate)upd;
            this.expressionAccess((List<Expression>)ifUpd.getGuards(), accessingGroupIndex);
            notDoneUpdates.addAll((Collection<Update>)ifUpd.getThens());
            notDoneUpdates.addAll((Collection<Update>)ifUpd.getElses());
            for (ElifUpdate elif : ifUpd.getElifs()) {
                this.expressionAccess((List<Expression>)elif.getGuards(), accessingGroupIndex);
                notDoneUpdates.addAll((Collection<Update>)elif.getThens());
            }
        }
    }

    private void expressionAccess(List<Expression> exprs, int accessingGroupIndex) {
        for (Expression expr : exprs) {
            this.expressionAccess(expr, accessingGroupIndex);
        }
    }

    private void expressionAccess(Expression expr, int accessingGroupIndex) {
        for (PositionObject element : this.exprCollector.collectDecls(expr)) {
            this.registerAccessedRelation(element, accessingGroupIndex);
        }
    }

    private void collectDeclarations(List<Declaration> decls, int groupIndex) {
        for (Declaration decl : decls) {
            int declIndex;
            if (decl instanceof InputVariable) {
                declIndex = this.registerPlantElement((PositionObject)decl);
                this.registerAccessedRelation((PositionObject)decl, declIndex);
                this.irrelevantRequirementAccessRelations.set(declIndex);
                continue;
            }
            if (!(decl instanceof DiscVariable)) continue;
            this.registerOwnedRelation((PositionObject)decl, groupIndex);
            if (this.isRequirementElement(groupIndex)) continue;
            declIndex = this.getIndex((PositionObject)decl);
            this.irrelevantRequirementAccessRelations.set(declIndex);
        }
    }

    private void collectInvariants(List<Invariant> invariants) {
        for (Invariant inv : invariants) {
            Assert.areEqual((Object)SupKind.REQUIREMENT, (Object)inv.getSupKind());
            int index = this.registerRequirementElement((PositionObject)inv);
            Event evt = ((EventExpression)inv.getEvent()).getEvent();
            this.registerAccessedRelation((PositionObject)evt, index);
            this.expressionAccess(inv.getPredicate(), index);
        }
    }

    private int registerPlantElement(PositionObject element) {
        Assert.check((element instanceof Automaton || element instanceof InputVariable ? 1 : 0) != 0);
        int elementIndex = this.getIndex(element);
        this.plantElementIndices.set(elementIndex);
        this.constructEmptyGroupRelations(elementIndex);
        return elementIndex;
    }

    boolean isPlantElement(int index) {
        return this.plantElementIndices.get(index);
    }

    private int registerRequirementElement(PositionObject element) {
        Assert.check((element instanceof Automaton || element instanceof Invariant ? 1 : 0) != 0);
        int elementIndex = this.getIndex(element);
        this.requirementElementIndices.set(elementIndex);
        this.constructEmptyGroupRelations(elementIndex);
        return elementIndex;
    }

    boolean isRequirementElement(int index) {
        return this.requirementElementIndices.get(index);
    }

    private void constructEmptyGroupRelations(int groupIndex) {
        OwnedAndAccessedElements groupRelations = new OwnedAndAccessedElements(groupIndex);
        OwnedAndAccessedElements prevGroupRelations = this.relationsByGroupElement.put(groupIndex, groupRelations);
        Assert.check((prevGroupRelations == null ? 1 : 0) != 0);
    }

    private void registerOwnedRelation(PositionObject element, int groupIndex) {
        Assert.check((groupIndex != -1 ? 1 : 0) != 0);
        OwnedAndAccessedElements groupRelations = this.relationsByGroupElement.get(groupIndex);
        groupRelations.setOwnedRelation(this.getIndex(element));
    }

    private void registerAccessedRelation(PositionObject element, int groupIndex) {
        Assert.check((groupIndex != -1 ? 1 : 0) != 0);
        OwnedAndAccessedElements groupRelations = this.relationsByGroupElement.get(groupIndex);
        int elementIndex = this.getIndex(element);
        groupRelations.setAccessedRelation(elementIndex);
        if (this.isPlantElement(groupIndex) && element instanceof Event) {
            this.irrelevantRequirementAccessRelations.set(elementIndex);
        }
    }

    int getIndex(PositionObject element) {
        Integer storedIndex = this.elementsToIndex.get(element);
        if (storedIndex != null) {
            return storedIndex;
        }
        int newIndex = this.elementsToIndex.size();
        this.elementsToIndex.put(element, newIndex);
        this.elementsByIndex.add(element);
        return newIndex;
    }

    PositionObject getElement(int index) {
        return this.elementsByIndex.get(index);
    }

    OwnedAndAccessedElements getGroupRelations(int groupIndex) {
        OwnedAndAccessedElements groupRelations = this.relationsByGroupElement.get(groupIndex);
        Assert.notNull((Object)groupRelations);
        return groupRelations;
    }

    public List<OwnedAndAccessedElements> computePlantGroups() {
        List<OwnedAndAccessedElements> plantRelations = this.plantElementIndices.stream().mapToObj(index -> this.relationsByGroupElement.get(index)).collect(Collectors.toList());
        return DisjunctGroupsBuilder.createPlantGroups(plantRelations);
    }

    public List<OwnedAndAccessedElements> computeRequirementGroups() {
        List<OwnedAndAccessedElements> requirementRelations = this.requirementElementIndices.stream().mapToObj(index -> this.relationsByGroupElement.get(index)).collect(Collectors.toList());
        return DisjunctGroupsBuilder.createRequirementGroups(requirementRelations, this.irrelevantRequirementAccessRelations);
    }

    private static class ExpressionCollector
    extends CifWithArgWalker<Set<PositionObject>> {
        private ExpressionCollector() {
        }

        public Set<PositionObject> collectDecls(Expression expr) {
            Set accessedElements = Sets.set();
            this.walkExpression(expr, accessedElements);
            return accessedElements;
        }

        protected void preprocessDiscVariableExpression(DiscVariableExpression discVarExpr, Set<PositionObject> accessedElements) {
            accessedElements.add((PositionObject)discVarExpr.getVariable());
        }

        protected void preprocessInputVariableExpression(InputVariableExpression inpVarExpr, Set<PositionObject> accessedElements) {
            accessedElements.add((PositionObject)inpVarExpr.getVariable());
        }

        protected void preprocessLocationExpression(LocationExpression locExpr, Set<PositionObject> accessedElements) {
            accessedElements.add((PositionObject)locExpr.getLocation());
        }

        protected void preprocessAlgVariableExpression(AlgVariableExpression algvarExpr, Set<PositionObject> accessedElements) {
            this.walkExpression(algvarExpr.getVariable().getValue(), accessedElements);
        }
    }
}

