/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixFormat;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifPreconditionChecker;
import org.eclipse.escet.cif.checkers.checks.AutOnlySpecificSupKindsCheck;
import org.eclipse.escet.cif.checkers.checks.AutOnlyWithOneInitLocCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoInitPredsCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoMarkerPredsCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeOnlySimpleAssignmentsCheck;
import org.eclipse.escet.cif.checkers.checks.EqnNotAllowedCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoChannelsCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoTauCheck;
import org.eclipse.escet.cif.checkers.checks.EventOnlyWithControllabilityCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificBinaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificUnaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificUserDefCheck;
import org.eclipse.escet.cif.checkers.checks.InvNoSpecificInvsCheck;
import org.eclipse.escet.cif.checkers.checks.TypeIntBoundsCheck;
import org.eclipse.escet.cif.checkers.checks.TypeNoSpecificTypesCheck;
import org.eclipse.escet.cif.checkers.checks.VarDiscOnlyStaticEvalInitCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoContinuousCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoDiscWithMultiInitValuesCheck;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesOptimized;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifRelations;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifToDmm;
import org.eclipse.escet.cif.multilevel.ciftodmm.SpecHasPlantCheck;
import org.eclipse.escet.cif.multilevel.ciftodmm.SpecHasRequirementCheck;
import org.eclipse.escet.cif.multilevel.clustering.ComputeMultiLevelTree;
import org.eclipse.escet.cif.multilevel.clustering.TreeNode;
import org.eclipse.escet.cif.multilevel.options.DmmOutputFileOption;
import org.eclipse.escet.cif.multilevel.options.PartialSpecsOutputDirectoryOption;
import org.eclipse.escet.cif.multilevel.partialspecs.PartialSpecsBuilder;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.dsm.ClusterInput;
import org.eclipse.escet.common.dsm.Dmm;
import org.eclipse.escet.common.dsm.Dsm;
import org.eclipse.escet.common.dsm.DsmClustering;
import org.eclipse.escet.common.java.BitSetIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class MultilevelApp
extends Application<IOutputComponent> {
    private static final Pattern SPEC_FILE_PATTERN = Pattern.compile("spec_[0-9]+\\.cif");
    private static final RealMatrixFormat MAT_DEBUG_FORMAT;

    static {
        NumberFormat valueFmt = NumberFormat.getIntegerInstance(Locale.US);
        MAT_DEBUG_FORMAT = new RealMatrixFormat("", "", "  ", "", "\n", " ", valueFmt);
    }

    public static void main(String[] args) {
        MultilevelApp app = new MultilevelApp();
        app.run(args, true);
    }

    public MultilevelApp() {
    }

    public MultilevelApp(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    /*
     * WARNING - void declaration
     */
    protected int runInternal() {
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        new RemoveAnnotations().transform(spec);
        new ElimComponentDefInst().transform(spec);
        new ElimSelf().transform(spec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new SimplifyValuesOptimized().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        MultilevelApp.checkSpec(spec, absSpecPath, () -> AppEnv.isTerminationRequested());
        if (this.isTerminationRequested()) {
            return 0;
        }
        CifRelations cifRelations = CifToDmm.transformToDmms(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        if (DmmOutputFileOption.getDmmOutputFilePath() != null) {
            cifRelations.writeDmms(InputFileOption.getPath(), DmmOutputFileOption.getDmmOutputFilePath());
        }
        Dmm reqsPlantsDmm = cifRelations.relations;
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg((String)"Plant groups:");
            OutputProvider.dbg((String)cifRelations.plantGroups.toString());
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Requirement groups:");
            OutputProvider.dbg((String)cifRelations.requirementGroups.toString());
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Requirement / Plant relations:");
            OutputProvider.dbg((String)cifRelations.relations.toString());
            OutputProvider.dbg();
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        for (PositionObject posObj : cifRelations.getUselessRequirements()) {
            if (posObj instanceof Automaton) {
                OutputProvider.warn((String)"Requirement automaton \"%s\" has no relation to any plant element and does not affect behavior.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false)});
                continue;
            }
            PositionObject positionObject = posObj;
            if (positionObject instanceof Invariant) {
                void inv;
                Invariant cfr_ignored_0 = (Invariant)positionObject;
                Invariant cfr_ignored_1 = (Invariant)positionObject;
                OutputProvider.warn((String)"Requirement invariant \"%s\" has no relation to any plant element and does not affect behavior.", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)true)});
                continue;
            }
            throw new AssertionError((Object)("Unexpected kind of requirement found: \"" + String.valueOf(posObj) + "\"."));
        }
        RealMatrix unclusteredMatrix = reqsPlantsDmm.adjacencies.transpose().multiply(reqsPlantsDmm.adjacencies);
        OutputProvider.dbg((String)"Unclustered reqsPlants:");
        OutputProvider.dbg((String)MAT_DEBUG_FORMAT.format(unclusteredMatrix));
        OutputProvider.dbg();
        if (this.isTerminationRequested()) {
            return 0;
        }
        OutputProvider.dbg((String)"--- Start of clustering --");
        OutputProvider.idbg();
        ClusterInput clusteringInput = new ClusterInput(unclusteredMatrix, reqsPlantsDmm.columnLabels, OutputProvider.getDebugOutputStream());
        Dsm clusteredDsm = DsmClustering.flowBasedMarkovClustering((ClusterInput)clusteringInput);
        OutputProvider.ddbg();
        OutputProvider.dbg((String)"--- End of clustering --");
        OutputProvider.dbg();
        OutputProvider.dbg((String)"Clustered DSM for reqsPlantsDmm (for information only, this data is not actually used):");
        OutputProvider.dbg((String)MAT_DEBUG_FORMAT.format(clusteredDsm.adjacencies));
        OutputProvider.dbg();
        if (this.isTerminationRequested()) {
            return 0;
        }
        TreeNode rootNode = ComputeMultiLevelTree.transformCluster(clusteredDsm.rootGroup, unclusteredMatrix, reqsPlantsDmm.adjacencies);
        if (this.isTerminationRequested()) {
            return 0;
        }
        List<TreeNode> linearizedTree = rootNode.linearizeTree();
        for (TreeNode node : linearizedTree) {
            OutputProvider.out((String)"Index: %d", (Object[])new Object[]{node.index});
            OutputProvider.out((String)"Plant groups: %s", (Object[])new Object[]{node.plantGroups.isEmpty() ? "<none>" : node.plantGroups.toString()});
            OutputProvider.out((String)"Req groups:   %s", (Object[])new Object[]{node.requirementGroups.isEmpty() ? "<none>" : node.requirementGroups.toString()});
            String childNodeNumbers = node.childNodes.stream().map(n -> String.valueOf(n.index)).collect(Collectors.joining(", "));
            OutputProvider.out((String)"Child nodes: %s", (Object[])new Object[]{childNodeNumbers.isEmpty() ? "<none>" : childNodeNumbers});
            OutputProvider.out();
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        List partialSpecs = Lists.listc((int)linearizedTree.size());
        PartialSpecsBuilder partialBuilder = new PartialSpecsBuilder(spec);
        for (TreeNode node : linearizedTree) {
            List neededObjects = Lists.list();
            Iterator iterator = new BitSetIterator(node.plantGroups).iterator();
            while (iterator.hasNext()) {
                int plantGrp = (Integer)iterator.next();
                neededObjects.addAll(cifRelations.getPlantsOfGroup(plantGrp));
            }
            iterator = new BitSetIterator(node.requirementGroups).iterator();
            while (iterator.hasNext()) {
                int reqGrp = (Integer)iterator.next();
                neededObjects.addAll(cifRelations.getRequirementsOfGroup(reqGrp));
            }
            if (this.isTerminationRequested()) {
                return 0;
            }
            Specification partialSpec = partialBuilder.createPartialSpecification(neededObjects);
            partialSpecs.add(partialSpec);
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        String partialSpecsDir = PartialSpecsOutputDirectoryOption.getPath();
        if (partialSpecsDir != null) {
            String absCifDir = cifReader.getAbsDirPath();
            this.writePartialSpecs(partialSpecsDir, partialSpecs, absCifDir);
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        OutputProvider.warn((String)"Multi-level synthesis not yet implemented.");
        return 0;
    }

    private void writePartialSpecs(String partialSpecsDir, List<Specification> partialSpecs, String absCifDir) {
        Path absDirPath = java.nio.file.Paths.get(Paths.resolve((String)partialSpecsDir), new String[0]);
        if (Files.isDirectory(absDirPath, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var6_10 = null;
                try (Stream<Path> dirContent = Files.list(absDirPath);){
                    Predicate<String> matcher = SPEC_FILE_PATTERN.asMatchPredicate();
                    dirContent.filter(p -> matcher.test(p.getFileName().toString())).forEach(p -> {
                        try {
                            Files.delete(p);
                        }
                        catch (IOException ex) {
                            String msg = Strings.fmt((String)"Failed to clean output directory \"%s\" for the partial specifications.", (Object[])new Object[]{partialSpecsDir});
                            throw new InputOutputException(msg, (Throwable)ex);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to clean output directory \"%s\" for the partial specifications.", (Object[])new Object[]{partialSpecsDir});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
        try {
            Files.createDirectories(absDirPath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to create output directory \"%s\" for the partial specifications.", (Object[])new Object[]{partialSpecsDir});
            throw new InputOutputException(msg, (Throwable)ex);
        }
        int specNumber = 1;
        for (Specification partialSpec : partialSpecs) {
            String outPath = Paths.join((String[])new String[]{Paths.resolve((String)partialSpecsDir), "spec_" + Strings.makeFixedLengthNumberText((int)specNumber, (int)partialSpecs.size()) + ".cif"});
            CifWriter.writeCifSpec((Specification)partialSpec, (String)outPath, (String)absCifDir);
            ++specNumber;
        }
        OutputProvider.out((String)"Wrote %d partial specification%s to directory \"%s\".", (Object[])new Object[]{partialSpecs.size(), partialSpecs.size() == 1 ? "" : "s", partialSpecsDir});
    }

    public static void checkSpec(Specification spec, String absSpecPath, BooleanSupplier shouldTerminate) {
        MultiLevelPreChecker checker = new MultiLevelPreChecker(shouldTerminate);
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF multi-level synthesis");
    }

    public String getAppName() {
        return "CIF multi-level synthesis";
    }

    public String getAppDescription() {
        return "Performs synthesis by making several smaller co-operating supervisors.";
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = MultilevelApp.getGeneralOptionCategory();
        List<Option> programOpts = List.of(Options.getInstance(InputFileOption.class), Options.getInstance(DmmOutputFileOption.class), Options.getInstance(PartialSpecsOutputDirectoryOption.class));
        OptionCategory programCat = new OptionCategory("Multi-level synthesis", "Multi-level synthesis options.", List.of(), programOpts);
        return new OptionCategory("CIF Multi-level Synthesis Options", "All options for the CIF multi-level synthesis tool.", List.of(generalCat, programCat), List.of());
    }

    private static class MultiLevelPreChecker
    extends CifPreconditionChecker {
        public MultiLevelPreChecker(BooleanSupplier shouldTerminate) {
            super(shouldTerminate, new CifCheck[]{new AutOnlyWithOneInitLocCheck(), new VarNoDiscWithMultiInitValuesCheck(), new VarDiscOnlyStaticEvalInitCheck(), new AutOnlySpecificSupKindsCheck(SupKind.PLANT, SupKind.REQUIREMENT), new SpecHasPlantCheck(), new SpecHasRequirementCheck(), new InvNoSpecificInvsCheck().disallow(NoInvariantSupKind.KINDLESS, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.SUPERVISOR, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.PLANT, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.REQUIREMENT, NoInvariantKind.STATE, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.ALL_KINDS, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.LOCATIONS), new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.COMP_DEF_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.COMP_TYPES}), new EventNoTauCheck(), new VarNoContinuousCheck(), new EqnNotAllowedCheck(), new FuncNoSpecificUserDefCheck(new FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc[]{FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.EXTERNAL, FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.INTERNAL}), new EventOnlyWithControllabilityCheck(), new EventNoChannelsCheck(), new TypeIntBoundsCheck(true, Integer.valueOf(0), null, null, null), new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.COMP_DEF_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.COMP_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DICT_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES_AS_DATA, TypeNoSpecificTypesCheck.NoSpecificType.INT_TYPES_RANGELESS, TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.REAL_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.SET_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.STRING_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.TUPLE_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.VOID_TYPES}), new ExprNoSpecificExprsCheck(new ExprNoSpecificExprsCheck.NoSpecificExpr[]{ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_REFS_USER_DEF, ExprNoSpecificExprsCheck.NoSpecificExpr.CAST_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.COMP_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.COMP_PARAM_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.CONT_VAR_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.DICT_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.TUPLE_FIELD_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_CALLS, ExprNoSpecificExprsCheck.NoSpecificExpr.LIST_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.REAL_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.RECEIVE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.SET_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.SLICE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.STRING_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.TIME_VAR_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.TUPLE_LITS}), new ExprNoSpecificUnaryExprsCheck(new ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp[]{ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.NEGATE, ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.SAMPLE}), new ExprNoSpecificBinaryExprsCheck(new ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp[]{ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_STRINGS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.CONJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DISJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DIVISION, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ELEMENT_OF, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_INT_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_REAL, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_TUPLE, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_EQUAL_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_EQUAL_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_THAN_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_THAN_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.INTEGER_DIVISION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_EQUAL_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_EQUAL_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_THAN_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_THAN_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MODULUS_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MULTIPLICATION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MULTIPLICATION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBSET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_INT_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_REAL, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_TUPLE}), new EdgeOnlySimpleAssignmentsCheck(), new CompNoInitPredsCheck(true), new CompNoMarkerPredsCheck(true)});
        }
    }
}

